<?php
//  $Revision: 1.10.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = "pmsg";
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}



$myts =& MyTextSanitizer::getInstance();
if ( isset($_GET['name']) )
	$name = $myts->stripSlashesGPC($_GET['name']);
else exit;

// name -> get names to display
$escName = addslashes( $name );
$fileTypeTable = $xoopsDB->prefix('xoonips_file_type');
$result = $xoopsDB->query( "select display_name from $fileTypeTable where name='$escName'" );
if ( $result != FALSE && $xoopsDB->getRowsNum($result) != 0 )
	list($displayName) = $xoopsDB->fetchRow($result);
else
	$displayName = $name;

//var_dump( $_POST );
//var_dump( $_FILES );
$text = false;
if ( !empty($_FILES['file']['name']) ){
	// file was uploaded
	$originalFileName = $myts->stripSlashesGPC( $_FILES['file']['name'] );
	$mimeType         = $myts->stripSlashesGPC( $_FILES['file']['type'] );
	$fileName         = $myts->stripSlashesGPC( $_FILES['file']['tmp_name'] );
	$error = (int)$_FILES['file']['error'];
	if ( $error != 0 ){
		if ( $error == UPLOAD_ERR_INI_SIZE )
			$errorMessage = _MD_XOONIPS_ITEM_UPLOAD_FILE_TOO_LARGE;
		else
			$errorMessage = _MD_XOONIPS_ITEM_UPLOAD_FILE_FAILED;
		echo $errorMessage;
	}
	$text = file_get_contents( $fileName );
	$getTextFromOpener = false;
}
else
	$getTextFromOpener = true;

/*
<link rel="stylesheet" type="text/css" media="all" href="http://10.12.60.61/~aga/xoops/html/xoops.css" />
<link rel="stylesheet" type="text/css" media="all" href="http://10.12.60.61/~aga/xoops/html/themes/default/style.css" /></head>
<body>
<form action='pmlite.php' method='post' name='coolsus'>
<table width='300' align='center' class='outer'>
<tr>
<td class='head' width='25%'>To: </td><td class='even'><input type='hidden' name='to_userid' value='1' />agata</td></tr><tr><td class='head' width='25%'>Subject: </td><td class='even'><input type='text' name='subject' value='Re: _MI_XOONIPS_INDEX_GLOBAL_NEWEVENT_NOTIFYSBJ' size='30' maxlength='100' /></td></tr><tr valign='top'><td class='head' width='25%'>Message: </td><td class='even'><a name='moresmiley'></a><img src='http://10.12.60.61/~aga/xoops/html/images/url.gif' alt='url' onmouseover='style.cursor="hand"' onclick='xoopsCodeUrl("message", "Enter the URL of the link you want to add:", "Enter the web site title:");' />&nbsp;<img src='http://10.12.60.61/~aga/xoops/html/images/email.gif' alt='email' onmouseover='style.cursor="hand"' onclick='xoopsCodeEmail("message", "Enter the email address you want to add.");' />&nbsp;<img src='http://10.12.60.61/~aga/xoops/html/images/imgsrc.gif' alt='imgsrc' onmouseover='style.cursor="hand"' onclick='xoopsCodeImg("message", "Enter the URL of the image you want to add.", "Now, enter the position of the image.", "&#039;R&#039; or &#039;r&#039; for right, &#039;L&#039; or &#039;l&#039; for left, or leave it blank.", "ERROR! Enter the position of the image.");' />&nbsp;<img src='http://10.12.60.61/~aga/xoops/html/images/image.gif' alt='image' onmouseover='style.cursor="hand"' onclick='openWithSelfMain("http://10.12.60.61/~aga/xoops/html/imagemanager.php?target=message","imgmanager",400,430);' />&nbsp;<img src='http://10.12.60.61/~aga/xoops/html/images/code.gif' alt='code' onmouseover='style.cursor="hand"' onclick='xoopsCodeCode("message", "Enter the codes that you want to add.");' />&nbsp;<img src='http://10.12.60.61/~aga/xoops/html/images/quote.gif' alt='quote' onmouseover='style.cursor="hand"' onclick='xoopsCodeQuote("message");' /><br />
*/

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
//$xoopsOption['template_main'] = 'xoonips_input_text_file.html';
//include XOOPS_ROOT_PATH.'/header.php';
xoops_header(false);

?>
</head>
<body <?php if ( $getTextFromOpener ) echo 'onload="getTextFromOpener()"'; ?> >
<form  method='post' action='' enctype="multipart/form-data">
<table class="outer">
<tr>
<td class="head">
  <?php echo $displayName; ?>
</td>
<td class="even">
<input type='hidden' name='name' value='<?php echo $name;?>' id='xoonipsName' />
<input type='file' name='file' />
<input type='submit' name='' value='<?php echo _MD_XOONIPS_ITEM_UPLOAD_LABEL;?>' />
<br />

<br />

<textarea name='text' id='xoonipsText' cols='37' rows='8'>
<?php echo htmlspecialchars($text,ENT_QUOTES);?>
</textarea>

<br />

<input type='button' value='<?php echo _MD_XOONIPS_ITEM_OK_LABEL; ?>' onclick='clickOK()' />
<input type='button' value='<?php echo _MD_XOONIPS_ITEM_CANCEL_LABEL; ?>' onclick='clickCancel()' />

</td>
</tr>
</table>
</form>
<script type="text/javascript">
<!--

function headText(str){
	str = str.replace(/\r\n/, "\n");
	str = str.replace(/\r/, "\n");
	return str;
}

function nl2br(str){
	return str.replace(/\n/, " <br/> ");
}

function clickOK(){
	var opener = window.opener;
	var name = document.getElementById('xoonipsName').value;
	
	// textarea -> opener_text
	var textarea = document.getElementById('xoonipsText');
	var text = textarea.value; // IE:OK mozilla:OK safari:OK
	text = text.split("\u00a5").join("\u005c"); // yen sign -> backslash
	// text = text.replace(/\u00a5/g, "\u005c"); // yen sign -> backslash
	
	// set text to opener
	var openerEncText = opener.document.getElementById(name+'EncText');
	var openerShowText = opener.document.getElementById(name+'ShowText');
	openerEncText.value = text;
	
	//openerShowText.firstChild.nodeValue = nl2br(headText(text)); // IE:OK mozilla:OK safari:OK
	var str = text;
	str = str.replace(/\r\n/g, "\n");
	str = str.replace(/\r/g, "\n");
	var ar = str.split( "\n" );
	
	// clear showText
	while ( openerShowText.hasChildNodes() )
		openerShowText.removeChild( openerShowText.lastChild );
	
	// appendto showText
	var i;
	var visibleLines = 3;
	for ( i = 0; i < ar.length && i < visibleLines; i++ ){
		if ( i == visibleLines-1 ){
			if ( ar.length > visibleLines+1 || ar.length == visibleLines+1 && ar[visibleLines] != '' ){
				//window.alert(ar);
				//window.alert(visibleLines);
				ar[i] = ar[i] + ' ...';
			}
		}
		openerShowText.appendChild( opener.document.createTextNode(ar[i]) );
		openerShowText.appendChild( opener.document.createElement('BR'));
	}
	
	window.close();
	return false;
}

function clickCancel(){
	window.close();
	return false;
}




<?php if ( $getTextFromOpener ) { ?>

function resizer(){
<?php 
	/* EBhEK؂ȍɃTCY.
		Ql: http://www.quirksmode.org/viewport/compatibility.html
	*/
?>
	
	window.resizeTo( 500, 400 );
	
	var windowInnerHeight;
	if (self.innerHeight) // all except Explorer
		windowInnerHeight = self.innerHeight;
	else if (document.documentElement && document.documentElement.clientHeight) // Explorer 6 Strict Mode
		windowInnerHeight = document.documentElement.clientHeight;
	else if (document.body) // other Explorers
		windowInnerHeight = document.body.clientHeight;
	
	var documentHeight;
	var test1 = document.body.scrollHeight;
	var test2 = document.body.offsetHeight
	if (test1 > test2) // all but Explorer Mac
		documentHeight = document.body.scrollHeight;
	else // Explorer Mac;
	     //would also work in Explorer 6 Strict, Mozilla and Safari
		documentHeight = document.body.offsetHeight;
	
	if ( windowInnerHeight && documentHeight ){
		window.resizeBy( 0, documentHeight - windowInnerHeight );
	}
}

function getTextFromOpener(){
	var opener = window.opener;
	var name = document.getElementById('xoonipsName').value;
	
	// opener_text -> textarea
	var encText = opener.document.getElementById(name+'EncText').value; // IE:OK mozilla:OK safari:OK
	var tarea = document.getElementById('xoonipsText');
	if ( encText == '' && name == 'rights' )
		encText = "All rights reserved.\nLicense:\n";
	tarea.value = encText;
	resizer();
}
<?php } ?>


//-->
</script>

<?php
//$xoopsTpl->assign('item_htmls', $item_htmls );

//include XOOPS_ROOT_PATH.'/footer.php';
xoops_footer();

?>
