<?php
//  Install script for moderator module                                         //
//  $Revision: 1.58.2.2 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

require_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/oaiclass.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/junii.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/lib.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';



function xoonips_get_default_configs(){
	$configs = array(
		'moderator_gid'                 => array( 'type' => 'i'  , 'value' => ''         ),
		'certify_user'                  => array( 'type' => 's'  , 'value' => 'on'       ),
		'certify_item'                  => array( 'type' => 's'  , 'value' => 'on'       ),
		'public_item_target_user'       => array( 'type' => 's'  , 'value' => 'all'      ),
		'upload_dir'                    => array( 'type' => 's'  , 'value' => ''         ),
		'account_realname_optional'     => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_address_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_division_optional'     => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_tel_optional'          => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_company_name_optional' => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_country_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_zipcode_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_fax_optional'          => array( 'type' => 's'  , 'value' => 'off'      ),
		'private_item_number_limit'     => array( 'type' => 'i'  , 'value' => '100'      ),
		'private_index_number_limit'    => array( 'type' => 'i'  , 'value' => '50'       ),
		'private_item_storage_limit'    => array( 'type' => 'dm' , 'value' => '50000000' ),
		'group_item_number_limit'       => array( 'type' => 'i'  , 'value' => '300'      ),
		'group_index_number_limit'      => array( 'type' => 'i'  , 'value' => '200'      ),
		'group_item_storage_limit'      => array( 'type' => 'dm' , 'value' => '100000000'),
		'amazon_associates_id'          => array( 'type' => 's'  , 'value' => ''         ),
		'export_attachment'             => array( 'type' => 's'  , 'value' => 'off'      ),
		'export_enabled'                => array( 'type' => 's'  , 'value' => 'off'      ),
		'rss_file_path'                 => array( 'type' => 's'  , 'value' => ''         ),
		'rss_item_max'                  => array( 'type' => 'i'  , 'value' => '10'       ),
		'tree_frame_width'              => array( 'type' => 's'  , 'value' => '100%'     ),
		'tree_frame_height'             => array( 'type' => 's'  , 'value' => '400'      ),
		'printer_friendly_header'       => array( 'type' => 's'  , 'value' => ''         ),
		'repository_institution'        => array( 'type' => 's'  , 'value' => 'meta_author' ),
		'repository_publisher'          => array( 'type' => 's'  , 'value' => 'meta_author' ),
		'repository_name'               => array( 'type' => 's'  , 'value' => ''         ),
		'repository_nijc_code'          => array( 'type' => 's'  , 'value' => ''         ),
		'repository_deletion_track'     => array( 'type' => 's'  , 'value' => '30'       ),
		'download_file_compression'     => array( 'type' => 's'  , 'value' => 'on'       ),
		'item_show_optional'            => array( 'type' => 's'  , 'value' => 'off'      ),
		'private_import_enabled'        => array( 'type' => 's'  , 'value' => 'off'      ),
		'moderator_modify_any_items'    => array( 'type' => 's'  , 'value' => 'off'      ),
	);
	return $configs;
}

// Unset items in xoonips_config is set.
function xoonips_insert_default_configs(){
	$configs = xoonips_get_default_configs();
	global $xoopsDB;
	$table = $xoopsDB->prefix('xoonips_config');
	foreach ( $configs as $key => $ar ){
		$escKey = addslashes( $key );
		$escVal = addslashes( $ar['value'] );
		
		$result = $xoopsDB->query( "select value from $table where name='$escKey'" );
		if ( $xoopsDB->getRowsNum($result) == 0 ){
			$result = $xoopsDB->query( "insert into $table ( name, value ) values ('$escKey', '$escVal' )" );
		}
	}
}

function xoonips_query( $sql ){
	global $xoopsDB;
	$result = $xoopsDB->queryF( $sql );
	if ( $result == FALSE ){
		echo __LINE__ . "ERROR: SQL=$sql<br />\n error=" . mysql_error() . "<br>\n";
	}
	return $result;
}

function xoonips_get_config( $name ){
	global $xoopsDB;
	$esc_name = addslashes($name);
	$table = $xoopsDB->prefix('xoonips_config');
	$result = xoonips_query( "select value from $table where name='$esc_name'" );
	list( $value ) = $xoopsDB->fetchRow( $result );
	return $value;
}

// display config in $bid blocks
function xoonips_set_block_visible( $bid, $visible ){
	$block = new XoopsBlock();
	$block->load( $bid );
	$block->setVar( 'visible', $visible ? 1 : 0 );
	$block->store();
	
	// set to display all pages
	// module_id = 0:all pages, -1:Top
	global $xoopsDB;
	if ( $visible )
		$xoopsDB->query( "insert into ".$xoopsDB->prefix('block_module_link')." (block_id, module_id) values ( $bid, 0 )" );
}

/** set a side parameter of the block specified by $bid
 * 
 * @param $bid block id
 * @param $side
 *        0: sideblock - left
 *        1: sideblock - right
 *        2: sideblock - left and right
 *        3: centerblock - left
 *        4: centerblock - right
 *        5: centerblock - center
 *        6: centerblock - left, right, center
 * 
 */
function xoonips_set_block_side( $bid, $side ){
	$block = new XoopsBlock();
	$block->load( $bid );
	$block->setVar( 'side', $side );
	$block->store();
}

/** set the weight of the block specified by $bid
 * 
 * @param $bid block id
 * @param $w weight
 */
function xoonips_set_block_weight( $bid, $w ){
	$block = new XoopsBlock();
	$block->load( $bid );
	$block->setVar( 'weight', $w );
	$block->store();
}

// positions
function xoonips_get_default_positions(){
	$positions = array(
		'Professor'                      => array( 'posi_order' => '10'        ),
		'Associate Professor'            => array( 'posi_order' => '20'        ),
		'Assistant Professor'            => array( 'posi_order' => '30'        ),
		'Lecturer'                       => array( 'posi_order' => '40'        ),
		'Instructor'                     => array( 'posi_order' => '50'        ),
		'Research Associate'             => array( 'posi_order' => '60'        ),
		'Research Assistant'             => array( 'posi_order' => '70'        ),
		'Assistant'                      => array( 'posi_order' => '80'        ),
		'Secretary'                      => array( 'posi_order' => '90'        ),
		'Others'                         => array( 'posi_order' => '100'       ),
		'Moderator'                      => array( 'posi_order' => '110'       ),
		'Registered Users'               => array( 'posi_order' => '120'       )
/*
	// For Riken BSI
		'Group Director'                 => array( 'posi_order' => '300'       ),
		'Laboratory Head'                => array( 'posi_order' => '310'       ),
		'Deputy Laboratory Head'         => array( 'posi_order' => '320'       ),
		'Unit Leader'                    => array( 'posi_order' => '330'       ),
		'Research Specialist'            => array( 'posi_order' => '340'       ),
		'Research Scientist'             => array( 'posi_order' => '350'       ),
		'Contract Researcher'            => array( 'posi_order' => '360'       ),
		'Research Associates'            => array( 'posi_order' => '370'       ),
		'Technical Staff I'              => array( 'posi_order' => '380'       ),
		'Technical Staff II'             => array( 'posi_order' => '390'       ),
		'Contract Technical Scientist'   => array( 'posi_order' => '400'       ),
		'Researcher/Technical Staff/etc' => array( 'posi_order' => '410'       )
*/
	);
	return $positions;
}

// set default positions to positions table
function xoonips_insert_default_positions(){
	$positions = xoonips_get_default_positions();
	global $xoopsDB;
	$table = $xoopsDB->prefix('xoonips_positions');
	foreach ( $positions as $key => $ar ){
		$escKey = addslashes( $key );
		$escVal = addslashes( $ar['posi_order'] );
		
		$result = $xoopsDB->query( "select posi_title from $table where posi_title='$escKey'" );
		if ( $xoopsDB->getRowsNum($result) == 0 ){
			$result = $xoopsDB->query( "insert into $table ( posi_title, posi_order ) values ('$escKey', '$escVal' )" );
		}
	}
}

function xoops_module_install_xoonips( $xoopsMod ) {
	global $xoopsUser;
	$error = false; //!< true if error occured	
	
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname('xoonips');
	if( $module ){
		// make moderator group
		$member_handler =& xoops_gethandler('member');
		$group =& $member_handler->createGroup();
		$group->setVar("name", "moderator");
		$group->setVar("description", "platform moderator");
		if (!$member_handler->insertGroup($group)) {
			xoops_cp_header();
			echo $group->getHtmlErrors();
			xoops_cp_footer();
		} else {
			// config of access right and visible config (groups and modules, groups and blocks)
			$mid = $module->getVar('mid'); // $xoopsMod->getVar('mid');
			$groupid = $group->getVar('groupid');
			$groupid_registered = 2;
			$groupid_anonymous = 3;
			
			$block_objects =& XoopsBlock::getByModule( $mid );
			$bids = array();
			foreach( $block_objects as $o )
				$bids[$o -> getVar( 'show_func' )] = $o -> getVar( 'bid' ); // it is problem that user search by name when languages change.
			
			if ( !isset($bids['b_xoonips_login_show'       ]) ) $error = true;
			if ( !isset($bids['b_xoonips_user_show'        ]) ) $error = true;
			if ( !isset($bids['b_xoonips_group_show'       ]) ) $error = true;
			if ( !isset($bids['b_xoonips_moderator_show'   ]) ) $error = true;
			if ( !isset($bids['b_xoonips_tree_show'        ]) ) $error = true;
			if ( !isset($bids['b_xoonips_quick_search_show']) ) $error = true;
			if ( !isset($bids['b_xoonips_itemtypes_show'   ]) ) $error = true;
			
			$gperm_handler =& xoops_gethandler('groupperm');
			$gperm_handler->addRight( 'module_read', $mid                                , $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_login_show'       ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_user_show'        ], $groupid_registered );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_group_show'       ], $groupid_registered );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_tree_show'        ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_moderator_show'   ], $groupid            );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_tree_show'        ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_quick_search_show'], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_itemtypes_show'   ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_ranking_show'     ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_ranking_new_show' ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_userlist_show'    ], $groupid_anonymous  );
			
			xoonips_set_block_visible( $bids['b_xoonips_login_show'       ], true );
			xoonips_set_block_visible( $bids['b_xoonips_user_show'        ], true );
			xoonips_set_block_visible( $bids['b_xoonips_group_show'       ], true );
			xoonips_set_block_visible( $bids['b_xoonips_moderator_show'   ], true );
			xoonips_set_block_visible( $bids['b_xoonips_tree_show'        ], true );
			xoonips_set_block_visible( $bids['b_xoonips_quick_search_show'], true );
			xoonips_set_block_visible( $bids['b_xoonips_itemtypes_show'   ], false );
			
			$bid_login = 2; // login block's bid
			xoonips_set_block_visible( $bid_login                        , false );
			
			// set block arrange
			xoonips_set_block_side( $bids['b_xoonips_login_show'       ], 0 ); //sideblock - left
			xoonips_set_block_side( $bids['b_xoonips_user_show'        ], 1 ); //sideblock - right
			xoonips_set_block_side( $bids['b_xoonips_group_show'       ], 1 ); //sideblock - right
			xoonips_set_block_side( $bids['b_xoonips_moderator_show'   ], 1 ); //sideblock - right
			xoonips_set_block_side( $bids['b_xoonips_tree_show'        ], 0 ); //sideblock - left
			xoonips_set_block_side( $bids['b_xoonips_quick_search_show'], 0 ); //sideblock - left
			xoonips_set_block_side( $bids['b_xoonips_itemtypes_show'   ], 5 ); //centerblock - center

			// sideblock-left
			xoonips_set_block_weight( $bids['b_xoonips_login_show'       ], 0 );
			xoonips_set_block_weight( $bids['b_xoonips_quick_search_show'], 10 );
			xoonips_set_block_weight( $bids['b_xoonips_tree_show'        ], 20 );
			// sideblock-right
			xoonips_set_block_weight( $bids['b_xoonips_user_show'        ], 0 );
			xoonips_set_block_weight( $bids['b_xoonips_group_show'       ], 10 );
			xoonips_set_block_weight( $bids['b_xoonips_moderator_show'   ], 20 );
			// 
			xoonips_set_block_weight( $bids['b_xoonips_itemtypes_show'   ], 0 );
			
			// makes XooNIps to be a start up module
			$config_handler =& xoops_gethandler('config');
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('conf_modid', 0));
			$criteria->add(new Criteria('conf_catid', XOOPS_CONF/*1*/));
			$criteria->add(new Criteria('conf_name', 'startpage'));
			$configs =& $config_handler->getConfigs($criteria);
			$new_value = "xoonips";
			if ( count( $configs ) != 1 ){
				$error = true;
			}
			else {
				$config = $configs[0];
				$config->setConfValueForInput($new_value);
				$config_handler->insertConfig($config);
				
				// add read permission for the start module to all groups
				$groups =& $member_handler->getGroupList();
				foreach ($groups as $groupid2 => $groupname) {
					if (!$gperm_handler->checkRight('module_read', $mid, $groupid2)) {
						$gperm_handler->addRight('module_read', $mid, $groupid2);
					}
				}
			}
			
			// delete the right to access moderator block from registered user.
			$criteria = new CriteriaCompo();
			$criteria->add( new Criteria( 'gperm_groupid', $groupid_registered ) );
			$criteria->add( new Criteria( 'gperm_itemid', $bids['b_xoonips_moderator_show'] ) );
			$criteria->add( new Criteria( 'gperm_name', 'block_read' ) );
			
			$objects = $gperm_handler->getObjects($criteria);
			if ( count( $objects ) == 1 ){
				$gperm_handler->delete( $objects[0] );
			}
			
			// set moderator_gid
			global $xoopsDB;
			$result = $xoopsDB->query(sprintf("DELETE FROM %s WHERE name='moderator_gid'", $xoopsDB->prefix("xoonips_config")));
			$result = $xoopsDB->query(sprintf("INSERT INTO %s (name, value) VALUES ('moderator_gid', %s)", $xoopsDB->prefix("xoonips_config"), $groupid ));
			if( !$result ){
				$error = true; //database query error
			}
			
			// The user that installed XooNips module is set to be XooNIps moderator(to pickup user and to certify users).
			$private_item_number_limit  = (int)xoonips_get_config('private_item_number_limit');
			$private_index_number_limit = (int)xoonips_get_config('private_index_number_limit');
			$private_item_storage_limit = (int)xoonips_get_config('private_item_storage_limit');
			
			$uid = $xoopsUser->getVar('uid');
			$esc_uname = addslashes($xoopsUser->getVar('uname'));
			$max_int = 2147483647;
			$sort_number = $max_int-1;
			$xnp_users = $xoopsDB->prefix('xoonips_users');
			$xnp_item_basic = $xoopsDB->prefix('xoonips_item_basic');
			$xnp_item_title = $xoopsDB->prefix('xoonips_item_title');
			$xnp_index = $xoopsDB->prefix('xoonips_index');
			$xnp_groups_users_link = $xoopsDB->prefix('xoonips_groups_users_link');
			
			$result1 = xoonips_query( "insert into $xnp_users ( uid, activate, private_item_number_limit, private_index_number_limit, private_item_storage_limit ) values ( $uid, 1, $private_item_number_limit, $private_index_number_limit, $private_item_storage_limit )" );
			$result2 = xoonips_query( "insert into $xnp_item_basic (item_type_id, uid, title) values (".ITID_INDEX.",$uid,'$esc_uname')" );
			$xid = mysql_insert_id();
			$result3 = xoonips_query( "insert into $xnp_item_title (item_id,title) values (${xid},'$esc_uname')" );
			$result4 = xoonips_query( "insert into $xnp_index (index_id, parent_index_id, uid, gid, open_level, sort_number) values ($xid,".IID_ROOT.",$uid,NULL,".OL_PRIVATE.",$sort_number)" );
			$result5 = xoonips_query( "update $xnp_users set private_index_id = $xid where uid = $uid " );
			$result6 = xoonips_query( "insert into ${xnp_groups_users_link} values ( 0, ${uid}, 0 )" );
			if ( $result1 == false || $result2 == false || $result3 == false || $result4 == false || $result5 == false || $result6 == false )
				$error = true;
			
			$member_handler =& xoops_gethandler('member');
			$member_handler->addUserToGroup($groupid, $uid);
		}
		// register mid in binder
		$table = $xoopsDB->prefix('xoonips_item_type');
		$mid = $xoopsMod->getVar('mid');
		$sql = "UPDATE $table SET mid = $mid WHERE name='xoonips_binder'";
		if ( $xoopsDB->query($sql) == FALSE ){
			// cannot register mid
			return false;
		}
	}else{
		$error = true; //xoonips is not installed
    }
    
	if( $error )
		return false;
	
	return true;
} 

function xoops_module_uninstall_xoonips( $xoopsMod ) {
	//if (everythingIsOK) {
		return true;
	//} else {
	//	return false;
	//}
}




function xoops_module_update_xoonips ( $xoopsMod, $oldversion) {

	global $xoopsDB;
	xoonips_insert_default_configs();
	
	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		$sql = sprintf("ALTER TABLE %s ADD lang CHAR(3) default 'eng'", $xoopsDB->prefix("xoonips_item_basic"));
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
	
	case 101:
		$sql = sprintf("CREATE TABLE %s (  item_id int(10) unsigned NOT NULL, timestamp timestamp(14), created_timestamp int(10) unsigned,  modified_timestamp int(10) unsigned,  deleted_timestamp int(10) unsigned,  is_deleted tinyint(3),  PRIMARY KEY  (item_id), KEY timestamp ( timestamp )) TYPE=MyISAM", $xoopsDB->prefix("xoonips_item_status") );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';
		$result = xnp_load_al_silent();
		if ( $result != 0 ){
			echo "ERROR: line=" . __LINE__ . " cannot load AL(${result}).";
			return false;
		}
		
		$result = xnp_refresh_item_status();
        if ( RES_OK != $result ){
			echo "ERROR: line=" . __LINE__ . "  cannot refresh item status(${result})";
			return false;
		}

        $sql = sprintf( "CREATE TABLE `%s` ("
                        ."`repository_id` int(11) unsigned NOT NULL auto_increment,"
                        ."`URL` varchar(255) default NULL,"
                        ."`last_access_date` int(11) unsigned default NULL,"
                        ."`last_success_date` int(11) unsigned default NULL,"
                        ."`last_access_result` text,"
                        ."`sort` int(10) unsigned NOT NULL default '0',"
                        ."`enabled` int(1) unsigned NOT NULL default '1',"
                        ."`deleted` int(1) unsigned NOT NULL default '0',"
                        ."PRIMARY KEY  (`repository_id`),"
                        ."UNIQUE KEY `url` (`URL`) )", $xoopsDB -> prefix( "xoonips_oaipmh_repositories" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
        
        $sql = sprintf( "CREATE TABLE %s ( "
			."identifier CHAR(255) , "
			."repository_id INT(11) UNSIGNED NOT NULL , "
			."format CHAR(255) NOT NULL, "
			."metadata BLOB DEFAULT NULL, "
			."title TEXT DEFAULT NULL, "
			."search_text TEXT DEFAULT NULL, "
			."PRIMARY KEY(identifier), "
			."FULLTEXT INDEX search( search_text ) )", $xoopsDB -> prefix( "xoonips_oaipmh_metadata" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
	    $sql = sprintf( "CREATE TABLE %s ( "
			."resumption_token CHAR(255), "
			."metadata_prefix CHAR(255), "
			."verb CHAR(32), "
			."args TEXT, "
			."last_item_id int, "
			."limit_row int, "
			."publish_date int, "
			."expire_date int, "
			."PRIMARY KEY(resumption_token) )", $xoopsDB -> prefix( "xoonips_oaipmh_resumption_token" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}

	case 102: //1.02 -> 1.03 support related_to
		$sql = sprintf( "CREATE TABLE %s ( "
						."parent_id int(11) NOT NULL default '0',"
						."item_id int(11) NOT NULL default '0',"
						."PRIMARY KEY  (parent_id,item_id)"
						.")", $xoopsDB -> prefix( "xoonips_related_to" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
	case 103:
	case 110: //1.10(CURRENT) -> 1.11(CURRENT) support file search
	case 111: //1.11(STABLE)
	case 200: //2.00(STABLE)
		xnp_load_init_create_session();
		$xnpsid = $_SESSION['XNPSID'];
		
		$file_table = $xoopsDB->prefix('xoonips_file');
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD COLUMN search_text TEXT" );
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD COLUMN search_module_name VARCHAR(255)" );
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD COLUMN search_module_version FLOAT" );
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD COLUMN header VARCHAR(32) BINARY" );
		
	case 111: //1.11(CURRENT)
		$file_table = $xoopsDB->prefix('xoonips_file');
		$xoopsDB->query( "ALTER TABLE $file_table ADD FULLTEXT search_text ( search_text )" );
		
		$xoopsDB->query(sprintf("DROP TABLE %s", $xoopsDB->prefix("xoonips_search_cache")));
		$xoopsDB->query(sprintf("DROP TABLE %s", $xoopsDB->prefix("xoonips_search_cache_item")));
		$xoopsDB->query(sprintf("DROP TABLE %s", $xoopsDB->prefix("xoonips_search_cache_metadata")));
		$xoopsDB->query(sprintf("DROP TABLE %s", $xoopsDB->prefix("xoonips_search_cache_file")));
		
		$sql = sprintf( "CREATE TABLE %s ( "
						."search_cache_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,"
						."sid INT(10) UNSIGNED NOT NULL default '0',"
						."timestamp TIMESTAMP,"
						."PRIMARY KEY  (search_cache_id)"
						.")", $xoopsDB -> prefix( "xoonips_search_cache" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
		$sql = sprintf( "CREATE TABLE %s ( "
						."search_cache_id INT(10) UNSIGNED NOT NULL,"
						."item_id INT(10) UNSIGNED NOT NULL default '0',"
						."PRIMARY KEY  (search_cache_id, item_id)"
						.")", $xoopsDB -> prefix( "xoonips_search_cache_item" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
		$sql = sprintf( "CREATE TABLE %s ( "
						."search_cache_id INT(10) UNSIGNED NOT NULL,"
						."identifier VARCHAR(255) NOT NULL default '',"
						."PRIMARY KEY  (search_cache_id, identifier)"
						.")", $xoopsDB -> prefix( "xoonips_search_cache_metadata" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
		$sql = sprintf( "CREATE TABLE %s ( "
						."search_cache_id INT(10) UNSIGNED NOT NULL,"
						."file_id INT(10) UNSIGNED NOT NULL default '0',"
						."PRIMARY KEY  (search_cache_id, file_id)"
						.")", $xoopsDB -> prefix( "xoonips_search_cache_file" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
	
	case 112: //1.12 -> 1.13 support show_item(CURRENT)
		$sql = sprintf( "CREATE TABLE %s ( "
						// ."show_id int(11) NOT NULL auto_increment,"
						."item_id int(10) NOT NULL default '0',"
						."uid int(10) NOT NULL default '0',"
						// ."show_state enum('0', '1') NOT NULL default '0',"
						."PRIMARY KEY  (item_id, uid)"
						.")", $xoopsDB -> prefix( "xoonips_item_show" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		
/*
		$sqlf = sprintf("SELECT uid FROM ".$xoopsDB->prefix("xoonips_users")."");
		$resf = $xoopsDB->query($sqlf);
		while($rowf = $xoopsDB->fetchArray($resf)){
			$sqlw = sprintf("SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_basic")." WHERE NOT (item_type_id=1) AND NOT (uid=0)");
			$resw = $xoopsDB->query($sqlw);
			if( !$resw ){
				echo "ERROR: line=" . __LINE__ . " sql=$sqlw " .$xoopsDB->error();
				return false;
			} else {
				while($roww = $xoopsDB->fetchArray($resw)){
					$sqlr = sprintf("INSERT INTO ".$xoopsDB->prefix("xoonips_item_show")." SET item_id=".$roww["item_id"].", uid=".$rowf["uid"]." ");
					$resr = $xoopsDB->query($sqlr);
					if( !$resr ) {
						echo "ERROR: line=" . __LINE__ . " sql=$sqlr " .$xoopsDB->error();
						return false;
					}
				}
			}
		}
*/
		$file_table = $xoopsDB->prefix('xoonips_users');
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD user_order smallint(3) default '0'" );
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD posi smallint(5) default '0'" );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		$tsql = sprintf( "CREATE TABLE %s ( "
						."posi_id smallint(5) NOT NULL auto_increment,"
						."posi_title varchar(50),"
						."posi_order smallint(3) NOT NULL default '0',"
						."PRIMARY KEY  (posi_id)"
						.")", $xoopsDB -> prefix( "xoonips_positions" ) );
		$tresult = $xoopsDB->query($tsql);
		if( !$tresult ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		xoonips_insert_default_positions();

	case 113://(CURRENT)
		$file_table = $xoopsDB->prefix('xoonips_users');
		$result = $xoopsDB->query( "ALTER TABLE $file_table ADD appeal text default NULL" );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}

	case 300://(CURRENT)
		// removing items which lost the link to basic information
		$sql = "SELECT basic.item_id FROM ".$xoopsDB->prefix('xoonips_item_basic')." AS basic LEFT JOIN ".$xoopsDB->prefix('xoonips_item_type')." AS type on basic.item_type_id = type.item_type_id WHERE type.item_type_id IS NULL";
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		$delete = array( );
		while( list( $item_id ) = $xoopsDB->fetchRow($result) ){
			$delete[] = $item_id;
		}
		if( count( $delete ) > 0 ){
			$table = $xoopsDB->prefix('xoonips_item_basic');
			$sql = "DELETE FROM ${table} WHERE item_id in ( ".implode( ",", $delete ).")";
			if ( $xoopsDB->query($sql) == FALSE ){
				echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				return false;
			}
			$table = $xoopsDB->prefix('xoonips_item_status');
			$sql = "UPDATE ${table} SET deleted_timestamp=UNIX_TIMESTAMP(NOW()), is_deleted=1 WHERE item_id in ( ".implode( ",", $delete ).")";
			if ( $xoopsDB->query($sql) == FALSE ){
				echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				return false;
			}
		}

		$basic_table = $xoopsDB->prefix('xoonips_item_basic');
		$result = $xoopsDB->query( "ALTER TABLE ${basic_table} DROP INDEX title" );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		$result = $xoopsDB->query( "ALTER TABLE ${basic_table} CHANGE title title TEXT NULL DEFAULT NULL" );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}

	case 301:
		$basic_table = $xoopsDB->prefix('xoonips_item_basic');
		$result = $xoopsDB->query( "ALTER TABLE ${basic_table} CHANGE doi doi BLOB NULL DEFAULT NULL" );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}

	case 302:
		$sql = sprintf( "CREATE TABLE %s ( "
						."cvitae_id int(11) NOT NULL auto_increment,"
						."uid int(10) NOT NULL default '0',"
						."from_month int(11) default NULL,"
						."from_year int(11) default NULL,"
						."to_month int(11) default NULL,"
						."to_year int(11) default NULL,"
						."cvitae_title text NOT NULL,"
						."cvitae_order smallint(3) NOT NULL default '0',"
						."PRIMARY KEY  (cvitae_id)"
						.")", $xoopsDB -> prefix( "xoonips_cvitaes" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
		

	case 303:
		$sql = "drop table " . $xoopsDB->prefix('xoonips_session') ;
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$sql = "alter table " . $xoopsDB->prefix('xoonips_file') . " change column sid sess_id varchar(32)";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$sql = "alter table " . $xoopsDB->prefix('xoonips_search_cache') . " change column sid sess_id varchar(32) not null";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$sql = "alter table " . $xoopsDB->prefix('xoonips_search_cache') . " add index sess_id ( sess_id )";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
	case 304: // mysql.sqlxoonips_filesearch_text̵äΤɲ
		$file_table = $xoopsDB->prefix('xoonips_file');
		$sql = "ALTER TABLE $file_table ADD COLUMN search_text TEXT";
		$result = $xoopsDB->query( $sql );
		$sql = "ALTER TABLE $file_table ADD FULLTEXT search_text ( search_text )";
		$result = $xoopsDB->query( $sql );
		
	case 305:
		global $xoopsUser;
		$error = false; //!< true if error occured	
		
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->getByDirname('xoonips');
		
		$mid = $module->getVar('mid'); // $xoopsMod->getVar('mid');
		// $groupid = $group->getVar('groupid');
		$groupid_registered = 2;
		$groupid_anonymous = 3;
		
		$block_objects =& XoopsBlock::getByModule( $mid );
		$bids = array();
		foreach( $block_objects as $o )
			$bids[$o -> getVar( 'show_func' )] = $o -> getVar( 'bid' ); // If it is going to investigate by name, it will be troubled when language changes.
		
		if ( !isset($bids['b_xoonips_itemtypes_show'   ]) ) $error = true;
		
		$gperm_handler =& xoops_gethandler('groupperm');
		$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_itemtypes_show'   ], $groupid_anonymous  );
		
		xoonips_set_block_visible( $bids['b_xoonips_itemtypes_show'   ], false );
		
		// itemtype block is arranged by center-center.
		global $xoopsDB;
		$blocks_tab = $xoopsDB->prefix('newblocks');
		$tfunc = 'b_xoonips_itemtypes_show';
		$result = xoonips_query( "update $blocks_tab set side = 5 where show_func = '$tfunc'" );
		if( !$result ){
			$error = true; //database query error
		}

		
		$table = $xoopsDB -> prefix('newblocks');
		$tfunc = "b_xoonips_quick_search_show";
		$result = xoonips_query( "SELECT name FROM $table WHERE show_func = '$tfunc'" );
		if( !$result ) {
			echo "ERROR: " . $xoopsDB -> error();
			return false;
		}
		while( $row = $xoopsDB -> fetchArray($result) ){
			$newtitle = $row['name'];
			$upres = xoonips_query( "UPDATE $table SET title = '$newtitle' where show_func = '$tfunc'" );
			if( !$upres ) {
				echo "ERROR: " . $xoopsDB -> error();
				return false;
			}
		}

	case 306://3.06 -> 3.10
	case 310:

		// xoonips_file.search_text ̥ơ֥˰ư
		$sql = sprintf( "CREATE TABLE %s ( "
						."file_id int(11) NOT NULL,"
						."search_text longtext,"
						."PRIMARY KEY  (file_id),"
						."FULLTEXT INDEX search( search_text ) "
						.")", $xoopsDB -> prefix( "xoonips_search_text" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$file_table = $xoopsDB->prefix('xoonips_file');
		$sql = "ALTER TABLE $file_table DROP COLUMN search_text";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		// update status from already-analyzed to not-yet-analyzed
		$sql = "UPDATE $file_table SET search_module_name=null, search_module_version=null";
		$xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		// construt search_text here from file contents
		// (when you manipulating search_text column, you must call xnpExtractTextAll at the end of the case block)
		xnpExtractTextAll();

	case 311:
		//insert 2 values in xoonips_positions table.
		$sql = sprintf("INSERT INTO ".$xoopsDB->prefix("xoonips_positions")." (posi_title, posi_order) VALUES ('moderator', 500), ('Registered Users', 510)");
		$res = $xoopsDB->query($sql);
		if( !$res ) {
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
	
	case 312:
		// metadata  search_text ʬΤǡ
		xnpRescanMetadata();

	case 313:
/*
		//fix xoonips_item_show
		$usql = "SELECT uid FROM ".$xoopsDB->prefix('xoonips_users')."";
		$ures = $xoopsDB->query($usql);
			if(!$ures) {
				$err = "Can't select data from database.";
			}
			if($ures == FALSE){
				echo "ERROR: SQL=$usql<br />\n error=" . $xoopsDB->error() . "<br />\n";
			}
			$ins_uids = array();
			while( $urow = $xoopsDB->fetchArray($ures) ){
				$ins_uids[] = $urow['uid'];
			}
		$isql = "SELECT item_id FROM ".$xoopsDB->prefix('xoonips_item_status')."";
		$ires = $xoopsDB->query($isql);
			if(!$ires) {
				$err = "Can't select data from database.";
			}
			if($ires == FALSE){
				echo "ERROR: SQL=$isql<br />\n error=" . $xoopsDB->error() . "<br />\n";
			}
			$ins_iids = array();
			while( $irow = $xoopsDB->fetchArray($ires) ){
				$ins_iids[] = $irow['item_id'];
			}
		foreach( $ins_uids as $uid_num => $uid4sql ){
			foreach( $ins_iids as $item_num => $itid ){
				$chk_sql = "SELECT show_id FROM ".$xoopsDB->prefix('xoonips_item_show')." WHERE item_id = ".$itid." AND uid = ".$uid4sql."";
				$chk_res = $xoopsDB->query($chk_sql);
				$num_sid = $xoopsDB->fetchArray($chk_res);
				$chk_sid = intval($num_sid['show_id']);
					if( $num_sid == 0 ) {
						$ins_sql = "INSERT INTO ".$xoopsDB->prefix('xoonips_item_show')." (item_id, uid) VALUES (".$itid.", ".$uid4sql.")";
						$ins_res = $xoopsDB->query($ins_sql);
						if(!$ins_res) {
							$err = "Can't select data from database.";
						}
						if($ins_res == FALSE) {
							echo "ERROR: SQL=$ins_sql<br />\n error=" . $xoopsDB->error() . "<br />\n";
						}
					}
			}
		}
*/	
	case 314:
		// modify table structure of item_basic
        $sql = "CREATE TABLE ".$xoopsDB -> prefix( "xoonips_item_title" )." ("
            ."  item_id int(10) unsigned NOT NULL,"
            ."  title_id int(10) unsigned NOT NULL,"
            ."  title varchar(255) default NULL,"
            ."  PRIMARY KEY  (item_id,title_id),"
            ."  KEY title (title)"
            .") TYPE=MyISAM";
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
            return false;
		}
        
        $sql = "CREATE TABLE ".$xoopsDB -> prefix( "xoonips_item_keyword" )." ("
            ."  item_id int(10) unsigned NOT NULL,"
            ."  keyword_id int(10) unsigned NOT NULL,"
            ."  keyword varchar(255) default NULL,"
            ."  PRIMARY KEY  (item_id,keyword_id),"
            ."  KEY keyword (keyword)"
            .") TYPE=MyISAM";
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
            $result = $xoopsDB->query("DROP TABLE ".$xoopsDB -> prefix( "xoonips_item_keyword" ));
            return false;
		}
		
		//convert titles and keywords and then move to new tables
		$sql = "select item_id, title, keywords from ".$xoopsDB -> prefix( "xoonips_item_basic" );
		$result = $xoopsDB->query($sql);
		if( $result ){
			while( list( $item_id, $titles, $keywords ) = $xoopsDB->fetchRow($result) ){
				//titles
				$values = array();
				$i=0;
				foreach( preg_split( "/[\r\n]+/", $titles ) as $title ){
					$title = trim( $title );
					if( $title === '' ) continue;
					$values[] = "( ${item_id}, ${i}, '".addslashes( $title )."')";
					$i++;
				}
				if( count( $values ) == 0 ) continue;//process next item if no titles
				$sql = "insert into ".$xoopsDB -> prefix( "xoonips_item_title" )." (item_id,title_id,title) values ".implode( ",", $values );
				$result2 = $xoopsDB->query($sql);
				if( !$result2 ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
					return false;
				}

				//keywords
				$values = array();
				$i=0;
				foreach( explode( ",", $keywords ) as $keyword ){
					$keyword = trim( $keyword );
					if( $keyword === '' ) continue;
					$values[] = "( ${item_id}, ${i}, '".addslashes( $keyword )."')";
					$i++;
				}
				if( count( $values ) == 0 ) continue;//process next item if no keywords
				$sql = "insert into ".$xoopsDB -> prefix( "xoonips_item_keyword" )." (item_id,keyword_id,keyword) values ".implode( ",", $values );
				$result2 = $xoopsDB->query($sql);
				if( !$result2 ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
					return false;
				}

			}
		}
	
		$ar = array(
			'viewed_item'       => 'item_id int(10)      unsigned not null,  count     int(10) unsigned not null,   primary key ( item_id )',
			'downloaded_item'   => 'item_id int(10)      unsigned not null,  count     int(10) unsigned not null,   primary key ( item_id )',
			'contributing_user' => 'item_id int(10)      unsigned not null,  uid       int(10) unsigned not null,   timestamp timestamp,  primary key ( item_id ) ',
			'searched_keyword'  => 'keyword varchar(255) binary   not null,  count     int(10) unsigned not null,   primary key ( keyword )',
			'active_group'      => 'gid     int(10)      unsigned not null,  count     int(10) unsigned not null,   primary key ( gid )',
			'new_item'          => 'item_id int(10)      unsigned not null,  timestamp timestamp,                   primary key ( item_id )',
			'new_group'         => 'gid     int(10)      unsigned not null,  timestamp timestamp,                   primary key ( gid )',
		);
		foreach ( $ar as $name => $columns ){
			$xoopsDB->query( "CREATE TABLE ".$xoopsDB->prefix('xoonips_ranking_'    .$name)." ( $columns )" );
			$xoopsDB->query( "CREATE TABLE ".$xoopsDB->prefix('xoonips_ranking_sum_'.$name)." ( $columns )" );
		}
		xnpRecalcRanking(false);
	
	case 315:
		$sql = "delete from ".$xoopsDB->prefix('xoonips_related_to')." where item_id=0";
		if( $xoopsDB->query($sql) == false )
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		
		$sql = "delete from ".$xoopsDB->prefix('xoonips_index_item_link')." where item_id=0";
		if( $xoopsDB->query($sql) == false )
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
	
	case 316:
		$sql = "create table ".$xoopsDB->prefix("xoonips_session")." ( sess_id varchar(32), updated timestamp, uid int(10) unsigned, primary key ( sess_id ))";
		if( $xoopsDB->query($sql) == false )
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
	
	case 317:
		$sql = "alter table ".$xoopsDB->prefix("xoonips_file")." add column timestamp timestamp";
		if( $xoopsDB->query($sql) == false )
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
	
	case 318:
		$sql = "alter table ".$xoopsDB->prefix("xoonips_session")." add column su_uid int(10) unsigned";
		if( $xoopsDB->query($sql) == false )
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
	
	case 319:
		// 
		// resolve not unique file_type_name 'presentation_file' and 'data_file'
		// 
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->getByDirname('xnpconference');
		if( $module ){
			$result = $xoopsDB->query("update " . $xoopsDB -> prefix( "xoonips_file_type" ) . " set name='conference_file', display_name='Presentation file of Conference' where name='presentation_file' and mid=" . $module -> mid() );
			if ( $result == false ){
				echo "ERROR: " . $xoopsDB->error();
				return false;
			}
		}

		$module =& $module_handler->getByDirname('xnpfiles');
		if( $module ){
			$result = $xoopsDB->query("update " . $xoopsDB -> prefix( "xoonips_file_type" ) . " set name='files_file', display_name='Data file of Files' where name='data_file' and mid=" . $module -> mid() );
			if ( $result == false ){
				echo "ERROR: " . $xoopsDB->error();
				return false;
			}
		}

		$sql = "alter table ".$xoopsDB->prefix("xoonips_file_type")." modify name varchar(30) NOT NULL, add unique ( name )";
		if( $xoopsDB->query($sql) == false ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}
	
	case 320:
		// 
		// add unique key restriction to xoonips_file_type if that doesn't have unique key for name.
		// For recovery of failure of dupulicate keys of name in updating from 3.19 to 3.20.
		// If the update is failed, update it again after removing dupulicate keys.
		// 
		$sql = "select name from ".$xoopsDB->prefix("xoonips_file_type");
		$result = $xoopsDB->query($sql);
		if( $result == false ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			return false;
		}else{
			// 
			// make sure that name doesn't have unique key restriction.
			// 
			$flags = mysql_field_flags($result, 0);
			if( !in_array( 'unique_key', explode(' ', $flags) ) ){
				// 
				// add unique key restriction to name
				// 
				$sql = "alter table ".$xoopsDB->prefix("xoonips_file_type")." modify name varchar(30) NOT NULL, add unique ( name )";
				if( $xoopsDB->query($sql) == false ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
					return false;
				}
			}
		}
	
	case 321:
		//
		// modify table structure
		//
		$basic_table = $xoopsDB->prefix('xoonips_item_basic');
		$search_table = $xoopsDB->prefix('xoonips_search_text');
		$file_table = $xoopsDB->prefix('xoonips_file');

		$sql = "SHOW INDEX from $basic_table";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		while( $row = $xoopsDB -> fetchArray( $result ) ){
			if( $row[ 'Key_name' ] == 'title' ){
				$sql = "ALTER TABLE $basic_table DROP INDEX title";
				$result = $xoopsDB->query( $sql );
				if( !$result ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				}
			}
		}
		
		$sql = "ALTER TABLE $basic_table CHANGE COLUMN title title TEXT NULL default NULL";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$sql = "ALTER TABLE $search_table modify file_id int(10)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
		$sql = "SELECT search_text FROM $file_table";
		$result = $xoopsDB->query( $sql );
		if( $result ){
			$sql = "ALTER TABLE $file_table DROP COLUMN search_text";
			$sec_result = $xoopsDB->query( $sql );
			if( !$sec_result ){
				echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			}
		}
		
		// 
		// change table type from MyISAM to InnoDB
		//
		// - remove title index from xoonips_item_basic to convert innodb;
		// - convert tables from myisam to innodb
		// 
		$basic_title = $xoopsDB->prefix('xoonips_item_basic');
		$sql = "SHOW INDEX from $basic_table";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		while( $row = $xoopsDB -> fetchArray( $result ) ){
			if( $row[ 'Column_name' ] == 'title' ){
				$sql = "ALTER TABLE $basic_table drop index title";
				$result = $xoopsDB->query( $sql );
				if( !$result ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				}
			}
		}
		foreach( array( 'xoonips_file',
						'xoonips_index',
						'xoonips_index_item_link',
						'xoonips_item_basic',
						'xoonips_item_keyword',
						'xoonips_item_title',
						'xoonips_related_to',
						'xoonips_event_log' ) as $table ){
			$sql = "ALTER TABLE " . $xoopsDB->prefix( $table ) . " TYPE = innodb";
			$result = $xoopsDB->query( $sql );
			if( !$result ){
				echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			}
		}


	case 322:
		// set mid in xoonips_binder
		$module_table = $xoopsDB->prefix('modules');
		$itemtype_table = $xoopsDB->prefix('xoonips_item_type');
		$sql = "SELECT mid FROM $itemtype_table WHERE name='xoonips_binder'";
		$res = $xoopsDB->query($sql);
		if( !$res ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		} else {
			while( $row = $xoopsDB->fetchArray($res) ){
				if( $row['mid'] == null ){
					$sql = "SELECT mid FROM $module_table WHERE dirname='xoonips'";
					$res = $xoopsDB->query($sql);
					if( !$res ){
						echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
					}
					$row = $xoopsDB->fetchArray( $res );
					$mid = intval( $row['mid'] );
						$sql = "UPDATE $itemtype_table SET mid = $mid WHERE name='xoonips_binder'";
						$res = $xoopsDB->query( $sql );
						if( !$res ){
							echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
						}
				}
			}
		}
		
		// modify xoonips_item_show
		$tab_name = $xoopsDB->prefix('xoonips_item_show');
		$sql = "SELECT * FROM $tab_name LIMIT 1";
		$res = $xoopsDB->query($sql);
		if( !$res ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		} else {
			$row = $xoopsDB->fetchArray($res);
			if( $row['show_id'] ){
				$sql = "DELETE FROM $tab_name WHERE show_state = '0'";
				$res = $xoopsDB->query($sql);
				if( !$res ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				}
				$sql = "ALTER TABLE $tab_name DROP show_id, DROP show_state";
				$res = $xoopsDB->query($sql);
				if( !$res ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				}
				$sql = "ALTER TABLE $tab_name ADD PRIMARY KEY (item_id, uid) ";
				$res = $xoopsDB->query($sql);
				if( !$res ){
					echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
				}
			}
		}

	case 323:
		$sql = "ALTER TABLE " . $xoopsDB->prefix('xoonips_item_status') . " TYPE = InnoDB";
		$res = $xoopsDB->query( $sql );
		if( !$res ){
			echo "ERROR: can't alter table xoonips_item_status line at " . __LINE__;
			trigger_error( "sql=$sql " .$xoopsDB->error() );
		}

	default:
		return true;
	}
	
}
?>
