<?php
//  $Revision: 1.3.2.1 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
// 
// send a mail to notice new item
// 
// 

include_once 'condefs.php';

$xoopsOption['pagetype'] = 'user';
$xoopsOption['nocommon'] = '';
include '../../mainfile.php';

include_once XOOPS_ROOT_PATH.'/class/logger.php';
include_once XOOPS_ROOT_PATH.'/include/functions.php';

include_once XOOPS_ROOT_PATH.'/class/database/databasefactory.php';
$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

include_once XOOPS_ROOT_PATH.'/kernel/object.php';
include_once XOOPS_ROOT_PATH.'/class/criteria.php';
include_once XOOPS_ROOT_PATH."/class/module.textsanitizer.php";

$config_handler =& xoops_gethandler('config');
$xoopsConfig =& $config_handler->getConfigsByCat(XOOPS_CONF);

include_once XOOPS_ROOT_PATH.'/class/xoopsmailer.php';

$t_users = $xoopsDB->prefix("users");
$t_xnpusers = $xoopsDB->prefix("xoonips_users");
$sql = "SELECT ${t_users}.uid, uname, email, notice_mail, notice_mail_since FROM ${t_users} LEFT JOIN ${t_xnpusers} ON ${t_users}.uid = ${t_xnpusers}.uid";
$result = $xoopsDB -> query( $sql );

while( list( $uid, $uname, $email, $notice_mail, $notice_mail_since ) = $xoopsDB->fetchRow( $result) ){
//    print_r( array( $uid, $uname, $email, $notice_mail, $notice_mail_since ) );
    if( $notice_mail == 0 || ( time() - $notice_mail_since ) < 24 * 3600 * $notice_mail ) continue;

    $sql = "SELECT COUNT(DISTINCT ti.item_id) FROM ";
    $sql = $sql. $xoopsDB->prefix("xoonips_index_item_link") . " AS tlink";
    $sql = $sql. " LEFT JOIN " . $xoopsDB->prefix("xoonips_index") . " AS tx ON tlink.index_id = tx.index_id";
    $sql = $sql. " LEFT JOIN " . $xoopsDB->prefix("xoonips_item_basic") . " AS ti ON tlink.item_id = ti.item_id";
    $sql = $sql. " LEFT JOIN " . $xoopsDB->prefix("xoonips_groups_users_link") . " AS tgulink ON tx.gid=tgulink.gid";
    $sql = $sql. " WHERE ( tx.open_level=".OL_PUBLIC;
    $sql = $sql.       " AND certify_state=".CERTIFIED;
    $sql = $sql.    " OR tx.open_level=".OL_GROUP_ONLY;
    $sql = $sql.      " AND tgulink.uid=${uid}";
    $sql = $sql.      " AND ( certify_state=".CERTIFIED;
    $sql = $sql.            " OR tgulink.is_admin=1 )"; //group administrator?
    $sql = $sql.    " OR tx.open_level=".OL_PRIVATE;
    $sql = $sql.       " AND tx.uid=${uid}";
    $sql = $sql.    " OR tx.uid IS NULL ";
    $sql = $sql.      " AND tx.open_level=".OL_PUBLIC;
    $sql = $sql.      " AND certify_state=".CERTIFIED;
    $sql = $sql. " ) AND ti.item_type_id != ".ITID_INDEX;

    $result2 = $xoopsDB -> queryF( $sql );
    list( $count ) = $xoopsDB->fetchRow( $result2 );
    
    if( $count == 0 ) continue;

    $myts =& MyTextSanitizer::getInstance();
    $xoopsMailer =& new XoopsMailer();
    $xoopsMailer->useMail( );
    $xoopsMailer->setToEmails( $email );
    $xoopsMailer->setFromEmail( $xoopsConfig['adminmail'] );
    $xoopsMailer->setFromName( $xoopsConfig['sitename'] );
    $xoopsMailer->setSubject( _MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_SUBJECT );
    $xoopsMailer->setBody( _MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_BODY );
    $xoopsMailer->setBody(  );
    $xoopsMailer->send( );
    print "send e-mail to ${email}\n";
    $sql = "UPDATE ${t_xnpusers} SET notice_mail_since=".time();
    $result2 = $xoopsDB -> queryF( $sql );
}
?>
