<?php
// $Id: user.php,v 1.11 2006/11/20 07:29:32 tani Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();

$op = 'main';

if ( isset($_POST['op']) ) {
    $op = trim($_POST['op']);
} elseif ( isset($_GET['op']) ) {
    $op = trim($_GET['op']);
}

if ($op == 'main') {
    if ( !$xoopsUser ) {
        $xoopsOption['template_main'] = 'xoonips_userform.html';
        include '../../header.php';
        if (isset($_COOKIE[$xoopsConfig['usercookie']])) {
            $xoopsTpl->assign('usercookie', $_COOKIE[$xoopsConfig['usercookie']]);                
        }
        if (isset($_GET['xoops_redirect'])) {
            $xoopsTpl->assign('redirect_page', htmlspecialchars(trim($_GET['xoops_redirect']), ENT_QUOTES));
        }
		if ( isset($_SESSION["back_url"]) ){
			$back_url = $_SESSION["back_url"];
			$xoopsTpl->assign('redirect_page', htmlspecialchars(trim($back_url), ENT_QUOTES));
		}
        include '../../footer.php';
    } elseif ( $xoopsUser ) {
        header('Location: '.XOOPS_URL.'/modules/xoonips/showusers.php?uid='.$xoopsUser->getVar('uid'));
    }
    exit();
}

if ($op == 'login') {
    require_once 'include/create_session.php';
    xnp_load_al();
    include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/checklogin.php';
    exit();
}

if ($op == 'logout') {
    // logout of Platform
    require_once 'include/create_session.php';
    xnp_load_init_create_session();
    $xnpsid = $_SESSION['XNPSID'];
    
    // record event(logout)
    require_once('include/lib.php');
    
    if ( isset($_SESSION['xoonips_old_uid']) ){
        redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_SU_CANNOT_LOGOUT );
    }
    if ( isset($_SESSION['xoopsUserId']) ){ // reject if $_SESSION is empty($_SESSION is empty if reload logout page)
        xnp_insert_event( $xnpsid, ETID_LOGOUT, time(), $_SESSION['xoopsUserId'], xnpGetRemoteHost(), array() );
    }
    $result = $xoopsDB->queryF( "delete from " . $xoopsDB->prefix('xoonips_session') . " where sess_id = '".addslashes( session_id() )."'" );
    if ( $xnpsid ){
        xnp_logout_user( $xnpsid );
    }
    
    // logout
    $message = '';
    $_SESSION = array();
    session_destroy();
    if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
        setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
    }
    // clear autologin cookies
    //setcookie('autologin_uname', '', time() - 3600, '/', '', 0);
    //setcookie('autologin_pass', '', time() - 3600, '/', '', 0);
    // clear entry from online users table
    if (is_object($xoopsUser)) {
        $online_handler =& xoops_gethandler('online');
        $online_handler->destroy($xoopsUser->getVar('uid'));
    }
    
    // remove files which are not associated from any item and any session
    xnpCleanup(); 
    
    $message = _US_LOGGEDOUT.'<br />'._US_THANKYOUFORVISIT;
    redirect_header(XOOPS_URL.'/index.php', 1, $message);
    
    exit();
}

if ($op == 'lostpass') {
	// get constant of '_US_*' -> refer to xnpaccount_userform.html
	require_once(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php');
	
	// page for password lost
	$xoopsOption['template_main'] = 'xoonips_userform.html';
	require(XOOPS_ROOT_PATH.'/header.php');
	require(XOOPS_ROOT_PATH.'/footer.php');
	exit();
}

// activate an account of user(uid=$id)
if ($op == 'actv') {
    $id = intval($_GET['id']);
    $actkey = trim($_GET['actkey']);
    if (empty($id)) {
        redirect_header('index.php',1,'');
        exit();
    }
    $member_handler =& xoops_gethandler('member');
    $thisuser =& $member_handler->getUser($id);
    if (!is_object($thisuser)) {
        exit();
    }
    if ($thisuser->getVar('actkey') != $actkey) {
        redirect_header('index.php',5,_US_ACTKEYNOT);
    } else {
        if ($thisuser->getVar('level') > 0 ) {
            redirect_header('user.php',5,_US_ACONTACT);
        } else {
            if (false != $member_handler->activateUser($thisuser)) {
                include 'header.php';
                // To send e-mail to activated user.
                $config_handler =& xoops_gethandler('config');
                $xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
                if( xnp_get_config_value( 'certify_user', $certify_user ) == RES_OK ){
                    if( $certify_user == "on" ){
                        //To send a e-mail to users who are belong to the group specified by moderator_gid if certify_user is 'manual' 
                        if( xnp_get_config_value( 'moderator_gid', $moderator_gid ) == RES_OK ){
                            $myts =& MyTextSanitizer::getInstance();
                            $xoopsMailer =& getMailer();
                            $xoopsMailer->useMail();
                            $member_handler =& xoops_gethandler('member');
                            $xoopsMailer->setTemplateDir(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/mail_template/" );
                            $xoopsMailer->setTemplate('xoonips_certify_manual.tpl');
                            $xoopsMailer->assign('USERNAME', $myts->oopsStripSlashesGPC($thisuser -> getVar('uname')));
                            $xoopsMailer->assign('USEREMAIL', $myts->oopsStripSlashesGPC($thisuser -> getVar('email')));
                            $xoopsMailer->assign('USERACTLINK', XOOPS_URL.'/modules/xoonips/certifyuser.php' );
                            $xoopsMailer->assign('USERINFOLINK', XOOPS_URL.'/modules/xoonips/userinfo.php?uid='. $thisuser -> getVar('uid') );
                            $xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
                            $xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
                            $xoopsMailer->assign('SITEURL', XOOPS_URL."/");
                            $xoopsMailer->setToGroups($member_handler->getGroup($moderator_gid));
                            $xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
                            $xoopsMailer->setFromName($xoopsConfig['sitename']);
                            $xoopsMailer->setSubject(_MD_XOONIPS_ACCOUNT_REGISTERD);
                            if( !$xoopsMailer->send() ){
                                if ($xoopsConfigUser['activation_type'] == 2)//activate by xoops admin & certify manual
                                    echo _MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL_MAILNG;
                                else if ($xoopsConfigUser['activation_type'] == 0)//activate by xoops by user & certify manual
                                    echo _MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL_MAILNG;
                            }else{
                                if ($xoopsConfigUser['activation_type'] == 2)//activate by xoops admin & certify manual
                                    echo _MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL;
                                else if ($xoopsConfigUser['activation_type'] == 0)//activate by xoops by user & certify manual
                                    echo _MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL;
                            }
                        }else{
                            redirect_header('index.php',3,"get_config_value failed(moderator_gid)");
                        }
                    }else{//certification automatically
                        if ($xoopsConfigUser['activation_type'] == 2) { //activate xoops account by xoops administrator
                            // 
                            // send e-mail to the registered address
                            // notify a completion of certification to the certified user by e-mail
                            //
                            $myts =& MyTextSanitizer::getInstance();
                            $xoopsMailer =& getMailer();
                            $xoopsMailer->useMail();
                            $xoopsMailer->setTemplateDir(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/mail_template/" );
                            $xoopsMailer->setTemplate('xoonips_account_certified.tpl');
                            $xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
                            $xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
                            $xoopsMailer->assign('SITEURL', XOOPS_URL."/");
                            $xoopsMailer->setToUsers($thisuser);
                            $xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
                            $xoopsMailer->setFromName($xoopsConfig['sitename']);
                            $xoopsMailer->setSubject(_MD_XOONIPS_ACCOUNT_CERTIFIED);
                            if ( $xoopsMailer->send() ) {
                                echo _MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO;
                            }else{
                                echo _MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO_MAILNG;
                            }
                        }else{
                            redirect_header( 'user.php', 5, _MD_XOONIPS_ACTIVATED_BY_USER_CERTIFIED_AUTO, false );
                        }
                    }
                }else{
                    redirect_header('index.php',3,"xnp_get_config_value failed(certify_user)");
                }
                include '../../footer.php';
            } else {
                redirect_header('index.php',3,'Activation failed!');
            }
        }
    }
}
?>
