-- $Id: mysql.sql,v 1.2 2003/09/11 05:21:07 kousuke Exp $

-- blog information table
-- uid :
--    xoops uid
-- blog_permission:
--    0: anyone can read, anyone can write comment
--    1: anyone can read, user can write comment
--    3: user can read, user can write comment
-- last_update:
--    update time
CREATE TABLE simpleblog_info (
	uid int(5) unsigned NOT NULL default '0',
	blog_permission tinyint(1) NOT NULL default '0',
	last_update TIMESTAMP NOT NULL ,
	PRIMARY KEY (uid)
) TYPE=MyISAM;

-- blog data table
-- uid :
--     xoops uid
-- blog_date :
--     date of blog
-- title :
--     title of blog
-- post_text :
--     blog data
CREATE TABLE simpleblog (
	uid int(5) unsigned NOT NULL default '0',
	blog_date DATE not null,
	title varchar(200),
	post_text text,
	PRIMARY KEY  (uid, blog_date)
) TYPE=MyISAM;

-- blog comment table
-- uid :
--     xoops uid
-- blog_date :
--     date of blog
-- comment_id :
--     sequential comment id. 
-- comment_uid :
--     uid of comment user. set value to 0 if guest user
-- comment_name :
--     guest user name. 
-- post_text :
--     comment data
CREATE TABLE simpleblog_comment (
	uid int(5) unsigned NOT NULL default '0',
	blog_date DATE not null,
	comment_id int(8) unsigned NOT NULL auto_increment,
	comment_uid int(5) unsigned NOT NULL default '0',
	comment_name varchar(200),
	post_text text,
	KEY (uid, blog_date),
	PRIMARY KEY (comment_id)
) TYPE=MyISAM;


