<?php
// $Id: simpleblog.php,v 1.49 2003/10/23 04:50:24 kousuke Exp $
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/conf.php';
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/language/'.$xoopsConfig['language'].'/main.php';
// include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";


class SimpleBlog {
	var $VIEW_NUM = 20;
	
	
	var $user_list;
	var $blogUid;
	var $targetUser;
	var $userHander;
	var $permission = -1;
	var $title = '';
	var $usersCache = array();
	var $ts;
	var $xoopsDB;
	
	function SimpleBlog($blogUid = -1){
		global $xoopsDB;
		$this->xoopsDB =& $xoopsDB;
		$this->userHander = new XoopsUserHandler($this->xoopsDB);
		$this->ts =& MyTextSanitizer::getInstance();
		$this->user_list = array();
		$this->blogUid = intval($blogUid);
		
		
		if($this->blogUid > 0){
			$this->targetUser = $this->userHander->get($this->blogUid);
			if(!$this->targetUser->isActive()){
				redirect_header(SIMPLEBLOG_DIR,2,_MD_SIMPLEBLOG_NORIGHTTOACCESS);
				exit();
			}
			$usersCache[$this->blogUid] = $this->targetUser;
		}else{
			redirect_header(XOOPS_URL.'/',1,_MD_INTERNALERROR.'(99.0) ['.$this->blogUid.']');
			exit();
		}
	}
	
	function getAllApplication(){
		global $xoopsDB;
		if(!$qResult = $xoopsDB->query('select uid, title, permission, create_date from '.SIMPLEBLOG_TABLE_APPL.' order by create_date' )){
			return false;
		}
		$result = array();
		while(list($uid, $title, $permission, $create_date) = $xoopsDB->fetchRow($qResult)){
			$result[] = array(
				'uid' => $uid, 
				'title' => $title, 
				'permission' => $permission, 
				'create_date' => $create_date);
		}
		return $result;
	}
	
	function deleteApplication($in_uid){
		global $xoopsDB;
		$uid = intval($in_uid);
		if($uid > 0){
			 $xoopsDB->queryF(sprintf('delete from %s where uid = %u', SIMPLEBLOG_TABLE_APPL, $uid));
		}
	}
	
	
	
	function getTargetUname(){
		return $this->targetUser->uname();
	}
	/**
	 * create new blog user
	 */
	function createNewBlogUser($permission = 0, $title = ''){
		global $xoopsUser;
		
		$result = $this->xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		if(list($localuid) = $this->xoopsDB->fetchRow($result)){
			return false;
		}else{
			$this->xoopsDB->queryF('insert into '.SIMPLEBLOG_TABLE_INFO.'(uid, blog_permission, last_update, title) values ('.$this->blogUid.', '.intval($permission).', \'0000-00-00\', \''.$title.'\')');
			$result = $this->xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$this->blogUid);
			if(list($appUid ) = $this->xoopsDB->fetchRow($result)){
				$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$this->blogUid);
			}
			return true;
		}
	}
	
	function setBlogInfo($permisstion = 0, $title = ""){
		$this->xoopsDB->queryF('update '.SIMPLEBLOG_TABLE_INFO.' set blog_permission = '.intval($permisstion).', title=\''.$title.'\' where uid ='.$this->blogUid);
	}
	
	function deleteAll(){
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid);
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid);
	}
	
	function loadBlogInfo(){
		global $xoopsUser;
		$sql = 'select blog_permission, title from '.SIMPLEBLOG_TABLE_INFO.' where uid='.$this->targetUser->uid();
		if(!$result = $this->xoopsDB->query($sql)){
			return false;
		}
		if(list($permission, $title) = $this->xoopsDB->fetchRow($result)){
			$this->permission = $permission;
			$this->title = $title;
			return true;
		}
		return false;
		
	}
	function canWrite(){
		global $xoopsUser;
		if(!$xoopsUser){
			return false;
		}else if($this->permission < 0){
			if(!$this->loadBlogInfo()){
				return false;
			}
		}
		if($xoopsUser->uid() == $this->blogUid){
			return true;
		}
		return false;	
	}
	
	function canRead(){
		global $xoopsUser;
		if($xoopsUser){
			return true;
		}
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if($this->permission < 2){
			return true;
		}
		return false;
	}
	
	function canComment(){
		global $xoopsUser;
		if($xoopsUser){
			return true;
		}
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if($this->permission == 0){
			return true;
		}
		return false;
	}
	
	function getTitle(){
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		if($this->title != ''){
			return $this->title;
		}else{
			return _MI_SIMPLEBLOG_TITLE_PREFIX.$this->getTargetUname()._MI_SIMPLEBLOG_TITLE_SUFFIX;
		}
	}
	
	
	function getBlogData($year = 0, $month = 0, $date = 0, $limit = 0){
		global $xoopsUser;
		if($limit == 0){
			$limit = SIMPLEBLOG_VIEW_LIST_NUM;
		}
		$dateFormat = '%y/%m/%d';
		if(!$this->canRead()){
			redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_NORIGHTTOACCESS);
			exit();
		}
		$sql_blog = '';
		
		if( ($year > 1000) && ($month > 0) ){
			if($date > 0){ // display date blog
					if(checkdate($month, $date, $year)){
						$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date= \''.$year.'-'.$month.'-'.$date.'\' order by blog_date desc ';
					}
			}else{ // display month blog
				$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and DATE_FORMAT(blog_date, \'%Y\')='.$year.' and DATE_FORMAT(blog_date, \'%m\') = '.$month.' order by blog_date desc ';
			}
		}
		if($sql_blog == ''){ // display current blog
			$sql_blog = 'select blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' order by blog_date desc limit '.$limit;
		}
		
		if(!$result_blog = $this->xoopsDB->query($sql_blog)){
			return false;
		}
		$result = array();
		$i = 0;
	
		while(	list(
				$result_date, 
				$result_title,
				$result_post_text
			) = $this->xoopsDB->fetchRow($result_blog)
		){

			$result['blog'][$i]['year'] = mb_strcut($result_date, 0, 4);
			$result['blog'][$i]['month'] = mb_strcut($result_date, 5, 2);
			$result['blog'][$i]['date'] = mb_strcut($result_date, 8, 2);
			$result['blog'][$i]['date_all'] = $result_date;
			$result['blog'][$i]['title'] = $result_title;
			$result['blog'][$i]['text'] = $this->ts->makeTareaData4Show($result_post_text);
			$result['blog'][$i]['text_edit'] = $this->ts->makeTareaData4Edit($result_post_text);
			$result['blog'][$i]['comments'] = $this->getComments($result_date);
			$i++;
		}
		
		
		$result['blog_num'] = $i;
		$time = time();
		$result['today']['year'] = date('Y',$time);
		$result['today']['month'] = date('m',$time);
		$result['today']['date'] = date('d',$time);
		$result['user'] = $this->targetUser;
		$result['uname'] = $this->targetUser->uname();
		return $result;
	}
	
	
	
	function getBlog1($dates){
		global $xoopsUser;
		$sql = 'select title, post_text FROM '.SIMPLEBLOG_TABLE_BLOG.' WHERE uid = '.$this->blogUid.' and  blog_date = \''.$dates['sql_date'].'\'';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		
		$result['year'] = $dates['year'];
		$result['month'] = $dates['month'];
		$result['date'] = $dates['date'];
			
		if(list($title, $text) = $this->xoopsDB->fetchRow($result_select)){
			
			$result['date_all'] = $dates['sql_date'];
			$result['title'] = $title;
			$result['text'] = $this->ts->makeTareaData4Show($text);
			$result['text_edit'] = $this->ts->makeTareaData4Edit($text);
		}
		return $result;
	}
	
	
	function updateBlog($dates, $text, $title = ''){
		global $xoopsUser;
		
		$sqlDate = $this->escapeHtml($dates['sql_date']);
		$sqlText = $this->ts->makeTareaData4Save($this->escapeHtml($text));
		$sqlTitle = $this->ts->makeTareaData4Save($this->escapeHtml($title));
		$uid = $xoopsUser->uid();
		if(empty($text)){
			$sql = sprintf("delete from %s where uid=%u and blog_date='%s'", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
		}else{
			$sql = sprintf("select uid from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
			if(!$result_select = $this->xoopsDB->query($sql)){
				return false;
			}
			if($this->xoopsDB->getRowsNum($result_select) == 0){
				$sql = sprintf("insert into %s(uid, blog_date, title, post_text) values(%u, '%s', '%s', '%s')", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate, $sqlTitle, $sqlText);
			}else{
				$sql = sprintf("update %s set title = '%s', post_text = '%s' where uid = %u and blog_date ='%s'", SIMPLEBLOG_TABLE_BLOG, $sqlTitle, $sqlText, $uid, $sqlDate);
			}
		}
		$this->xoopsDB->queryF($sql);
		$this->update();
		return true;
	}
	
	function update(){
		$sql = 'update '.SIMPLEBLOG_TABLE_INFO.' set last_update = CURRENT_TIMESTAMP() where uid = '.$this->blogUid;
		$this->xoopsDB->queryF($sql);
	}
	
	function insertComment($dates, $name, $comment){
		global $xoopsUser;
		$uid = 0;
		if($xoopsUser){
			$uid = $xoopsUser->uid();
		}
		$sqlDate = $this->escapeHtml($dates['sql_date']);
		$sqlName = $this->escapeHtml($name);
		$sqlComment = $this->escapeHtml($comment); 
		$sql = sprintf("select count(*) from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $this->blogUid, $sqlDate);
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		if($this->xoopsDB->getRowsNum($result_select) == 1){
			$sql_base = "insert into %s (uid, blog_date, comment_id, comment_uid, comment_name, post_text) values(%u, '%s', null, %u, '%s', '%s')";
			$sql = sprintf($sql_base, SIMPLEBLOG_TABLE_COMMENT, $this->blogUid, $sqlDate, $uid, $sqlName, $sqlComment);
			$result = $this->xoopsDB->queryF($sql);
			
			$this->update();
			return true;
		}
		return false;
	}
	
	function escapeHtml($text){
		$result = $text;
		// $result = ereg_replace('&', '&amp;', $text);
		$result = ereg_replace('<', '&lt;', $result);
		$result = ereg_replace('>', '&gt;', $result);
		// $result = ereg_replace('\'', '&apos;', $result);
		$result = ereg_replace('"', '&quot;', $result);
		//$result = ereg_replace('\r\n', '\n', $result);
		//$result = ereg_replace('\r', '\n', $result);
		//$result = ereg_replace('\n', '<br />', $result);
		return $result;
	}
	
	function getBlogIndex(){
		global $xoopsUser;
		$sql = 'select distinct DATE_FORMAT(blog_date, \'%Y\') year, DATE_FORMAT(blog_date, \'%m\') month from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date != \'0000-00-00\' order by year desc, month';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		while(list($year, $month) = $this->xoopsDB->fetchRow($result_select)){
			$result[$year][$month] = $month;
		}
		return $result;
	}
	
	function getComments($blogDate){
		global $xoopsUser;
		$sql = 'select comment_id, comment_uid,comment_name, post_text from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid.' and blog_date = '.$this->xoopsDB->quoteString($blogDate).' order by comment_id '; 
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$i = 0;
		$comments = array();
		
		while(
			list($comment_id, $comment_uid, $comment_name, $post_text) = $this->xoopsDB->fetchRow($result_select)
		){
			$comments[$i]['id'] = $comment_id;
			$comments[$i]['uid'] = $comment_uid;
			if($comment_uid > 0){
				if(!in_array($comment_uid, $this->usersCache)){
					$this->usersCache[$comment_uid] = $this->userHander->get($comment_uid);
				}
				$comments[$i]['name'] = $this->usersCache[$comment_uid]->uname();
			}else{
				$comments[$i]['name'] = $comment_name.'@'._MI_SIMPLEBLOG_FORM_GUEST;
			}
			$comments[$i]['comment'] = $post_text;
			$i++;
		}
		return $comments;
	}
	
	function getCompleteDateFromHttpParams(){
		global $HTTP_POST_VARS, $HTTP_GET_VARS;
		$result = array();
		$result['year'] = isset($HTTP_POST_VARS['year']) ? intval($HTTP_POST_VARS['year']) : 0;
		if($result['year'] == 0){
			$result['year'] = isset($HTTP_GET_VARS['year']) ? intval($HTTP_GET_VARS['year']) : 0;
		}
		$result['month'] = isset($HTTP_POST_VARS['month']) ? intval($HTTP_POST_VARS['month']) : 0;
		if($result['month'] == 0){
			$result['month'] = isset($HTTP_GET_VARS['month']) ? intval($HTTP_GET_VARS['month']) : 0;
		}
		$result['date'] = isset($HTTP_POST_VARS['date']) ? intval($HTTP_POST_VARS['date']) : 0;
		if($result['date'] == 0){
			$result['date'] = isset($HTTP_GET_VARS['date']) ? intval($HTTP_GET_VARS['date']) : 0;
		}
		if( ($result['year'] == 0) || ($result['month'] == 0) || ($result['date'] == 0) ){
			return false;
		}
		if($result['year'] != 0){
			if( ($result['year'] < 1000) || ($result['year'] > 3000) ){
				return false;
			}
		}
		
		if($result['month'] != 0){
			if( ($result['month'] < 1) || ($result['month'] > 12) ){
				return false;
			}
		}
		
		if($result['date'] != 0){
			if( ($result['date'] < 1) || ($result['date'] > 31) ){
				return false;
			}
			return $this->dateCheck($result);
		}else{
			return $result;	
		}
	}
	
	function getDateFromHttpParams(){
		global $HTTP_POST_VARS, $HTTP_GET_VARS;
		$result = array();
		$result['year'] = isset($HTTP_POST_VARS['year']) ? intval($HTTP_POST_VARS['year']) : 0;
		if($result['year'] == 0){
			$result['year'] = isset($HTTP_GET_VARS['year']) ? intval($HTTP_GET_VARS['year']) : 0;
		}
		$result['month'] = isset($HTTP_POST_VARS['month']) ? intval($HTTP_POST_VARS['month']) : 0;
		if($result['month'] == 0){
			$result['month'] = isset($HTTP_GET_VARS['month']) ? intval($HTTP_GET_VARS['month']) : 0;
		}
		$result['date'] = isset($HTTP_POST_VARS['date']) ? intval($HTTP_POST_VARS['date']) : 0;
		if($result['date'] == 0){
			$result['date'] = isset($HTTP_GET_VARS['date']) ? intval($HTTP_GET_VARS['date']) : 0;
		}
		
		// check params
		if($result['year'] != 0){
			if( ($result['year'] < 1000) || ($result['year'] > 3000) ){
				return false;
			}
		}
		if($result['month'] != 0){
			if( ($result['month'] < 1) || ($result['month'] > 12) ){
				return false;
			}
		}
		
		if($result['date'] != 0){
			if( ($result['date'] < 1) || ($result['date'] > 31) ){
				return false;
			}
			return $this->dateCheck($result);
		}else{
			if(!checkdate($result['month'], 1, $result['year'])){
				return false;
			}
		}
		
		return $result;
	}
	
	function dateCheck($dates){
		if(!checkdate($dates['month'], $dates['date'], $dates['year'])){
			return false;
		}
		
		$dates['sql_date'] = sprintf("%04u-%02u-%02u", $dates['year'], $dates['month'], $dates['date']);
		return $dates;
	}
	
	//________________________________________________________________________________________________
	//                                                                                 static methods
	
	function newApplication($in_title, $in_permission){
		global $xoopsUser, $xoopsDB;
		$title = "";
		$permission = -1;
		if(!empty($in_title)){
			$title = $in_title;
		}
		if( ($in_permission == 0) || ($in_permission == 1) || ($in_permission == 3)){
			$permission = intval($in_permission);
		}
		
		if($permission < 0){
			return _MI_SIMPLEBLOG_ERR_INVALID_PERMISSION;
		}
		if(!$result = $xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$xoopsUser->uid())){
			return "select error";
		}
		if(list($tmpUid) = $xoopsDB->fetchRow($result)){
			return _MI_SIMPLEBLOG_ERR_APPLICATION_ALREADY_APPLIED;
		}
		if(!$result = $xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$xoopsUser->uid())){
			return "select error";
		}
		if(list($tmpUid) = $xoopsDB->fetchRow($result)){
			return _MI_SIMPLEBLOG_ERR_ALREADY_WRITABLE;
		}
		$sql = sprintf("insert into %s (uid, title, permission, create_date) values(%u, '%s', %u, CURRENT_TIMESTAMP())", 
			SIMPLEBLOG_TABLE_APPL, $xoopsUser->uid(), $title, $permission);
		if(!$result = $xoopsDB->query($sql)){
			return "insert error";
		}
		
		return "";
	}
	
	function get_blog_list($start = 0){
		global $xoopsUser, $xoopsDB;
	
		$block_list_num = 10;
		$permission = 2;
		$dateFormat = '%m/%d %k:%i';
		if ( $xoopsUser ) {
			$permission = 4;
		}
	
		$selectMax = $start + SIMPLEBLOG_BLOCK_LIST_NUM;
		$sql_select = sprintf('select uid, DATE_FORMAT(last_update, \'%s\') last_update, DATE_FORMAT(last_update, \'%s\') last_update4rss, title FROM %s WHERE blog_permission <= %u and last_update != \'0000-00-00\' ORDER BY last_update desc limit %u',
			 $dateFormat, '%Y-%m-%dT%H:%i:%s', SIMPLEBLOG_TABLE_INFO, $permission, $selectMax);
		if(!$result_select = $xoopsDB->query($sql_select)){
			return false;
		}
	
		$tmp = array();
		$i = 0;
		while(	list(
				$result_uid, 
				$result_last_update,
				$last_update4rss,
				$title
			) = $xoopsDB->fetchRow($result_select)
		){
			if($i >= $start){
				$res = array();
				$res['uid'] = $result_uid;
				$res['last_update'] = $result_last_update;
				$res['last_update4rss'] = $last_update4rss;
				$res['title'] = $title;
				$tmp[$i] = $res;
			}
			$i++;
		}
		$block = array();
		$userHander = new XoopsUserHandler($xoopsDB);
		$i = 0;
		foreach ( $tmp as $target ) {
			$tUser = $userHander->get($target['uid']);
			$target['uname'] = $tUser->uname();
			if(empty($target['title'])){
				$target['title'] = _MI_SIMPLEBLOG_TITLE_PREFIX.$target['uname']._MI_SIMPLEBLOG_TITLE_SUFFIX;
			}
			$block[$i] = $target;
			$i++;
		
		}
		return $block;
	}
	
	
	function check_updater(){
		$host = "xoops-modules.sourceforge.jp";
		$port = 80;
		$file = "/update/simpleblog.txt";
		$local = "simpleblog-0.1.0";
		$response = "";

		$request  = "GET ".$file." HTTP/1.0\r\n";
		$request .= "Host: " . $host . ":" . $port . "\r\n";
		$request .= "User-agent: xoops/".$local."\r\n\r\n";

		$fp = fsockopen($host, $port, $errno, $errstr, 10);
		if(! $fp) {
			return false;
		} else {
			fputs($fp, $request);
			while( !feof($fp) ){
				$response .= fread($fp, 4096);
			}
		}
		$pos = strpos($response, "\r\n\r\n");
		$response = substr($response, $pos + 4);
		$pos = strpos($response, "\r");
		if($pos == false){
			$pos = strpos($response, "\n");
		}
		if($pos != false){
			$response = substr($response, 0, $pos);
		}
		return array('request' => $request, 'response' => $response, 'local' => $local);

	}
}

?>