<?php
// $Id: rss.php,v 1.9 2003/11/30 06:18:24 kousuke Exp $

include '../../mainfile.php';
include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/simpleblog.php';

if(function_exists('mb_http_output')) { 
	mb_http_output('pass');
} 

header ('Content-Type: text/xml; charset=utf-8');

$params = SimpleBlogUtils::getDateFromHttpParams();

if($params['uid'] && $params['uid'] > 0){
	$blog = new SimpleBlog($params['uid']);
	$r = array();
	if($blog->canRead()){
		$r = $blog->getBlogData();
	}
	if(empty($r)){
		exit();
	}
	$i = 0;
	echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
	?>
	<rdf:RDF xmlns:dc="http://purl.org/dc/elements/1.1/" 
	         xmlns="http://purl.org/rss/1.0/" 
		 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
		 xml:lang="ja">
	  <channel rdf:about="<?php echo SimpleBlogUtils::createRssUrl($params['uid']); ?>">
	    <title><?php echo xoops_convert_encoding(htmlspecialchars($blog->getTitle(), ENT_QUOTES)); ?></title>
	    <link><?php echo SimpleBlogUtils::createUrl($params['uid']); ?></link>
	    <description></description>
	    <items>
	      <rdf:Seq>
	<?php foreach($r['blog'] as $b){ 
		if($i < 10){
	?>
	        <rdf:li rdf:resource="<?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?>" />
	<?php 
			$i++;
		}
	} 
	$i = 0;
	?>
	      </rdf:Seq>
	    </items>
	  </channel>
	<?php foreach($r['blog'] as $b){ 
		if($i < 10){
			$text = SimpleBlogUtils::remove_html_tags($b['text']);
			$text = (strlen($text) > 100) ? SimpleBlogUtils::mb_strcut($text, 0, 90)."..." : $text;
	?>
	  <item rdf:about="<?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?>">
	    <title><?php echo xoops_convert_encoding(htmlspecialchars($b['title'], ENT_QUOTES)); ?></title>
	    <link><?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?></link>
	    <description><![CDATA[<?php echo xoops_convert_encoding($text);  ?>]]></description>
	    <dc:date><?php echo xoops_convert_encoding(htmlspecialchars($b['last_update4rss'], ENT_QUOTES)); ?></dc:date> 
	    <dc:creator><?php echo xoops_convert_encoding(htmlspecialchars($blog->getTargetUname(), ENT_QUOTES)); ?></dc:creator>
	  </item>
	<?php
			$i++; 
		}
	} ?>
	</rdf:RDF>
<?php
}else{
	$tpl = new XoopsTpl();
	$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/cache');
	$tpl->xoops_setCaching(2);
	$tpl->xoops_setCacheTime(3600);
	if (!$tpl->is_cached('db:simpleblog_rss.html')) {
		$blogList = SimpleBlogUtils::get_blog_list();
		if (is_array($blogList)) {
			$tpl->assign('channel_title', xoops_convert_encoding(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
			$tpl->assign('channel_link', XOOPS_URL.'/');
			$tpl->assign('channel_desc', xoops_convert_encoding(htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
			$tpl->assign('channel_lastbuild', formatTimestamp(time(), 'rss'));
			$tpl->assign('channel_webmaster', $xoopsConfig['adminmail']);
			$tpl->assign('channel_editor', $xoopsConfig['adminmail']);
			$tpl->assign('channel_category', 'News');
			$tpl->assign('channel_generator', XOOPS_VERSION);
			$tpl->assign('channel_language', _LANGCODE);
			$tpl->assign('image_url', XOOPS_URL.'/images/logo.gif');
			$tpl->assign('channel_desc', xoops_convert_encoding(htmlspecialchars($xoopsModuleConfig['blog_description'], ENT_QUOTES)));
		
			foreach ($blogList as $blog) {
				$tpl->append('items', array(
					'title' => xoops_convert_encoding(htmlspecialchars($blog['title'], ENT_QUOTES)), 
					// 'link' => XOOPS_URL.'/modules/simpleblog/view.php?uid='.$blog['uid'], 
					'link' => $blog['url'], 
					'date' => htmlspecialchars($blog['last_update4rss'], ENT_QUOTES),
					'uname' => xoops_convert_encoding(htmlspecialchars($blog['uname'], ENT_QUOTES))
				));
			}
		
			$tpl->assign("_MD_SIMPLEBLOG_TITLE_SUFFIX",xoops_convert_encoding(htmlspecialchars(_MD_SIMPLEBLOG_TITLE_SUFFIX, ENT_QUOTES)));
			$tpl->assign("_MD_SIMPLEBLOG_TITLE_PREFIX",xoops_convert_encoding(htmlspecialchars(_MI_SIMPLEBLOG_TITLE_PREFIX, ENT_QUOTES)));
		}
	}
	$tpl->display('db:simpleblog_rss.html');
}

?>

