<?php
/**
 * @package Legacy
 * @version $Id$
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_LEGACY_PATH."/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_LEGACY_PATH."/admin/class/ModuleInstaller.class.php";
require_once XOOPS_LEGACY_PATH."/admin/forms/ModuleInstallForm.class.php";

/**
 * Install module
 */
class Legacy_ModuleInstallAction extends Legacy_AbstractModuleInstallAction
{
	var $mLicence;
	var $mLicenceText;

	/**
	 * @var XCube_Delegate
	 */
	var $mInstallSuccess = null;
	
	/**
	 * @var XCube_Delegate
	 */
	var $mInstallFail = null;
	
	function Legacy_ModuleInstallAction($flag)
	{
		parent::Legacy_AbstractModuleInstallAction($flag);
		
		$this->mInstallSuccess =& new XCube_Delegate();
		$this->mInstallSuccess->register('Legacy_ModuleInstallAction.InstallSuccess');
		
		$this->mInstallFail =& new XCube_Delegate();
		$this->mInstallFail->register('Legacy_ModuleInstallAction.InstallFail');
	}
	
	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleInstaller($dirname);
		return $installer;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_ModuleInstallForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		if (!$this->mLog->hasError()) {
			$this->mInstallSuccess->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleInstall.' . ucfirst($this->mModuleObject->get('dirname') . '.Success'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}
		else {
			$this->mInstallFail->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleInstall.' . ucfirst($this->mModuleObject->get('dirname') . '.Fail'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}

		$renderer->setTemplateName("module_install_success.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);

		if (isset($this->mModuleObject->modinfo['installer'])) {
			//
			// Jump
			//
			$controller->executeForward('index.php?action=InstallWizard&dirname=' . $this->mModuleObject->get('dirname'));
		}
		else {
			$renderer->setTemplateName("module_install.html");
		}
	}

	function executeViewInput(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_install.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$renderer)
	{
		$controller->executeForward("./index.php?action=InstallList");
	}
}

?>