<?php
// $Id: table_catlink.php,v 1.1.1.1 2005/02/16 17:32:32 ohwada Exp $

// 2004-11-28 K.OHWADA
// use module_base

// 2004/08/10 K.OHWADA
// It enables to install this module two or more. 

//=========================================================
// class table_catlink
// created since v0.7
// 2004/08/10 K.OHWADA
//=========================================================
class table_catlink  extends module_base
{
// table field
	var $jid;	// joint id
	var $lid;
	var $cid;

// class instance
	var $tbl_category;

// local
	var $cid_arr;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function table_catlink()
{
	module_base::module_base( 'catlink' );

	$this->tbl_category =& table_category::getInstance();

}


function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new table_catlink();
	}

	return $instance;
}

//---------------------------------------------------------
// insert
// for class/link.php
//---------------------------------------------------------
function insert($cid, $lid)
{
	$sql = "INSERT INTO $this->table (cid, lid) VALUES ($cid, $lid)";
	return $this->query_false($sql);
}

//---------------------------------------------------------
// update
//---------------------------------------------------------

//---------------------------------------------------------
// delete
//---------------------------------------------------------
// for admin/category.php
function deleteByCid($cid)
{
	$sql = "DELETE FROM $this->table WHERE cid=$cid";
	return $this->query_false($sql);
}

// for class/link.php
function deleteByLid($lid)
{
	$sql = "DELETE FROM $this->table WHERE lid=$lid";
	return $this->query_false($sql);
}

//---------------------------------------------------------
// select
//---------------------------------------------------------
// for future
function getNumAll()
{
	$sql = "SELECT count(*) FROM $this->table";
    return $this->get_num_by_sql($sql);
}

// for viewcat.php
function getNumByCid($cid)
{
	$sql = "SELECT count(*) FROM $this->table WHERE cid=$cid";
    return $this->get_num_by_sql($sql);
}

// for getLinkNumByCid()
function getNumByCidArray($cid_arr)
{
	$count = count($cid_arr);

	$where = " WHERE ( cid=$cid_arr[0] ";
	for ( $i=1; $i<$count; $i++ )
	{
		$where .= " OR cid=$cid_arr[$i] ";
	}
	$where .= " ) ";

	$sql = "SELECT COUNT(DISTINCT lid) FROM $this->table $where";
	return $this->get_num_by_sql($sql);
}

// for admin/category.php
function getNumByLid($lid)
{
	$sql = "SELECT count(*) FROM $this->table WHERE lid=$lid";
    return $this->get_num_by_sql($sql);
}

// for future
function getRowsAll($limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table ORDER BY jid";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

// for future
function getRowsByCid($cid,$limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table WHERE cid=$cid ORDER BY lid";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

// for future
function getRowsByLid($lid,$limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table WHERE lid=$lid ORDER BY cid";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

// for admin/category.php
function getLidArrayByCid($cid,$limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE cid=$cid ORDER BY lid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

// for singlelink.php
function getCidArrayByLid($lid,$limit=0,$offset=0)
{
	$sql = "SELECT cid FROM $this->table WHERE lid=$lid ORDER BY cid";
	$this->cid_arr = $this->get_first_row_by_sql($sql,$limit,$offset);
	return $this->cid_arr;
}

// for admin/category.php
function getLidArrayByCidArray($cid_arr)
{
	$count = count($cid_arr);

	$where = " WHERE ( cid=$cid_arr[0] ";
	for ( $i=1; $i<$count; $i++ )
	{
		$where .= " OR cid=$cid_arr[$i] ";
	}
	$where .= " ) ";

	$sql = "SELECT DISTINCT lid FROM $this->table $where";
	return $this->get_first_row_by_sql($sql);
}


//---------------------------------------------------------
// add new link
//---------------------------------------------------------
function add_link($lid, $cid_arr)
{
	foreach ($cid_arr as $cid)
	{
		$ret = $this->insert($cid, $lid);
		if (!$ret) return FALSE;
	}

	return TRUE;
}


//=========================================================
// use cateogry class
//=========================================================
// for catlist.php
function getLinkNumByCid($cid)
{
	$arr   = $this->tbl_category->getAllChildId($cid);
	$arr[] = $cid;

	return $this->getNumByCidArray($arr);
}


// admin/link.php
function showCidSelboxByLid($lid=0)
{
	$cid_arr = array();

	if ($lid)
	{
		$cid_arr   = $this->getCidArrayByLid($lid);
	}

// show always, if cid array is empty
	return $this->tbl_category->showSelboxMulti($cid_arr);
}


// for modlink.php
function makeEditCidSelboxByLid($lid=0)
{
	$cid_arr = array();
	if ($lid)
	{
		$cid_arr = $this->getCidArrayByLid($lid);
	}

// show always, if cid array is empty
	return $this->tbl_category->makeEditSelboxMulti($cid_arr);
}


//---------------------------------------------------------
}
?>
