<?php
// $Id: weblinks_top.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-05-20 K.OHWADA
// unlimited when $options[2] = 0 

// 2005-01-20 K.OHWADA
// add $options 3:new days 4:popular 5:max width 6:default width
// add $url, $votes, $comments

// 2004-12-05 K.OHWADA
// write fair, delete unnecessary comments

// 2004-10-20 K.OHWADA
// newred.gif -> new.gif
// add update_image

// 2004/08/10 K.OHWADA
// enable to install this module two or more. 
// not use class weblinksLink
// add block rating 
// add new mark, popular mark

// ***************************************************************************
// * Function: b_weblinks_top_show
// * Input   : $options[0] = date for the most recent links
// *                    hits for the most popular links
// *           $block['content'] = The optional above content
// *           $options[1]   = How many reviews are displayes
// * Output  : Returns the desired most recent or most popular links
// ***************************************************************************

//=========================================================
// block top
// use class weblinksLink
// 2004/01/14 K.OHWADA
//=========================================================

//---------------------------------------------------------
// $options
// [0] order (time_update/hits/rating)
// [1] number of display links (10)
// [2] max length of title (30)
//       when 0, unlimited
// [3] days to show new icon (7)
// [4] hits to show popular icon (0)
// [5] max width of banner image (50)
//       when 0, not show
// [6] default width of banner image (50)
//       when 0, use original size
//---------------------------------------------------------

// --- change function name ---
function b_weblinks_top_show($options) 
{
	global $xoopsDB;

// --- change function name ---    
    $MODULE_DIRNAME = 'weblinks';

	$weblinks_url = XOOPS_URL."/modules/".$MODULE_DIRNAME;
	$table_link   = $xoopsDB->prefix("{$MODULE_DIRNAME}_link");

	$myts =& MyTextSanitizer::getInstance();

	$block = array();
	$block['module_url']    = $weblinks_url;
	$block['lang_hits']     = _MB_WEBLINKS_HITS;
	$block['lang_rating']   = _MB_WEBLINKS_RATING;
	$block['lang_votes']    = _MB_WEBLINKS_VOTES;
	$block['lang_comments'] = _MB_WEBLINKS_COMMENTS;

	$order     = $options[0];
	$limit     = $options[1];
	$max_title = $options[2];
	$newdays   = $options[3];
	$popular   = $options[4];
	$max_width = $options[5];
	$width_default = $options[6];

	$sql    = "SELECT * FROM $table_link ORDER BY $order DESC";
	$result = $xoopsDB->query($sql, $limit, 0);

	while( $row = $xoopsDB->fetchArray($result) )
	{
		$link = array();

		$show_banner  = 0;
		$show_new     = 0;
		$show_update  = 0;
		$show_popular = 0;

		$lid    = $row['lid'];
		$title  = $row['title'];
		$url    = $row['url'];
		$banner = $row['banner'];
		$width  = $row['width'];
		$height = $row['height'];
		$hits   = $row['hits'];
		$rating = $row['rating'];
		$votes  = $row['votes'];
		$comments = $row['comments'];
		$time_create = $row['time_create'];
		$time_update = $row['time_update'];

// unlimited when $options[2] = 0 
		if ( ($max_title > 0) && (strlen( $title ) > $max_title) )
		{
			$title = strip_tags( $title );

// for multibyte environment
			if (function_exists('mb_strimwidth'))
			{
				$title = mb_strimwidth( $title, 0, $max_title, " ..." );
			}
			else
			{
				$title = substr( $title, 0, $max_title )." ...";
			}
		}

// banner image
		if ( ($max_width > 0) && $banner )
		{
			$show_banner = 1;

			if ($width > $max_width)
			{
				$width = $max_width;
			}

			if (($width == 0) && ($width_default > 0))
			{
				$width = $width_default;
			}
		}

// new & update image

		if ( $newdays > 0)
		{
			$startdate = (time()-(86400 * $newdays));

			if ( $startdate < $time_create ) 
			{
				$show_new = 1;
			}
			elseif ( $startdate < $time_update )
			{
				$show_update = 1;
			}
		}

// popular image
		if ($popular > 0)
		{
			if ( $row['hits'] >= $popular )
			{
				$show_popular = 1;
			}
		}

		$link['show_banner'] = $show_banner;
		$link['show_new']    = $show_new;
		$link['show_update'] = $show_update;
		$link['show_pop']    = $show_popular;
		$link['width']       = $width;

		$link['id']       = $lid;
		$link['hits']     = $hits;
		$link['votes']    = $votes;
		$link['comments'] = $comments;
		$link['url']      = htmlspecialchars($url,    ENT_QUOTES);
		$link['banner']   = htmlspecialchars($banner, ENT_QUOTES);
		$link['date']     = formatTimestamp($time_update,'s');
		$link['rates']    = sprintf("%.1f",$rating);
		$link['title']    = $myts->makeTboxData4Show( $title );

// old style
		if ($order == "rating")
		{
			$link['hits']  = $link['rates'];
		}

		$block['links'][] = $link;
	}

	return $block;
}

// --- change function name ---
function b_weblinks_top_edit($options) 
{

	$form  = '';
	$form .= "<input type='hidden' name='options[0]' value='".$options[0]."' />\n";

	$form .= "<table><tr><td>";
	$form .= _MB_WEBLINKS_DISP;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[1]' value='".$options[1]."' />&nbsp;"._MB_WEBLINKS_LINKS."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_CHARS;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[2]' value='".$options[2]."' />&nbsp;"._MB_WEBLINKS_LENGTH."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_NEWDAYS;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[3]' value='".$options[3]."' />&nbsp;"._MB_WEBLINKS_DAYS."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_POPULAR;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[4]' value='".$options[4]."' />&nbsp;"._MB_WEBLINKS_HITS."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MAX_WIDTH;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[5]' value='".$options[5]."' />&nbsp;"._MB_WEBLINKS_PIXEL."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_WIDTH_DEFAULT;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[6]' value='".$options[6]."' />&nbsp;"._MB_WEBLINKS_PIXEL."";
	$form .= "</td></tr></table>\n";
	return $form;

}

?>
