<?php
// $Id: link_check.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-08-09 K.OHWADA
// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
// add get_no_check() get_no_refresh()

// 2005-01-20 K.OHWADA
// use class remote_file
// add refresh_site()

// 2004-12-26 K.OHWADA
// use get_google_url()

// 2004-11-28 K.OHWADA
// add function refresh()

//=========================================================
// class link check
// 2004-10-20 K.OHWADA
//=========================================================

class link_check
{
	var $flag_google;
	var $google_url;

	var $flag_broken;	// view broken colum
	var $flag_echo;
	var $flag_echo_lid;

	var $flag_write;
	var $fp_result;

	var $total_site_rss;
	var $total_link;
	var $num_link_check;
	var $num_link_broken;
	var $num_clear_atomfeed;
	var $link_broken_arr;

	var $num_refresh_rss_url;
	var $num_refresh_rss_site;
	var $num_refresh_atom_site;
	var $num_refresh_atomfeed;

// class constance
	var $tbl_link;
	var $module_url;
	var $lang;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function link_check()
{
	$this->flag_google   = 0;
	$this->flag_broken   = 0;
	$this->flag_echo     = 1;
	$this->flag_write    = 0;
	$this->flag_echo_lid = 0;

	unset($this->fp_result);

// class constance
	$this->tbl_link   =& table_link::getInstance();
	$this->module_url = $this->tbl_link->module_url;
	$this->lang       =& language_convert::getInstance();

// exsample "http://www.google.com/search?hl=en&amp;q=";
	$google_url = $this->lang->get_google_url();
	if ( $google_url )
	{
		$this->set_google_url($google_url);
	}

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new link_check();
	}

	return $instance;
}

//---------------------------------------------------------
// check link broken
//---------------------------------------------------------
function check($limit, $offset)
{
// class instance
	$remote  =& remote_file::getInstance();
	$collect =& rss_atom_collect::getInstance();

	$link_broken_count = 0;
	$link_broken_arr   = array();

	$this->total_link = $this->tbl_link->getNumAll();

	$lid_array = $this->tbl_link->getLidArrayAll($limit, $offset);
	$lid_num   = count($lid_array);

// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
	if ($lid_num == 0)
	{
		$data = $this->get_no_check();
		$this->echo_write_data($data);
		return;
	}

	$this->num_link_check = $lid_num;

	$lid_start = $lid_array[0];
	$lid_end   = $lid_array[$this->num_link_check - 1];

	$time_start = time();

// --- check start ---
	$data = $this->get_check_html_start();
	$this->echo_write_data($data);

// proc by record
	foreach($lid_array as $lid)
	{
		$this->tbl_link->getRowByLid($lid);
		$title    = $this->tbl_link->title;
		$url      = $this->tbl_link->url;
		$rss_flag = $this->tbl_link->rss_flag;

		if ( $this->flag_echo_lid )
		{
			echo $lid."\n";
		}

// next, if url is null
		if (empty($url)) continue;

// link check
//		$fp = fopen($url,"r");
//		if (!$fp)
		if ( !$remote->check_url($url) )
  		{
			$this->tbl_link->countupBroken($lid);
		    $link_broken_count ++;
		    $link_broken_arr[] = array($lid, $title, $url);
		}
// refresh RSS url
		elseif ( $rss_flag == 3 )
		{
			$collect->refresh_rss_url($lid, $url);
		}

	}

// --- check end ---
	$this->link_broken_arr     = $link_broken_arr;
	$this->num_link_broken     = $link_broken_count;
	$this->num_refresh_rss_url = $collect->count_refresh_rss_url;

	$data = $this->get_check_html_end( $time_start, $lid_start, $lid_end);
	$this->echo_write_data($data);

	return;
}


//---------------------------------------------------------
// refresh XML cache for link
//---------------------------------------------------------
function refresh_link($limit, $offset)
{
// class constance
	$collect =& rss_atom_collect::getInstance();

	$link_broken_count = 0;
	$link_broken_arr   = array();

	$this->total_site_rss = $this->tbl_link->getNumRssFlag();

	$orderby = 'lid';
	$lid_array = $this->tbl_link->getLidArrayByRssFlag($orderby, $limit, $offset);
	$lid_num = count($lid_array);

// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
	if ($lid_num == 0)
	{
		$data = $this->get_no_refresh();
		$this->echo_write_data($data);
		return;
	}

	$this->num_link_check = $lid_num;

	$lid_start = $lid_array[0];
	$lid_end   = $lid_array[$this->num_link_check - 1];

	$time_start = time();

	$this->num_clear_atomfeed = $this->clear_old();

// --- check start ---
	$data = $this->get_refresh_html_start();
	$this->echo_write_data($data);

// each link
	foreach($lid_array as $lid)
	{
		$this->tbl_link->getRowByLid($lid);
		$title    = $this->tbl_link->title;
		$url      = $this->tbl_link->url;
		$rss_flag = $this->tbl_link->rss_flag;
		$rss_url  = $this->tbl_link->rss_url;

		if ( empty($rss_url) )   continue;
		if ( ($rss_flag != 1) && ($rss_flag != 2) )  continue;

// get remote XML
		$xml_data = $collect->read_remote_xml($rss_url);
		if (!$xml_data)
		{
			$link_broken_count ++;
			$link_broken_arr[] = array($lid, $title, $rss_url);
			// set no use RSS ( in future)
		}
		else
		{
			$collect->refresh_xml_for_admin($this->tbl_link, $xml_data);
		}
	}

// --- check end ---
	$this->link_broken_arr        = $link_broken_arr;
	$this->num_link_broken        = $link_broken_count;
	$this->num_refresh_rss_site   = $collect->count_refresh_rss_update;
	$this->num_refresh_atom_site  = $collect->count_refresh_atom_site;
	$this->num_refresh_atomfeed   = $collect->count_refresh_atomfeed;

	$data = $this->get_refresh_html_end( $time_start, $lid_start, $lid_end);
	$this->echo_write_data($data);

	return;
}

function clear_old()
{
// class constance
	$tbl_atomfeed =& table_atomfeed::getInstance();
	$tbl_config   =& table_config::getInstance();

	$config    = $tbl_config->get_config();
	$rss_limit = $config['rss_limit'];

	$del = $tbl_atomfeed->clearOverNum( $rss_limit );
	return $del;
}

//---------------------------------------------------------
// refresh ATOM cache for RSS search site
//---------------------------------------------------------
function refresh_site($limit=0, $offset=0)
{
// class constance
	$tbl_config =& table_config::getInstance();
	$collect    =& rss_atom_collect::getInstance();

	$config = $tbl_config->get_config();
	$rss_site_arr = $config['rss_site_arr'];
	$lid_num = count($rss_site_arr);

// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
	if ($lid_num == 0)
	{
		$data = $this->get_no_refresh();
		$this->echo_write_data($data);
		return;
	}

	$this->total_site_rss = $lid_num;
	$this->num_link_check = $lid_num;

	$count_refresh_site = 0;
	$link_broken_count  = 0;
	$link_broken_arr    = array();

	$time_start = time();

// --- check start ---
	$data = $this->get_refresh_html_start();
	$this->echo_write_data($data);

// each site
	foreach($rss_site_arr as $rss_url)
	{
		if ( empty($rss_url) )   continue;

// get remote XML
		$xml_data = $collect->read_remote_xml($rss_url);
		if (!$xml_data)
		{
  		    $link_broken_count ++;
		    $link_broken_arr[] = array(0, '', $rss_url);
//    		$data = $this->get_refresh_table_line(0, '', $rss_url);
//    		$this->echo_write_data($data);
		}
		else
		{
			$collect->refresh_xml_for_admin_2($xml_data);
			$count_refresh_site ++;
		}
	}

// --- check end ---
	$this->link_broken_arr        = $link_broken_arr;
	$this->num_link_broken        = $link_broken_count;
	$this->num_refresh_rss_site   = $count_refresh_site;
	$this->num_refresh_atom_site  = $collect->count_refresh_atom_site;
	$this->num_refresh_atomfeed   = $collect->count_refresh_atomfeed;
	$this->num_clear_atomfeed     = 0;

	$data = $this->get_refresh_html_end( $time_start, 0, 0);
	$this->echo_write_data($data);

	return;
}

//---------------------------------------------------------
// print HTML for check
//---------------------------------------------------------
function get_check_html_start()
{
	$time_now    = $this->get_time_now();

	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";
//	$text .= $this->get_check_table_start();

	return $text;
}

function get_check_html_end( $time_start, $lid_start, $lid_end)
{
	$time_now    = $this->get_time_now();
	$time_elapse = $this->get_time_elapse($time_start);

	$text  = '';

	if ($this->num_link_broken)
	{
		$text .= $this->get_check_table_start();

		foreach ($this->link_broken_arr as $broken)
		{
			list($lid, $title, $url) = $broken;
    		$text .= $this->get_check_table_line($lid, $title, $url);
		}

		$text .= $this->get_table_end();

		$link_broken = "<font color='red'>$this->num_link_broken</font>";
	}
	else
	{
		$link_broken = $this->num_link_broken;
	}

	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_ALL."</td>";
	$text .= "<td>$this->total_link "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_CHECK."</td>";

	if ($lid_start)
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM." ( "._WLS_LINKID." $lid_start - $lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	}

	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_BROKEN."</td>";
	$text .= "<td>$link_broken "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_RSS_URL."</td>";
	$text .= "<td>$this->num_refresh_rss_url "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}

function get_check_table_start()
{
	$text = _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_NOTICE;

	if ($this->flag_google)
	{
		$text .= _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_GOOGLE;
	}

	$text .= "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._WLS_LINKID."</th>";
	$text .= "<th align='center'>"._WLS_SITETITLE."</th>";
	$text .= "<th align='center'>"._WLS_SITEURL."</th>";

	if ($this->flag_broken)
	{	$text .= "<th align='center'>"._WEBLINKS_ADMIN_BROKEN."</th>";	}

	$text .= "</tr>\n";

	return $text;
}

function get_check_table_line($lid, $title, $url, $broken='')
{
	$link_id = sprintf("%03d",$lid);

	$modlink = $this->module_url."/admin/link_manage.php?op=modLink&lid=".$lid;
	$title   = htmlspecialchars($title);

	$text  = "<tr>";
	$text .= "<td><a href='$modlink'>$link_id</a></td>";

	if ($this->flag_google)
	{
		$google = $this->get_google_query_url($title);
		$text  .= "<td><a href='$google' target='_blank'>$title</a></td>";
	}
	else
	{
		$text .= "<td>$title</td>";
	}

	$text .= "<td><a href='$url' target='_blank'>$url</a></td>";

	if ($this->flag_broken)
	{	$text .= "<td>$broken</td>";	}

	$text .= "</tr>\n";

	return $text;
}

function get_table_end()
{
	return "</table><br />\n";
}

function echo_write_data($data)
{
	if ($this->flag_echo)
	{
		echo $data;
	}

	if ($this->flag_write)
	{
		fwrite($this->fp_result, $data);
	}
}

function get_no_check()
{
	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_NO_LINK_BROKEN_CHECK." $time_now<br /><br />\n";

	return $text;
}

//---------------------------------------------------------
// print HTML for refresh
//---------------------------------------------------------
function get_refresh_html_start()
{
	$time_now = $this->get_time_now();

	$text  = "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	$text .= _WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";
//	$text .= $this->get_refresh_table_start();

	return $text;
}

function get_refresh_html_end( $time_start, $lid_start, $lid_end)
{
	$time_now    = $this->get_time_now();
	$time_elapse = $this->get_time_elapse($time_start);

	$text = '';

	if ($this->num_link_broken)
	{
		$text .= $this->get_refresh_table_start();

		foreach ($this->link_broken_arr as $broken)
		{
			list($lid, $title, $rss_url) = $broken;
    		$text .= $this->get_refresh_table_line($lid, $title, $rss_url);
		}

		$text .= $this->get_table_end();

		$link_broken = "<font color='red'>$this->num_link_broken</font>";
	}
	else
	{
		$link_broken = $this->num_link_broken;
	}

//	$text  = $this->get_table_end();
	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WLS_SITE_RSS."</td>";
	$text .= "<td>$this->total_site_rss "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_CHECK."</td>";

	if ($lid_start)
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM." ( "._WLS_LINKID." $lid_start - $lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	}

	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_BROKEN."</td>";
	$text .= "<td>$link_broken "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_RSS_SITE."</td>";
	$text .= "<td>$this->num_refresh_rss_site "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
//	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_ATOM_SITE."</td>";
//	$text .= "<td>$this->num_refresh_atom_site "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_ATOMFEED."</td>";
	$text .= "<td>$this->num_refresh_atomfeed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$this->num_clear_atomfeed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}


function get_refresh_table_start()
{
	$text  = "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._WLS_LINKID."</th>";
	$text .= "<th align='center'>"._WLS_SITETITLE."</th>";
	$text .= "<th align='center'>"._WLS_RSS_URL."</th>";
	$text .= "</tr>\n";

	return $text;
}

function get_refresh_table_line($lid, $title, $rss_url)
{
	$link_id = sprintf("%03d",$lid);

	$modlink = $this->module_url."/admin/link_manage.php?op=modLink&lid=".$lid;
	$title   = htmlspecialchars($title);

	$text  = "<tr>";
	$text .= "<td><a href='$modlink'>$link_id</a></td>";
	$text .= "<td>$title</td>";
	$text .= "<td><a href='$rss_url' target='_blank'>$rss_url</a></td>";
	$text .= "</tr>\n";

	return $text;
}

function get_no_refresh()
{
	$text  = "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	$text .= _WEBLINKS_ADMIN_NO_RSS_REFRESH."<br />\n";

	return $text;
}

//---------------------------------------------------------
// time
//---------------------------------------------------------
function get_time_now()
{
	return date("Y-m-d H:i:s");
}

function get_time_elapse($time_start)
{
	$time = time() - $time_start;
	$min = intval($time/60);
	$sec = $time - 60*$min;
	return  sprintf(_WEBLINKS_ADMIN_MIN_SEC, $min, $sec);
}

//---------------------------------------------------------
// set and get parameter
//---------------------------------------------------------
function set_google_url($value)
{
	if ( empty($value) )  return;

	$this->google_url  = $value;
	$this->flag_google = 1;
}

function set_flag_broken($value)
{
	$this->flag_broken = intval($value);
}

function set_flag_echo($value)
{
	$this->flag_echo = intval($value);
}

function set_flag_echo_lid($value)
{
	$this->flag_echo_lid = intval($value);
}

function set_write($fp)
{
	$this->fp_result  = $fp;
	$this->flag_write = 1;
}


//---------------------------------------------------------
// langauge
//---------------------------------------------------------
function get_google_query_url($word)
{
	$query = $this->lang->convert_to_utf8($word);
	$query = urlencode($query);
	$url   = $this->google_url.$query;

	return $url;
}

//---------------------------------------------------------
}

?>
