<?php
// $Id: admin_config_class.php,v 1.1.1.1 2006/01/03 05:05:59 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

class admin_config extends rssc_config_form
{
// handler
	var $_config_handler;

// local
	var $_line_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config()
{
	$this->rssc_config_form();

// handler
	$DIRNAME = rssc_admin_get_dirname();
	$this->_config_handler =& rssc_get_handler('config', $DIRNAME);

// init
	$this->_config_handler->load();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config();
	}

	return $instance;
}

//=========================================================
// main function
//=========================================================
function init_form()
{
	$this->set_config_id_cache(   $this->_config_handler->get_config_id_cache() );
	$this->set_config_name_cache( $this->_config_handler->get_config_name_cache() );
}

function show_main()
{
	$this->print_top3('rssc_config_main', _RSSC_SEARCH, _RSSC_HEADLINE, _RSSC_SINGLE);

	$this->print_three('main_search_min');
	$this->print_three('',                        'main_headline_links_perpage');
	$this->print_three('main_search_perpage',     'main_headline_feeds_perpage');
	$this->print_three('main_search_max_title',   'main_headline_max_title',   'main_single_max_title');
	$this->print_three('main_search_max_summary', 'main_headline_max_summary', 'main_single_max_summary');
	$this->print_sel3 ('main_search_order',       'main_headline_order');

	$this->print_form_bottom();
}

function show_block()
{
	$this->print_top2('rssc_config_block', _MI_RSSC_BNAME_LATEST, _MI_RSSC_BNAME_HEADLINE);

	$this->print_two ('',                         'block_headline_links_perpage');
	$this->print_two ('block_latest_perpage',     'block_headline_feeds_perlink');
	$this->print_two ('block_latest_max_title',   'block_headline_max_title');
	$this->print_two ('block_latest_max_summary', 'block_headline_max_summary');
	$this->print_sel2('block_latest_order',       'block_headline_order');

	$this->print_form_bottom();
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$this->_config_handler->save();
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function is_exist()
{
	$conf_num = $this->_config_handler->get_num();
	if ( $conf_num == 0 )  return false;

	return true;
}

function init()
{
	$conf_num = $this->_config_handler->get_num();
	if ( $conf_num == 0 )
	{
		$this->_config_handler->init();
	}
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function is_version($ver)
{
	switch ($ver)
	{
		case '0.10':
		default:
			$name = 'basic_rss_atom';
			break;

	}

	return $this->_config_handler->is_exist_by_name( $name );
}

function upgrade()
{
	$this->_config_handler->upgrade();
}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_top2($form_name, $name1, $name2)
{
	echo $this->make_form_start($form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "</tr>\n";
}

function print_top3($form_name, $name1, $name2, $name3)
{
	echo $this->make_form_start($form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "<th align='center'>".$name3."</th>";
	echo "</tr>\n";
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_two($name1, $name2='')
{
	if ( $name1 )
	{
		$title_show = $this->make_conf_caption_by_name($name1);
	}
	else
	{
		$title_show = $this->make_conf_caption_by_name($name2);
	}

	$name1_show = $this->make_conf_textbox_by_name($name1);
	$name2_show = $this->make_conf_textbox_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td></tr>\n";

}

function print_three($name1, $name2='', $name3='')
{
	if ( $name1 )
	{
		$title_show = $this->make_conf_caption_by_name($name1);
	}
	elseif ( $name2 )
	{
		$title_show = $this->make_conf_caption_by_name($name2);
	}
	else
	{
		$title_show = $this->make_conf_caption_by_name($name3);
	}

	$name1_show = $this->make_conf_textbox_by_name($name1);
	$name2_show = $this->make_conf_textbox_by_name($name2);
	$name3_show = $this->make_conf_textbox_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td>";
	echo "<td align='right'>$name3_show</td></tr>\n";

}

function print_sel2($name1, $name2='')
{
	$title_show = $this->make_conf_caption_by_name($name1);
	$name1_show = $this->make_conf_radio_select_by_name($name1);
	$name2_show = $this->make_conf_radio_select_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td></tr>\n";

}

function print_sel3($name1, $name2='', $name3='')
{
	$title_show = $this->make_conf_caption_by_name($name1);
	$name1_show = $this->make_conf_radio_select_by_name($name1);
	$name2_show = $this->make_conf_radio_select_by_name($name2);
	$name3_show = $this->make_conf_radio_select_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td>";
	echo "<td align='left'>$name3_show</td></tr>\n";

}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->make_conf_yseno_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->make_conf_caption_by_name($name);
	$name_show  = $this->make_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->make_conf_caption_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td colspan='3'>";
	echo $this->make_form_submit( 'submit', _SAVE );
	echo "</tr></table>\n";
	echo $this->make_form_end();
	echo "<br />\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}

//---------------------------------------------------------
// print form init
//---------------------------------------------------------
function print_form_init()
{
	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _AM_RSSC_INIT_EXEC ."</h4>\n";
	echo $this->make_form_box( '', 'init', _SAVE );
	echo "</td></tr></table>\n";
	echo "<br />\n";

}

//---------------------------------------------------------
// print form upgrade
//---------------------------------------------------------
function print_form_upgrade()
{
	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _AM_RSSC_UPGRADE_EXEC ."</h4>\n";
	echo $this->make_form_box( '', 'upgrade', _SAVE );
	echo "</td></tr></table>\n";
	echo "<br />\n";
}

// --- class end ---
}

?>