<?php
// $Id: admin_form_class.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================
class admin_form extends rssc_form
{
// class instance
	var $_feed_handler;
	var $_strings;

// constant
	var $_TEXT_SIZE =  50;
	var $_TEXT_MAX  = 255;
	var $_URL_SIZE  =  70;
	var $_URL_MAX   = 255;

// black & white
	var $_id_name;
	var $_form_name;
	var $_form_title_add;
	var $_form_title_mod;

// defined by rssc_form
//	var $_myts;
//	var $_strings;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_form()
{
	$this->rssc_form();

// class instance
	$DIRNAME = rssc_admin_get_dirname();
	$this->_feed_handler =& rssc_get_handler('feed', $DIRNAME);

	$this->_strings  =& rssc_strings::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_form();
	}

	return $instance;
}

//---------------------------------------------------------
// show link
//---------------------------------------------------------
function show_link($data, $flag=0)
{
	switch ($flag) 
	{
		case 1:
			$form_title = _AM_RSSC_MOD_LINK;
			$op         = 'mod_table';
			$button_val = _MODIFY;
			break;

		case 0:
		default:
			$form_title = _AM_RSSC_ADD_LINK;
			$op         = 'add_table';
			$button_val = _ADD;
			break;
	}

	$this->set_datas($data);

	if ( $flag == 1 )
	{
		$lid = $data['lid'];
		$total_feed = $this->_feed_handler->get_count_by_lid( $lid );
		$url_feed   = XOOPS_URL."/modules/rssc/admin/feed_list.php?lid=".$lid;

		printf(_AM_RSSC_THERE_ARE_MATCH, $total_feed);
		echo "<br /><br />\n";
		echo $this->make_html_url_link($url_feed, _AM_RSSC_FEED_BELONG_LINK);
	}

// form start
	echo $this->make_form_start('link_edit');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', $op);

	if ( $flag == 1 )
	{
		echo $this->make_form_hidden('lid', $data['lid']);
	}

	echo $this->make_table_start();
	echo $this->make_table_title($form_title);

	if ( $flag == 1 )
	{
		echo $this->make_table_line(_RSSC_LINK_ID, $data['lid']);
	}

	echo $this->make_data_table_text(_RSSC_USER_ID, 'uid');
	echo $this->make_data_table_text(_RSSC_MOD_ID,  'mid');
	echo $this->make_data_table_text('p1', 'p1');
	echo $this->make_data_table_text('p2', 'p2');
	echo $this->make_data_table_text('p3', 'p3');

	echo $this->make_data_table_text(_RSSC_SITE_TITLE, 'title');

	$ele_url = $this->_make_form_url('url', $data['url']);
	echo $this->make_table_line(_RSSC_SITE_LINK, $ele_url);

	echo $this->make_data_table_text(_RSSC_LTYPE, 'ltype');
	echo $this->make_data_table_text(_RSSC_REFRESH_INTERVAL, 'refresh');
	echo $this->make_data_table_text(_RSSC_HEADLINE_ORDER, 'headline');

	$ele_mode = $this->make_form_radio_select('mode', $data['mode'], $this->_get_opt_rss_flag() );
	echo $this->make_table_line(_RSSC_RSS_MODE, $ele_mode);

	$ele_rdf_url = $this->_make_form_url('rdf_url', $data['rdf_url']);
	echo $this->make_table_line(_RSSC_RDF_URL, $ele_rdf_url);

	$ele_rss_url = $this->_make_form_url('rss_url', $data['rss_url']);
	echo $this->make_table_line(_RSSC_RSS_URL, $ele_rss_url);

	$ele_atom_url = $this->_make_form_url('atom_url', $data['atom_url']);
	echo $this->make_table_line(_RSSC_ATOM_URL, $ele_atom_url);

	echo $this->make_data_table_text(_RSSC_ENCODING,  'encoding');

	if ( $flag == 1 )
	{
		echo $this->make_data_table_text(_RSSC_UPDATED, 'updated_unix');
		echo $this->make_data_table_textarea('channel', 'channel');
	}
	else
	{
		echo $this->make_table_line(_RSSC_UPDATED, 0);

		$ele_channel = $this->_make_data_short('channel', 0);
		echo $this->make_table_line('channel', $ele_channel);
	}

	$ele_xml = $this->_make_data_short('xml', 500);
	echo $this->make_table_line('xml', $ele_xml);

	$ele_submit = $this->make_form_submit('submit', $button_val);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');

	if ( $flag == 1 )
	{
		$ele_del    = $this->make_form_submit('del_table', _DELETE);
		$ele_cancel = $this->make_form_cancel_button('cancel', _CANCEL);
		echo $this->make_table_line('', $ele_del.'  '.$ele_cancel, 'foot', 'foot');
	}

	echo $this->make_table_end();
	echo $this->make_form_end();
// --- form end ---

}


//---------------------------------------------------------
// show black & white
//---------------------------------------------------------
function show_black($data, $flag=0)
{
	$this->_id_name        = 'bid';
	$this->_form_name      = 'black_edit';
	$this->_form_title_add = _AM_RSSC_ADD_BLACK;
	$this->_form_title_mod = _AM_RSSC_MOD_BLACK;

	$this->_show_black_white($data, $flag);
}

function show_white($data, $flag=0)
{
	$this->_id_name        = 'wid';
	$this->_form_name      = 'white_edit';
	$this->_form_title_add = _AM_RSSC_ADD_WHITE;
	$this->_form_title_mod = _AM_RSSC_MOD_WHITE;

	$this->_show_black_white($data, $flag);
}

function _show_black_white($data, $flag=0)
{
	switch ($flag) 
	{
		case 1:
			$form_title = $this->_form_title_mod;
			$op         = 'mod_table';
			$button_val = _MODIFY;
			break;

		case 0:
		default:
			$form_title = $this->_form_title_add;
			$op         = 'add_bulk';
			$button_val = _ADD;
			break;
	}

	$this->set_datas($data);

	if ( ($this->_id_name == 'bid') && ($flag == 1) )
	{
		$url = $data['url'];
		$total_feed = $this->_feed_handler->get_count_by_link( $url );
		$url_feed   = XOOPS_URL."/modules/rssc/admin/feed_list.php?link=".$url;

		printf(_AM_RSSC_THERE_ARE_MATCH, $total_feed);
		echo "<br /><br />\n";
		echo $this->make_html_url_link($url_feed, _AM_RSSC_FEED_MATCH_LINK);
	}

// form start
	echo $this->make_form_start($this->_form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', $op);

	if ( $flag == 1 )
	{
		echo $this->make_form_hidden($this->_id_name, $data[$this->_id_name]);
	}

	echo $this->make_table_start();
	echo $this->make_table_title($form_title);

	if ( $flag == 1 )
	{
		echo $this->make_table_line('id', $data[$this->_id_name]);
	}

	echo $this->make_data_table_text(_RSSC_LINK_ID, 'lid');
	echo $this->make_data_table_text(_RSSC_USER_ID, 'uid');
	echo $this->make_data_table_text(_RSSC_MOD_ID,  'mid');
	echo $this->make_data_table_text('p1', 'p1');
	echo $this->make_data_table_text('p2', 'p2');
	echo $this->make_data_table_text('p3', 'p3');

	echo $this->make_data_table_text(_RSSC_SITE_TITLE, 'title');

	if ( $flag == 1 )
	{
		$ele_url = $this->_make_form_url('url', $data['url']);
		echo $this->make_table_line(_RSSC_SITE_LINK, $ele_url);
	}
	else
	{
		$ele_url = $this->_make_form_urllist('urllist', $data['urllist']);
		echo $this->make_table_line(_RSSC_SITE_LINK, $ele_url);
	}

	echo $this->make_data_table_textarea('memo', 'memo');

	$ele_submit = $this->make_form_submit('submit', $button_val);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');

	if ( $flag == 1 )
	{
		$ele_del    = $this->make_form_submit('del_table', _DELETE);
		$ele_cancel = $this->make_form_cancel_button('cancel', _CANCEL);
		echo $this->make_table_line('', $ele_del.'  '.$ele_cancel, 'foot', 'foot');
	}

	echo $this->make_table_end();
	echo $this->make_form_end();
// --- form end ---

}

//---------------------------------------------------------
// show feed
//---------------------------------------------------------
function show_feed($data, $flag=0)
{
	switch ($flag) 
	{
		case 1:
			$form_title = _AM_RSSC_MOD_FEED;
			$op         = 'mod_table';
			$button_val = _MODIFY;
			break;

		case 0:
		default:
			$form_title = _AM_RSSC_ADD_FEED;
			$op         = 'add_table';
			$button_val = _ADD;
			break;
	}

	$this->set_datas($data);

// form start
	echo $this->make_form_start('feed_edit');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', $op);

	if ( $flag == 1 )
	{
		echo $this->make_form_hidden('fid', $data['fid']);
	}

	echo $this->make_table_start();
	echo $this->make_table_title($form_title);

	if ( $flag == 1 )
	{
		echo $this->make_table_line('feed id', $data['fid']);
	}

	echo $this->make_data_table_text(_RSSC_LINK_ID, 'lid');
	echo $this->make_data_table_text(_RSSC_USER_ID, 'uid');
	echo $this->make_data_table_text(_RSSC_MOD_ID,  'mid');
	echo $this->make_data_table_text('p1', 'p1');
	echo $this->make_data_table_text('p2', 'p2');
	echo $this->make_data_table_text('p3', 'p3');

	echo $this->make_data_table_text(_RSSC_SITE_TITLE, 'site_title');

	$ele_sitelink = $this->_make_form_url('site_link', $data['site_link']);
	echo $this->make_table_line(_RSSC_SITE_LINK, $ele_sitelink);

	echo $this->make_data_table_text(_RSSC_TITLE, 'title');

	$ele_link = $this->_make_form_url('link', $data['link']);
	echo $this->make_table_line(_RSSC_LINK, $ele_link);

	echo $this->make_data_table_text(_RSSC_ATOM_ID,   'entry_id');
	echo $this->make_data_table_text(_RSSC_RSS_GUID,  'guid');
	echo $this->make_data_table_text(_RSSC_PUBLISHED, 'published_unix');
	echo $this->make_data_table_text(_RSSC_UPDATED,   'updated_unix');
	echo $this->make_data_table_text(_RSSC_CATEGORY,  'category');
	echo $this->make_data_table_text(_RSSC_AUTHOR_NAME,  'author_name');
	echo $this->make_data_table_text(_RSSC_AUTHOR_URI,   'author_uri');
	echo $this->make_data_table_text(_RSSC_AUTHOR_EMAIL, 'author_email');
	echo $this->make_data_table_text(_RSSC_MODE_CONT,    'mode_cont');

	echo $this->make_data_table_textarea(_RSSC_RAWS, 'raws');

	$ele_content = $this->_make_data_short('content', 500);
	echo $this->make_table_line(_RSSC_CONTENT, $ele_content);

	$ele_search = $this->_make_data_short('search', 500);
	echo $this->make_table_line(_RSSC_SEARCH_FIELD, $ele_search);

	$ele_submit = $this->make_form_submit('submit', $button_val);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');

	if ( $flag == 1 )
	{
		$ele_del    = $this->make_form_submit('del_table', _DELETE);
		$ele_cancel = $this->make_form_cancel_button('cancel', _CANCEL);
		echo $this->make_table_line('', $ele_del.'  '.$ele_cancel, 'foot', 'foot');
	}

	echo $this->make_table_end();
	echo $this->make_form_end();
// --- form end ---

}

//---------------------------------------------------------
// show keyword
//---------------------------------------------------------
function show_keyword($data, $flag=0)
{
	$form_title = _AM_RSSC_ADD_KEYWORD;
	$op         = 'add_keyword';
	$button_val = _ADD;

	$this->set_datas($data);

// form start
	echo $this->make_form_start('link_edit');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', $op);

	echo $this->make_table_start();
	echo $this->make_table_title($form_title);

	echo $this->make_data_table_text(_RSSC_USER_ID, 'uid');
	echo $this->make_data_table_text(_RSSC_MOD_ID,  'mid');
	echo $this->make_data_table_text('p1', 'p1');
	echo $this->make_data_table_text('p2', 'p2');
	echo $this->make_data_table_text('p3', 'p3');

	echo $this->make_data_table_text(_KEYWORD, 'keyword');
	echo $this->make_data_table_text(_RSSC_REFRESH_INTERVAL, 'refresh');

	$ele_submit = $this->make_form_submit('submit', $button_val);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');

	echo $this->make_table_end();
	echo $this->make_form_end();
// --- form end ---

}

//---------------------------------------------------------
// show feed refresh
//---------------------------------------------------------
function show_refresh($limit=0, $offset=0)
{

// form start
	echo $this->make_form_start('refresh');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'refresh');
	echo $this->make_table_start();
	echo $this->make_table_title(_AM_RSSC_REFRESH);
	$ele_limit = $this->make_form_text('limit',  $limit);
	echo $this->make_table_line(_AM_RSSC_LINK_LIMIT, $ele_limit);
	$ele_offset = $this->make_form_text('offset',  $offset);
	echo $this->make_table_line(_AM_RSSC_LINK_OFFSET, $ele_offset);
	$ele_submit = $this->make_form_submit('submit', _UPDATE);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

}

function show_refresh_next($limit=0, $offset=0)
{
	$submit = sprintf(_AM_RSSC_REFRESH_NEXT, $limit);

// form start
	echo $this->make_form_start('refresh_next');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',    'refresh');
	echo $this->make_form_hidden('limit',  $limit);
	echo $this->make_form_hidden('offset', $offset);
	echo $this->make_table_start();
	echo $this->make_table_title(_AM_RSSC_REFRESH);
	$ele_submit = $this->make_form_submit('submit', $submit);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

}

//---------------------------------------------------------
// show feed clear
//---------------------------------------------------------
function show_clear_old($num=0)
{

// form start
	echo $this->make_form_start('clear_old');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'clear_old');
	echo $this->make_table_start();
	echo $this->make_table_title(_AM_RSSC_FEED_CLEAR_OLD);
	$ele_num = $this->make_form_text('num', $num);
	echo $this->make_table_line(_AM_RSSC_FEED_CLEAR_NUM, $ele_num);
	$ele_submit = $this->make_form_submit('submit', _CLEAR);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

}

//---------------------------------------------------------
// show form
//---------------------------------------------------------
function show_rss($data)
{
	$this->set_datas($data);

// form start
	echo $this->make_form_start('rss');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'param');
	echo $this->make_table_start();
	echo $this->make_table_title(_AM_RSSC_VIEW_RSS);

	echo $this->make_data_table_text( _RSSC_LINK_ID, 'lid');
	echo $this->make_data_table_label_hidden( _RSSC_SITE_TITLE, 'title' );
	$this->_print_sel_mode();
	$this->_print_text('feed_perpage');
	$this->_print_yesno('sanitize');
	$this->_print_yesno('title_html');
	$this->_print_yesno('content_html');
	$this->_print_text('max_title');
	$this->_print_text('max_content');
	$this->_print_text('max_summary');

	echo $this->make_table_title( _AM_RSSC_VIEW_PARSER );
	echo $this->make_data_table_label_hidden( _RSSC_RDF_URL,  'rdf_url' );
	echo $this->make_data_table_label_hidden( _RSSC_RSS_URL,  'rdf_url' );
	echo $this->make_data_table_label_hidden( _RSSC_ATOM_URL, 'atom_url' );
	$this->_print_sel_rss_mode();
	$this->_print_sel_parser_rss();
//	$this->_print_sel_parser_atom();
	$this->_print_yesno('force_discover');

	echo $this->make_table_title( _AM_RSSC_VIEW_SAVE_ETC );
	$this->_print_yesno('link_update');
	$this->_print_yesno('xml_save');
	$this->_print_yesno('feed_update');
	$this->_print_yesno('force_update');
	$this->_print_yesno('force_overwrite');
	$this->_print_yesno('print_log');
	$this->_print_yesno('print_error');

	$ele_submit = $this->make_form_submit('submit', _EXECUTE);
	echo $this->make_table_line('', $ele_submit, 'foot', 'foot');

	echo $this->make_table_end();
	echo $this->make_form_end();

}


//---------------------------------------------------------
// private
//---------------------------------------------------------
function _make_form_urllist($name, $urllist)
{
	$url_p   = $this->_strings->make_url_null($urllist);
	$ele_url = $this->make_form_textarea($name, $url_p);

	return $ele_url;
}

function _make_form_url($name, $url)
{
	$url_p   = $this->_strings->make_url_null($url);
	$ele_url = $this->make_form_text($name, $url_p, $this->_URL_SIZE);

	if ($url && ($url != 'http://') )
	{
		$ele_url .= ' '.$this->_make_html_visit($url);
	}

	return $ele_url;
}

function _make_html_visit($url)
{
	return $this->make_html_url_link($url, $this->_get_visit_mark(), '_blank');
}

function _get_visit_mark()
{
	$mark = " ["._VISIT."] ";
	return $mark;
}

function _get_opt_rss_flag()
{
	$opt = array(
		_RSSC_RSS_MODE_NON  => RSSC_C_MODE_NON,
		_RSSC_RSS_MODE_AUTO => RSSC_C_MODE_AUTO,
		_RSSC_RSS_MODE_RDF  => RSSC_C_MODE_RDF,
		_RSSC_RSS_MODE_RSS  => RSSC_C_MODE_RSS,
		_RSSC_RSS_MODE_ATOM => RSSC_C_MODE_ATOM,
	);

	return $opt;
}

function _make_data_short($key, $len=100)
{
	$value = '';

	if ( isset($this->_datas[$key]) )
	{
		$value = $this->_datas[$key];
	
		if ($len)
		{
			$value = $this->_strings->shorten_text($value, $len);
		}

		$value = '<pre>'.$value.'</pre>';
	}

	return $value;
}

function _print_label_hidden($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->make_data_table_label_hidden($cap, $name);
}

function _print_text($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->make_data_table_text($cap, $name);
}

function _print_yesno($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->make_data_table_radio_yesno($cap, $name);
}

function _print_sel_mode()
{
	$options = array(
		_AM_RSSC_VIEW_MODE_CURRENT => RSSC_C_VIEW_CURRENT,
		_AM_RSSC_VIEW_MODE_LINK    => RSSC_C_VIEW_LINK,
		_AM_RSSC_VIEW_MODE_FEED    => RSSC_C_VIEW_FEED,
		);

	$cap = $this->make_caption(_AM_RSSC_VIEW_MODE, _AM_RSSC_VIEW_MODE_DESC);
	$ele = $this->make_form_radio_select('mode_view', $this->_datas['mode_view'], $options, '<br />');
	echo $this->make_table_line($cap, $ele);
}

function _print_sel_rss_atom()
{
	$options = array(
		_AM_RSSC_CONF_RSS_ATOM_SEL_RSS  => RSSC_C_SEL_RSS,
		_AM_RSSC_CONF_RSS_ATOM_SEL_ATOM => RSSC_C_SEL_ATOM,
		);

	$cap = $this->make_caption(_AM_RSSC_CONF_RSS_ATOM, _AM_RSSC_CONF_RSS_ATOM_DESC);
	$ele = $this->make_form_radio_select('rss_atom', $this->_datas['rss_atom'], $options, '<br />');
	echo $this->make_table_line($cap, $ele);
}

function _print_sel_parser_rss()
{
	$options = array(
		_AM_RSSC_CONF_RSS_PARSER_XOOPS => RSSC_C_PARSER_RSS_XOOPS,
		_AM_RSSC_CONF_RSS_PARSER_SELF  => RSSC_C_PARSER_RSS_SELF
		);

	$cap = $this->make_caption(_AM_RSSC_CONF_RSS_PARSER);
	$ele = $this->make_form_radio_select('parser_rss', $this->_datas['parser_rss'], $options, '<br />');
	echo $this->make_table_line($cap, $ele);
}

function _print_sel_rss_mode()
{
	$ele_mode = $this->make_form_radio_select('rss_mode', $this->_datas['rss_mode'], $this->_get_opt_rss_flag() );
	echo $this->make_table_line(_RSSC_RSS_MODE, $ele_mode);
}

function _make_admin_caption($keyword)
{
	$const_title = '_AM_RSSC_VIEW_' . strtoupper($keyword);
	$const_desc  = $const_title.'_DESC';
	$title = '';
	$desc  = '';

	if ( defined( $const_title ) )
	{
		$title = constant( $const_title );
	}
	else
	{
		$title = $const_title;
	}

	if ( defined( $const_desc ) )
	{
		$desc = constant( $const_desc );
	}

	return $this->make_caption($title, $desc);
}

// --- class end ---
}

?>