<?php
// $Id: admin_function.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================
function rssc_admin_print_header()
{
	echo "<h3>"._MI_RSSC_NAME."</h3>\n";
	echo _MI_RSSC_DESC."<br /><br />\n";
}

function rssc_admin_print_menu()
{
	$MAX_COL = 5;
	$DIRNAME = rssc_admin_get_dirname();

	$link_handler  =& rssc_get_handler('link',  $DIRNAME);
	$black_handler =& rssc_get_handler('black', $DIRNAME);
	$white_handler =& rssc_get_handler('white', $DIRNAME);
	$feed_handler  =& rssc_get_handler('feed',  $DIRNAME);

	$total_link  = $link_handler->getCount();
	$total_black = $black_handler->getCount();
	$total_white = $white_handler->getCount();
	$total_feed  = $feed_handler->getCount();

	$link_list  = _AM_RSSC_LIST_LINK. " ($total_link)";
	$black_list = _AM_RSSC_LIST_BLACK." ($total_black)";
	$white_list = _AM_RSSC_LIST_WHITE." ($total_white)";
	$feed_list  = _AM_RSSC_LIST_FEED. " ($total_feed)";

	$menu_arr = array(
		_MI_RSSC_ADMENU_CONFIG => 'index.php',
		$link_list   => 'link_list.php',
		$black_list  => 'black_list.php',
		$white_list  => 'white_list.php',
		$feed_list   => 'feed_list.php',

		_AM_RSSC_ADD_KEYWORD => 'keyword_manage.php',
		_AM_RSSC_ADD_LINK    => 'link_manage.php',
		_AM_RSSC_ADD_BLACK   => 'black_manage.php',
		_AM_RSSC_ADD_WHITE   => 'white_manage.php',
		_AM_RSSC_ADD_FEED    => 'feed_manage.php',

		_AM_RSSC_ARCHIVE_MANAGE => 'archive_manage.php',
		_AM_RSSC_COMMAND_MANAGE => 'command_manage.php',
		_AM_RSSC_UPDATE_MANAGE  => 'update_manage.php',
		_AM_RSSC_VIEW_RSS       => 'view_rss.php',
		'&nbsp;'        => '',

		_AM_RSSC_GOTO_MODULE => '../index.php',
	);

	rssc_admin_print_menu_table($menu_arr, $MAX_COL);
}

function rssc_admin_print_footer()
{

?>
<hr>
<div align="right"><a href="http://linux2.ohwada.net/" target="_blank"><font size="-1">Powered by Happy Linux</font></a></div>
<div align="right"><font size="-1">&copy; 2005, Kenichi OHWADA</font></div>
<?php

}

function rssc_admin_print_menu_table($menu_arr, $MAX_COL=5)
{
	echo "<table class='outer' cellpadding='4' cellspacing='1'> \n";
	echo "<tr>";

	$col_count  = 0;
	$line_count = 0;
	$class = 'odd';
	foreach ($menu_arr as $name => $url) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo "<td class='$class' align='center' valign='bottom' width='19%'>";

		if ($name && $url)
		{
			echo "<a href='".$url."'><b>" .$name."</b></a>";
		}

		echo "</td>\n";

		$col_count ++;

		if ( $col_count >= $MAX_COL ) 
		{
			if ($line_count % 2 == 0) 
			{
				$class = 'even';
			}
			else 
			{
				$class = 'odd';
			}

			$col_count = 0;
			$line_count ++;

			echo "</tr>\n";
			echo "<tr>";
		}
	}

	while ($col_count < $MAX_COL) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo '<td class="'.$class.'">&nbsp;</td>';

		$col_count ++;
	}

	echo "</tr></table>\n";
}

//---------------------------------------------------------
// $xoopsModule
//---------------------------------------------------------
function rssc_admin_get_dirname()
{
	global $xoopsModule;
	return $xoopsModule->dirname();
}

//---------------------------------------------------------
// XoopsMultiTokenHandler
//---------------------------------------------------------
function rssc_admin_check_token( $name='rssc' )
{
	if ( !class_exists('XoopsMultiTokenHandler') )  return true;
	if( XoopsMultiTokenHandler::quickValidate($name) ) return true;
	return false;
}

?>