<?php
// $Id: admin_import_class.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

class admin_import
{
	var $_LIMIT = 100;

	var $_db;
	var $_form;
	var $_system;
	var $_strings;

// local
	var $_lid_list_by_p1   = array();
	var $_lid_list_by_url  = array();
	var $_link_list_by_lid = array();
	var $_table_rssc_link;
	var $_table_rssc_feed;
	var $_table_rssc_black;
	var $_table_rssc_white;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_import()
{
	$this->_db      =& Database::getInstance();
	$this->_form    =& rssc_form::getInstance();
	$this->_system  =& rssc_system::getInstance();
	$this->_strings =& rssc_strings::getInstance();

	$DIRNAME = rssc_admin_get_dirname();
	$this->_table_rssc_link  = $this->_db->prefix( $DIRNAME.'_link' );
	$this->_table_rssc_feed  = $this->_db->prefix( $DIRNAME.'_feed' );
	$this->_table_rssc_black = $this->_db->prefix( $DIRNAME.'_black' );
	$this->_table_rssc_white = $this->_db->prefix( $DIRNAME.'_white' );

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_import();
	}

	return $instance;
}

//=========================================================
// import from weblinks
//=========================================================
function first_step()
{

?>
<br />
There are 5 steps. <br />
1. import rss site <br />
2. import black list <br />
3. import white list <br />
4. import link table <br />
5. import feed table <br />
excute each <?php echo $this->_LIMIT; ?> records at a time <br />
<br />
<?php

	$this->_form_site();

}

function import_site()
{
	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/rssc";
	include_once $MODULE_ROOT."/api/parse.php";

	$xml_utility =& rssc_xml_utility::getInstance();

	echo "<h4>STEP 1: import rss site</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

// weblinks list
	$site_list = $this->_get_weblinks_list( 'rss_site' );
	$total = count($site_list);

	echo "There are <b>".$total."</b> rss site in weblinks<br /><br />\n";

// write param
	$uid = 1;	// admin
	$mid = $this->_get_weblinks_mid();
	$p1  = 0;
	$p2  = 0;
	$p3  = 0;
	$refresh  = 3600;	// 1 hour
	$headline = 0;
	$ltype    = 1;	// rss site
	$mode     = 2;	// rss
	$rdf_url  = '';
	$atom_url = '';
	$encoding = '';
	$updated_unix = 0;
	$channel    = '';
	$xml        = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	$i = 0;

	foreach ($site_list as $site_url)
	{
		echo $i.": ".htmlspecialchars($site_url);
		$i ++;

		if ( $this->_exist_url($site_url) )
		{
			echo " <b>skip</b> <br />\n";
			continue;
		}

		echo " <br />\n";

		$title = '';
		$link  = '';

		if ( $xml_utility->parse_by_url($site_url) )
		{
			$title = $xml_utility->get_channel_var('title');
			$link  = $xml_utility->get_channel_var('link');
		}

		if ( empty($title) )
		{
			$title = 'RSS site '.$i;
		}

		$url      = $link;
		$rss_url  = $site_url;

		$sql3 = 'INSERT INTO '.$this->_table_rssc_link.' (uid, mid, p1, p2, p3, title, url, ltype, rdf_url, rss_url, atom_url, mode, encoding, refresh, headline, updated_unix, channel, xml, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).','.$ltype.', '.$this->_quote($rdf_url).', '.$this->_quote($rss_url).', '.$this->_quote($atom_url).', '.$mode.', '.$this->_quote($encoding).', '.$refresh.', '.$headline.', 0, '.$this->_quote($channel).', '.$this->_quote($xml).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);
	}

	$this->_form_black();

}

function import_black()
{
// === black table ===
// --- rssc ---
//  bid int(11)
//  lid int(11)
//  uid int(11)
//  mid int(11)
//  p1  int(11)
//  p2  int(11)
//  p3  int(11)
//  title  varchar(255)
//  url    varchar(255)
//  memo text
//  aux_int_1 int(5)
//  aux_int_2 int(5)
//  aux_text_1 varchar(255)
//  aux_text_2 varchar(255)

	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/rssc";
	include_once $MODULE_ROOT."/api/parse.php";

	$xml_utility =& rssc_xml_utility::getInstance();

	echo "<h4>STEP 2: import block list</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

// weblinks list
	$site_list = $this->_get_weblinks_list( 'rss_black' );
	$total = count($site_list);

	echo "There are <b>".$total."</b> black list in weblinks<br /><br />\n";

// write param
	$lid = 0;
	$uid = 1;	// admin
	$mid = $this->_get_weblinks_mid();
	$p1  = 0;
	$p2  = 0;
	$p3  = 0;
	$memo  = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	$i = 0;

	foreach ($site_list as $site_url)
	{
		$title = '';

		if ( $xml_utility->discover_parse($site_url) )
		{
			$title = $xml_utility->get_channel_var('title');
		}

		if ( empty($title) )
		{
			$title = 'Black '.$i;
		}

		$url = $site_url;

		echo $i.": ".htmlspecialchars($url)." <br />\n";

		$sql3 = 'INSERT INTO '.$this->_table_rssc_black.' (lid, uid, mid, p1, p2, p3, title, url, memo, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).', '.$this->_quote($memo).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);

		$i ++;
	}

	$this->_form_white();

}

function import_white()
{
// === white table ===
// --- rssc ---
//  wid int(11)
//  lid int(11)
//  uid int(11)
//  mid int(11)
//  p1  int(11)
//  p2  int(11)
//  p3  int(11)
//  title  varchar(255)
//  url    varchar(255)
//  memo text
//  aux_int_1 int(5)
//  aux_int_2 int(5)
//  aux_text_1 varchar(255)
//  aux_text_2 varchar(255)

	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/rssc";
	include_once $MODULE_ROOT."/api/parse.php";

	$xml_utility =& rssc_xml_utility::getInstance();

	echo "<h4>STEP 3: import white list</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

// weblinks list
	$site_list = $this->_get_weblinks_list( 'rss_white' );
	$total = count($site_list);

// write param
	$lid = 0;
	$uid = 1;	// admin
	$mid = $this->_get_weblinks_mid();
	$p1  = 0;
	$p2  = 0;
	$p3  = 0;
	$memo  = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	echo "There are <b>".$total."</b> white list in weblinks<br /><br />\n";

	$i = 0;

	foreach ($site_list as $site_url)
	{
		$title = '';

		if ( $xml_utility->discover_parse($site_url) )
		{
			$title = $xml_utility->get_channel_var('title');
		}

		if ( empty($title) )
		{
			$title = 'White '.$i;
		}

		$url = $site_url;

		echo $i.": ".htmlspecialchars($url)." <br />\n";

		$sql3 = 'INSERT INTO '.$this->_table_rssc_white.' (lid, uid, mid, p1, p2, p3, title, url, memo, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).', '.$this->_quote($memo).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);

		$i ++;
	}

	$this->_form_link();

}

function import_link()
{
// === link table ===

// --- weblinks ---
//  lid int(11)
//  cids  varchar(100) : use catlink
//  title varchar(100)
//  url varchar(255)
//  banner varchar(255) : full url
//  uid int(5) : submitter
//  time_create int(10)
//  time_update int(10)
//  hits int(11)
//  rating double(6,4)
//  votes int(11)
//  comments int(11)
//  description text
//  search text default
//  passwd varchar(255)
//  name varchar(255)
//  nameflag tinyint(2)
//  mail varchar(255)
//  mailflag tinyint(2)
//  company varchar(255)
//  addr varchar(255)
//  tel varchar(255)
//  admincomment text
//  width  int(5)
//  height int(5)
//  recommend tinyint(2)
//  mutual    tinyint(2)
//  broken int(11)
//  rss_url  varchar(255)
//  rss_flag tinyint(3)
//  rss_xml  mediumtext
//  rss_update int(10)
//  usercomment text
//  zip    varchar(100)
//  state  varchar(100)
//  city   varchar(100)
//  addr2  varchar(255)
//  fax    varchar(255)

// --- rssc ---
//  lid int(11)
//  uid int(11)
//  mid int(11)
//  p1  int(11)
//  p2  int(11)
//  p3  int(11)
//  title  varchar(255)
//  url    varchar(255)
//  refresh   mediumint(8)
//  headline  mediumint(8)
//  mode      tinyint(3)
//  rdf_url   varchar(255)
//  rss_url   varchar(255)
//  atom_url  varchar(255)
//  encoding  varchar(15)
//  updated_unix int(10)
//  channel text
//  xml  mediumtext
//  aux_int_1 int(5)
//  aux_int_2 int(5)
//  aux_text_1 varchar(255)
//  aux_text_2 varchar(255)

	echo "<h4>STEP 4: import link table</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

	$table_weblinks_link = $this->_db->prefix("weblinks_link");

	$sql1  = "SELECT count(*) FROM ".$table_weblinks_link;
	$sql1 .= " WHERE ( rss_flag=1 OR rss_flag=2 )";
	$res1  = $this->_sql_exec($sql1);
	$row1  = $this->_db->fetchRow($res1);
	$total = $row1[0];

	echo "There are <b>".$total."</b> rss links in weblinks<br />\n";
	echo "Transfer ".$offset." - ".$next." record <br /><br />\n";

	$sql2  = "SELECT * FROM ".$table_weblinks_link;
	$sql2 .= " WHERE ( rss_flag=1 OR rss_flag=2 ) ORDER BY lid";
	$res2  = $this->_sql_exec($sql2, $this->_LIMIT, $offset);

// write param
	$mid = $this->_get_weblinks_mid();
	$p1  = 0;
	$p2  = 0;
	$p3  = 0;
	$refresh  = 86400;	// 24 hours
	$headline = 0;
	$ltype    = 0;
	$rdf_url  = '';
	$encoding = '';
	$updated_unix = 0;
	$channel    = '';
	$xml        = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	while ($row2 = $this->_db->fetchArray($res2))
	{
		$lid   = $row2['lid'];
		$url   = $row2['url'];
		$url2  = $row2['rss_url'];
		$title = $row2['title'];
		$uid   = $row2['uid'];

		echo $lid.": ".htmlspecialchars($title);

		if ($this->_exist_url($url) || $this->_exist_url($url2))
		{
			echo " <b>skip</b> <br />\n";
			continue;
		}

		echo " <br />\n";

		$p1       = $lid;	// store lid;
		$rss_url  = '';
		$atom_url = '';

		switch ( $row2['rss_flag'] )
		{
			case 1:
				$mode    = 2;	// rss
				$rss_url = $url2;
				break;

			case 2:
				$mode     = 3;	// atom
				$atom_url = $url2;
				break;

			default:
				$mode = 4;	// auto
				break;
		}

		$sql3 = 'INSERT INTO '.$this->_table_rssc_link.' (uid, mid, p1, p2, p3, title, url, rdf_url, rss_url, atom_url, mode, encoding, refresh, headline, updated_unix, channel, xml, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).', '.$this->_quote($rdf_url).', '.$this->_quote($rss_url).', '.$this->_quote($atom_url).', '.$mode.', '.$this->_quote($encoding).', '.$refresh.', '.$headline.', 0, '.$this->_quote($channel).', '.$this->_quote($xml).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);
	}

	if ( $total > $next )
	{
		$this->_form_link($next);
	}
	else
	{
		$this->_form_feed();
	}

}


function import_feed()
{
// === feed table ===

// --- weblinks ---
//  aid int(11)
//  lid int(11)
//  site_title varchar(100)
//  site_url   varchar(255)
//  title varchar(100)
//  url   varchar(255)
//  entry_id   varchar(255)
//  guid       varchar(255)
//  time_modified int(10)
//  time_issued   int(10)
//  time_created  int(10)
//  author_name  varchar(100)
//  author_url   varchar(255)
//  author_email varchar(255)
//  content text

// --- rssc ---
//  fid int(11)
//  lid int(11)
//  uid int(11)
//  mid int(11)
//  p1  int(11)
//  p2  int(11)
//  p3  int(11)
//  site_title varchar(255)
//  site_link  varchar(255)
//  title  varchar(255)
//  link   varchar(255)
//  entry_id  varchar(255)
//  guid      varchar(255)
//  updated_unix   int(10)
//  published_unix int(10)
//  category  varchar(255)
//  author_name  varchar(255)
//  author_uri   varchar(255)
//  author_email varchar(255)
//  type_cont    varchar(255)
//  raws    text
//  content text
//  search  text
//  aux_int_1 int(5)
//  aux_int_2 int(5)
//  aux_text_1 varchar(255)
//  aux_text_2 varchar(255)

	echo "<h4>STEP 5: import feed table</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

	$table_weblinks_feed = $this->_db->prefix("weblinks_atomfeed");

	$this->_set_lid_list();

	$sql1  = "SELECT count(*) FROM ".$table_weblinks_feed;
	$res1  = $this->_sql_exec($sql1);
	$row1  = $this->_db->fetchRow($res1);
	$total = $row1[0];

	echo "There are <b>".$total."</b> feeds in weblinks<br />\n";
	echo "Transfer ".$offset." - ".$next." record <br /><br />\n";

	$sql2  = "SELECT * FROM ".$table_weblinks_feed;
	$sql2 .= " ORDER BY aid";
	$res2  = $this->_sql_exec($sql2, $this->_LIMIT, $offset);

// write param
	$mid = $this->_get_weblinks_mid();
	$p2  = 0;
	$p3  = 0;
	$category   = '';
	$type_cont  = '';
	$raws       = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	while ($row2 = $this->_db->fetchArray($res2))
	{
		$aid   = $row2['aid'];
		$title = $row2['title'];
		$link  = $row2['url'];

		echo $aid.": ".htmlspecialchars($title);

		if ( $this->_exist_feed($link) )
		{
			echo " <b>skip</b> <br />\n";
			continue;
		}

		echo " <br />\n";

		$lid = $this->_get_feed_lid( $row2 );
		$uid = $this->_get_feed_uid( $lid );
		$p1  = $this->_get_feed_p1(  $lid );
		$site_title     = $row2['site_title'];
		$site_link      = $row2['site_url'];
		$entry_id       = $row2['entry_id'];
		$guid           = $row2['guid'];
		$updated_unix   = $row2['time_modified'];
		$published_unix = $row2['time_issued'];
		$author_name    = $row2['author_name'];
		$author_uri     = $row2['author_url'];
		$author_email   = $row2['author_email'];
		$content        = $row2['content'];

		$search = $title.' '.$content;
		$search = $this->_strings->strip_control_code($search);
		$search = $this->_strings->strip_style_tag($search);
		$search = $this->_strings->add_space_after_tag($search);
		$search = strip_tags($search);

		$sql3 = 'INSERT INTO '.$this->_table_rssc_feed.' (lid, uid, mid, p1, p2, p3, site_title, site_link, title, link, entry_id, guid, updated_unix, published_unix, category, author_name, author_uri, author_email, type_cont, raws, content, search, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($site_title).', '.$this->_quote($site_link).', '.$this->_quote($title).', '.$this->_quote($link).', '.$this->_quote($entry_id).', '.$this->_quote($guid).', '.$updated_unix.', '.$published_unix.', '.$this->_quote($category).', '.$this->_quote($author_name).', '.$this->_quote($author_uri).', '.$this->_quote($author_email).', '.$this->_quote($type_cont).', '.$this->_quote($raws).', '.$this->_quote($content).', '.$this->_quote($search).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);
	}

	if ( $total > $next )
	{
		$this->_form_feed($next);
	}
	else
	{
		$this->_print_finish();
	}

}

//=========================================================
// import from xoopsheadline
//=========================================================
function hl_first_step()
{
	$this->_hl_form_xoopsheadline();
}

function hl_import_xoopsheadline()
{
// === line table ===

// --- xoopsheadline ---
//  headline_id smallint(3)
//  headline_name varchar(255)
//  headline_url varchar(255)
//  headline_rssurl varchar(255)
//  headline_encoding varchar(15)
//  headline_cachetime mediumint(8),
//  headline_asblock tinyint(1)
//  headline_display tinyint(1)
//  headline_weight smallint(3)
//  headline_mainfull tinyint(1)
//  headline_mainimg tinyint(1)
//  headline_mainmax tinyint(2)
//  headline_blockimg tinyint(1)
//  headline_blockmax tinyint(2)
//  headline_xml text NOT NULL default '',
//  headline_updated int(10) NOT NULL default'0',

// --- rssc ---
//  lid int(11)
//  uid int(11)
//  mid int(11)
//  p1  int(11)
//  p2  int(11)
//  p3  int(11)
//  title  varchar(255)
//  url    varchar(255)
//  refresh   mediumint(8)
//  headline  mediumint(8)
//  mode      tinyint(3)
//  rdf_url   varchar(255)
//  rss_url   varchar(255)
//  atom_url  varchar(255)
//  encoding  varchar(15)
//  updated_unix int(10)
//  channel text
//  xml  mediumtext
//  aux_int_1 int(5)
//  aux_int_2 int(5)
//  aux_text_1 varchar(255)
//  aux_text_2 varchar(255)

	echo "<h4>import link table</h4>\n";

	$offset = 0;
	if ( isset($_POST['offset']) )  $offset = $_POST['offset'];

	$next = $offset + $this->_LIMIT;

	$table_xoopsheadline = $this->_db->prefix("xoopsheadline");

	$sql1  = "SELECT count(*) FROM ".$table_xoopsheadline;
	$res1  = $this->_sql_exec($sql1);
	$row1  = $this->_db->fetchRow($res1);
	$total = $row1[0];

	echo "There are <b>".$total."</b> xoopsheadline in XoopsHeadline<br />\n";
	echo "Transfer ".$offset." - ".$next." record <br /><br />\n";

	$sql2  = "SELECT * FROM ".$table_xoopsheadline;
	$sql2 .= " ORDER BY headline_id";
	$res2  = $this->_sql_exec($sql2, $this->_LIMIT, $offset);

// write param
	$uid = 1;	// admin
	$mid = $this->_get_xoopsheadline_mid();
	$p2  = 0;
	$p3  = 0;
	$ltype    = 0;
	$mode     = 2;	// rss
	$rdf_url  = '';
	$atom_url = '';
	$updated_unix = 0;
	$channel    = '';
	$xml        = '';
	$aux_int_1  = 0;
	$aux_int_2  = 0;
	$aux_text_1 = '';
	$aux_text_2 = '';

	while ($row2 = $this->_db->fetchArray($res2))
	{
		$id        = $row2['headline_id'];
		$url       = $row2['headline_url'];
		$rssurl    = $row2['headline_rssurl'];
		$name      = $row2['headline_name'];
		$encoding  = $row2['headline_encoding'];
		$cachetime = $row2['headline_cachetime'];
		$weight    = $row2['headline_weight'];
		$asblock   = $row2['headline_asblock'];
		$display   = $row2['headline_display'];

		echo $id.": ".htmlspecialchars($name);

		if ($this->_exist_url($url) || $this->_exist_url($rssurl))
		{
			echo " <b>skip</b> <br />\n";
			continue;
		}

		echo " <br />\n";

		$title    = $name;
		$rss_url  = $rssurl;
		$refresh  = $cachetime;
		$p1       = $id;	// store lid;

		$headline = 0;

// as block
		if ( $asblock )
		{
			$headline = $weight + 1;
		}

		$sql3 = 'INSERT INTO '.$this->_table_rssc_link.' (uid, mid, p1, p2, p3, title, url, rdf_url, rss_url, atom_url, mode, encoding, refresh, headline, updated_unix, channel, xml, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).', '.$this->_quote($rdf_url).', '.$this->_quote($rss_url).', '.$this->_quote($atom_url).', '.$mode.', '.$this->_quote($encoding).', '.$refresh.', '.$headline.', 0, '.$this->_quote($channel).', '.$this->_quote($xml).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

		$this->_sql_exec($sql3);
	}

	if ( $total > $next )
	{
		$this->_form_link($next);
	}
	else
	{
		$this->_print_finish();
	}

}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// weblinks
//---------------------------------------------------------
function _get_weblinks_list($key)
{
	$table_weblinks_config = $this->_db->prefix("weblinks_config");

	$sql  = "SELECT * FROM ".$table_weblinks_config;
	$res  = $this->_sql_exec($sql);
	$row  = $this->_db->fetchArray($res);

	$list = $this->_strings->convert_string_to_array($row[$key], "\n");

	return $list;
}

function _get_weblinks_mid()
{
	return $this->_system->get_mid_by_dirname('weblinks');
}

function _exist_url($url)
{
	$url   = $this->_quote($url);
	$sql  = "SELECT count(*) FROM ".$this->_table_rssc_link;
	$sql .= " WHERE url=".$url." OR rdf_url=".$url." OR rss_url=".$url;
	$res  = $this->_sql_exec($sql);

	if ( !$res ) return false;

	$row  = $this->_db->fetchRow($res);

// already exist
	if ( $row[0] )
	{
		return true;
	}

	return false;
}

function _set_lid_list()
{
	$sql  = "SELECT * FROM ".$this->_table_rssc_link." ORDER BY lid";
	$res  = $this->_sql_exec($sql);

	$arr1 = array();
	$arr2 = array();
	$arr3 = array();

	while ( $row = $this->_db->fetchArray($res) )
	{
		if ( $row['p1'] )
		{
			$arr1[ $row['p1'] ]  = $row['lid'];
		}

		if ( $row['url'] )
		{
			$arr2[ $row['url'] ] = $row['lid'];
		}

		$arr3[ $row['lid'] ] = $row;
	}

	$this->_lid_list_by_p1   = $arr1;
	$this->_lid_list_by_url  = $arr2;
	$this->_link_list_by_lid = $arr3;

}

function _get_feed_lid($arr)
{
	$lid = $arr['lid'];
	$url = $arr['site_url'];

	if ( isset( $this->_list_list_by_p1[$lid] ) )
	{
		return $this->_list_list_by_p1[$lid];
	}

	if ( isset( $this->_lid_list_by_url[$url] ) )
	{
		return $this->_lid_list_by_url[$url];
	}

	return 0;
}

function _get_feed_uid($lid)
{
	if ( isset( $this->_link_list_by_lid[$lid]['uid'] ) )
	{
		return $this->_link_list_by_lid[$lid]['uid'];
	}

	return 0;
}

function _get_feed_p1($lid)
{
	if ( isset( $this->_link_list_by_lid[$lid]['p1'] ) )
	{
		return $this->_link_list_by_lid[$lid]['p1'];
	}

	return 0;
}

function _exist_feed($link)
{
	$sql  = "SELECT count(*) FROM ".$this->_table_rssc_feed;
	$sql .= " WHERE link=".$this->_quote($link);
	$res  = $this->_sql_exec($sql);

	if ( !$res ) return false;

	$row  = $this->_db->fetchRow($res);

// already exist
	if ( $row[0] )
	{
		return true;
	}

	return false;
}

function _form_site()
{
	$title  = 'STEP 1 : import rss site';
	$op     = 'import_site';
	$submit = 'GO STEP 1';

	$this->_make_form($title, $op, $submit);

}

function _form_black()
{
	$title  = 'STEP 2 : import black list';
	$op     = 'import_black';
	$submit = 'GO STEP 2';

	$this->_make_form($title, $op, $submit);

}

function _form_white()
{
	$title  = 'STEP 3 : import white list';
	$op     = 'import_white';
	$submit = 'GO STEP 3';

	$this->_make_form($title, $op, $submit);

}

function _form_link($offset=0)
{
	$title  = 'STEP 4 : import link table';
	$op     = 'import_link';

	if ($offset)
	{
		$submit = "GO next $this->_LIMIT links";
	}
	else
	{
		$submit = 'GO STEP 4';
	}

	$this->_make_form($title, $op, $submit, $offset);

}

function _form_feed($offset=0)
{
	$title  = "STEP 5 : import feed table";
	$op     = 'import_feed';

	if ($offset)
	{
		$submit = "GO next $this->_LIMIT feeds";
	}
	else
	{
		$submit = 'GO STEP 5';
	}

	$this->_make_form($title, $op, $submit, $offset);

}

//---------------------------------------------------------
// headline
//---------------------------------------------------------
function _hl_form_xoopsheadline()
{
	$title  = 'import xoopsheadline';
	$op     = 'import_xoopsheadline';
	$submit = 'GO';

	$this->_make_form($title, $op, $submit);

}

function _get_xoopsheadline_mid()
{
	return $this->_system->get_mid_by_dirname('xoopsheadline');
}

//---------------------------------------------------------
// common
//---------------------------------------------------------
function _make_form($title, $op, $submit, $offset=0)
{
	echo "<br /><hr />\n";
	echo "<h4>".$title."</h4>\n";

	if ($offset)
	{
		$next = $offset + $this->_LIMIT;
		echo "Transfer ".$offset." - ".$next." th record<br />\n";
	}

// form start
	echo $this->_form->make_form_start('tarns');
	echo $this->_form->make_form_token();
	echo $this->_form->make_form_hidden('op', $op);
	echo $this->_form->make_form_hidden('offset', $offset);
	echo $this->_form->make_table_start();
	echo $this->_form->make_table_title($title);
	$ele_submit = $this->_form->make_form_submit('submit', $submit);
	echo $this->_form->make_table_line('', $ele_submit, 'foot', 'foot');
	echo $this->_form->make_table_end();
	echo $this->_form->make_form_end();

}

function _print_finish()
{
	echo "<br /><hr />\n";
	echo "<h4>FINISHED</h4>\n";
	echo "<a href='index.php'>GOTO Admin Menu</a><br />\n";
}

function _quote($text)
{
	$str = "'".addslashes($text)."'";
	return $str;
}

function _sql_exec($sql, $limit=0, $offset=0)
{
	$ret = $this->_db->query($sql, $limit, $offset);
	if ($ret != false ) { return $ret; }

	$error = $this->_db->error();
	echo "<font color=red>$sql<br />$error</font><br />";

	return false;
}


// --- class end ---
}

?>