<?php
// $Id: admin_list_class.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

// 2006-01-20 K.OHWADA
// add sortid

//=========================================================
// RSS Center Module
// this file contain 5 class
//    admin_list_link
//    admin_list_black
//    admin_list_white
//    admin_list_feed
//    admin_list_base
// 2006-01-01 K.OHWADA
//=========================================================

//=========================================================
// class admin list link
//=========================================================
class admin_list_link extends admin_list_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_link()
{
	$this->admin_list_base();

	$this->_handler =& rssc_get_handler('link', $this->_DIRNAME);
	$this->_id = 'lid';

	$this->_TITLE = _AM_RSSC_LIST_LINK;
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_link();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_table_header()
{

	$edit = _RSSC_LINK_ID.'<br />('._EDIT.')';

	$arr = array(
		$edit,
		_AM_RSSC_SHOW_RSS,
		_AM_RSSC_SHOW_FEED,
		_RSSC_SITE_TITLE,
		_RSSC_RDF_URL, 
		_RSSC_RSS_URL, 
		_RSSC_ATOM_URL, 
	);

	return $arr;
}

function get_line(&$obj)
{
	$jump = 'link_manage.php?op=mod_form&amp;lid=';
	list($href1, $href2) = $this->get_linkfeed($obj);

	$arr = array(
		$this->get_mod_linkto($obj, 'lid', $jump),
		$href1,
		$href2,
		$this->get_name_linkto($obj, 'url', 'title'),
		$this->get_name_linkto($obj, 'rdf_url'),
		$this->get_name_linkto($obj, 'rss_url'),
		$this->get_name_linkto($obj, 'atom_url'),
	);

	return $arr;
}

function get_linkfeed(&$obj)
{
	$lid   = $obj->getVar('lid');
	$lid_p = sprintf("%03d",$lid);
	$count = $this->_feed_handler->get_count_by_lid( $lid );

	if ($count)
	{
		$name_feed = "FEED ($count)";
	}
	else
	{
		$name_feed = "FEED";
	}

	$jump_rss  = "view_rss.php?lid=".$lid;
	$jump_feed = "feed_list.php?lid=".$lid;
	$href1 = $this->make_html_url_link($jump_rss, 'RSS');
	$href2 = $this->make_html_url_link($jump_feed, $name_feed);

	return array($href1, $href2);
}

// --- class end ---
}


//=========================================================
// class admin list black
//=========================================================
class admin_list_black extends admin_list_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_black()
{
	$this->admin_list_base();

	$this->_handler =& rssc_get_handler('black', $this->_DIRNAME);
	$this->_id = 'bid';

	$this->_TITLE = _AM_RSSC_LIST_BLACK;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_black();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_table_header()
{
	$arr = array(
		_RSSC_BLACK_ID,
		_AM_RSSC_SHOW_FEED,
		_RSSC_SITE_LINK,
		_RSSC_SITE_TITLE,
	);

	return $arr;
}

function get_line(&$obj)
{
	$jump = 'black_manage.php?op=mod_form&amp;bid=';

	$url   = $obj->getVar('url');
	$jump_feed  = "feed_list.php?link=".$url;
	$count = $this->_feed_handler->get_count_by_link( $url );

	if ($count)
	{
		$name_feed = "FEED ($count)";
	}
	else
	{
		$name_feed = "FEED";
	}

	$arr = array(
		$this->get_mod_linkto( $obj, 'bid', $jump),
		$this->make_html_url_link($jump_feed, $name_feed),
		$this->get_name_linkto($obj, 'url'),
		$this->make_text(      $obj, 'title'),
	);

	return $arr;
}

// --- class end ---
}


//=========================================================
// class admin list white
//=========================================================
class admin_list_white extends admin_list_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_white()
{
	$this->admin_list_base();

	$this->_handler =& rssc_get_handler('white', $this->_DIRNAME);
	$this->_id = 'wid';

	$this->_TITLE = _AM_RSSC_LIST_WHITE;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_white();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_table_header()
{
	$arr = array(
		_RSSC_WHITE_ID,
		_RSSC_SITE_LINK,
		_RSSC_SITE_TITLE,
	);

	return $arr;
}

function get_line(&$obj)
{
	$jump = 'white_manage.php?op=mod_form&amp;wid=';

	$arr = array(
		$this->get_mod_linkto( $obj, 'wid', $jump),
		$this->get_name_linkto($obj, 'url'),
		$this->make_text(      $obj, 'title'),
	);

	return $arr;
}

// --- class end ---
}


//=========================================================
// class admin list feed
//=========================================================
class admin_list_feed extends admin_list_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_feed()
{
	$this->admin_list_base();

	$this->_handler =& rssc_get_handler('feed', $this->_DIRNAME);
	$this->_id = 'fid';

	$this->_TITLE = _AM_RSSC_LIST_FEED;

	$this->_action = 'feed_manage.php';

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_feed();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function print_top_extra()
{
	$condition = '';

	if ( isset($_GET['lid']) )
	{
		$lid = $this->_post->get_get_int('lid');
		$condition = "lid = ".$lid;
	}
	elseif ( isset($_GET['link']) )
	{
		$link = $this->_post->get_get('link');
		$condition = "link LIKE ".$link;
	}

	if ( $condition )
	{
		$total = $this->get_total();
		printf(_AM_RSSC_THERE_ARE_MATCH, $total);
		echo "<br />\n";
		echo _AM_RSSC_CONDITION.": ".$condition. "<br /><br />\n";
	}

}

function get_total()
{
	if ( isset($_GET['lid']) )
	{
		$lid = $this->_post->get_get_int('lid');
		return $this->_feed_handler->get_count_by_lid($lid);
	}
	elseif ( isset($_GET['link']) )
	{
		$link = $this->_post->get_get('link');
		return $this->_feed_handler->get_count_by_link($link);
	}

	return $this->_handler->getCount();
}

function get_objects($sortid=0, $limit=0, $start=0)
{
	if ( isset($_GET['lid']) )
	{
		$lid = $this->_post->get_get_int('lid');
		return $this->_feed_handler->get_objects_by_lid($lid, $limit, $start);
	}
	elseif ( isset($_GET['link']) )
	{
		$link = $this->_post->get_get('link');
		return $this->_feed_handler->get_objects_by_link($link, $limit, $start);
	}

	return $this->_get_objects_by_sortid($sortid, $limit, $start);

//	return $this->_feed_handler->get_objects($limit, $start);
}

function get_table_header()
{
	$checkbox = $this->make_js_checkall();

	$arr = array(
		$checkbox,
		_RSSC_FEED_ID,
		_RSSC_TITLE,
		_RSSC_SITE_TITLE,
		_RSSC_UPDATED,
		_RSSC_CONTENT,
	);

	return $arr;
}

function get_line($obj)
{
	$fid = $obj->getVar('fid');
	$checkbox = $this->make_js_checkbox($fid);

	$jump = 'feed_manage.php?op=mod_form&amp;fid=';

	$updated_unix = $obj->getVar('updated_unix', 'n');
	$content = $obj->getVar('content', 'n');

	formatTimestamp( $updated_unix, 'mysql');

	if ($content)
	{
		$content = strip_tags($content);
		$content = $this->_strings->shorten_text($content, 50);
		$content_html = htmlspecialchars($content);
	}
	else
	{
		$content_html = '&nbsp;';
	}

	$arr = array(
		$checkbox,
		$this->get_mod_linkto($obj, 'fid', $jump),
		$this->get_name_linkto($obj, 'link',      'title'),
		$this->get_name_linkto($obj, 'site_link', 'site_title'),
		formatTimestamp($updated_unix, 'mysql'),
		$content_html,
	);

	return $arr;
}

function print_form_submit()
{
	$ele_submit = $this->make_form_submit('submit', _DELETE);
	echo "<tr><td colspan='2' class='foot'>".$ele_submit."</td>";
	echo "<td colspan='4' class='foot'></tr>\n";
}

// --- class end ---
}

//=========================================================
// class admin list base
//=========================================================
class admin_list_base extends rssc_form
{
// class instance
	var $_handler;
	var $_id;
	var $_feed_handler;
	var $_pagenavi;
	var $_strings;
	var $_post;

// constant
	var $_PERPAGE = 50;

// loacl
	var $_DIRNAME;
	var $_TITLE = '';
	var $_action = '';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_list_base()
{
// handler
	$this->_DIRNAME = rssc_admin_get_dirname();
	$this->_feed_handler =& rssc_get_handler('feed', $this->_DIRNAME);

// class instance
	$this->_pagenavi =& rssc_pagenavi::getInstance();
	$this->_strings  =& rssc_strings::getInstance();
	$this->_post     =& rssc_post::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_list_base();
	}
	return $instance;
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function show()
{
	$total_db = $this->get_total_db();
	$total    = $this->get_total();

	$this->_pagenavi->setPerpage( $this->_PERPAGE );
	$this->_pagenavi->setTotal($total);
	$this->_pagenavi->set_max_sortid(1);
	$this->_pagenavi->set_flag_sortid(1);

	$this->_pagenavi->getGetPage();
	$sortid = $this->_pagenavi->getGetSortid();

	$this->print_top($total_db);

	echo "<ul>\n";
	echo "<li><a href='?sortid=0'>"._AM_RSSC_ID_ASC."</a><br /></li>\n";
	echo "<li><a href='?sortid=1'>"._AM_RSSC_ID_DESC."</a><br /></li>\n";
	echo "</ul>\n";

// --- link list ---
	if ($total > 0)
	{
		$start = $this->_pagenavi->calcStart();

// form start
		echo $this->make_form_start('rssclist', $this->_action);
		echo $this->make_form_token();
		echo $this->make_form_hidden('op', 'del_all');

		$this->print_table_start();

		$obj_arr = $this->get_objects($sortid, $this->_PERPAGE, $start);

		foreach ($obj_arr as $obj) 
		{
			$this->print_table_line( $this->get_line($obj) );
		}

		$navi = $this->_pagenavi->build();

		$this->print_form_submit();
		$this->print_table_end();
		echo $this->make_form_end();

		echo "<div align='center'>$navi</div>\n";

	}
	else
	{
		echo "<br />\n";
		echo "<font color='blue'>"._NO_RECORD."</font><br />\n";
	}
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_total_db()
{
	return $this->_handler->getCount();
}

function print_top($total)
{
	echo "<h4>".$this->_TITLE."</h4>\n";
	printf(_RSSC_THEREARE, $total);
	echo "<br /><br />\n";

	$this->print_top_extra();
}

function print_table_start()
{
	$head_arr = $this->get_table_header();

	echo "<table border='1'><tr>";

	foreach ($head_arr as $head)
	{
		echo "<th align='center'>".$head."</th>";
	}

	echo "</tr>\n";

}

function print_table_end()
{
	echo "</table><br />\n";
}

function print_table_line( $line_arr )
{
	echo "<tr>";

	foreach ($line_arr as $line)
	{
		echo "<td>".$line."</td>";
	}

	echo "</tr>\n";
}

function get_mod_linkto(&$obj, $key, $jump)
{
	$id   = $obj->getVar($key);
	$id_p = sprintf("%03d",$id);
	$jump_mod = $jump.$id;

	return $this->make_html_url_link($jump_mod, $id_p);
}

function get_name_linkto(&$obj, $key1, $key2='')
{
	$url = $obj->getVar($key1, 's');

	if ($key2)
	{
		$name = $obj->getVar($key2, 's');
	}
	else
	{
		$name = $url;
	}

	if ($url)
	{
		return $this->make_html_url_link($url, $name, '_blank');
	}

	return '&nbsp;';
}

function make_text(&$obj, $key)
{
	$text = $obj->getVar($key, 's');

	if ($text)
	{
		return $text;
	}

	return '&nbsp;';
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _get_objects_by_sortid($sortid=0, $limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);

	if ($sortid == 1)
	{
		$sort = $this->_id.' DESC';
		$criteria->setSort($sort);
	}

	return $this->_handler->getObjects($criteria);
}

//---------------------------------------------------------
// override
//---------------------------------------------------------
function get_total()
{
	return $this->_handler->getCount();
}

function get_objects($sortid=0, $limit=0, $start=0)
{
	return $this->_get_objects_by_sortid($sortid, $limit, $start);
}

function print_top_extra()
{
	// dummy
}

function get_table_header()
{
	return array();
}

function get_line($obj)
{
	// dummy
}

function print_form_submit()
{
	// dummy
}

// --- class end ---
}

?>