<?php
// $Id: admin_manage_base_class.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

// 2006-01-20 K.OHWADA
// change update table

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

class admin_manage_base extends rssc_error
{
// handler
	var $_feed_handler;

// class
	var $_handler;
	var $_strings;
	var $_form;
	var $_post;
	var $_system;

// varibale for each list
	var $_id_name = 'lid';
	var $_url_redirect      = 'link_list.php';
	var $_url_redirect_desc = 'link_list.php?sortid=1';

	var $_TITLE_ADD = _AM_RSSC_ADD_LINK;
	var $_TITLE_MOD = _AM_RSSC_MOD_LINK;
	var $_TITLE_DEL = _AM_RSSC_DEL_LINK;

// local
	var $_DIRNAME;
	var $_flag_cp_header = false;

// define by rssc_base
//	var $_logs   = array();
//	var $_errors = array();
//	var $_error_code = 0;
//	var $_error_flag = false;
//	var $_flag_debug_print_log   = 0;
//	var $_flag_debug_print_error = 0;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_base()
{
	$this->rssc_error();

// handler
	$this->_DIRNAME = rssc_admin_get_dirname();
	$this->_feed_handler =& rssc_get_handler('feed', $this->_DIRNAME);

// class
	$this->_strings =& rssc_strings::getInstance();
	$this->_form    =& admin_form::getInstance();
	$this->_post    =& rssc_post::getInstance();
	$this->_system  =& rssc_system::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_base();
	}

	return $instance;
}

//---------------------------------------------------------
// override function
//---------------------------------------------------------
function add_form()
{
	// dummy
}

function add_link()
{
	return true;	// dummy
}

function add_list()
{
	return true;	// dummy
}

function add_bulk()
{
	return true;	// dummy
}

function del_bulk()
{
	return true;	// dummy
}

function print_form($arr, $flag)
{
	// dummy
}

function _set_insert_vars()
{
	// dummy
}

function _set_update_vars()
{
	// dummy
}

function _check_input($arr)
{
	// dummy
}


//---------------------------------------------------------
// main function
//---------------------------------------------------------
function main()
{
	$op = '';
	if     ( isset($_POST['del_table']) )  $op = 'del_table';
	elseif ( isset($_POST['op']) )         $op = $_POST['op'];
	elseif ( isset($_GET['op']) )          $op = $_GET['op'];

	$flag_token = $this->check_token();

	if( $op == 'add_table' )
	{
		if ( $flag_token && $this->add_table() )
		{
			redirect_header($this->_url_redirect_desc, 1, _AM_RSSC_DBUPDATED);
			exit();
		}

		$this->print_top( $this->_TITLE_ADD );
		$this->print_token_error();
		$this->print_error();
		$this->print_preview();
	}

	elseif( $op == 'mod_form' )
	{
		$this->print_top( $this->_TITLE_MOD );

		if ( !$this->mod_form() )
		{
			$this->print_error();
		}
	}

	elseif( $op == 'mod_table' )
	{
		if ( $flag_token )
		{
	// check param
			if ( !$this->check_mod_table() ) 
			{
				if ( $this->mod_table() )
				{
					redirect_header($this->_url_redirect, 1, _AM_RSSC_DBUPDATED);
					exit();
				}
				else
				{
					$this->print_top( $this->_TITLE_MOD );
					$this->print_error();
				}
			}
			else
			{
				$this->print_top( $this->_TITLE_MOD );
				$this->print_error();
				$this->print_preview(1);
			}
		}
		else
		{
			$this->print_top( $this->_TITLE_MOD );
			$this->print_token_error();
			$this->print_error();
			$this->print_preview(1);
		}
	}

	elseif( $op == 'del_table' )
	{
		if ( $flag_token && $this->del_table() )
		{
			redirect_header($this->_url_redirect, 1, _AM_RSSC_DBUPDATED);
			exit();
		}

		$this->print_top( $this->_TITLE_DEL );
		$this->print_token_error();
		$this->print_error();
	}

// for link
	elseif( $op == 'addlink' )
	{
		$this->print_top( $this->_TITLE_ADD );

		if ( !$this->add_link() )
		{
			$this->print_error();
		}
	}

// for black
	elseif( $op == 'addlist' )
	{
		$this->print_top( $this->_TITLE_ADD );

		if ( !$this->add_list() )
		{
			$this->print_error();
		}
	}

	elseif( $op == 'add_bulk' )
	{
		if ( $flag_token && $this->add_bulk() )
		{
			redirect_header($this->_url_redirect_desc, 1, _AM_RSSC_DBUPDATED);
			exit();
		}

		$this->print_top( $this->_TITLE_ADD );
		$this->print_token_error();
		$this->print_error();
		$this->print_preview();
	}

// for feed
	elseif( $op == 'del_all' )
	{
		if ( $flag_token && $this->del_bulk() )
		{
			redirect_header($this->_url_redirect, 1, _AM_RSSC_DBUPDATED);
			exit();
		}

		$this->print_top( $this->_TITLE_DEL );
		$this->print_token_error();
		$this->print_error();
	}

	else
	{
		$this->print_top( $this->_TITLE_ADD );
		$this->add_form();
	}

	xoops_cp_footer();
	exit();
}


//---------------------------------------------------------
// public
//---------------------------------------------------------
function print_cp_header()
{
// not yet
	if ( !$this->_flag_cp_header )
	{
		xoops_cp_header();
	}

	$this->_flag_cp_header = true;	// already
}

function print_top($title)
{
	$this->print_cp_header();

	rssc_admin_print_header();
	rssc_admin_print_menu();

	if ($title)
	{
		echo "<h4>".$title."</h4>\n";
	}
}

function print_preview($flag=0)
{
	$this->_print_form($_POST, $flag);
}

function print_error()
{
	echo "<hr /><font color='red'>\n";
	echo $this->getErrors(1);
	echo "</font><hr />\n";
}

function print_no_record()
{
	echo "<br />\n";
	echo "<font color='blue'>"._NO_RECORD."</font><br />\n";
}

function check_token()
{
	$this->_flag_token = false;

	if( rssc_admin_check_token() ) 
	{
		$this->_flag_token = true;
		return true;
	}

	return false;
}

function print_token_error()
{
	if( !$this->_flag_token ) 
	{
		xoops_error("Token Error");
	}
}

//---------------------------------------------------------
// modify form
//---------------------------------------------------------
function mod_form()
{
	$id  = $this->_post->get_get_int( $this->_id_name );
	$obj = $this->_handler->get($id);

	if ( !is_object($obj) ) 
	{
		$this->_set_errors( _NO_RECORD );
		return false;
	}

	$arr = $obj->getVarAll('E');
	$this->_print_form($arr, 1);

	return true;
}

//---------------------------------------------------------
// add record to table
//---------------------------------------------------------
function add_table()
{
// check param
	if ( $this->_check_input( $_POST ) ) 
	{
		return false;
	}

	$obj =& $this->_set_insert_vars();

	if ( !$this->_handler->insert($obj) ) 
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// update recode in table
//---------------------------------------------------------
function mod_table()
{
	$id  =  $this->_post->get_post_int( $this->_id_name );
	$obj =& $this->_handler->get($id);

	if ( !is_object($obj) ) 
	{
		$this->_set_errors( _NO_RECORD );
		return false;
	}

	$obj =& $this->_set_update_vars( $obj );

	if ( !$this->_handler->update($obj) ) 
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

	return true;
}

function check_mod_table()
{
	return $this->_check_input($_POST); 
}

//---------------------------------------------------------
// delete recode from table
//---------------------------------------------------------
function del_table()
{
	$id  =  $this->_post->get_post_int( $this->_id_name );
	$obj =& $this->_handler->get($id);

	if ( !is_object($obj) ) 
	{
		$this->_set_errors( _NO_RECORD );
		return false;	
	}

	if ( !$this->_handler->delete($obj) ) 
	{
		$this->_set_errors( _AM_RSSC_FAILDELETE );
		return false;	
	}

	return true;
}

//=========================================================
// private
//=========================================================
function _check_fill($text, $msg)
{
	if ( $text == "" )
	{
		$msg1 = sprintf(_AM_RSSC_ERROR_FILL, $msg);
		$this->_set_errors( $msg1 );
	}
}

function _check_url($url, $msg, $flag_check=1)
{
	$flag_empty   = false;
	$flag_illegal = false;

	if ( ($url == "") || ($url == "http://") )
	{
		$flag_empty = true;
	}
	elseif ( !preg_match("|^https?://|", $url) || preg_match("/javascript:/si", $url) )
	{
		$flag_illegal = true;
	}

	if ( $flag_check && $flag_empty )
	{
		$msg1 = sprintf(_AM_RSSC_ERROR_FILL, $msg);
		$this->_set_errors( $msg1 );
	}

	if ( $flag_illegal )
	{
		$msg1 = sprintf(_AM_RSSC_ERROR_ILLEGAL, $msg);
		$this->_set_errors( $msg1 );
	}

}

function _set_field_value_url($array, $key)
{
	if ( isset($array[$key]) )
	{
		return $this->_set_value_url( $array[$key] );
	}

	return '';
}

function _set_value_url($value)
{
	$value = trim($value);

	if ( $value && ( $value != "http://" ) )
	{
		return $value;
	}

	return '';
}

//---------------------------------------------------------
// black & white
//---------------------------------------------------------
function _add_form_black_white()
{
	$arr = array(
		'uid' => $this->_system->get_uid(),
		'mid' => $this->_system->get_mid(),
		'lid' => 0,
		'p1'  => 0,
		'p2'  => 0,
		'p3'  => 0,
		'title'   => '',
		'url'     => '',
		'urllist' => '',
		'memo'    => '',
	);

	$this->_print_form($arr, 0);
	return true;
}

function _add_bulk_black_white()
{
// check param
	if ( $this->_check_add_bulk_black_white( $_POST ) ) 
	{
		return false;
	}

	$urllist  = $this->_post->get_post('urllist');
	$url_arr  = $this->_strings->split_nl($urllist);
	$flag_err = false;

	foreach ($url_arr as $url1)
	{
		$url2 = $this->_set_value_url($url1);

		if ( empty($url2) )  continue;

		$obj = $this->_handler->create();
		$obj->assignVars( $_POST );
		$obj->setVar('url', $url2 );

		if ( !$this->_handler->insert($obj) ) 
		{
			$flag_err = true;
			$this->_set_errors( "$url2 :"._AM_RSSC_FAILUPDATE );
			$this->_set_errors( $this->_handler->getErrors() );
		}
	}

	if ($flag_err)  return false;

	return true;
}

function _check_add_bulk_black_white($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_url($arr['urllist'], _RSSC_SITE_LINK);

	return $this->_error_flag;
}

function &_set_update_vars_black_white( &$obj )
{
	$url = $this->_set_field_value_url($_POST, 'url');

	$obj->assignVars( $_POST );
	$obj->setVar('url', $url );

	return $obj;
}


//---------------------------------------------------------
// feed table
//---------------------------------------------------------
function _get_feed_by_fid($fid)
{
	if ($fid <= 0)
	{
		$this->_set_errors( _NO_RECORD );
		return false;
	}

	$feed_obj = $this->_feed_handler->get($fid);

	if ( !is_object($feed_obj) )
	{
		$this->_set_errors( _NO_RECORD );
		return false;
	}

	$feed = $feed_obj->getVarAll();	
	return $feed;
}

// --- class end ---
}

?>