<?php
// $Id: admin_manage_class.php,v 1.1.1.1 2006/01/03 05:06:00 ohwada Exp $

// 2006-01-20 K.OHWADA
// change update table

//=========================================================
// RSS Center Module
// this file contain 5 class
//    admin_manage_link
//    admin_manage_black
//    admin_manage_white
//    admin_manage_feed
// 2006-01-01 K.OHWADA
//=========================================================

//=========================================================
// class link manage
//=========================================================
class admin_manage_link extends admin_manage_base
{
	var $_MODE = RSSC_C_MODE_AUTO;	// auto discovery
	var $_REFRESH_INTERVAL = 86400;	// 24 hours

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_link()
{
	$this->admin_manage_base();

	$this->_handler =& rssc_get_handler('link', $this->_DIRNAME);

	$this->_id_name = 'lid';
	$this->_url_redirect      = 'link_list.php';
	$this->_url_redirect_desc = 'link_list.php?sortid=1';

	$this->_TITLE_ADD = _AM_RSSC_ADD_LINK;
	$this->_TITLE_MOD = _AM_RSSC_MOD_LINK;
	$this->_TITLE_DEL = _AM_RSSC_DEL_LINK;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_link();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function add_form()
{
	$arr = array(
		'uid'  => $this->_system->get_uid(),
		'mid'  => $this->_system->get_mid(),
		'mode'     => $this->_MODE,
		'refresh'  => $this->_REFRESH_INTERVAL,
		'ltype'    => 0,
		'headline' => 0,
		'updated_unix' => 0,
		'lid'  => 0,
		'p1'   => 0,
		'p2'   => 0,
		'p3'   => 0,
		'title'     => '',
		'url'       => '',
		'rdf_url'   => '',
		'rss_url'   => '',
		'atom_url'  => '',
		'encoding'  => '',
		'channel'   => '',
		'xml'       => '',
		);

	$this->_print_form($arr, 0);
	return true;
}


//---------------------------------------------------------
// add link form
// override
//---------------------------------------------------------
function add_link()
{
	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/rssc";
	include_once $MODULE_ROOT."/api/parse.php";

	$xml_utility =& rssc_xml_utility::getInstance();

	$fid  = $this->_post->get_get_int('fid');

	$feed = $this->_get_feed_by_fid($fid);
	if ( !$feed )
	{
		return false;
	}

	$feed_title = $feed['title'];
	$feed_link  = $feed['link'];

	if ( $xml_utility->discover_parse( $feed_link ) )
	{
		$title    = $xml_utility->get_channel_var('title');
		$url      = $xml_utility->get_channel_var('link');
		$xml_mode = $xml_utility->get_xml_mode();
		$rdf_url  = $xml_utility->get_rdf_url();
		$rss_url  = $xml_utility->get_rss_url();
		$atom_url = $xml_utility->get_atom_url();
		$encoding = $xml_utility->get_xml_encoding();
	}
	else
	{
		$title    = $feed_title;
		$url      = $feed_link;
		$xml_mode = $this->_MODE;
		$rdf_url  = '';
		$rss_url  = '';
		$atom_url = '';
		$encoding = '';
	}

	$arr = array(
		'uid'  => $this->_system->get_uid(),
		'mid'  => $this->_system->get_mid(),
		'refresh'  => $this->_REFRESH_INTERVAL,
		'mode'     => intval($xml_mode),
		'title'    => htmlspecialchars($title,    ENT_QUOTES),
		'url'      => htmlspecialchars($url,      ENT_QUOTES),
		'rdf_url'  => htmlspecialchars($rdf_url,  ENT_QUOTES),
		'rss_url'  => htmlspecialchars($rss_url,  ENT_QUOTES),
		'atom_url' => htmlspecialchars($atom_url, ENT_QUOTES),
		'encoding' => htmlspecialchars($encoding, ENT_QUOTES),
		'ltype'        => 0,
		'headline'     => 0,
		'updated_unix' => 0,
		'lid'  => 0,
		'p1'   => 0,
		'p2'   => 0,
		'p3'   => 0,
		'channel'   => '',
		'xml'       => '',
		);

	$this->_print_form($arr, 0);
	return true;
}

//---------------------------------------------------------
// private override
//---------------------------------------------------------
function _print_form($arr, $flag)
{
	$this->_form->show_link($arr, $flag);
}

function &_set_insert_vars()
{
	$obj =& $this->_handler->create();
	return $this->_set_vars( $obj );
}

function &_set_update_vars( &$obj )
{
	return $this->_set_vars( $obj );
}

function &_set_vars( &$obj )
{
	$url      = $this->_set_field_value_url($_POST, 'url');
	$rdf_url  = $this->_set_field_value_url($_POST, 'rdf_url');
	$rss_url  = $this->_set_field_value_url($_POST, 'rss_url');
	$atom_url = $this->_set_field_value_url($_POST, 'atom_url');

	$obj->assignVars( $_POST );
	$obj->setVar('url',      $url );
	$obj->setVar('rdf_url',  $rdf_url );
	$obj->setVar('rss_url',  $rss_url );
	$obj->setVar('atom_url', $atom_url );

	return $obj;
}

function _check_input($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_fill($arr['title'],   _RSSC_SITE_TITLE);
	$this->_check_url($arr['url'],      _RSSC_SITE_LINK);
	$this->_check_url($arr['rdf_url'],  _RSSC_RDF_URL, 0);
	$this->_check_url($arr['rss_url'],  _RSSC_RSS_URL, 0);
	$this->_check_url($arr['atom_url'], _RSSC_ATOM_URL, 0);

	return $this->_error_flag;
}

// --- class end ---
}

//=========================================================
// class black manage
//=========================================================
class admin_manage_black extends admin_manage_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_black()
{
	$this->admin_manage_base();

	$this->_handler =& rssc_get_handler('black', $this->_DIRNAME);

	$this->_id_name = 'bid';
	$this->_url_redirect      = 'black_list.php';
	$this->_url_redirect_desc = 'black_list.php?sortid=1';

	$this->_TITLE_ADD = _AM_RSSC_ADD_BLACK;
	$this->_TITLE_MOD = _AM_RSSC_MOD_BLACK;
	$this->_TITLE_DEL = _AM_RSSC_DEL_BLACK;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_black();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function add_form()
{
	return $this->_add_form_black_white();
}

//---------------------------------------------------------
// add list form
// override
//---------------------------------------------------------
function add_list()
{
	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/rssc";
	include_once $MODULE_ROOT."/api/parse.php";

	$xml_utility =& rssc_xml_utility::getInstance();

	$fid  = $this->_post->get_get_int('fid');

	$feed = $this->_get_feed_by_fid($fid);
	if ( !$feed )
	{
		return false;
	}

	$feed_title = $feed['title'];
	$feed_link  = $feed['link'];

	if ( $xml_utility->discover_parse( $feed_link ) )
	{
		$title = $xml_utility->get_channel_var('title');
		$link  = $xml_utility->get_channel_var('link');
		$site_title = $title;
		$site_link  = $link;
	}
	else
	{
		$title = $feed_title;
		$link  = $feed_link;
		$site_title = '';
		$site_link  = '';
	}

	$memo  = '';
	$memo .= $feed['site_title']."\n";
	$memo .= $feed['site_link']."\n";
	$memo .= $feed_title."\n";
	$memo .= $feed_link."\n";
	$memo .= $site_title."\n";
	$memo .= $site_link."\n";

	$link_html = htmlspecialchars($link,  ENT_QUOTES);

	$arr = array(
		'uid'     => intval( $feed['uid'] ),
		'mid'     => intval( $feed['mid'] ),
		'lid'     => intval( $feed['lid'] ),
		'p1'      => intval( $feed['p1'] ),
		'p2'      => intval( $feed['p2'] ),
		'p3'      => intval( $feed['p3'] ),
		'url'     => $link_html,
		'urllist' => $link_html,
		'title'   => htmlspecialchars($title, ENT_QUOTES),
		'memo'    => htmlspecialchars($memo,  ENT_QUOTES),
	);

	$this->_print_form($arr, 0);
	return true;
}

//---------------------------------------------------------
// add bulk recode to table
// override
//---------------------------------------------------------
function add_bulk()
{
	return $this->_add_bulk_black_white();
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _check_add_bulk($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_url($arr['urllist'], _RSSC_SITE_LINK);

	return $this->_error_flag;
}

//---------------------------------------------------------
// private override
//---------------------------------------------------------
function _print_form($arr, $flag)
{
	$this->_form->show_black($arr, $flag);
}

function _set_update_vars()
{
	return $this->_set_update_vars_black_white();
}

// --- class end ---
}


//=========================================================
// class white manage
//=========================================================
class admin_manage_white extends admin_manage_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_white()
{
	$this->admin_manage_base();

	$this->_handler =& rssc_get_handler('white', $this->_DIRNAME);

	$this->_id_name = 'wid';
	$this->_url_redirect      = 'white_list.php';
	$this->_url_redirect_desc = 'white_list.php?sortid=1';

	$this->_TITLE_ADD = _AM_RSSC_ADD_WHITE;
	$this->_TITLE_MOD = _AM_RSSC_MOD_WHITE;
	$this->_TITLE_DEL = _AM_RSSC_DEL_WHITE;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_white();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function add_form()
{
	return $this->_add_form_black_white();
}

//---------------------------------------------------------
// add bulk recode to table
// override
//---------------------------------------------------------
function add_bulk()
{
	return $this->_add_bulk_black_white();
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _check_add_bulk($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_url($arr['urllist'],      _RSSC_SITE_LINK);

	return $this->_error_flag;
}

//---------------------------------------------------------
// private override
//---------------------------------------------------------
function _print_form($arr, $flag)
{
	$this->_form->show_white($arr, $flag);
}

function &_set_update_vars( &$obj )
{
	return $this->_set_update_vars_black_white( $obj );
}

// --- class end ---
}

//=========================================================
// class feed manage
//=========================================================
class admin_manage_feed extends admin_manage_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_feed()
{
	$this->admin_manage_base();

	$this->_handler =& rssc_get_handler('feed', $this->_DIRNAME);

	$this->_id_name = 'fid';
	$this->_url_redirect      = 'feed_list.php';
	$this->_url_redirect_desc = 'feed_list.php?sortid=1';

	$this->_TITLE_ADD = _AM_RSSC_ADD_FEED;
	$this->_TITLE_MOD = _AM_RSSC_MOD_FEED;
	$this->_TITLE_DEL = _AM_RSSC_DEL_FEED;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_feed();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function add_form()
{
	$arr = array(
		'uid'  => $this->_system->get_uid(),
		'mid'  => $this->_system->get_mid(),
		'updated_unix' => 0,
 		'published_unix' => 0,
		'lid'  => 0,
		'p1'   => 0,
		'p2'   => 0,
		'p3'   => 0,
  		'site_title' => '',
  		'site_link'  => '',
		'title'     => '',
		'link'      => '',
  		'entry_id'  => '',
  		'guid'      => '',
  		'category'  => '',
  		'author_name'  => '',
  		'author_uri'   => '',
  		'author_email' => '',
  		'mode_cont'    => '',
  		'raws'    => '',
  		'content' => '',
  		'search'  => '',
		);

	$this->_print_form($arr, 0);
	return true;
}

//---------------------------------------------------------
// delete recode from table
// override
//---------------------------------------------------------
function del_bulk()
{
	$id_arr = $this->_post->get_post('rssclist_id');

	if ( count($id_arr) == 0 )  return true;

	$flag_err = false;

	foreach ($id_arr as $id)
	{
		$obj =& $this->_handler->get($id);

		if ( !is_object($obj) ) continue;

		if ( !$this->_handler->delete($obj) ) 
		{
			$flag_err = true;
			$this->_set_errors( "$id :"._AM_RSSC_FAILDELETE );
		}
	}

	if ($flag_err)  return false;

	return true;
}

//---------------------------------------------------------
// private override
//---------------------------------------------------------
function _print_form($arr, $flag)
{
	$this->_form->show_feed($arr, $flag);
}

function &_set_insert_vars()
{
	$obj =& $this->_handler->create();
	return $this->_set_vars( $obj );
}

function &_set_update_vars( &$obj )
{
	return $this->_set_vars( $obj );
}

function &_set_vars( &$obj )
{
	$site_link = $this->_set_field_value_url($_POST, 'site_link');
	$link      = $this->_set_field_value_url($_POST, 'link');

	$obj->assignVars( $_POST );
	$obj->setVar('site_link',  $site_link );
	$obj->setVar('link',       $link );

	return $obj;
}

function _check_input($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_fill($arr['site_title'],   _RSSC_SITE_TITLE);
	$this->_check_url($arr['site_link'],     _RSSC_SITE_LINK);

	return $this->_error_flag;
}

// --- class end ---
}

//=========================================================
// class keyword manage
//=========================================================

class admin_manage_keyword extends admin_manage_base
{
// handler, class
	var $_handler;
	var $_list;
	var $_convert;

	var $_from = _CHARSET;

	var $_MODE = RSSC_C_MODE_RSS;	// rss
	var $_REFRESH_INTERVAL = 3600;	// 1 hours

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_manage_keyword()
{
	$this->admin_manage_base();

// handler, class
	$this->_handler =& rssc_get_handler('link', $this->_DIRNAME);
	$this->_list    =& rssc_site_list::getInstance();
	$this->_convert =& rssc_convert::getInstance();

	$this->_id_name = 'lid';
	$this->_list_id = 1;

	$this->_TITLE_ADD = _AM_RSSC_ADD_LINK;
	$this->_TITLE_MOD = _AM_RSSC_MOD_LINK;
	$this->_TITLE_DEL = _AM_RSSC_DEL_LINK;

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_manage_keyword();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function add_form()
{
	$arr = array(
		'uid'      => $this->_system->get_uid(),
		'mid'      => $this->_system->get_mid(),
		'mode'     => $this->_MODE,
		'refresh'  => $this->_REFRESH_INTERVAL,
		'ltype'    => 1,
		'updated_unix' => 0,
		'lid'  => 0,
		'p1'   => 0,
		'p2'   => 0,
		'p3'   => 0,
		'title'     => '',
		'url'       => '',
		'rss_url'   => '',
		'atom_url'  => '',
		'encoding'  => '',
		'channel'   => '',
		'xml'       => '',
		);

	$this->_print_form($arr, 0);
	return true;
}

//---------------------------------------------------------
// add record to table
//---------------------------------------------------------
function add_keyword()
{
// check param
	if ( $this->_check_input( $_POST ) ) 
	{
		return false;
	}

	$flag = true;

	foreach( $this->_list->get_site_list() as $site )
	{
		$obj = $this->_set_insert_vars($site);

		if ( !$this->_handler->insert($obj) ) 
		{
			$this->_set_errors( $this->_handler->getErrors() );
			$flag = false;
		}
	}

	return $flag;
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _print_form($arr, $flag)
{
	$this->_form->show_keyword($arr, $flag);
}

function _set_insert_vars($site)
{
	$key        = $_POST['keyword'];
	$key_conv   = $this->_convert->convert($key, $site['code'], $this->_from);
	$key_encode = urlencode( $key_conv );

	$title   = $site['title'].': '.$key;
	$url     = $site['url']. $key_encode;
	$rss_url = $site['rss']. $key_encode;

	$obj = $this->_handler->create();
	$obj->assignVars( $_POST );
	$obj->setVar('title',    $title );
	$obj->setVar('url',      $url );
	$obj->setVar('encoding', $site['encoding'] );

	if ($site['mode'] == RSSC_C_MODE_RDF)
	{
		$obj->setVar('mode',     RSSC_C_MODE_RDF );
		$obj->setVar('rdf_url',  $rss_url );
	}
	elseif ($site['mode'] == RSSC_C_MODE_ATOM)
	{
		$obj->setVar('mode',     RSSC_C_MODE_ATOM );
		$obj->setVar('atom_url',  $rss_url );
	}
	else
	{
		$obj->setVar('mode',     RSSC_C_MODE_RSS );
		$obj->setVar('rss_url',  $rss_url );
	}

	return $obj;
}

function _check_input($arr)
{
	$this->_clear_errors();

// check fill
	$this->_check_fill($arr['keyword'], _KEYWORD);

	return $this->_error_flag;
}

// --- class end ---
}

?>