<?php
// $Id: archive_manage.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

include 'admin_header.php';

include_once $MODULE_ROOT."/api/refresh.php";
include_once $MODULE_ROOT."/class/rssc_refresh_all_handler.php";
include_once $MODULE_ROOT."/admin/admin_form_class.php";

$link_handler =& rssc_get_handler('link', $DIRNAME);
$feed_handler =& rssc_get_handler('feed', $DIRNAME);
$conf_handler =& rssc_get_handler('config_data', $DIRNAME);
$post =& rssc_post::getInstance();

// --- print start ----
xoops_cp_header();

$conf_data  =& $conf_handler->get_config_data();
$feed_limit =  $conf_data['basic_feed_limit'];

$op     = $post->get_post_get('op');
$limit  = $post->get_post_int('limit');
$offset = $post->get_post_int('offset');
$num    = $post->get_post_int('num', $feed_limit);

if ($limit  < 0)  $limit  = 0;
if ($offset < 0)  $offset = 0;

rssc_admin_print_header();
rssc_admin_print_menu();

$total_link  = $link_handler->getCount();
$total_feed  = $feed_handler->getCount();

echo "<h3>"._AM_RSSC_ARCHIVE_MANAGE."</h3>\n";
printf(_AM_RSSC_THERE_ARE_LINKS, $total_link);
echo "<br />\n";
printf(_AM_RSSC_THERE_ARE_FEEDS, $total_feed);
echo "<br /><br />\n";

if ( ($op == 'refresh')||($op == 'clear_old') )
{
	if( !rssc_admin_check_token() ) 
	{
		xoops_error("Token Error");
		$op = '';	// no action
	}
}

print_form($limit, $offset, $num);

if ($op == 'refresh')
{
	echo "<hr />\n";
	$refresh_handler =& rssc_get_handler('refresh_all', $DIRNAME);
	$refresh_handler->set_feed_limit($feed_limit);
	$refresh_handler->refresh($limit, $offset);

// next
	$total = $link_handler->getCount();
	$next  = $offset + $limit;

	if (($limit > 0) && ($next < $total))
	{
		$form =& admin_form::getInstance();
		$form->show_refresh_next($limit, $next);
	}
}
elseif ($op == 'clear_old')
{
	echo "<hr />\n";
	$del = $feed_handler->clear_old_over_num( $num );
	clear_old($del);
}

echo "<hr />\n";
xoops_cp_footer();
// --- print end ----

exit();
// --- end of main ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function print_form($limit, $offset, $feed_limit)
{
	$form =& admin_form::getInstance();

	echo "<a name='refresh'></a>";
	echo "<h4>"._AM_RSSC_REFRESH."</h4>\n";
	$form->show_refresh($limit, $offset);

	echo "<a name='clear'></a>";
	echo "<h4>"._AM_RSSC_FEED_CLEAR."</h4>\n";
	$form->show_clear_old( $feed_limit );

}

function clear_old($del)
{
	echo "<h4>"._AM_RSSC_FEED_CLEAR_OLD."</h4>\n";

	if ($del == 0)
	{
		echo "<font color='blue'>"._NO_ACTION."</font><br />";
		return;
	}

	$text  = "<br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._AM_RSSC_NUM_FEED_CLEARED."</td>";
	$text .= "<td>$del "._AM_RSSC_NUM_FEEDS."</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

?>