<?php
// $Id: view_rss.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

include 'admin_header.php';

include_once XOOPS_ROOT_PATH.'/class/template.php';

include_once $MODULE_ROOT."/api/refresh.php";
include_once $MODULE_ROOT."/api/view.php";
include_once $MODULE_ROOT."/admin/admin_form_class.php";

$TEMPLATE_RDF  = $MODULE_ROOT.'/templates/xml/rssc_view_rdf.html';
$TEMPLATE_RSS  = $MODULE_ROOT.'/templates/xml/rssc_view_rss.html';
$TEMPLATE_ATOM = $MODULE_ROOT.'/templates/xml/rssc_view_atom.html';

$link_handler =& rssc_get_handler('link', $DIRNAME);
$form =& admin_form::getInstance();
$post =& rssc_post::getInstance();

// === print ===
xoops_cp_header();

$op  = $post->get_post('op');
$lid = $post->get_post_get_int('lid');

rssc_admin_print_header();
rssc_admin_print_menu();

echo "<h3>"._AM_RSSC_VIEW_RSS."</h3>\n";
echo "<a href='#option'>"._AM_RSSC_VIEW_RSS_OPTION."</a><br /><br />\n";

$param = get_param();

if ($lid > 0)
{
	$link =& $link_handler->get($lid);

	if ( is_object($link) )
	{
		if ($op == 'param')
		{
			$param = $_POST;
		}
		else
		{
			$param = get_param($lid);
		}

		list($template, $result_data) = 
			get_result_data($lid, $link, $param);

		display_tpl($template, $result_data);
	}
	else
	{
		echo "<font color='red'>"._NO_RECORD."</font><br />\n";
	}

}
else
{
	echo "<font color='red'>"._AM_RSSC_NOT_SELECT_LINK."</font><br /><br />\n";
	echo _AM_RSSC_PLEASE_SELECT_LINK."<br />\n";
}

echo "<br />\n";
echo "<a name='option'><h4>"._AM_RSSC_VIEW_RSS_OPTION."</h4></a>\n";

$form->show_rss($param);

xoops_cp_footer();
// === print end ===

exit();



//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_param($lid='')
{
	$DIRNAME = rssc_admin_get_dirname();
	$conf_handler =& rssc_get_handler('config_data', $DIRNAME);

	$conf_data =& $conf_handler->get_config_data();

	$title    = '';
	$rdf_url  = '';
	$rss_url  = '';
	$atom_url = '';
	$rss_mode = '';

	if ($lid)
	{
		$link_handler =& rssc_get_handler('link', $DIRNAME);
		$link =& $link_handler->get($lid);

		$title    = $link->getVar('title',    's');
		$rdf_url  = $link->getVar('rdf_url',  's');
		$rss_url  = $link->getVar('rss_url',  's');
		$atom_url = $link->getVar('atom_url', 's');
		$rss_mode = $link->getVar('mode',     's');
	}

	$data = array(
		'lid'      => $lid,
		'title'    => $title,
		'rdf_url'  => $rdf_url,
		'rss_url'  => $rss_url,
		'atom_url' => $atom_url,
		'rss_mode' => $rss_mode,
		'rss_atom'      => $conf_data['basic_rss_atom'],
		'parser_rss'    => $conf_data['basic_parser_rss'],
		'xml_save'      => $conf_data['basic_xml_save'],
		'mode_view'     => 0,
		'feed_perpage'  => 10,
		'sanitize'      => 1,
		'title_html'    => 1,
		'content_html'  => 1,
		'max_title'     => -1,
		'max_content'   => -1,
		'max_summary'   => -1,
		'link_update'   => 1,
		'feed_update'   => 1,
		'force_discover'  => 0,
		'force_update'    => 0,
		'force_overwrite' => 0,
		'print_log'   => 0,
		'print_error' => 1,
	);

	return $data;
}

function get_result_data($lid, &$link, $param)
{
	$DIRNAME = rssc_admin_get_dirname();
	$refresh_handler =& rssc_get_handler('refresh', $DIRNAME);
	$view_handler    =& rssc_get_handler('view', $DIRNAME);

	$link_encoding = $link->getVar('encoding');
	$link_xml      = $link->getVar('xml');

	$error = '';
	$mode     = $param['mode_view'];
	$rss_mode = $param['rss_mode'];

	switch ($rss_mode)
	{
		case RSSC_C_MODE_RDF:
			$xml_url = $link->getVar('rdf_url');
			break;

		case RSSC_C_MODE_RSS:
			$xml_url = $link->getVar('rss_url');
			break;

		case RSSC_C_MODE_ATOM:
		default:
			$xml_url = $link->getVar('atom_url');
			break;
	}

	$refresh_handler->set_debug_parse( 1, $xml_url, $link_encoding, $rss_mode );

	$refresh_handler->setRssParser(          $param['parser_rss'] );
	$refresh_handler->set_link_update(       $param['link_update'] );
	$refresh_handler->set_feed_update(       $param['feed_update'] );
	$refresh_handler->set_link_xml_save(     $param['xml_save'] );
	$refresh_handler->set_force_discover(    $param['force_discover'] );
	$refresh_handler->set_force_refresh(     $param['force_update'] );
	$refresh_handler->set_force_overwrite(   $param['force_overwrite'] );
	$refresh_handler->set_debug_print_log(   $param['print_log'] );
	$refresh_handler->set_debug_print_error( $param['print_error'] );

	$view_handler->setFlagSanitize( $param['sanitize'] );
	$view_handler->setFeedStart( 0 );
	$view_handler->setFeedLimit(   $param['feed_perpage'] );
	$view_handler->setTitleHtml(   $param['title_html'] );
	$view_handler->setContentHtml( $param['content_html'] );
	$view_handler->setMaxTitle(    $param['max_title'] );
	$view_handler->setMaxContent(  $param['max_content'] );
	$view_handler->setMaxSummary(  $param['max_summary'] );

	if ($mode == 1)
	{
		$refresh_handler->convertXml($link_xml, $link_encoding);
		$xml_converted      = $refresh_handler->getXmlConverted();
		$encoding_converted = $refresh_handler->getEncodingConverted();

		if ( !$refresh_handler->parseXml($xml_converted, $encoding_converted, $rss_mode) )
		{
			$error = $refresh_handler->getErrors('s');
		}

		$result_data =& $refresh_handler->getData();
	}
	elseif ($mode == 2)
	{
		if ( !$refresh_handler->refresh($lid) )
		{
			$error = $refresh_handler->getErrors('s');
		}
	}
	else
	{
		$refresh_handler->set_link_update(   0 );
		$refresh_handler->set_feed_update(   0 );
		$refresh_handler->set_force_refresh( 1 );

		if ( !$refresh_handler->refresh($lid) )
		{
			$error = $refresh_handler->getErrors('s');
		}

		$result_data =& $refresh_handler->getData();
	}

	if ( $error )
	{
		echo "<font color='red'>";
		echo "error ".$error."<br />";
		echo "</font>";
	}

	if ($mode == 1)
	{
		$data =& $view_handler->format( $result_data );
		$data =& $view_handler->sanitize( $data );
	}
	elseif ($mode == 2)
	{
		$data = array();
		$data['channel'] =& $view_handler->getChannel($lid);
		$data['image']   =& $view_handler->getImage($lid);
		$data['items']   =& $view_handler->getFeeds($lid);
	}
	else
	{
		$data =& $view_handler->format( $result_data );
		$data =& $view_handler->sanitize( $data );
	}

	global $TEMPLATE_ATOM, $TEMPLATE_RDF, $TEMPLATE_RSS;

	if ($rss_mode == RSSC_C_MODE_ATOM)
	{
		$template = $TEMPLATE_ATOM;
	}
	elseif ($rss_mode == RSSC_C_MODE_RDF)
	{
		$template = $TEMPLATE_RDF;
	}
	else
	{
		$template = $TEMPLATE_RSS;
	}

	return array($template, $data);
}

function display_tpl($template, $result_data)
{
	$tpl = new XoopsTpl();
	$tpl->clear_all_assign();
	$tpl->assign('xoops_url', XOOPS_URL);
	$tpl->assign_by_ref('channel', $result_data['channel'] );
	$tpl->assign_by_ref('image',   $result_data['image'] );

	foreach ($result_data['items'] as $item) 
	{
		$tpl->append('items', $item);
	}

	$tpl->assign(array(
		'lang_site_desc'      => _RSSC_SITE_DESCRIPTION,
		'lang_site_updated'   => _RSSC_SITE_UPDATED,
		'lang_site_date'      => _RSSC_SITE_DATE, 
		'lang_site_webmaster' => _RSSC_SITE_WEBMASTER, 
		'lang_site_language'  => _RSSC_SITE_LANGUAGE, 
		'lang_site_generator' => _RSSC_SITE_GENERATOR, 
		'lang_site_category'  => _RSSC_SITE_CATEGORY, 
		'lang_site_docs'      => _RSSC_RSS_SITE_DOCS, 
		'lang_site_copyright' => _RSSC_RSS_SITE_COPYRIGHT, 
		'lang_site_cloud'     => _RSSC_RSS_SITE_CLOUD, 
		'lang_site_ttl'       => _RSSC_RSS_SITE_TTL, 
		'lang_site_rating'    => _RSSC_RSS_SITE_RATING, 
		'lang_site_textinput' => _RSSC_RSS_SITE_TEXTINPUT, 
		'lang_site_skiphours' => _RSSC_RSS_SITE_SKIPHOURS, 
		'lang_site_skipdays'  => _RSSC_RSS_SITE_SKIPDAYS, 
		'lang_site_rights'    => _RSSC_ATOM_SITE_RIGHTS, 
		'lang_site_source'    => _RSSC_ATOM_SITE_SOURCE,
		'lang_site_subtitle'  => _RSSC_ATOM_SITE_SUBTITLE,
		'lang_site_id'        => _RSSC_ATOM_SITE_ID,
		'lang_site_icon'      => _RSSC_ATOM_SITE_ICON,
		'lang_site_logo'      => _RSSC_ATOM_SITE_LOGO,
		'lang_site_lastbuilddate'  => _RSSC_RSS_SITE_LASTBUILDDATE, 
		'lang_site_pubdate'        => _RSSC_RSS_SITE_PUBDATE, 
		'lang_site_managingeditor' => _RSSC_RSS_SITE_MANAGINGEDITOR, 
		'lang_site_author_name'    => _RSSC_ATOM_SITE_AUTHOR_NAME, 
		'lang_site_author_email'   => _RSSC_ATOM_SITE_AUTHOR_EMAIL, 
		'lang_site_author_uri'     => _RSSC_ATOM_SITE_AUTHOR_URI, 
		'lang_site_contributor'    => _RSSC_ATOM_SITE_CONTRIBUTOR, 
		'lang_site_link_self'      => _RSSC_ATOM_SITE_LINK_SELF, 
		'lang_site_creator'        => _RSSC_DC_CREATOR, 
		'lang_title'     => _RSSC_TITLE, 
		'lang_published' => _RSSC_PUBLISHED, 
		'lang_updated'   => _RSSC_UPDATED, 
		'lang_summary'   => _RSSC_SUMMARY, 
		'lang_category'  => _RSSC_CATEGORY, 
		'lang_rights'    => _RSSC_RIGHTS, 
		'lang_source'    => _RSSC_SOURCE,
		'lang_guid'      => _RSSC_RSS_GUID,
		'lang_pubdate'   => _RSSC_RSS_PUBDATE,
		'lang_author'    => _RSSC_RSS_AUTHOR,
		'lang_comments'  => _RSSC_RSS_COMMENTS,
		'lang_enclosure' => _RSSC_RSS_ENCLOSURE,
		'lang_entry_id'  => _RSSC_ATOM_ID,
		'lang_author_name'  => _RSSC_AUTHOR_NAME, 
		'lang_author_email' => _RSSC_AUTHOR_EMAIL, 
		'lang_author_uri'   => _RSSC_AUTHOR_URI, 
		'lang_contributor'  => _RSSC_ATOM_CONTRIBUTOR, 
		'lang_subject'    => _RSSC_DC_SUBJECT,
		'lang_publisher'  => _RSSC_DC_PUBLISHER,
		'lang_creator'    => _RSSC_DC_CREATOR,
		'lang_date'       => _RSSC_DC_DATE,
		'lang_format'     => _RSSC_DC_FORMAT,
		'lang_relation'   => _RSSC_DC_RELATION,
		'lang_identifier' => _RSSC_DC_IDENTIFIER,
		'lang_coverage'   => _RSSC_DC_COVERAGE,
		'lang_audience'   => _RSSC_DC_AUDIENCE,
		'lang_encoded'    => _RSSC_CONTENT_ENCODED,
		'lang_more'       => _MORE)
	);

	$tpl->display($template);

}

?>