<?php
// $Id: bin_refresh_class.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//=========================================================

class bin_refresh
{
// class Instant
	var $_refresh;
	var $_config;

// constant
	var $_X_MAILER = 'XOOPS rssc';
	var $_TITLE    = 'refresh archive';
	var $_FILE_RESULT = 'refresh_link.html';

// test mode ( access from web )
	var $_flag_print     = 1;
	var $_flag_write     = 0;
	var $_limit          = 10;

// local
	var $_CHARSET;
	var $_MODULE_URL;
	var $_MODULE_ROOT;
	var $_SITE_NAME;
	var $_ADMIN_EMAIL;
	var $_fp;
	var $_url_result;
	var $_file_full_result;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function bin_refresh( $dirname='rssc' )
{
// class Instant
	$this->_refresh =& rssc_get_handler( 'refresh_all', $dirname );
	$this->_config  =& rssc_get_handler( 'config_data', $dirname );

	$this->_MODULE_ROOT = XOOPS_ROOT_PATH.'/modules/'.$dirname;
	$this->_MODULE_URL  = XOOPS_URL.'/modules/'.$dirname;

	$this->_file_full_result = $this->_MODULE_ROOT.'/cache/'.$this->_FILE_RESULT;
	$this->_url_result       = $this->_MODULE_URL. '/cache/'.$this->_FILE_RESULT;

// system parameter
	global $xoopsConfig;
	$this->_SITE_NAME   = $xoopsConfig['sitename'];
	$this->_ADMIN_EMAIL = $xoopsConfig['adminmail'];

	$this->_CHARSET = _CHARSET;

}

//=========================================================
// public
//=========================================================
function refresh()
{
	$conf_data  =& $this->_config->get_config_data();
	$feed_limit =  $conf_data['basic_feed_limit'];
	$pass       =  $conf_data['bin_pass'];
	$mailto     =  $conf_data['bin_mailto'];
	$flag_send  =  $conf_data['bin_send'];

	if ( !$this->_set_env_param($pass) )
	{
		return false;
	}

	$this->_refresh->set_feed_limit($feed_limit);
	$this->_refresh->set_flag_print($this->_flag_print);

// --- file open ---
	$this->_file_open( $this->_file_full_result );

	if ($this->_flag_write && $this->_fp)
	{
		$this->_refresh->set_fp($this->_fp);
	}

	$this->_html_header();

	$this->_refresh->refresh($this->_limit);

	$this->_html_footer();
	$this->_file_close();
// --- file close ---

	if ($flag_send)
	{
		$total       = $this->_refresh->get_total();
		$num_broken  = $this->_refresh->get_count_broken();
		$num_feed    = $this->_refresh->get_count_feed();

// mail
		$text = <<<END_OF_TEXT
total  links:  $total
broken links:  $num_broken
refresh feeds: $num_feed
END_OF_TEXT;

		$this->_send_mail($mailto, $text);
	}

	return true;
}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// web_param
//---------------------------------------------------------
function _set_env_param($pass)
{

// web
	if ( isset($_SERVER['REQUEST_METHOD']) )
	{
		if ( !isset($_GET['pass']) )
		{
			echo "no action <br />\n";
			return false;
		}

		if ( $_GET['pass'] != $pass )
		{
			echo "no action <br />\n";
			return false;
		}

		if ( isset($_GET['limit']) )
		{
			$this->_limit = $_GET['limit'];
		}
	}

// command line
	else
	{
		$this->_flag_print = 0;
		$this->_flag_write = 1;
		$this->_limit      = 10;

		if ( !isset( $_SERVER['argv'][1] ) )
		{
			return false;
		}

		if ( $_SERVER['argv'][1] != $pass )
		{
			return false;
		}

	}

	return true;
}

//---------------------------------------------------------
// html header & footer
//---------------------------------------------------------
function _html_header()
{
	$text = <<<END_OF_TEXT
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=$this->_CHARSET">
<title> $this->_TITLE </title>
</head><body>
<h3> $this->_TITLE </h3>
<hr>
END_OF_TEXT;

	$this->_print_write_data($text);
}

function _html_footer()
{
	$url_index = $this->_MODULE_URL.'/admin/index.php';
	$index = 'goto admin index';

	$text = <<<END_OF_TEXT
<br />
<hr>
<a href='$url_index'>$index</a><br />
</head></html>
END_OF_TEXT;

	$this->_print_write_data($text);
}

//---------------------------------------------------------
// result file
//---------------------------------------------------------
function _file_open($filename)
{
	if ($this->_flag_write)
	{
		$this->_fp = fopen($filename, 'w');
	}
}

function _file_close()
{
	if ($this->_flag_write && $this->_fp)
	{
		fclose($this->_fp);
	}
}

function _print_write_data($data)
{
	if ($this->_flag_print)
	{
		echo $data;
	}

	if ($this->_flag_write)
	{
		fwrite($this->_fp, $data);
	}
}

//---------------------------------------------------------
// mail
//---------------------------------------------------------
function _send_mail($mailto, $content)
{
	$subject = "[$this->_SITE_NAME] $this->_TITLE";
	$body    = $this->_build_mail_body($this->_TITLE, $content);

	$header  = "From: $this->_ADMIN_EMAIL \n";
	$header .= "X-Mailer: $this->_X_MAILER \n"; 

	return $this->_mb_send_mail($mailto, $subject, $body, $header);
}

function _build_mail_body($title, $body)
{
	$siteurl = XOOPS_URL.'/';

	$text = <<<END_OF_TEXT
$title

$body

You can view detail here:
$this->_url_result

-----------
$this->_SITE_NAME ( $siteurl )
webmaster
$this->_ADMIN_EMAIL
-----------
END_OF_TEXT;

	return $text;
}

function _mb_send_mail($mailto, $subject, $body, $header)
{
	if ( function_exists('mb_send_mail') )
	{
		return mb_send_mail($mailto, $subject, $body, $header);
	}
	else
	{
		return mail($mailto, $subject, $body, $header);
	}
}

// --- class end ---
}

?>