<?php
// $Id: block_latest.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// --- block function begin ---
if( !function_exists( 'b_rssc_show_latest' ) ) 
{

//---------------------------------------------------------
// show latest feeds
//---------------------------------------------------------
function b_rssc_show_latest( $options )
{
	global $xoopsDB;

	$dirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_feed = $xoopsDB->prefix( $dirname.'_feed' );

	$block = array();
	$block['lang_more']  = _BL_RSSC_MORE;
	$block['module_url'] = XOOPS_URL.'/modules/'.$dirname;

// config data
	$conf_data = b_rssc_get_conf( $dirname );
	if ( !$conf_data )
	{
		return $block;
	}

	$limit       = $conf_data['block_latest_perpage'];
	$max_title   = $conf_data['block_latest_max_title'];
	$max_summary = $conf_data['block_latest_max_summary'];
	$order  = b_rssc_get_order(  $conf_data['block_latest_order'] );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

// feed data
	$sql  = 'SELECT * FROM '.$table_feed;
	$sql .= ' WHERE updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;
	$sql .= ' ORDER BY '.$order;

	$res = $xoopsDB->query($sql, $limit, 0);
	if ( !$res )
	{
		return $block;
	}

	$feeds = array();

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$feeds[] = b_rssc_make_feed($row, $max_title, $max_summary);
	}

	$block['feeds'] = $feeds;

	return $block;
}

//---------------------------------------------------------
// show headline
//---------------------------------------------------------
function b_rssc_show_headline( $options )
{
	global $xoopsDB;

	$dirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_link   = $xoopsDB->prefix( $dirname.'_link' );
	$table_feed   = $xoopsDB->prefix( $dirname.'_feed' );

	$block = array();
	$block['lang_more']  = _BL_RSSC_MORE;
	$block['module_url'] = XOOPS_URL.'/modules/'.$dirname;

// config data
	$conf_data = b_rssc_get_conf( $dirname );
	if ( !$conf_data )
	{
		return $block;
	}

	$link_limit  = $conf_data['block_headline_links_perpage'];
	$limit       = $conf_data['block_headline_feeds_perlink'];
	$max_title   = $conf_data['block_headline_max_title'];
	$max_summary = $conf_data['block_headline_max_summary'];
	$order  = b_rssc_get_order(  $conf_data['block_headline_order'] );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

// link data
	$sql1 = 'SELECT * FROM '.$table_link.' WHERE headline > 0 ORDER BY headline ASC';

	$res1 = $xoopsDB->query($sql1, $link_limit, 0);
	if ( !$res1 )
	{
		return  $block;
	}

	$links = array();

	while ($row1 = $xoopsDB->fetchArray($res1)) 
	{
		$lid   = $row1['lid'];
		$title = $row1['title'];
		$url   = $row1['url'];

		$lid   = intval($lid);
		$url   = preg_replace('/&amp;/i', '&', $url);
		$url   = htmlspecialchars($url,    ENT_QUOTES);
		$title = htmlspecialchars($title,  ENT_QUOTES);
		$title = preg_replace('/&amp;/i', '&', $title);

		$link = array();
		$link['url']   = $url;
		$link['title'] = $title;

// feed data
		$sql2  = 'SELECT * FROM '.$table_feed;
		$sql2 .= ' WHERE lid='.$lid;
		$sql2 .= ' AND updated_unix <'.  $future;
		$sql2 .= ' AND published_unix <'.$future;
		$sql2 .= ' ORDER BY '.$order;

		$res2 = $xoopsDB->query($sql2, $limit, 0);
		$feeds = array();

		while ($row2 = $xoopsDB->fetchArray($res2)) 
		{
			$feeds[] = b_rssc_make_feed($row2, $max_title, $max_summary);
		}

		$link['feeds'] = $feeds;
		$links[] = $link;
	}

	$block['links'] = $links;

	return $block;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function b_rssc_get_conf( $dirname='rssc' )
{
	global $xoopsDB;
	$table_config = $xoopsDB->prefix( $dirname.'_config' );

// config data
	$conf = array();

	$sql = 'SELECT * FROM '.$table_config.' ORDER BY conf_id ASC';

	$res = $xoopsDB->query($sql, 0, 0);
	if ( !$res )
	{
		return false;
	}

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$conf[ $row['conf_name'] ] = $row['conf_value'];
	}

	return $conf;
}

function b_rssc_get_future($value)
{
	$time = time() + 86400 * intval($value);	// days
	return $time;
}

function b_rssc_get_order($value)
{
	switch ( $value )
	{
		case 1:
			$order = 'published_unix DESC, fid DESC';
			break;

		case 0:
		default:
			$order = 'updated_unix DESC, fid DESC';
			break;
	}

	return $order;
}

function b_rssc_make_feed($row, $max_title, $max_summary)
{
	$title = $row['title'];
	$link  = $row['link'];
	$content      = $row['content'];
	$updated_unix = $row['updated_unix'];

	$title   = strip_tags( $title );
	$title   = b_rssc_shoten_text($title, $max_title);

	$summary = str_replace(">",   "> ", $content);
	$summary = strip_tags( $summary );
	$summary = b_rssc_shoten_text($summary, $max_summary);

	$updated_l = formatTimestamp( $updated_unix, 'mysql' );
	$updated_s = formatTimestamp( $updated_unix, 's' );

	$link    = preg_replace('/&amp;/i', '&', $link);
	$link    = htmlspecialchars($link,    ENT_QUOTES);
	$title   = htmlspecialchars($title,   ENT_QUOTES);
	$title   = preg_replace('/&amp;/i', '&', $title);
	$summary = htmlspecialchars($summary, ENT_QUOTES);
	$summary = preg_replace('/&amp;/i', '&', $summary);

	$feed = array();
	$feed['link']    = $link;
	$feed['title']   = $title;
	$feed['summary'] = $summary;
	$feed['updated_l'] = $updated_l;
	$feed['updated_s'] = $updated_s;

	return $feed;
}

function b_rssc_shoten_text($text, $max)
{
// nothing, if zero
	if ($max == 0)
	{
		return '';
	}

// unlimited, if minus
	if ($max < 0)
	{
		return $text;
	}

// less than
	if ( strlen($text) <= $max)
	{
		return $text;
	}

// for multibyte environment
	if (function_exists('mb_strcut'))
	{
	// cut strings for multibayte byte length
		$text = mb_strcut( $text, 0, $max )." ...";
	}
	else
	{
		$text = substr( $text, 0, $max )." ...";
	}

	return $text;
}

// --- block function begin end ---
}

?>