<?php
// $Id: block_refresh.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// --- block function begin ---
if( !function_exists( 'b_rssc_show_refresh' ) ) 
{

$rssc_dirname = basename( dirname( dirname( __FILE__ ) ) );
include_once XOOPS_ROOT_PATH.'/modules/'.$rssc_dirname.'/api/block.php';

//---------------------------------------------------------
// show headline after refresh
//---------------------------------------------------------
function b_rssc_show_refresh( $options )
{
	$dirname = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$refresh_handler =& rssc_get_handler('refresh', $dirname);
	$view_handler    =& rssc_get_handler('view',    $dirname);
	$conf_handler    =& rssc_get_handler('config_data', $dirname);

	$conf_data =& $conf_handler->get_config_data();

	$link_limit = 10;
	$link_start =  0;

	$refresh_handler->refreshHeadline($link_limit, $link_start);

	$view_handler->setFeedStart(   0 );
	$view_handler->setTitleHtml(   0 );
	$view_handler->setContentHtml( 0 );
	$view_handler->setMaxContent(  0 );
	$view_handler->setFeedLimit(  $conf_data['block_headline_feeds_perlink'] );
	$view_handler->setFeedOrder(  $conf_data['block_headline_order'] );
	$view_handler->setMaxTitle(   $conf_data['block_headline_max_title'] );
	$view_handler->setMaxSummary( $conf_data['block_headline_max_summary'] );

	$block = array();
	$block['lang_more']  = _BL_RSSC_MORE;
	$block['module_url'] = XOOPS_URL.'/modules/'.$dirname;
	$block['links']      =& $view_handler->getHeadlineLinksFeeds($link_limit, $link_start);

	return $block;
}

// --- block function begin ---
}

?>