<?php
// $Id: rssc_atom_parser.php,v 1.1.1.1 2006/01/03 05:06:01 ohwada Exp $

//=========================================================
// Rss Center Module
// class for ATOM Parser 
// for PHP gennerally
// this file contain 1 xml parser & 3 class
//   rssc_atom_xml_xxx
//   rssc_atom_parser
//   rssc_atom_parser_channel
//   rssc_atom_parser_entry
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_atom_parser') ) 
{

//=========================================================
// xml handler
//=========================================================
// The Atom Syndication Format 0.3
// http://www.mnot.net/drafts/draft-nottingham-atom-format-02.html

// Dublin Core Metadata Element Set
// http://dublincore.org/documents/dces/

//---------------------------------------------------------
// global function
//---------------------------------------------------------
//  $rssc_atom_xml_feed
//  $rssc_atom_xml_entrys
//  $rssc_atom_xml_entry_num
//  $rssc_atom_xml_parent
//  $rssc_atom_xml_parent_num
//  $rssc_atom_xml_uris

//---------------------------------------------------------
// start element handler
//---------------------------------------------------------
function rssc_atom_xml_start_element($parser, $name, $attrs)
{
	global $rssc_atom_xml_parent, $rssc_atom_xml_parent_num, $rssc_atom_xml_uris;
	global $rssc_atom_xml_feed, $rssc_atom_xml_entrys, $rssc_atom_xml_entry_num;

//  echo "<br>\n";
//  echo "parent:  $rssc_atom_xml_parent <br>\n";
//  echo "current: $rssc_atom_xml_current <br>\n";
//  echo "name:    $name <br>\n";
//  print_r($attrs);
//  echo "<br>\n";

	$parent = $rssc_atom_xml_parent[$rssc_atom_xml_parent_num];

	$parent_num_prev = $rssc_atom_xml_parent_num - 1;
	if ($parent_num_prev < 0)  $parent_num_prev = 0;
	$parent_prev = $rssc_atom_xml_parent[$parent_num_prev];

	$name_ns = split(':',$name);
	$name_wk = array_pop($name_ns);
	$uri1 = implode($name_ns,":");

	$name_low = strtolower( $name_wk );

	$flag = 0;
	foreach($rssc_atom_xml_uris as $uri2)
	{
  		if ($uri1 == $uri2)
  		{
    		$flag = 1;
    		break;
  		}
	}

// FEED
	if ( $name_wk == 'FEED' )
	{
		$rssc_atom_xml_parent_num = 0;
		$rssc_atom_xml_parent[0]  = $name_wk;
		return;
	}

// CONTENT
	if (($parent_prev == 'ENTRY')&&($parent == 'CONTENT'))
	{
		$data = '';

  		if (($name_wk == 'P')||($name_wk == 'BR'))
  		{
			$data .= "<br>\n";
  		}
  		elseif ($name_wk == 'A')
  		{
	  		$href   = '';
	  		$target = '';
  			if ( isset($attrs['HREF']) )    $href   = $attrs['HREF'];
			if ( isset($attrs['TARGET']) )  $target = "target=\"{$attrs['TARGET']}\" ";

			$data .= "<a href=\"$href\" $target >";

  		}
  		elseif ($name_wk == 'IMG')
  		{
			$src    = '';
			$width  = '';
			$height = '';
			$border = 0;
			if ( isset($attrs['SRC']) )     $src    = $attrs['SRC'];
			if ( isset($attrs['BORDER']) )  $border = $attrs['BORDER'];
			if ( isset($attrs['WIDTH']) )   $width  = "width=\"{$attrs['WIDTH']}\" ";
			if ( isset($attrs['HEIGHT']) )  $height = "hight=\"{$attrs['HEIGHT']}\" ";

			$data .= "<img src=\"$src\" border=\"$border\" $width $height >";
  		}

		$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num]['content'] .= $data;
		return;
	}

// LINK
	if ( $name_wk == 'LINK' )
	{
  		$rel  = '';
  		$href = '';
  		if ( isset($attrs['REL']) )   $rel  = $attrs['REL'];
  		if ( isset($attrs['HREF']) )  $href = $attrs['HREF'];

		$rel = strtolower($rel);

		if ( $parent == 'FEED' )
		{
    		$rssc_atom_xml_feed[$name_low.'_'.$rel] = $href;
		}
		elseif (($parent == 'ENTRY') && ($rel == 'alternate'))
		{
			$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$name_low] = $href;
		}
	}

// CATEGORY
	if ( $name_wk == 'CATEGORY' )
	{
  		$term = '';
  		if ( isset($attrs['TERM']) )  $term = $attrs['TERM'];

		if ( $parent == 'FEED' )
		{
    		$rssc_atom_xml_feed[$name_low] = $term;
		}
		elseif ( $parent == 'ENTRY' ) 
		{
   			$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$name_low] = $term;
		}
	}

// increment parent
	if ( $flag || empty($uri1) )
	{
		$rssc_atom_xml_parent_num ++;
		$rssc_atom_xml_parent[$rssc_atom_xml_parent_num] = $name_wk;
	}

}

//---------------------------------------------------------
// end element handler
//---------------------------------------------------------
function rssc_atom_xml_end_element($parser, $name)
{
	global $rssc_atom_xml_parent, $rssc_atom_xml_parent_num, $rssc_atom_xml_entry_num, $rssc_atom_xml_entrys, $rssc_atom_xml_uris;

	$parent = $rssc_atom_xml_parent[$rssc_atom_xml_parent_num];

	$parent_num_prev = $rssc_atom_xml_parent_num - 1;
	if ($parent_num_prev < 0)  $parent_num_prev = 0;
	$parent_prev = $rssc_atom_xml_parent[$parent_num_prev];

	$name_ns = split(':',$name);
	$name_wk = array_pop($name_ns);
	$uri1 = implode($name_ns,":");

//	echo "<br>\n";
//	echo "parent num : $rssc_atom_xml_parent_num <br>\n";
//	echo "parent prev: $parent_prev <br>\n";
//	echo "parent  :    $parent <br>\n";
//	echo "current :    $name_wk <br>\n";

	$flag = 0;
	foreach($rssc_atom_xml_uris as $uri2)
	{
  		if ($uri1 == $uri2)
  		{
			$flag = 1;
    		break;
  		}
	}

// CONTENT
	if (($parent_prev == 'ENTRY')&&($parent == 'CONTENT'))
	{
  		if ($name_wk == 'A')
  		{
			$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num]['content'] .= "</a>";
  		}

  		if ($name_wk != 'CONTENT')
		{
  			return;
  		}
  	}

// decrement parent
	if (( $flag || empty($uri1) )&&( $parent == $name_wk ))
	{
		$rssc_atom_xml_parent_num --;
		if ($rssc_atom_xml_parent_num < 0)  $rssc_atom_xml_parent_num = 0;

      	if ($name_wk == 'ENTRY')
      	{
      		$rssc_atom_xml_entry_num ++;
      	}
	}

}

//---------------------------------------------------------
// character data handler
//---------------------------------------------------------
function rssc_atom_xml_character_data($parser, $data) 
{
	global $rssc_atom_xml_parent, $rssc_atom_xml_parent_num, $rssc_atom_xml_feed, $rssc_atom_xml_entrys, $rssc_atom_xml_entry_num;

	$parent_0 = '';
	$parent_1 = '';
	$parent_2 = '';
	if ( isset($rssc_atom_xml_parent[0]) )	$parent_0 = $rssc_atom_xml_parent[0];
	if ( isset($rssc_atom_xml_parent[1]) )	$parent_1 = $rssc_atom_xml_parent[1];
	if ( isset($rssc_atom_xml_parent[2]) )	$parent_2 = $rssc_atom_xml_parent[2];

	$current     = $rssc_atom_xml_parent[$rssc_atom_xml_parent_num];
	$current_low = strtolower( $current );

// data part may be divided including a space. 
//	$data        = trim($data);

//	echo "<br>\n";
//	echo "parent num: $rssc_atom_xml_parent_num <br>\n";
//	echo "parent 0:   $parent_0 <br>\n";
//	echo "parent 1:   $parent_1 <br>\n";
//	echo "parent 2:   $parent_2 <br>\n";
//	echo "current :   $current <br>\n";
//	echo "data:       $data <br>\n";
//	print_r($rssc_atom_xml_entrys);
//	echo "<hr>\n";

	if ($parent_0 != 'FEED')  return;

	switch($parent_1)
	{
// ENTRY
		case 'ENTRY':
    		switch($parent_2)
    		{

// ENTRY AUTHOR
				case 'AUTHOR':
    				switch($current)
    				{
    					case 'NAME':
    					case 'URL':
    // atom 1.0
       					case 'URI':
    // atom 0.3
       					case 'URL':
    						$key = 'author_'.$current_low;
     						if ( isset( $rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$key] ) )
     						{
     							$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$key] .= $data;
     						}
     						else
     						{
     							$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$key] = $data;
      						}
      						break;
      				}
					break;

// ENTRY others
				default:
					switch($current)
					{
    					case 'TITLE':
    					case 'SUMMARY':
    					case 'SUBJECT':
    					case 'ID':
    					case 'CONTENT':
    // atom 1.0
    					case 'UPDATED';
    					case 'PUBLISHED';
    					case 'CATEGORY':
    					case 'RIGHTS':
        	 			case 'SOURCE':
    // atom 0.3
    					case 'MODIFIED';
    					case 'ISSUED';
    					case 'CREATED';
//						case 'LINK':	// see rssc_atom_xml_start_element()

// dc:xxx
						case 'CREATOR':
						case 'DESCRIPTION':
						case 'DATE':
						case 'TYPE':
						case 'FORMAT':
						case 'IDENTIFIER':
						case 'LANGUAGE':
						case 'RELATION':
						case 'COVERAGE':
						case 'CONTRIBUTOR':

     						if ( isset( $rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$current_low] ) )
     						{
     							$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$current_low] .= $data;
     						}
     						else
     						{
     							$rssc_atom_xml_entrys[$rssc_atom_xml_entry_num][$current_low] = $data;
      						}
      						break;
      				}
					break;
			}
			break;

// FEED AUTHOR
		case 'AUTHOR':
    		switch($current)
    		{
    			case 'NAME':
    			case 'EMAIL':
    // atom 1.0
       			case 'URI':
    // atom 0.3
       			case 'URL':
    				$key = 'author_'.$current_low;
    			    if ( isset( $rssc_atom_xml_feed[$key] ) )
     				{
     					$rssc_atom_xml_feed[$key] .= $data;
     				}
     				else
     				{
     					$rssc_atom_xml_feed[$key] = $data;
      				}
      				break;
      		}
      		break;

// FEED others
		default:
			switch($current)
			{
    			case 'TITLE':
    			case 'ID':
    			case 'GENERATOR':
    // atom 1.0
    			case 'RIGHTS':
    			case 'UPDATED';
    			case 'SUBTITLE':
    			case 'CATEGORY':
    			case 'ICON':
    			case 'LOGO':
     			case 'SOURCE':
    // atom 0.3
	   			case 'COPYRIGHT':
    			case 'MODIFIED';
    			case 'TAGLINE':
    			case 'INFO':
//				case 'LINK':	// see rssc_atom_xml_start_element()

// dc:xxx
				case 'CREATOR':
				case 'SUBJECT':
				case 'DESCRIPTION':
				case 'PUBLISHER':
				case 'DATE':
				case 'TYPE':
				case 'FORMAT':
				case 'IDENTIFIER':
				case 'SOURCE':
				case 'LANGUAGE':
				case 'RELATION':
				case 'COVERAGE':
				case 'CONTRIBUTOR':

					if ( isset( $rssc_atom_xml_feed[$current_low] ) )
					{
						$rssc_atom_xml_feed[$current_low] .= $data;
					}
					else
					{
						$rssc_atom_xml_feed[$current_low] = $data;
					}
					break;
			}
			break;
	}

}

//---------------------------------------------------------
// start namespace handler
//---------------------------------------------------------
function rssc_atom_xml_ns_start($parser, $prefix, $uri)
{
	global $rssc_atom_xml_uris;
//	echo "nss;$prefix;$uri <br>\n";
	array_push($rssc_atom_xml_uris, strtoupper($uri));
}

//---------------------------------------------------------
// end namespace handler
//---------------------------------------------------------
function rssc_atom_xml_ns_end($parser, $prefix)
{
	global $rssc_atom_xml_uris;
	array_pop($rssc_atom_xml_uris);
}

//=========================================================
// class rssc_atom_parser
//=========================================================
class rssc_atom_parser extends rssc_parser_base
{
	var $parse_error;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_atom_parser()
{
	$this->rssc_parser_base();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_atom_parser();
	}

	return $instance;
}

//---------------------------------------------------------
// get_feed
//---------------------------------------------------------
function get_feed()
{
	global $rssc_atom_xml_feed;

	$atom_feed =& $this->create_feed();
	$atom_feed->set_var_array( $rssc_atom_xml_feed );
	$feed = $atom_feed->get_feed();

	return $feed;
}

//---------------------------------------------------------
// get_entrys
//---------------------------------------------------------
function get_entrys()
{
	global $rssc_atom_xml_entrys;

	$i = 0;
	$arr = array();

	foreach ($rssc_atom_xml_entrys as $entry)
	{
		$atom_entry =& $this->create_entry();
		$atom_entry->set_var_array( $entry );
		$arr[] = $atom_entry->get_entry();
	}

	return $arr;
}

//---------------------------------------------------------
// get_parse_error
//---------------------------------------------------------
function get_parse_error()
{
  return $this->parse_error;
}

//---------------------------------------------------------
// parse
//---------------------------------------------------------
function parse($data)
{
	global $rssc_atom_xml_entry_num,$rssc_atom_xml_parent_num,$rssc_atom_xml_parent,$rssc_atom_xml_feed,$rssc_atom_xml_entrys,$rssc_atom_xml_uris;

// global
	$rssc_atom_xml_feed       = array();
	$rssc_atom_xml_entrys     = array();
	$rssc_atom_xml_entry_num  = 0;
	$rssc_atom_xml_parent     = array();
	$rssc_atom_xml_parent[0]  = '';
	$rssc_atom_xml_parent_num = 0;
	$rssc_atom_xml_uris       = array();

	$this->parse_error = '';

	$xml_parser = xml_parser_create_ns( $this->_encoding );
	xml_set_element_handler($xml_parser, "rssc_atom_xml_start_element", "rssc_atom_xml_end_element");
	xml_set_character_data_handler($xml_parser, "rssc_atom_xml_character_data");
	xml_set_start_namespace_decl_handler($xml_parser, "rssc_atom_xml_ns_start");
	xml_set_end_namespace_decl_handler($xml_parser, "rssc_atom_xml_ns_end");

	if (!xml_parse($xml_parser, $data, sizeof($data)))
	{
		$line  = xml_get_current_line_number($xml_parser);
		$error = xml_error_string(xml_get_error_code($xml_parser));

		if ($line == 1)
		{
			$this->parse_error = 'XML error at line 1, check URL';
		}
		else
		{
			$this->parse_error = sprintf('XML error: %s at line %d', $error, $line );
		}

		xml_parser_free($xml_parser);
		return false;
	}

	xml_parser_free($xml_parser);

	return true;
}


//=========================================================
// output option
//=========================================================
function &create_feed()
{
	return new rssc_atom_parser_feed();
}

function &create_entry()
{
	return new rssc_atom_parser_entry();
}

// --- class end ---
}

//=========================================================
// class atom channel
//=========================================================
class rssc_atom_parser_feed extends rssc_parser_element_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_atom_parser_feed()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_atom_parser_feed();
	}

	return $instance;
}

//---------------------------------------------------------
// get feed
//---------------------------------------------------------
function get_feed()
{
	$arr = $this->_data_arr;
	$arr['link']       = $this->get_atom_link( $this->_data_arr );
	$arr['author_uri'] = $this->get_atom_author_uri( $this->_data_arr );
	$arr['updated']    = $this->get_atom_updated(    $this->_data_arr );
	$arr['published']  = $this->get_atom_published(  $this->_data_arr );
	$arr['updated_unix']   = $this->get_unixtime_w3cdtf( $arr['updated'] );
	$arr['published_unix'] = $this->get_unixtime_w3cdtf( $arr['published'] );

	return $arr;
}

function get_atom_link($data)
{
	if ( isset($data['link']) )
	{
		return $data['link'];
	}
	elseif ( isset($data['link_alternate']) )
	{
		return $data['link_alternate'];
	}

	return false;
}

// --- class end ---
}


//=========================================================
// class atom entry
//=========================================================
class rssc_atom_parser_entry extends rssc_parser_element_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_atom_parser_entry()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_atom_parser_entry();
	}

	return $instance;
}

//---------------------------------------------------------
// get entry
//---------------------------------------------------------
function get_entry()
{
	$arr = $this->_data_arr;
	$arr['entry_id']   = $arr['id'];
	$arr['content']    = $this->get_atom_content( $this->_data_arr );
	$arr['author_uri'] = $this->get_atom_author_uri( $this->_data_arr );
	$arr['updated']    = $this->get_atom_updated(    $this->_data_arr );
	$arr['published']  = $this->get_atom_published(  $this->_data_arr );
	$arr['updated_unix']   = $this->get_unixtime_w3cdtf( $arr['updated'] );
	$arr['published_unix'] = $this->get_unixtime_w3cdtf( $arr['published'] );

	return $arr;
}

//---------------------------------------------------------
// get_content
//---------------------------------------------------------
function get_atom_content($data)
{
	if ( isset($data['content']) )
	{
		return $data['content'];
	}
	elseif ( isset($data['summary']) )
	{
		return $data['summary'];
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>