<?php
// $Id: rssc_build_base.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_build_base') ) 
{

//=========================================================
// class builder base
//=========================================================
class rssc_build_base
{
// constant
	var $MODULE_ID_DEFUALT = 1;
	var $HEADER   = 'Content-Type:text/xml; charset=utf-8';
	var $RSS_DOCS = 'http://backend.userland.com/rss/';

	var $FLAG_XML_UNDO_XOOPS_CHAR = 1;	// undo XOOPS htmlSpcialChars
	var $FLAG_XML_STRIP_CONTROL   = 1;
	var $FLAG_XML_STRIP_CRLF      = 1;
	var $FLAG_XML_STRIP_STYLE     = 1;
	var $FLAG_XML_STRIP_SPACE     = 1;
	var $FLAG_UTF8_STRIP_CONTROL  = 1;

	var $_max_summary = 100;

// class instance
	var $_strings;
	var $_convert;
	var $_build;

// set param
	var $_channel = array();
	var $_items   = array();
	var $_template;
	var $_title;
	var $_cache_time = 0;	// no cache
	var $_flag_force_build = 0;
	var $_view_goto_title = 'goto index';
	var $_view_goto_url;

// local variable
	var $_config_data;
	var $_count_line = 1;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_build_base()
{
// class instance
	$this->_strings =& rssc_strings::getInstance();
	$this->_convert =& rssc_convert::getInstance();

// dir name
	$dirname = basename( dirname( dirname( __FILE__ ) ) );
	$this->_view_goto_url = XOOPS_URL.'/modules/'.$dirname.'/admin/index.php';

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_build_base();
	}

	return $instance;
}


//=========================================================
// public
//=========================================================
function build()
{
// no output encode
	if (function_exists('mb_http_output')) 
	{
		mb_http_output('pass');
	}

	header($this->HEADER);

	$tpl = new XoopsTpl();

// use cache
	if ( !$this->_flag_force_build && ($this->_cache_time > 0) )
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($this->_cache_time);
	}

// always build
	if ( $this->_flag_force_build || !$tpl->is_cached($this->_template) || ($this->_cache_time == 0) ) 
	{
		$this->assign( $tpl );
	}

	$tpl->display($this->_template);
}

function view()
{
	header ('Content-Type:text/html; charset=utf-8');

	if ( empty($this->_template) )
	{
		echo "<font color='red'>No Template</font><br />\n";
		return;
	}

	$tpl = new XoopsTpl();

	$this->assign( $tpl );

	$xml  = $tpl->fetch($this->_template);
	$body = $this->_strings->sanitize_html_textarea( $xml );

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title><?php echo $this->_title; ?></title>
</head>
<body>
<h3><?php echo $this->_title; ?></h3>
This is debug mode <br /> <br />
<hr />
<pre>
<?php echo $body; ?>
</pre>
<hr />
<a href="<?php echo $this->_view_goto_url; ?>"><?php echo $this->_view_goto_title; ?></a>
</body>
</html>
<?php

}

function clear()
{
	$tpl = new XoopsTpl();
	$tpl->clear_cache($this->_template);
}

// --------------------------------------------------------
// set param
// --------------------------------------------------------
function set_template($value)
{
	$this->_template = $value;
}

function set_title($value)
{
	$this->_title = $value;
}

function set_cache_time($value)
{
	$this->_cache_time = intval($value);
}

function set_channel($value)
{
	$this->_channel = $value;
}

function set_items($value)
{
	$this->_items = $value;
}

function set_flag_force_build($value)
{
	$this->_flag_force_build = intval($value);
}

function set_view_goto_title($value)
{
	$this->_view_goto_title = $value;
}

function set_view_goto_url($value)
{
	$this->_view_goto_url = $value;
}

//=========================================================
// private
//=========================================================
function _get_site_tag($url)
{
	$parse = parse_url($url);
	if ( isset($parse['host']) )
	{
		return $parse['host'];
	}
	return false;
}

// --------------------------------------------------------
// meke title
// --------------------------------------------------------
function _make_xml_title($feed, $flag_char=1, $flag_numeric=1)
{
	$title = $feed['title'];

	if ($flag_char)
	{
		$title = $this->_strip_html_entity_char( $title );
	}

	if ($flag_numeric)
	{
		$title = $this->_strip_html_entity_numeric($title);
	}

	$title = $this->_xml_htmlspecialchars($title);

	return $title;
}

// --------------------------------------------------------
// meke content
// --------------------------------------------------------
function _make_xml_content($feed, $flag_control=1, $flag_undo=1)
{
	$content = $feed['content'];

	if ($flag_control)
	{
		$content = $this->_strings->strip_control_code($content);
	}

	if ($flag_undo)
	{
		$content = $this->_undo_html_special_chars($content);
	}

// not sanitize
	$cont = $this->_convert_cdata($content);

	return $cont;
}

function _convert_cdata($text)
{
	$text = preg_replace("/]]>/", ']]&gt;', $text);
	return $text;
}

// --------------------------------------------------------
// meke summary
// --------------------------------------------------------
function _make_xml_summary($feed, $flag_char=1, $flag_numeric=1, $flag_control=1, $flag_undo=1, $flag_crlf=1, $flag_style=1, $flag_space=1)
{
	$sum = $feed['content'];

	if ($flag_char)
	{
		$sum = $this->_strip_html_entity_char($sum);
	}

	if ($flag_numeric)
	{
		$sum = $this->_strip_html_entity_numeric($sum);
	}

	if ($flag_control)
	{
		$sum = $this->_strings->strip_control_code($sum);
	}

	if ($flag_undo)
	{
		$sum = $this->_undo_html_special_chars($sum);
	}

	if ($flag_crlf)
	{
		$sum = $this->_strings->strip_crlf($sum);
	}

	if ($flag_style)
	{
		$sum = $this->_strings->strip_style_tag($sum);
	}

	$sum = strip_tags($sum);

	if ($flag_space)
	{
		$sum = $this->_strings->strip_space($sum);
	}

	$sum = $this->_strings->shorten_text($sum, $this->_max_summary );
	$sum = $this->_xml_htmlspecialchars($sum);

	return $sum;
}

// --------------------------------------------------------
// htmlspecialchars
// http://www.w3.org/TR/REC-xml/#dt-markup
// http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#dt-markup
//   &  -> &amp;	// without html entity
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &apos;
// --------------------------------------------------------
function _xml($text)
{
	return $this->_xml_htmlspecialchars_strict($text);
}

function _xml_url($text)
{
	return $this->_xml_htmlspecialchars_url($text);
}

function _xml_htmlspecialchars($text)
{
	$text = htmlspecialchars($text);
	$text = preg_replace("/'/", '&apos;', $text);
	return $text;
}

function _xml_htmlspecialchars_strict($text)
{
	$text = $this->_strip_html_entity_char($text);
	$text = $this->_xml_htmlspecialchars($text);
	return $text;
}

function _xml_htmlspecialchars_url($text)
{
	$text = preg_replace("/&amp;/sU", '&', $text);
	$text = $this->_strip_html_entity_char($text);
	$text = $this->_xml_htmlspecialchars($text);
	return $text;
}

// --------------------------------------------------------
// undo XOOPS HtmlSpecialChars
//   &lt;   -> <
//   &gt;   -> >
//   &quot; -> "
//   &#039; -> '
//   &amp;  -> &
//   &amp;nbsp; -> &nbsp;
// --------------------------------------------------------
function _undo_html_special_chars($text)
{
	$text = preg_replace("/&gt;/i",   '>', $text);
	$text = preg_replace("/&lt;/i",   '<', $text);
	$text = preg_replace("/&quot;/i", '"', $text);
	$text = preg_replace("/&#039;/i", "'", $text);	
	$text = preg_replace("/&amp;nbsp;/i", '&nbsp;', $text);
	return $text;
}

// --------------------------------------------------------
// undo html entities
//   &amp;abc;  -> &abc;
// --------------------------------------------------------
function _undo_html_entity_char($text)
{
	return preg_replace("/&amp;([0-9a-zA-z]+);/sU", '&\\1;', $text);
}

// --------------------------------------------------------
// undo html entities
//   &amp;#123; -> &#123;
// --------------------------------------------------------
function _undo_html_entity_numeric($text)
{
	return preg_replace("/&amp;#([0-9a-fA-F]+);/sU", '&#\\1;', $text);
}

// --------------------------------------------------------
// strip html entities
//   &abc; -> ' '
// --------------------------------------------------------
function _strip_html_entity_char($text)
{
	return preg_replace("/&[0-9a-zA-z]+;/sU", ' ', $text);
}

// --------------------------------------------------------
// strip html entities
//   &#123; -> ' '
// --------------------------------------------------------
function _strip_html_entity_numeric($text)
{
	return preg_replace("/&amp;#([0-9a-fA-F]+);/sU", '&#\\1;', $text);
}

//---------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
// 2003-12-13T18:30:02+09:00
//
// http://www.php.net/manual/ja/function.date.php
// User Contributed Notes
//---------------------------------------------------------
function _iso8601_date($time)
{
	$tzd  = date('O',$time);
	$tzd  = substr( chunk_split( $tzd, 3, ':' ), 0, 6 );
	$date = date('Y-m-d\TH:i:s', $time) . $tzd;
	return $date;
}

//-----------------------------------------------
// use convert class
//-----------------------------------------------
function _utf8( $text )
{
	return $this->_convet_to_utf8( $text );
}

function _convet_to_utf8( $text )
{
	$text = $this->_convert->convert($text, 'utf-8', _CHARSET);

	if ($this->FLAG_UTF8_STRIP_CONTROL)
	{
		$text = $this->_strings->strip_control_code( $text );
	}

	return $text;
}

//=========================================================
// assign to template
//=========================================================

//---------------------------------------------------------
// http://web.resource.org/rss/1.0/spec
// required paramter
// channel elements 
//   - title
//   - link
// item elements
//   - title
//   - link
//---------------------------------------------------------
function assign_rdf( &$tpl )
{
	$channel = $this->get_rdf_channel();
	$items   = $this->get_rdf_items();

	$tpl->assign('xml_lang',       $this->_utf8( $channel['xml_lang'] ) );
	$tpl->assign('channel_title',  $this->_utf8( $channel['title'] ) );
	$tpl->assign('channel_link',   $this->_utf8( $channel['link']  ));
	$tpl->assign('channel_description',  $this->_utf8( $channel['description']  ));
	$tpl->assign('channel_dc_language',  $this->_utf8( $channel['dc_language'] ) );
	$tpl->assign('channel_dc_date',      $this->_utf8( $channel['dc_date'] ) );

	foreach ($items as $item)
	{
		$tpl->append('items', 
			array(
				'link'        => $this->_utf8( $item['link'] ),
				'title'       => $this->_utf8( $item['title'] ),
				'description' => $this->_utf8( $item['description'] ),
				'dc_subject'  => $this->_utf8( $item['dc_subject'] ),
				'dc_creator'  => $this->_utf8( $item['dc_creator'] ), 
				'dc_date'     => $this->_utf8( $item['dc_date'] ), 
				'content_encoded' => $this->_utf8( $item['content_encoded'] ),
			));
	}

}

//---------------------------------------------------------
// http://blogs.law.harvard.edu/tech/rss
// required paramter
// channel elements 
//   - title
//   - link
//   - description
// item elements
//   - title
//   - link
//   - description
//---------------------------------------------------------
function assign_rss( &$tpl )
{
	$channel = $this->get_rss_channel();
	$items   = $this->get_rss_items();

	$tpl->assign('channel_title',      $this->_utf8( $channel['title'] ) );
	$tpl->assign('channel_link',       $this->_utf8( $channel['link']  ));
	$tpl->assign('channel_docs',       $this->_utf8( $channel['docs'] ) );
	$tpl->assign('channel_generator',  $this->_utf8( $channel['generator'] ) );
	$tpl->assign('channel_category',   $this->_utf8( $channel['category'] ) );
	$tpl->assign('channel_copyright',  $this->_utf8( $channel['copyright'] ) );
	$tpl->assign('channel_language',   $this->_utf8( $channel['language'] ) );
	$tpl->assign('channel_webmaster',  $this->_utf8( $channel['webmaster'] ) );
	$tpl->assign('channel_lastbuild',  $this->_utf8( $channel['lastbuild'] ) );
	$tpl->assign('channel_pubdate',    $this->_utf8( $channel['pubdate'] ) );
	$tpl->assign('channel_description',    $this->_utf8( $channel['description']  ));
	$tpl->assign('channel_managingeditor', $this->_utf8( $channel['managingeditor'] ) );

	$tpl->assign('image_url',    $this->_utf8( $channel['image_url'] ) );
	$tpl->assign('image_width',  $this->_utf8( $channel['image_width'] ) );
	$tpl->assign('image_height', $this->_utf8( $channel['image_height'] ) );
	$tpl->assign('image_title',  $this->_utf8( $channel['image_title']  ));
	$tpl->assign('image_link',   $this->_utf8( $channel['image_link'] ) );

	foreach ($items as $item)
	{
		$tpl->append('items', 
			array(
				'link'        => $this->_utf8( $item['link'] ),
				'guid'        => $this->_utf8( $item['guid'] ),
				'title'       => $this->_utf8( $item['title'] ),
				'description' => $this->_utf8( $item['description'] ),
				'category'    => $this->_utf8( $item['category'] ),
				'pubdate'     => $this->_utf8( $item['pubdate'] ), 

// for future
//				'dc_creator'      => $this->_utf8( $item['dc_creator'] ), 
//				'content_encoded' => $this->_utf8( $item['content_encoded'] ),
			));
	}

}

//---------------------------------------------------------
// http://www.mnot.net/drafts/draft-nottingham-atom-format-02.html
// required paramter
// feed elements 
//   - id
//   - title
//   - updated
//   - author name
// entry elements 
//   - id
//   - title
//   - updated
//   - author name
//   - summary or content
//---------------------------------------------------------
function assign_atom( &$tpl )
{
	$channel = $this->get_atom_channel();
	$entrys  = $this->get_atom_entrys();

	$tpl->assign('xml_lang',           $this->_utf8( $channel['xml_lang'] ) );
	$tpl->assign('feed_title',         $this->_utf8( $channel['title'] ) );
	$tpl->assign('feed_link_alt',      $this->_utf8( $channel['link_alt']  ));
	$tpl->assign('feed_link_self',     $this->_utf8( $channel['link_self'] ) );
	$tpl->assign('feed_id',            $this->_utf8( $channel['id'] ) );
	$tpl->assign('feed_generator',     $this->_utf8( $channel['generator'] ) );
	$tpl->assign('feed_generator_uri', $this->_utf8( $channel['generator_uri'] ) );
	$tpl->assign('feed_rights',        $this->_utf8( $channel['rights'] ) );
	$tpl->assign('feed_author_name',   $this->_utf8( $channel['author_name'] ) );
	$tpl->assign('feed_author_uri',    $this->_utf8( $channel['author_uri'] ) );
	$tpl->assign('feed_author_email',  $this->_utf8( $channel['author_email'] ) );
	$tpl->assign('feed_updated',       $this->_utf8( $channel['updated'] ) );

	foreach ($entrys as $entry)
	{
		$tpl->append('entrys', 
			array(
				'title'        => $this->_utf8( $entry['title'] ),
				'link'         => $this->_utf8( $entry['link'] ),
				'id'           => $this->_utf8( $entry['id'] ), 
				'summary'      => $this->_utf8( $entry['summary'] ),
				'category'     => $this->_utf8( $entry['category'] ),
				'content'      => $this->_utf8( $entry['content'] ),
				'author_name'  => $this->_utf8( $entry['author_name'] ),
				'author_uri'   => $this->_utf8( $entry['author_uri'] ),
				'author_email' => $this->_utf8( $entry['author_email'] ),
				'updated'      => $this->_utf8( $entry['updated'] ),
				'published'    => $this->_utf8( $entry['published'] ),
			));
	}
}

//=========================================================
// over ride
//=========================================================
function assign( &$tpl )
{
	// dummy
}

function get_rdf_channel()
{
	// dummy
}

function get_rdf_items()
{
	// dummy
}

function get_rss_channel()
{
	// dummy
}

function get_rss_items()
{
	// dummy
}
function get_atom_channel()
{
	// dummy
}

function get_atom_entrys()
{
	// dummy
}

// --- class end ---
}

// === class end ===
}

?>