<?php
// $Id: rssc_build_rssc.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//=========================================================
// Rss Center Module
// class builder RDF/RSS/ATOM
// for rssc module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_build_rssc') ) 
{

//=========================================================
// class rssc_build_rssc
//=========================================================
class rssc_build_rssc extends rssc_build_base
{
// constant
	var $GENERATOR     = 'XOOPS rssc';
	var $GENERATOR_URI = 'http://linux2.ohwada.net/';
	var $CATEGORY      = 'RSS Center';

	var $RDF_TITLE  = 'RSS Center: RDF';
	var $RSS_TITLE  = 'RSS Center: RSS';
	var $ATOM_TITLE = 'RSS Center: ATOM';

// class instance
	var $_system;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_build_rssc()
{
	$this->rssc_build_base();

// class instance
	$this->_system =& rssc_system::getInstance();

	$this->_flag_force_build = 1;	// always build
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_build_rssc();
	}

	return $instance;
}

//=========================================================
// RDF
//=========================================================
function get_rdf_channel()
{
	return $this->_make_common_channel();
}

function get_rdf_items()
{
	$arr = array();

	foreach ($this->_items as $item)
	{
		$arr[] = $this->_make_rdf_item( $item );
	}

	return $arr;
}

function _make_rdf_item( $item )
{
	return $this->_make_common_item( $item );
}


//=========================================================
// RSS
//=========================================================
function get_rss_channel()
{
	$channel = $this->_make_common_channel();

	$channel['pubdate'] = $channel['date_rfc822'];

// lastbuild
	if ( isset($this->_items[0]['updated_unix']) )
	{
		$channel['lastbuild'] = date("r", $this->_items[0]['updated_unix'] );
	}
	else
	{
		$channel['lastbuild'] = '';
	}

	return $channel;
}

function get_rss_items()
{
	$arr = array();

	foreach ($this->_items as $item)
	{
		$arr[] = $this->_make_rss_item( $item );
	}

	return $arr;
}

function _make_rss_item( $item )
{
	$arr = $this->_make_common_item( $item );

// guid
	if ( empty($arr['guid']) )
	{
		$arr['guid'] = $arr['link'];
	}

// date
	$arr['pubdate'] = $arr['date_rfc822'];

	return $arr;
}

//=========================================================
// ATOM
//=========================================================
function get_atom_channel()
{
	$channel = $this->_make_common_channel();

// atom id
	$site_id = "tag:".$this->_site_tag.",".$this->_site_year."://1";
	$channel['id'] = $this->_xml( $site_id );

// date
	$channel['updated'] = $channel['date_iso8601'];

	return $channel;
}

function get_atom_entrys()
{
	$arr = array();
	$this->_count_line = 1;

	foreach ($this->_items as $entry)
	{
		$arr[] = $this->_make_atom_entry( $entry );
	}

	return $arr;
}

function _make_atom_entry( $entry )
{
	$arr = $this->_make_common_item( $entry );

// title
	$arr['title'] = $this->_make_xml_title($entry, 0, 0);

// must content or summary
	if ( empty($arr['content']) && empty($arr['summary']) )
	{
		$arr['summary'] = $arr['title'];
	}

// must author_name
	if ( empty($arr['author_name']) )
	{
		$arr['author_name']  = $this->_xml( $this->_site_author_name );
		$arr['author_uri']   = '';
		$arr['author_email'] = '';
	}

// atom id
	if ( $arr['entry_id'] )
	{
		$arr['id'] = $arr['entry_id'];
	}
	else
	{
		$atom_id = "tag:".$this->_site_tag.",".$this->_site_year."://1.1.".$this->_count_line;
		$arr['id'] = $this->_xml( $atom_id );
	}

// date
	$arr['updated']   = $arr['updated_iso8601'];
	$arr['published'] = $arr['published_iso8601'];

	$this->_count_line ++;

	return $arr;
}

//=========================================================
// common
//=========================================================
function _make_common_channel()
{

// site information
	$site_url    = XOOPS_URL.'/';
	$site_name   = $this->_system->get_sitename();
	$site_desc   = $this->_system->get_slogan();
	$site_author_name  = $this->_system->get_meta_author();
	$site_author_email = $this->_system->get_adminmail();
	$site_author_uri   = '';

	$site_link_self = 'http://'.$_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];

	$site_url_xml          = $this->_xml_url( $site_url );
	$site_author_email_xml = $this->_xml( $site_author_email );
	$language_xml = $this->_xml( _LANGCODE );

	$time = time();
	$date_rfc822_xml  = $this->_xml( date("r", $time ) );
	$date_iso8601_xml = $this->_xml( $this->_iso8601_date( $time ) );

// image
	$site_image_url    = '';
	$site_image_link   = '';
	$site_image_width  = '';
	$site_image_height = '';
	$site_image_title  = '';

// copyright
	$year = date("Y");
	$site_copyright     = "Copyright (c) $year, $site_author_name";
	$site_copyright_xml = $this->_xml( $site_copyright );

// save param
	$this->_site_author_name = $site_author_name;
	$this->_site_tag    = $this->_get_site_tag( $site_url );
	$this->_site_year   = $year;

	$ret = array(
		'link'           => $site_url_xml,
		'link_alt'       => $site_url_xml,
		'author_uri'     => $site_url_xml,
		'link_self'      => $this->_xml_url( $site_link_self ),
		'image_url'      => $this->_xml_url( $site_image_url ),
		'image_link'     => $this->_xml_url( $site_image_link ),
		'generator_uri'  => $this->_xml_url( $this->GENERATOR_URI ),
		'language'       => $language_xml,
		'copyright'      => $site_copyright_xml,
		'rights'         => $site_copyright_xml,
		'author_email'   => $site_author_email_xml,
		'webmaster'      => $site_author_email_xml,
		'managingeditor' => $site_author_email_xml,
		'title'          => $this->_xml( $site_name ),
		'description'    => $this->_xml( $site_desc ),
		'generator'      => $this->_xml( $this->GENERATOR ),
		'category'       => $this->_xml( $this->CATEGORY ),
		'docs'           => $this->_xml( $this->RSS_DOCS ),
		'author_name'    => $this->_xml( $site_author_name ),
		'author_uri'     => $this->_xml( $site_author_uri ),
		'image_width'    => $this->_xml( $site_image_width ),
		'image_height'   => $this->_xml( $site_image_height ),
		'image_title'    => $this->_xml( $site_image_title ),

		'date_unix'      => $time,
		'date_rfc822'    => $date_rfc822_xml,
		'date_iso8601'   => $date_iso8601_xml,

		'xml_lang'       => $language_xml,
		'dc_language'    => $language_xml,
		'dc_date'        => $date_iso8601_xml,
	);

	return $ret;
}

function _make_common_item( $item )
{
// title content 
	$title_xml   = $this->_make_xml_title($item);
	$content_xml = $this->_make_xml_content($item);
	$sum_xml     = $this->_make_xml_summary($item, 0, 0);

	$category_xml    = $this->_xml( $item['category'] );
	$author_name_xml = $this->_xml( $item['author_name'] );

	$published_unix  = intval( $item['published_unix'] );
	$updated_unix    = intval( $item['updated_unix'] );
	$published_rfc822_xml  = $this->_xml( date("r", $published_unix ) );
	$updated_rfc822_xml    = $this->_xml( date("r", $updated_unix ) );
	$published_iso8601_xml = $this->_xml( $this->_iso8601_date( $published_unix ) );
	$updated_iso8601_xml   = $this->_xml( $this->_iso8601_date( $updated_unix ) );

	$ret = array(
		'link'         => $this->_xml_url( $item['link'] ),
		'guid'         => $this->_xml_url( $item['guid'] ),
		'entry_id'     => $this->_xml_url( $item['entry_id'] ),
		'author_uri'   => $this->_xml_url( $item['author_uri'] ),
		'author_email' => $this->_xml( $item['author_email'] ),
		'author_name'  => $author_name_xml,
		'title'        => $title_xml,
		'summary'      => $sum_xml,
		'description'  => $sum_xml,
		'content'      => $content_xml,
		'category'     => $category_xml,

		'published_unix'    => $published_unix,  // unixtime
		'updated_unix'      => $updated_unix,    // unixtime
		'published_rfc822'  => $published_rfc822_xml,
		'date_rfc822'       => $published_rfc822_xml,
		'updated_rfc822'    => $updated_rfc822_xml,
		'published_iso8601' => $published_iso8601_xml,
		'date_iso8601'      => $published_iso8601_xml,
		'updated_iso8601'   => $updated_iso8601_xml,

		'dc_subject'  => $category_xml,
		'dc_creator'  => $author_name_xml,
		'dc_date'     => $published_iso8601_xml,
		'content_encoded' => $content_xml,
	);

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>