<?php
// $Id: rssc_config_form.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//================================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('rssc_config_form') ) 
{

//=========================================================
// class rssc_config_form
//=========================================================
class rssc_config_form extends rssc_form
{
// cache
	var $_config_id_cache;
	var $_config_name_cache;

	var $_form_name_config = 'rssc_config';

// define by rssc_form
//	var $_form_name   = 'rssc';
//	var $_token_name  = 'rssc';
//	var $_op_name     = 'op';
//	var $_submit_name = 'submit';
//	var $_method      = 'post';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_config_form()
{
	$this->_form_name = $this->_form_name_config;
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_config_form();
	}

	return $instance;
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
function show($config_arr)
{
	if ( !is_array($config_arr) || empty($config_arr) )  return;

// form start
	$this->init_form();
	echo $this->make_form_start($this->_form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');
	echo $this->make_table_start();
	echo $this->make_table_title( $this->FORM_TITLE );

// list from config array
	foreach ($config_arr as $id => $config) 
	{
		$title = $this->make_conf_caption( $id );
		$ele   = $this->make_conf_element( $id );
		$ele  .= $this->make_conf_hidden( $id );
		echo $this->make_table_line($title, $ele);
	}

	$ele = $this->make_form_submit('submit', $this->SUBMIT_VALUE );
	echo $this->make_table_line('', $ele, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

// form end

}

function show_by_catid( $catid )
{
	$config_arr =& $this->get_by_catid($catid);

	$form_name = $this->_form_name_config.'_'.$catid;
	$this->set_form_name( $form_name );

	$this->show( $config_arr );
}

//---------------------------------------------------------
// set cache
//---------------------------------------------------------
function set_config_id_cache( &$cache )
{
	$this->_config_id_cache =& $cache;
}

function set_config_name_cache( &$cache )
{
	$this->_config_name_cache =& $cache;
}

//---------------------------------------------------------
// make config element
//---------------------------------------------------------
function make_conf_element( $id )
{
	$formtype = $this->_config_id_cache[$id]->getVar('conf_formtype');

	switch ( $formtype ) 
	{
		case 'textarea':
			$ele = $this->make_conf_textarea($id);
			break;

		case 'select':
			$ele = $this->make_conf_select($id);
			break;

//		case 'select_multi':
//			$ele = $this->make_conf_select_multi($id);
//			break;

		case 'radio':
		case 'radio_select':
			$ele = $this->make_conf_radio_select($id);
			break;

		case 'yesno':
		case 'radio_yesno':
			$ele = $this->make_conf_radio_yesno($id);
			break;

		case 'yesno_check':
		case 'checkbox_yesno':
			$ele = $this->make_conf_checkbox_yesno($id);
			break;

//		case 'group':
//			$ele = $this->make_conf_group($id);
//			break;

//		case 'group_multi':
//			$ele = $this->make_conf_group_multi($id);
//			break;

//		case 'user':
//			$ele = $this->make_conf_user($id);
//			break;

//		case 'user_multi':
//			$ele = $this->make_conf_user_multi($id);
//			break;

//		case 'password':
//			$ele = $this->make_conf_password($id);
//			break;

		case 'label':
			$ele = $this->make_conf_label($id);
			break;

		case 'text_image':
			$ele = $this->make_conf_text_image($id);
			break;

		case 'label_image':
			$ele = $this->make_conf_label_image($id);
			break;

		case 'textbox':
		default:
			$ele = $this->make_conf_textbox($id);
			break;
	}

	return $ele;
}

//---------------------------------------------------------
// make config by name
//---------------------------------------------------------
function make_conf_caption_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id = $this->get_id_by_name($name);
	return $this->make_conf_caption($id);
}

function make_conf_textbox_by_name($name, $size=5)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_textbox($id, $size);
	$text .= $this->make_conf_hidden($id);
	return $text;
}

function make_conf_yseno_checkbox_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_checkbox_yesno($id);
	$text .= $this->make_conf_hidden($id);
	return $text;
}

function make_conf_radio_select_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_radio_select($id, '<br />');
	$text .= $this->make_conf_hidden($id);
	return $text;
}

//---------------------------------------------------------
// make config form
//---------------------------------------------------------
function make_conf_caption($id)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	$title = $this->_config_id_cache[$id]->getVar('conf_title');
	$desc  = $this->_config_id_cache[$id]->getVar('conf_desc');

	return $this->make_caption($title, $desc);

}

function make_conf_textbox($id, $size=50, $maxlength=255)
{
	$name  = $this->get_conf_name($id);
	$value = $this->get_conf_html_value($id);
	$text  = $this->make_form_text($name, $value, $size);
	return $text;
}

function make_conf_label($id)
{
	return $this->get_conf_html_value($id);
}

function make_conf_select($id, $none=0, $none_name='---', $none_value='')
{
	$name    = $this->get_conf_name($id);
	$value   = $this->get_conf_value($id);
	$options = $this->get_conf_options($id);
	$text    = $this->make_form_select($name, $value, $options, $none, $none_name, $none_value);
	return $text;
}

function make_conf_select_options($id, $options, $none=0, $none_name='---', $none_value='')
{
	$name    = $this->get_conf_name($id);
	$value   = $this->get_conf_value($id);
	$text    = $this->make_form_select($name, $value, $options, $none, $none_name, $none_value);
	return $text;
}

function make_conf_radio_select($id, $del='')
{
	$name    = $this->get_conf_name($id);
	$value   = $this->get_conf_value($id);
	$options = $this->get_conf_options($id);
	$text    = $this->make_form_radio_select($name, $value, $options, $del);
	return $text;
}

function make_conf_radio_yesno($id)
{
	$name  = $this->get_conf_name($id);
	$value = $this->get_conf_value($id);
	return $this->make_form_radio_yesno($name, $value);

}

function make_conf_checkbox_yesno($id)
{
	$name  = $this->get_conf_name($id);
	$value = $this->get_conf_html_value($id);
	return $this->make_form_radio_yesno($name, $value);

}

function make_conf_textarea($id)
{
	$name      = $this->get_conf_name($id);
	$valuetype = $this->get_conf_valuetype($id);

	if ($valuetype == 'array') 
	{
		$value = $this->_config_id_cache[$id]->getVar('conf_value');

		if ($value != '')
		{
			$value_conf = $this->get_conf_value($id);
			$value_show = $this->sanitize_html_text( implode('|', $value_conf) );
			$text = $this->make_form_textarea($name, $value_show, 5, 50);
		}
		else
		{
			$text = $this->make_form_textarea($name, '', 5, 50);
		}
	}
	else 
	{
		$value_show = $this->get_conf_html_value($id);
		$text = $this->make_form_textarea($name, $value_show, 5, 50);
	}

	return $text;
}

function make_conf_text_image($id, $size=50, $maxlength=255, $width=0, $height=0, $border=0, $alt='image')
{
	$name   = $this->get_conf_name($id);
	$value  = $this->get_conf_value($id);
	$text   = $this->make_form_text($name, $value, $size);
	$text  .= "<br /><br />\n";
	$text  .= $this->make_html_img($value, $width, $height, $border, $alt);
	return $text;
}

function make_conf_label_image($id, $width=0, $height=0, $border=0, $alt='image')
{
	$name   = $this->get_conf_name($id);
	$value  = $this->get_conf_value($id);
	$text   = $value;
	$text  .= "<br /><br />\n";
	$text  .= $this->make_html_img($value, $width, $height, $border, $alt);
	return $text;
}

function make_conf_hidden($id)
{
	return $this->make_form_hidden('conf_ids[]', $id);
}

//---------------------------------------------------------
// get config value
//---------------------------------------------------------
function get_id_by_name($name)
{
	if ( isset( $this->_config_name_cache[$name] ) )
	{
		return $this->_config_name_cache[$name]->getVar('conf_id');
	}

	return false;
}

function get_conf_name($id)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	return $this->_config_id_cache[$id]->getVar('conf_name');
}

function get_conf_valuetype($id)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	return $this->_config_id_cache[$id]->getVar('conf_valuetype');
}

function get_conf_options($id)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	return $this->_config_id_cache[$id]->getVar('conf_options');
}

function get_conf_html_value($id)
{
	return $this->sanitize_html_text( $this->get_conf_value($id) );
}

function get_conf_value($id)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	return $this->_config_id_cache[$id]->getConfValueForOutput();
}

//---------------------------------------------------------
// set config value
//---------------------------------------------------------
function set_conf_options($id, $optins)
{
	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	return $this->_config_id_cache[$id]->setVar('conf_options', $options);
}

//---------------------------------------------------------
// get_by_catid
//---------------------------------------------------------
function &get_by_catid( $catid )
{
	$catid = intval($catid);
	if ($catid <= 0) return false;

	$obj_arr = array();

	foreach ($this->_config_id_cache as $id => $obj)
	{
		if ( $catid == $obj->getVar('conf_catid') )
		{
			$obj_arr[$id] =& $obj;
		}
	}

	return $obj_arr;
}

// --- class end ---
}

// === class end ===
}

?>