<?php
// $Id: rssc_config_handler.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//================================================================
// Rss Center Module
// this file contain 2 class
//   rssc_config 
//   rssc_config_handler
// 2006-01-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('ssc_config') ) 
{

//================================================================
// class rssc_config
// modify form system XoopsConfigItem
//================================================================
class rssc_config extends XoopsObject
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_config()
{
	$this->initVar('conf_id',        XOBJ_DTYPE_INT, 0, true);
	$this->initVar('conf_name',      XOBJ_DTYPE_OTHER);
	$this->initVar('conf_value',     XOBJ_DTYPE_TXTAREA);
	$this->initVar('aux_int_1',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2',     XOBJ_DTYPE_TXTBOX, null, false, 255);

// not table value, refer to define
	$this->initVar('conf_exist',     XOBJ_DTYPE_INT, 0);
	$this->initVar('conf_catid',     XOBJ_DTYPE_INT, 0);
	$this->initVar('conf_valuetype', XOBJ_DTYPE_OTHER);
	$this->initVar('conf_formtype',  XOBJ_DTYPE_OTHER);
	$this->initVar('conf_title',     XOBJ_DTYPE_TXTBOX);
	$this->initVar('conf_desc',      XOBJ_DTYPE_OTHER);
	$this->initVar('conf_options',   XOBJ_DTYPE_OTHER);

}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &getConfValueForOutput()
{
	switch ( $this->getVar('conf_valuetype') ) 
	{
		case 'int':
			return intval($this->getVar('conf_value', 'N'));

		case 'array':
			return unserialize($this->getVar('conf_value', 'N'));

		case 'float':
			$value = $this->getVar('conf_value', 'N');
			return (float)$value;

		case 'textarea':
			return $this->getVar('conf_value');

		case 'text':
		default:
			return $this->getVar('conf_value', 'N');
	}
}

function setConfValueForInput(&$value, $force_slash = false)
{
	switch ( $this->getVar('conf_valuetype') ) 
	{
		case 'array':
			if (!is_array($value)) 
			{
				$value = explode('|', trim($value));
			}
			$this->setVar('conf_value', serialize($value), $force_slash);
			break;

		case 'text':
			$this->setVar('conf_value', trim($value), $force_slash);
			break;

		default:
			$this->setVar('conf_value', $value, $force_slash);
			break;
	}
}

// --- class end ---
}

//=========================================================
// class congig handler
//=========================================================
class rssc_config_handler extends rssc_db_base
{
// class
	var $_config_define;
	var $_post;

// cache
	var $_define_id_cache   = array();
	var $_config_id_cache   = array();
	var $_config_name_cache = array();
	var $_config_data_cache = array();


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_config_handler( $dirname )
{
	$this->rssc_db_base($dirname, 'rssc_config_handler');

	$this->_table      = $this->_db->prefix( $dirname.'_config' );
	$this->_id_name    = 'conf_id';
	$this->_class_name = 'rssc_config';

	$this->_flag_debug_print_sql   = 0;
	$this->_flag_debug_print_error = 0;

// class
	$this->_config_define =& rssc_config_define::getInstance();
	$this->_post          =& rssc_post::getInstance();

}


//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// load to cache
//---------------------------------------------------------
function load()
{
	$this->init_define();

	$id_arr = array();

// create from MySQL
	$sql = 'SELECT * FROM '.$this->_table.' ORDER BY conf_id ASC';

	if ( !$res = $this->_query($sql) ) 
	{	return false;	}

// list from MySQL
	while ( $myrow = $this->_db->fetchArray($res) ) 
	{
		$id    = $myrow['conf_id'];
		$name  = $myrow['conf_name'];
		$value = $myrow['conf_value'];

		$title     = $this->get_define_var($id, 'title');
		$desc      = $this->get_define_var($id, 'description');
		$catid     = $this->get_define_var($id, 'catid');
		$valuetype = $this->get_define_var($id, 'valuetype');
		$formtype  = $this->get_define_var($id, 'formtype');
		$options   = $this->get_define_var($id, 'options');

		$id_arr[$id] = 1;

		$config =& $this->create( false );	// not new
		$config->assignVars($myrow);
		$config->setVar('conf_exist',     1 );
		$config->setVar('conf_catid',     $catid );
		$config->setVar('conf_valuetype', $valuetype );
		$config->setVar('conf_formtype',  $formtype );
		$config->setVar('conf_options',   $options );
		$config->setVar('conf_title',     $title );
		$config->setVar('conf_desc',      $desc );

		$this->_config_id_cache[$id]     =& $config;
		$this->_config_name_cache[$name] =& $config;
		$this->_config_data_cache[$name] =  $value;
		unset($config);
	}

// list from define
	foreach ($this->_define_id_cache as $id => $define) 
	{
		if ( isset($id_arr[$id]) && $id_arr[$id] ) continue;

		$title     = $this->get_define_var($id, 'title');
		$desc      = $this->get_define_var($id, 'description');
		$name      = $this->get_define_var($id, 'name');
		$catid     = $this->get_define_var($id, 'catid');
		$default   = $this->get_define_var($id, 'default');
		$valuetype = $this->get_define_var($id, 'valuetype');
		$formtype  = $this->get_define_var($id, 'formtype');
		$options   = $this->get_define_var($id, 'options');

// create, when not in MySQL
		$config =& $this->create();
		$config->setVar('conf_id',        $id );
		$config->setVar('conf_name',      $name);
		$config->setVar('conf_catid',     $catid );
		$config->setVar('conf_valuetype', $valuetype );
		$config->setVar('conf_formtype',  $formtype );
		$config->setVar('conf_options',   $options );
		$config->setVar('conf_title',     $title );
		$config->setVar('conf_desc',      $desc );
		$config->setConfValueForInput($default, true);

		$this->_config_id_cache[$id]     =& $config;
		$this->_config_name_cache[$name] =& $config;
		$this->_config_data_cache[$name] =  $default;
		unset($config);
	}

}

//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function insert(&$obj)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('config table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('config table: not clean');
		return false;
	}

	if ( !$obj->isNew() )
	{
		$this->_set_errors('config table: not new');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	$sql = sprintf("INSERT INTO %s (conf_id, conf_name, conf_value, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES (%u, %s, %s, %u, %u, %s, %s)", $this->_table, $conf_id, $this->_quote($conf_name), $this->_quote($conf_value), $aux_int_1, $aux_int_2, $this->_quote($aux_text_1), $this->_quote($aux_text_2) );

//	echo "$sql <br>";

	if ( !$result = $this->_query($sql) ) 
	{	return false;	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function update(&$obj)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('config table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('config table: not clean');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	if (empty($conf_id)) 
	{
		$this->_set_errors('config table: not exist conf_id');
		return false;
	}

	$sql = sprintf("UPDATE %s SET conf_name = %s, conf_value = %s, aux_int_1 = %u, aux_int_2 = %u, aux_text_1 = %s, aux_text_2 = %s WHERE conf_id = %u", $this->_table, $this->_quote($conf_name), $this->_quote($conf_value), $aux_int_1, $aux_int_2, $this->_quote($aux_text_1), $this->_quote($aux_text_2), $conf_id);

	if ( !$result = $this->_query($sql) ) 
	{	return false;	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function update_by_id($id, $value)
{
	$id = intval($id);
	if ($id <= 0) return false;

	$obj =& $this->get($id);

	if ( !is_object($obj) )
	{	return false;	}

	$obj->setConfValueForInput($value, true);
	return $this->update($obj);
}

function update_by_name($name, $value)
{
	$id = $this->get_id_by_name($name);
	return $this->update_by_id($id, $value);
}

function delete(&$obj)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('config table: not match class');
		return false;
	}

	$sql = "DELETE FROM ".$this->_table." WHERE ".$this->_id_name." = ".$obj->getVar($this->_id_name);

	if ( !$result = $this->_query($sql) ) 
	{	return false;	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function &get_config_id_cache()
{
	return $this->_config_id_cache;
}

function &get_config_name_cache()
{
	return $this->_config_name_cache;
}

function &get_config_data()
{
	return $this->_config_data_cache;
}

function &get($id)
{
	$id = intval($id);
	if ($id <= 0) return false;

	if ( isset($this->_config_id_cache[$id]) )
	{
		return $this->_config_id_cache[$id];
	}

	return false;
}

function &get_by_catid($catid)
{
	$catid = intval($catid);
	if ($catid <= 0) return false;

	$obj_arr = array();

	foreach ($this->_config_id_cache as $id => $obj)
	{
		if ( $catid == $obj->getVar('conf_catid') )
		{
			$obj_arr[$id] =& $obj;
		}
	}

	return $obj_arr;
}

function get_num()
{
	return $this->getCount();
}

function get_id_by_name($name)
{
	if ( isset( $this->_config_name_cache[$name] ) )
	{
		return $this->_config_name_cache[$name]->getVar('conf_id');
	}

	return false;
}

function is_exist_by_name($name)
{
	$id = $this->get_id_by_name($name);

	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	if ( $this->_config_id_cache[$id]->isNew() )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// config define
//---------------------------------------------------------
function init_define()
{
	$this->_define_id_cache = $this->_config_define->get_define();
}

function &get_define_all()
{
	return $this->_define_id_cache;
}

function get_define_var($id, $key)
{
	$id = intval($id);
	if ($id <= 0) return false;

	if ( !isset($this->_define_id_cache[$id][$key]) )
	{
		return false;;
	}

	$value = $this->_define_id_cache[$id][$key];

	switch ($key)
	{
		case 'title':
		case 'description':
			if ( defined( $value ) )
			{
				return constant( $value );
			}
			else
			{
				return $value;
			}
			break;

		default:
			return $value;
			break;
	}

	return false;	// dummy
}


//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$conf_ids = $this->_post->get_post('conf_ids');

	$count = count($conf_ids);
	if ($count <= 0)  return; 

// list from POST 
	for ( $i=0; $i<$count; $i++ ) 
	{
		$id = $conf_ids[$i];

		$config =& $this->get($id);
		if ( !is_object($config) )  continue;

		$name  = $config->getVar('conf_name');
		$value = $this->_post->get_post($name);
		$value_current = $config->getVar('conf_value');

// insert, when not in MySQL
		if ( $config->isNew() )
		{
			$this->insert($config);
		}
// update
		elseif ( is_array($value) || ($value != $value_current) )
		{
			$config->setConfValueForInput($value, true);
			$this->update($config);
		}

		unset($config);
	}

}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function upgrade()
{
	$define_arr = $this->get_define_all();

// list from Define
	foreach ($define_arr as $id => $define) 
	{
		$config =& $this->get($id);
		if ( !is_object($config) )  continue;

// insert, when not in MySQL
		if ( $config->isNew() )
		{
			$this->insert($config);
		}

		unset($config);
	}

}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function init()
{
	$define_arr = $this->get_define_all();

// list from Define
	foreach ($define_arr as $id => $define) 
	{
		$name      = $define['name'];
		$valuetype = $define['valuetype'];
		$value     = $define['default'];

		$config =& $this->create();
		$config->setVar('conf_id',        $id );
		$config->setVar('conf_name',      $name);
		$config->setVar('conf_valuetype', $valuetype);
		$config->setConfValueForInput($value, true);
		$this->insert($config);

		unset($config);
	}

}

// --- class end ---
}

// === class end ===
}

?>