<?php
// $Id: rssc_convert.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_convert') ) 
{

//=========================================================
// class rssc_convert
//=========================================================
class rssc_convert
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_convert()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_convert();
	}
	return $instance;
}

//=========================================================
// public function
//=========================================================
function convert_array_array($in_arr, $to, $from)
{
	if ( $to == $from )
	{
		return $in_arr;
	}

	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert_array($value, $to, $from);
	}

	return $out_arr;
}

function convert_array($in_arr, $to, $from)
{
	if ( $to == $from )
	{
		return $in_arr;
	}

	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert($value, $to, $from);
	}

	return $out_arr;
}

//---------------------------------------------------------
// multibyte
//---------------------------------------------------------
function convert($text, $to, $from)
{
	if ( $to == $from )
	{
		return $text;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		return mb_convert_encoding($text, $to, $from);
	}
	elseif ( $to == 'utf-8' )
	{
		return utf8_encode($text);
	}
	elseif ( $from == 'utf-8' )
	{
		return utf8_decode($text);
	}

	return $text;
}

// --- class end ---
}

// === class end ===
}

?>