<?php
// $Id: rssc_db_base.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_db_base') ) 
{

//=========================================================
// class rssc_db_base
//=========================================================
class rssc_db_base extends rssc_error
{
// class instance
	var $_db;

// override
	var $_table;
	var $_id_name;
	var $_class_name;

// debug
	var $_flag_debug_print_sql = 0;
	var $_debug_max_sql = 1000;

// define by rssc_error
//	var $_flag_debug_print_log   = 0;
//	var $_flag_debug_print_error = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_db_base($dirname, $handler_name)
{
// check dirname
	if ( empty($dirname) )
	{
		$error = 'System Error: dirname is empty: '.$handler_name;

		if ( function_exists('xoops_error') )
		{
			xoops_error( $error );
		}
		else
		{
			echo $error;
		}
	}

	$this->rssc_error();

// class instance
	$this->_db =& Database::getInstance();
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function &create($isNew = true)
{
	$config = new $this->_class_name();

	if ($isNew) 
	{
		$config->setNew();
	}

	return $config;
}

function delete(&$obj, $force=false)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('table delete: not match class');
		return false;
	}

	$id  = $obj->getVar($this->_id_name);
	$sql = "DELETE FROM ".$this->_table." WHERE ".$this->_id_name." = ".$id;

	if ( !$result = $this->_query($sql, 0, 0, $force) ) 
	{	return false;	}

	return true;
}

function &get($id)
{
	$id = intval($id);

	if ($id <= 0)
	{
		$this->_set_errors('table get: id must be above zero');
		return false;
	}

	$sql = "SELECT * FROM ".$this->_table." WHERE ".$this->_id_name." = ".$id;

	if ( !$result = $this->_query($sql) ) 
	{	return false;	}

	$numrows = $this->_db->getRowsNum($result);
	if ($numrows != 1)  return false;

	$obj = $this->create();
	$obj->assignVars($this->_db->fetchArray($result));

	return $obj;
}

function &getObjects($criteria = null)
{
	$ret = array();
	$limit = $start = 0;

	$sql = 'SELECT * FROM '.$this->_table;

	if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) 
	{
		$sql .= ' '.$criteria->renderWhere();

		$sort = $criteria->getSort();

		if ($sort)
		{
			$sql .= ' ORDER BY '.$sort;
		}
		else
		{
			$sql .= ' ORDER BY '.$this->_id_name.' '.$criteria->getOrder();
		}

		$limit = $criteria->getLimit();
		$start = $criteria->getStart();
	}
	else
	{
		$sql .= ' ORDER BY '.$this->_id_name;
	}

	if ( !$result = $this->_query($sql, $limit, $start) ) 
	{	return false;	}

	while ( $row = $this->_db->fetchArray($result) ) 
	{
		$obj = $this->create();
		$obj->assignVars($row);
		$ret[] =& $obj;
		unset($obj);
	}

	return $ret;
}

function getCount($criteria = null)
{
	$sql = 'SELECT COUNT(*) FROM '.$this->_table;

	if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) 
	{
		$sql .= ' '.$criteria->renderWhere();
	}

	if ( !$result =& $this->_query($sql) ) 
	{
		return 0;
	}

	list($count) = $this->_db->fetchRow($result);
	return $count;
}

function &getObjectsBySql($sql, $limit=0, $start=0)
{
	if ( !$result = $this->_query($sql, $limit, $start) ) 
	{	return false;	}

	$ret = array();

	while ($myrow = $this->_db->fetchArray($result)) 
	{
		$obj = $this->create();
		$obj->assignVars($myrow);
		$ret[] =& $obj;
		unset($obj);
	}

	return $ret;
}

function getCountBySql($sql)
{
	if ( !$result =& $this->_query($sql) ) 
	{
		return 0;
	}

	list($count) = $this->_db->fetchRow($result);
	return $count;
}

//---------------------------------------------------------
// set & get parameter
//---------------------------------------------------------
function set_flag_print_sql($value)
{
	$this->_flag_print_sql = intval($value);
}

function set_table()
{
	return $this->_table;
}

//---------------------------------------------------------
// database handler
//---------------------------------------------------------
function _query($sql, $limit=0, $offset=0, $force=false)
{
	if ( $force )
	{
		$result = $this->_db->queryF($sql, $limit, $offset);
	}
	else
	{
		$result = $this->_db->query($sql, $limit, $offset);
	}

	$this->_print_sql($sql);

	if ( !$result ) 
	{
		$this->_set_db_error($sql);
		return false;
	}

	return $result;
}

function _queryF($sql, $limit=0, $offset=0)
{
	$result = $this->_db->queryF($sql, $limit, $offset);

	$this->_print_sql($sql);

	if ( !$result ) 
	{
		$this->_set_db_error($sql);
		return false;
	}

	return $result;
}

function _quote($text)
{
	return $this->_db->quoteString($text);
}

//---------------------------------------------------------
// funcuton
//---------------------------------------------------------
function _check_class( &$obj )
{
	if (strtolower(get_class($obj)) == $this->_class_name) 
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// error
//---------------------------------------------------------
function _set_db_error($sql='')
{
	$err1 = $this->_db->error();
	$this->_set_errors( $err1 );

	if ($sql)
	{
		$err2 = $this->_shorten_text($sql, $this->_debug_max_sql);
		$this->_set_errors( $err2 );
	}
}

function _print_sql($sql)
{
	if ( !$this->_flag_debug_print_sql )  return;
	if ( empty($sql) )  return;

	$sql = $this->_shorten_text($sql, $this->_debug_max_sql);
	$sql = htmlSpecialChars($sql);
	echo "sql: $sql <br />\n";
}

//---------------------------------------------------------
// multi byte
//---------------------------------------------------------
function _shorten_text($text, $max=100)
{
	if ( strlen($text) > $max)
	{
		if (function_exists('mb_strcut'))
		{
			$text = mb_strcut( $text, 0, $max )." ...";
		}
		else
		{
			$text = substr( $text, 0, $max )." ...";
		}
	} 

	return $text;
}

// --- class end ---
}

// === class end ===
}

?>