<?php
// $Id: rssc_error.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_error') ) 
{

//=========================================================
// class rssc_error
//=========================================================
class rssc_error
{

// log & error
	var $_logs   = array();
	var $_errors = array();
	var $_error_code = 0;
	var $_error_flag = false;	// no error

// debug
	var $_flag_debug_print_log   = 0;
	var $_flag_debug_print_error = 0;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_error()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_error();
	}

	return $instance;
}

//=========================================================
// Public
//=========================================================
function &getLogs($format='n')
{
	if ($format == 'n') 
	{
		return $this->_logs;
	}

	if (count($this->_logs) == 0)
	{
		return '';
	} 

	$ret = '';

	foreach ($this->_logs as $log) 
	{
		$ret .= $log.'<br />';
	}

	return $ret;
}

function &getErrors($format='n')
{
	if ($format == 'n') 
	{
		return $this->_errors;
	}

	if (count($this->_errors) == 0)
	{
		return '';
	} 

	$ret = '';

	foreach ($this->_errors as $error) 
	{
		$ret .= $error.'<br />';
	}

	return $ret;
}

function getErrorCode()
{
	return $this->_error_code;
}

function set_debug_print_log($value)
{
	$this->_flag_debug_print_log = intval($value);
}

function set_debug_print_error($value)
{
	$this->_flag_debug_print_error = intval($value);
}

//=========================================================
// Private
//=========================================================
function _clear_errors()
{
	$this->_errors     = array();
	$this->_error_flag = false;	// no error
}

function _set_log_func_name($text)
{
	$this->_set_log( 'function: '.$text );
}

function _set_log($text_arr)
{
	if ( is_array($text_arr) )
	{
		foreach ($text_arr as $text)
		{
			$this->_logs[] = $text;

			if ($this->_flag_debug_print_log)
			{
				$this->_print_line($text);
			}
		}
	}
	else
	{
		$this->_logs[] = $text_arr;

		if ($this->_flag_debug_print_log)
		{
			$this->_print_line($text_arr);
		}
	}
}

function _set_errors($text_arr)
{
	if ( is_array($text_arr) )
	{
		foreach ($text_arr as $text)
		{
			$this->_errors[] = $text;

			if ($this->_flag_debug_print_error)
			{
				$this->_print_line($text);
			}
		}
	}
	else
	{
		$this->_errors[] = $text_arr;

		if ($this->_flag_debug_print_error)
		{
			$this->_print_line($text_arr);
		}
	}

	$this->_error_flag = true;	// error
}

function _set_error_code($code)
{
	$this->_error_code = $code;
}

function _print_line($text)
{
	echo htmlSpecialChars($text, ENT_QUOTES);
	echo "<br />\n";
}


// --- class end ---
}

// === class end ===
}

?>