<?php
// $Id: rssc_feed_handler.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// class feed
// this file contain 2 class
//   rssc_feed
//   rssc_feed_handler
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_feed_hnadler') ) 
{

//=========================================================
// class feed
//=========================================================
class rssc_feed extends XoopsObject
{
// class
	var $_strings;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed()
{
	$this->XoopsObject();
	$this->initVar('fid', XOBJ_DTYPE_INT, null, false);
	$this->initVar('lid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p1',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p2',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p3',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('site_title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('site_link',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('link',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('entry_id', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('guid',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('updated_unix',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('published_unix', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('category',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_name',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_uri',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('author_email', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('type_cont',    XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('raws',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('content', XOBJ_DTYPE_TXTAREA);
	$this->initVar('search',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

// class
	$this->_strings =& rssc_strings::getInstance();

}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function getVarAll($format='n')
{
	$arr = array(
		'fid' => $this->getVar('fid', $format),
		'lid' => $this->getVar('lid', $format),
		'uid' => $this->getVar('uid', $format),
		'mid' => $this->getVar('mid', $format),
		'p1'  => $this->getVar('p1', $format),
		'p2'  => $this->getVar('p2', $format),
		'p3'  => $this->getVar('p3', $format),
		'site_title' => $this->getVar('site_title', $format),
		'site_link'  => $this->getVar('site_link',  $format),
		'title'      => $this->getVar('title', $format),
		'link'       => $this->getVar('link',  $format),
		'entry_id'   => $this->getVar('entry_id', $format),
		'guid'       => $this->getVar('guid', $format),
		'category'   => $this->getVar('category', $format),
		'author_name'  => $this->getVar('author_name', $format),
		'author_uri'   => $this->getVar('author_uri',  $format),
		'author_email' => $this->getVar('author_email',$format), 
		'type_cont'    => $this->getVar('type_cont',   $format), 
		'updated_unix'   => $this->getVar('updated_unix',   $format),
		'published_unix' => $this->getVar('published_unix', $format),
		'content' => $this->getVar('content', $format),
		'search'  => $this->getVar('search',  $format),
		'raws'    => $this->getVar('raws',    $format),
	);

	return $arr;
}

function setSearch($item)
{
	$search = $item['title'].' '.$item['content'];
	$search = $this->_strings->strip_control_code($search);
	$search = $this->_strings->strip_style_tag($search);
	$search = $this->_strings->add_space_after_tag($search);
	$search = strip_tags($search);

	$this->setVar('search', $search);
}

function setRaws($item)
{
// atom
	if ( isset($item['content']) )
	{
		$item['content'] = '';
	}

// rss  content:encoded
	if ( isset($item['encoded']) )
	{
		$item['encoded'] = '';
	}

	$raws = $this->_strings->convert_array_key_to_string($item);
	$this->setVar('raws', $raws);
}

function getRaws()
{
	$raws = $this->getVar('raws', 'n');
	return $this->_strings->convert_string_to_array_key($raws);
}

// --- class end ---
}

//=========================================================
// class feed handler
//=========================================================
class rssc_feed_handler extends rssc_db_base
{

// class
	var $_strings;

// constant
	var $_FLAG_SUBSUTUTE_DATE = true;

// input parameter
	var $_future_days = 3;	// 3 days

// result
	var $_fetch_datas  = array();
	var $_format_datas = array();

// counter
	var $_count_refresh_feed  = 0;

// debug
	var $_flag_force_overwrite = 0;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed_handler( $dirname )
{
	$this->rssc_db_base($dirname, 'rssc_feed_handler');

// class
	$this->_strings =& rssc_strings::getInstance();

// basic
	$this->_table = $this->_db->prefix( $dirname.'_feed' );
	$this->_id_name    = 'fid';
	$this->_class_name = 'rssc_feed';

	$this->_flag_debug_print_sql   = 0;
	$this->_flag_debug_print_error = 0;

}

//=========================================================
// Public
//=========================================================
//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function insert(&$obj, $force=false)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('feed table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('feed table: not clean');
		return false;
	}

	if ( !$obj->isNew() )
	{
		$this->_set_errors('feed table: not new');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'INSERT INTO '.$this->_table.' (lid, uid, mid, p1, p2, p3, site_title, site_link, title, link, entry_id, guid, updated_unix, published_unix, category, author_name, author_uri, author_email, type_cont, raws, content, search, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($site_title).', '.$this->_quote($site_link).', '.$this->_quote($title).', '.$this->_quote($link).', '.$this->_quote($entry_id).', '.$this->_quote($guid).', '.$updated_unix.', '.$published_unix.', '.$this->_quote($category).', '.$this->_quote($author_name).', '.$this->_quote($author_uri).', '.$this->_quote($author_email).', '.$this->_quote($type_cont).', '.$this->_quote($raws).', '.$this->_quote($content).', '.$this->_quote($search).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

	if ( !$result = $this->_query($sql, 0, 0, $force) ) 
	{	return false;	}

	if (empty($fid)) 
	{
		$fid = $this->_db->getInsertId();
	}

	return $fid;
}

function update(&$obj, $force=false)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('feed table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('feed table: not clean');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	if (empty($fid)) 
	{
		$this->_set_errors('feed table: not exist fid');
		return false;
	}

	$sql = 'UPDATE '.$this->_table.' SET lid='.$lid.', uid='.$uid.', mid='.$mid.', p1='.$p1.', p2='.$p2.', p3='.$p3.', site_title='.$this->_quote($site_title).', site_link='.$this->_quote($site_link).', title='.$this->_quote($title).', link='.$this->_quote($link).', updated_unix='.$updated_unix.', published_unix='.$published_unix.', category='.$this->_quote($category).', author_name='.$this->_quote($author_name).', author_uri='.$this->_quote($author_uri).', author_email='.$this->_quote($author_email).', type_cont='.$this->_quote($type_cont).', raws='.$this->_quote($raws).', content='.$this->_quote($content).', search='.$this->_quote($search).', aux_int_1='.$aux_int_1.', aux_int_2='.$aux_int_2.', aux_text_1='.$this->_quote($aux_text_1).', aux_text_2='.$this->_quote($aux_text_2).' WHERE fid='.$fid;

	if ( !$result = $this->_query($sql, 0, 0, $force) ) 
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_total()
{
	return $this->getCount();
}

function get_count_by_lid($lid)
{
	$criteria = new CriteriaCompo();
	$criteria->add( $this->get_addtion_by_lid($lid) );
	return $this->getCount($criteria);
}

function get_count_by_link($link)
{
	$criteria =& new CriteriaCompo();
	$criteria->add( $this->get_addtion_by_link($link) );
	return $this->getCount($criteria);
}

function &get_addtion_by_lid($lid)
{
	$addtion =& new Criteria('lid', $lid, '=');
	return $addtion;
}

function &get_addtion_by_link($link)
{
	$link = $link.'%';
	$addtion =& new Criteria('link', $link, 'LIKE');
	return $addtion;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	return $this->getObjects( $criteria );
}

function &get_objects_by_lid($lid, $limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$criteria->add( $this->get_addtion_by_lid($lid) );
	return $this->getObjects( $criteria );
}

function &get_objects_by_link($link, $limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$criteria->add( $this->get_addtion_by_link($link) );
	return $this->getObjects( $criteria );
}

function &get_latest($order='updated_unix DESC, fid DESC', $limit=0, $start=0)
{
	$feeds  = array();
	$future = $this->_get_future_time();

	$criteria = new CriteriaCompo();
	$criteria->setSort(  $order );
	$criteria->setLimit( $limit );
	$criteria->setStart( $start );
	$criteria->add( new Criteria('updated_unix',   $future, '<') );
	$criteria->add( new Criteria('published_unix', $future, '<') );

	$feed_objs = $this->getObjects( $criteria );

	if ( !$feed_objs )
	{
		return $feeds;
	}

	foreach ($feed_objs as $feed_obj) 
	{
		$feeds[] =& $feed_obj->getVarAll();
	}

	return $feeds;
}

//---------------------------------------------------------
// refresh
//---------------------------------------------------------
function refresh($lid, $uid, $mid, $p1, $p2, $p3, $item)
{
	$flag_err = false;

// return , if already exit
	if ( !$this->_flag_force_overwrite )
	{
		$criteria = new CriteriaCompo();
		$criteria->add( new Criteria('link', $item['link'], '=') );
		$criteria->add( new Criteria('updated_unix', $item['updated_unix'], '>=') );

		if ( $this->getCount($criteria) )
		{
			return true;
		}
	}

// delete old, if exist
	$criteria = new Criteria('link', $item['link'], '=');
	$feed_objs = $this->getObjects( $criteria );
	$ret1 = $this->_delete_table_bulk($feed_objs);

// add new
	$item_sub = $this->_subsutute_date($item);

	$feed_obj = $this->create();
	$feed_obj->setVar('lid', $lid);
	$feed_obj->setVar('uid', $uid);
	$feed_obj->setVar('mid', $mid);
	$feed_obj->setVar('p1',  $p1);
	$feed_obj->setVar('p2',  $p2);
	$feed_obj->setVar('p3',  $p3);
	$feed_obj->assignVars($item_sub);
	$feed_obj->setSearch($item);
	$feed_obj->setRaws($item);

	$ret2 = $this->_insert_table($feed_obj);
	$this->_count_refresh_feed ++;

	if (!$ret1 || !$ret2)
	{
		return false;
	}

	return true;
}

function set_force_overwrite($value)
{
	$this->_flag_force_overwrite = intval($value);
}

//---------------------------------------------------------
// clear
//---------------------------------------------------------
function clear_old_over_num($num)
{
	$num = intval($num);

	if ($num <= 0)
	{
		return 0;	// non
	}

	$total = $this->getCount();

	if ($total < $num)
	{
		return 0;	// non
	}

	$limit = $total - $num;
	$sort  = 'updated_unix ASC';

	$criteria = new CriteriaCompo();
	$criteria->getSort($sort);
	$criteria->setStart(0);
	$criteria->setLimit($limit);
	$feed_objs = $this->getObjects( $criteria );
	$this->_delete_table_bulk($feed_objs);

	return $limit;	// excute
}

//---------------------------------------------------------
// get feed
//---------------------------------------------------------
function &get_feed_by_fid($fid)
{
	$feed_obj  =& $this->get($fid);

	if ( !is_object($feed_obj) )
	{
		return false;
	}

	$feed =& $this->_get_feed_raws($feed_obj);
	return $feed;
}

//---------------------------------------------------------
// get feeds
//---------------------------------------------------------
function &get_feeds_by_lid($lid, $order='updated_unix DESC, fid DESC', $limit=0, $start=0)
{
	$feeds  = array();
	$future = $this->_get_future_time();

// set lid
	$criteria = new CriteriaCompo();
	$criteria->setSort(  $order );
	$criteria->setLimit( $limit );
	$criteria->setStart( $start );
	$criteria->add( new Criteria('lid', $lid, '=') );
	$criteria->add( new Criteria('updated_unix',   $future, '<') );
	$criteria->add( new Criteria('published_unix', $future, '<') );

	$feed_objs =& $this->getObjects( $criteria );

	if ( !$feed_objs )
	{
		return $feeds;
	}

	foreach ($feed_objs as $obj) 
	{
		$feeds[] =& $this->_get_feed_raws($obj);
	}

	return $feeds;
}

//---------------------------------------------------------
// search
//---------------------------------------------------------
function &get_feeds_by_where($where, $order='', $limit=0, $start=0)
{
	$future = $this->_get_future_time();

	$sql  = 'SELECT * FROM '.$this->_table;
	$sql .= ' WHERE '.$where;
	$sql .= ' AND updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;

	if ($order)
	{
		$sql .= ' ORDER BY '.$order;
	}
	else
	{
		$sql .= ' ORDER BY fid';
	}

	$feeds = array();

	$feed_objs =& $this->getObjectsBySql($sql, $limit, $start);

	if ( !$feed_objs )
	{
		return $feeds;
	}

	foreach ($feed_objs as $obj) 
	{
		$feeds[] =& $obj->getVarAll();
	}

	return $feeds;
}

function get_count_by_where($where)
{
	$future = $this->_get_future_time();

	$sql = 'SELECT COUNT(*) FROM '.$this->_table;
	$sql .= ' WHERE '.$where;
	$sql .= ' AND updated_unix <'.$future;
	$sql .= ' AND published_unix <'.$future;

	return $this->getCountBySql($sql);
}

//---------------------------------------------------------
// counter
//---------------------------------------------------------
function clear_count()
{
	$this->_count_refresh_feed = 0;
}

function get_count_refresh_feed()
{
	return $this->_count_refresh_feed;
}

//---------------------------------------------------------
// future days
//---------------------------------------------------------
function set_future($value)
{
	$this->_future_days = intval($value);
}

//=========================================================
// private
//=========================================================
function _insert_table( &$feed_obj )
{
// enable from GET method
	if ( $this->insert( $feed_obj, true ) )
	{
		return true;
	}
	else
	{
		$this->_set_errors( 'rssc: cannot insert feed' );
		$this->_set_errors( $this->getErrors() );
		return false;
	}
}

function _delete_table_bulk( $feed_objs )
{
	$flag_err = false;

	if ( $feed_objs )
	{
		foreach ( $feed_objs as $obj )
		{
			if ( !$this->_delete_table($obj) )
			{
				$flag_err = true;
			}
		}
	}

	if ($flag_err)
	{
		return false;
	}

	return true;
}

function _delete_table( &$feed_obj )
{
// enable from GET method
	if ( $this->delete( $feed_obj, true ) )
	{
		return true;
	}
	else
	{
		$this->_set_errors( 'rssc: cannot delete feed' );
		$this->_set_errors( $this->getErrors() );
		return false;
	}
}

function &_get_feed_raws( &$feed_obj )
{
	$feed_arr = $feed_obj->getVarAll();
	$raw_arr  = $feed_obj->getRaws();

	if ( !$raw_arr )
	{
		return $feed_arr;
	}

	$feed_new = $feed_arr;

	foreach ($raw_arr as $key => $value)
	{
		if (($key == 'content')||($key == 'encoded'))
		{
			$feed_new[$key] = $feed_arr['content'];
		}
		else
		{
			$feed_new[$key] = $value;
		}
	}

	return $feed_new;
}

//---------------------------------------------------------
// subsutute date
// some feed have no date
// subsutute by present time
//---------------------------------------------------------
function _subsutute_date($item)
{
// no action, if not flag
	if ( !$this->_FLAG_SUBSUTUTE_DATE )
	{
		return $item;
	}

	$time = time();

	if ( $item['updated_unix'] == 0 )
	{
		$item['updated_unix'] = $time;
	}

	if ( $item['published_unix'] == 0 )
	{
		$item['published_unix'] = $time;
	}

	return $item;
}

//---------------------------------------------------------
// get_future_time
// some feed have future date
// supress at showing
//---------------------------------------------------------
function _get_future_time()
{
	$time = time() + 86400 * $this->_future_days;
	return $time;
}

// --- class end ---
}

// === class end ===
}

?>