<?php
// $Id: rssc_form.php,v 1.1.1.1 2006/01/03 05:06:02 ohwada Exp $

//================================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('rssc_form') ) 
{

//=========================================================
// class rssc_form
//=========================================================
class rssc_form
{
// constant
	var $FORM_TITLE   = 'Config Setting';
	var $SUBMIT_VALUE = _GO;

// variable
	var $_form_name   = 'rssc';
	var $_token_name  = 'rssc';
	var $_op_name     = 'op';
	var $_submit_name = 'submit';
	var $_method      = 'post';

	var $_size      =  50;
	var $_maxlength = 255;
	var $_rows      =   5;
	var $_cols      =  50;

	var $_datas = array();

	var $_font_caption_title = "<span style='font-weight:bold;'>";
	var $_font_caption_desc  = "<span style='font-weight:normal;'>";
	var $_font_caption_title_end = "</span>";
	var $_font_caption_desc_end  = "</span>";

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_form()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_form();
	}

	return $instance;
}

//---------------------------------------------------------
// make table form
//---------------------------------------------------------
function make_table_start()
{
	return "<table width='100%' class='outer' cellspacing='1'>\n";
}

function make_table_title($title)
{
	return "<tr><th colspan='2'>".$title."</th></tr>\n";
}

function make_table_end()
{
	return "</table>\n";
}

function make_table_line($title='', $ele='', $title_class='head', $ele_class='odd')
{
	$text  = "<tr valign='top' align='left'><td class='$title_class'>$title</td>";
	$text .= "<td class='$ele_class'>$ele</td></tr>\n";
	return $text;
}

//---------------------------------------------------------
// make form box
//---------------------------------------------------------
function make_form_box($action='', $hidden_value='save', $submit_value='save')
{
	$text  = '';
	$text .= $this->make_form_start($this->_form_name, $action, $this->_method);
	$text .= $this->make_form_token($this->_token_name);
	$text .= $this->make_form_hidden($this->_op_name, $hidden_value);
	$text .= $this->make_form_submit($this->_submit_name, $submit_value);
	$text .= $this->make_form_end();
	return $text;
}

//---------------------------------------------------------
// make form
//---------------------------------------------------------
function make_form_start($name='', $action='', $method='post')
{
	if ( empty($name) )
	{
		$name = $this->_form_name;
	}

// restore form name
	$this->_form_name = $name;

	if ( empty($action) )
	{
		$action = xoops_getenv('PHP_SELF');
	}

// sanitize
	$action = $this->sanitize_html_url($action);

	return "<form name='$name' id='$name' action='$action' method='$method' >\n";
}

function make_form_end()
{
	return "</form>\n";
}

function make_form_token($name='')
{
	if ( !class_exists('XoopsMultiTokenHandler') )  return '';

	if ( empty($name) )
	{
		$name = $this->_token_name;
	}

	$token =& XoopsMultiTokenHandler::quickCreate($name);
	return $this->make_form_hidden($token->getTokenName(), $token->getTokenValue());
}

function make_form_radio_select($name, $value, $options, $del='')
{
	$text = '';

	foreach ($options as $opt_name => $opt_val)
	{
		$checked       = $this->make_checked($value, $opt_val);
		$opt_val_show  = $this->sanitize_html_text($opt_val);
		$opt_name_show = $this->sanitize_html_text($opt_name);
		$text .= $this->make_form_radio($name, $opt_val_show, $checked);
		$text .= " $opt_name_show ";
		$text .= $del;
	}

	return $text;
}

function make_form_checkbox_select($name, $value, $options)
{
	$text = '';

	foreach ($options as $opt_name => $opt_val)
	{
		$checked      = $this->make_checked($value, $opt_val);
		$opt_val_show = $this->sanitize_html_text($opt_val);
		$name_show    = $this->sanitize_html_text($name);
		$text .= $this->make_form_checkbox($name, $opt_val_show, $checked);
		$text .= " $name_show ";
	}

	return $text;
}

function make_form_select($name, $value, $options, $none=0, $none_name='---', $none_value='')
{
	$text = "<select name='$name'>\n";

	if ($none)
	{
		$text .= "<option value='$none_value' >$none_name</option>\n";
	}

	foreach ($options as $opt_name => $opt_val)
	{
		$selected = '';
		if ($value == $opt_val)
		{
			$selected = "selected='selected'";
		}

		$text .= "<option value='$opt_val' $selected >$opt_name</option>\n";
	}

	$text .= "</select>\n";
	return $text;
}

function make_form_text($name, $value, $size=50, $maxlength=255)
{
	return "<input type='text' name='$name' value='$value' size='$size' maxlength='$maxlength' />\n";
}

function make_form_textarea($name, $value, $rows=5, $cols=50)
{
	$text  = "<textarea name='$name' rows='$rows' cols='$cols' >\n";
	$text .= $value;
	$text .= "</textarea>\n";
	return $text;
}

function make_form_radio($name, $value, $checked='', $extra='')
{
	return "<input type='radio' name='$name' id='$name'  value='$value' $checked $extra />\n";
}

function make_form_checkbox($name, $value, $checked='', $extra='')
{
	return "<input type='checkbox' name='$name' id='$name' value='$value' $checked $extra />\n";
}

function make_form_hidden($name, $value)
{
	return "<input type='hidden' name='$name' value='$value' />\n";
}

function make_form_submit($name, $value)
{
	return "<input type='submit' name='$name' value='$value' />\n";
}

function make_form_button($name, $value, $extra='')
{
	return "<input type='button' name='$name' value='$value' $extra />\n";
}

function make_form_cancel_button($name, $value)
{
	$extra = " onclick=\"javascript:history.go(-1)\" ";
	return $this->make_form_button($name, $value, $extra);
}

function make_checked($val1, $val2)
{
	if ( isset($val1) && ( $val1 == $val2 ) )
	{
		return 'checked';
	}

	return '';
}

//---------------------------------------------------------
// complex form
//---------------------------------------------------------
function make_form_radio_yesno($name, $value)
{
	$options = array( _YES => 1, _NO => 0 );
	$text    = $this->make_form_radio_select($name, $value, $options);
	return $text;
}

function make_form_checkbox_yesno($name, $value)
{
// check, if yes
	$checked = $this->make_checked($value, 1);
	$text    = $this->make_form_checkbox($name, 1, $checked);
	return $text;
}

//---------------------------------------------------------
// XOOPS JavaScript
//---------------------------------------------------------
function make_js_checkall()
{
	$form_name = $this->_form_name;
	$checkall  = $this->_form_name."_checkall";

	$extra = "onclick='xoopsCheckAll(\"" .$form_name. "\", \"" .$checkall. "\")' ";
	return $this->make_form_checkbox($checkall, '', '', $extra);
}

function make_js_checkbox($value)
{
	$name = $this->_form_name."_id[]";
	return $this->make_form_checkbox($name, $value);
}

//---------------------------------------------------------
// make data form
//---------------------------------------------------------
function make_data_table_label_hidden($caption, $key)
{
	$value  = $this->get_data_value($key);
	$ele  = $value.' ';
	$ele .= $this->make_form_hidden($key, $value);
	return $this->make_table_line($caption, $ele);
}

function make_data_table_label($caption, $key)
{
	$ele = $this->get_data_value($key);
	return $this->make_table_line($caption, $ele);
}

function make_data_table_text($caption, $key)
{
	$ele = $this->make_data_text($key);
	return $this->make_table_line($caption, $ele);
}

function make_data_table_textarea($caption, $key)
{
	$ele = $this->make_data_textarea($key);
	return $this->make_table_line($caption, $ele );
}

function make_data_table_radio_yesno($caption, $key)
{
	$ele = $this->make_data_radio_yesno($key);
	return $this->make_table_line($caption, $ele );
}

function make_data_text($key)
{
	$value = $this->get_data_value($key);
	return $this->make_form_text($key, $value, $this->_size, $this->_maxlength);
}

function make_data_textarea($key)
{
	$value = $this->get_data_value($key);
	return $this->make_form_textarea($key, $value, $this->_rows, $this->_cols);
}

function make_data_radio_yesno($key)
{
	$value = $this->get_data_value($key);
	return $this->make_form_radio_yesno($key, $value, $this->_rows, $this->_cols);
}

function get_data_value($key)
{
	if ( isset($this->_datas[$key]) )
	{
		return $this->_datas[$key];
	}

	return '';
}


//---------------------------------------------------------
// make html
//---------------------------------------------------------
function make_html_url_link($url, $name='', $target='')
{
// sanitize
	$url = $this->sanitize_html_url($url);

	if ( $url && $name && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='".$url."'>".$name."</a>";
	}
	elseif ( $url && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

function make_html_img($image_url, $width=0, $height=0, $border=0, $alt='image')
{
// sanitize
	$image_url = $this->sanitize_html_url($image_url);

	$text  = "<img ";
	$text .= "src='$image_url' ";

	if ($width)
	{
		$text .= "width='$width' ";
	}

	if ($height)
	{
		$text .= "height='$height' ";
	}

	$text .= "border='$border' ";
	$text .= "alt='$alt' ";
	$text .= "/>";

	return $text;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function make_caption($title, $desc='')
{
	$text = '';

	if ( $title)
	{
		if ($this->_font_caption_title)
		{
			$text .= $this->_font_caption_title . $title . $this->_font_caption_title_end;
		}
		else
		{
			$text .= $title;
		}

	}
	
	if ( $desc )
	{
		if ( $title)
		{
			$text .= "<br /><br />\n";
		}

		if ($this->_font_caption_desc)
		{
			$text .= $this->_font_caption_desc . $desc. $this->_font_caption_desc_end;
		}
		else
		{
			$text .= $desc;
		}
	}

	return $text;
}

//---------------------------------------------------------
// sanitize
//---------------------------------------------------------
function sanitize_html_text($text)
{
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

function sanitize_html_url($text)
{
	$text = preg_replace('/javascript:/si', 'java script:', $text);
	$text = preg_replace('/&amp;/i', '&', $text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	return $text;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_form_title($value)
{
	$this->FORM_TITLE = $value;
}

function set_submit_value($value)
{
	$this->SUBMIT_VALUE = $value;
}

function set_form_name($value)
{
	$this->_form_name = $value;
}

function set_token_name($value)
{
	$this->_token_name = $value;
}

function set_op_name($value)
{
	$this->_op_name = $value;
}

function set_submit_name($value)
{
	$this->_submit_name = $value;
}

function set_method($value)
{
	$this->_method = $value;
}

function set_size($value)
{
	$this->_size = intval($value);
}

function set_maxlength($value)
{
	$this->_maxlength = intval($value);
}

function set_rows($value)
{
	$this->_rows = intval($value);
}

function set_cols($value)
{
	$this->_text_cols = intval($value);
}

function set_datas($value)
{
	$this->_datas = $value;
}

// --- class end ---
}

// === class end ===
}

?>