<?php
// $Id: rssc_link_handler.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// this file contain 2 class
//   rssc_link
//   rssc_link_handler
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_link_handler') ) 
{

//=========================================================
// class link
//=========================================================
class rssc_link extends XoopsObject
{
// class
	var $_strings;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_link()
{
	$this->XoopsObject();
	$this->initVar('lid', XOBJ_DTYPE_INT, null, false);
	$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p1',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p2',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p3',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('title',  XOBJ_DTYPE_TXTBOX, null, true, 255);
	$this->initVar('url',    XOBJ_DTYPE_TXTBOX, null, true, 255);
	$this->initVar('ltype',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('refresh',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('headline',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mode',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rdf_url',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('rss_url',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('atom_url', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('encoding',  XOBJ_DTYPE_TXTBOX, null, false);
	$this->initVar('updated_unix',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('channel', XOBJ_DTYPE_TXTAREA);
	$this->initVar('xml', XOBJ_DTYPE_SOURCE, null, false);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

// class
	$this->_strings =& rssc_strings::getInstance();
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &getVarAll($format='n')
{
	return array(
		'lid' => $this->getVar('lid', $format),
		'uid' => $this->getVar('uid', $format),
		'mid' => $this->getVar('mid', $format),
		'p1'  => $this->getVar('p1',  $format),
		'p2'  => $this->getVar('p2',  $format),
		'p3'  => $this->getVar('p3',  $format),
		'title'     => $this->getVar('title', $format),
		'url'       => $this->getVar('url',   $format),
		'ltype'     => $this->getVar('ltype', $format),
		'refresh'   => $this->getVar('refresh',  $format),
		'headline'  => $this->getVar('headline', $format),
		'mode'      => $this->getVar('mode',      $format),
		'rdf_url'   => $this->getVar('rdf_url',   $format),
		'rss_url'   => $this->getVar('rss_url',   $format),
		'atom_url'  => $this->getVar('atom_url',  $format),
		'encoding'  => $this->getVar('encoding',  $format),
		'channel'   => $this->getVar('channel',   $format),
		'xml'       => $this->getVar('xml',       $format),
		'updated_unix' => $this->getVar('updated_unix',   $format),
	);
}

function get_rssurl_by_mode($format='n')
{
	$mode = $this->getVar('mode');

	switch ($mode)
	{
		case RSSC_C_MODE_RDF:
			return $this->getVar('rdf_url', $format);
			break;

		case RSSC_C_MODE_RSS:
			return $this->getVar('rss_url', $format);
			break;

		case RSSC_C_MODE_ATOM:
			return $this->getVar('atom_url', $format);
			break;
	}

	return false;
}

function refreshExpired()
{
	if ( time() > ( $this->getVar('refresh') + $this->getVar('updated_unix') ) )
	{
		return true;
	}

	return false;
}

function setChannel($channel)
{
	$strings =& rssc_strings::getInstance();
	$value   =  $this->_strings->convert_array_key_to_string($channel);
	$this->setVar('channel', $value);
}

function &getChannel($format='n')
{
	$strings =& rssc_strings::getInstance();
	$channel =  $this->getVar('channel', 'n');
	return $this->_strings->convert_string_to_array_key($channel, $format);
}

// --- class end ---
}

//=========================================================
// class link handler
//=========================================================
class rssc_link_handler extends rssc_db_base
{
// class
	var $_strings;

// link table
	var $_link_datas = array();
	var $_link_lid;
	var $_link_obj;

// basic config
	var $_flag_xml_save = 1;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_link_handler( $dirname )
{
	$this->rssc_db_base($dirname, 'rssc_link_handler');

// class
	$this->_strings =& rssc_strings::getInstance();

// basic function
	$this->_table      = $this->_db->prefix( $dirname.'_link' );
	$this->_id_name    = 'lid';
	$this->_class_name = 'rssc_link';

	$this->_flag_debug_print_sql   = 0;
	$this->_flag_debug_print_error = 0;

}

//=========================================================
// Public
//=========================================================
//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function insert(&$obj, $force=false)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('link table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('link table: not clean');
		return false;
	}

	if ( !$obj->isNew() )
	{
		$this->_set_errors('link table: not new');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'INSERT INTO '.$this->_table.' (uid, mid, p1, p2, p3, title, url, ltype, rdf_url, rss_url, atom_url, mode, encoding, refresh, headline, updated_unix, channel, xml, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).','.$ltype.', '.$this->_quote($rdf_url).', '.$this->_quote($rss_url).', '.$this->_quote($atom_url).', '.$mode.', '.$this->_quote($encoding).', '.$refresh.', '.$headline.', 0, '.$this->_quote($channel).', '.$this->_quote($xml).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

	if ( !$result = $this->_query($sql, 0, 0, $force) ) 
	{	return false;	}

	if (empty($lid)) 
	{
		$lid = $this->_db->getInsertId();
	}

	return $lid;
}

function update(&$obj, $force=false)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('link table: not class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('link table: not clean');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	if (empty($lid))
	{
		$this->_set_errors('link table: not exist lid');
		return false;
	}

	$sql = 'UPDATE '.$this->_table.' SET uid='.$uid.', mid='.$mid.', p1='.$p1.', p2='.$p2.', p3='.$p3.', title='.$this->_quote($title).', url='.$this->_quote($url).', ltype='.$ltype.', rdf_url='.$this->_quote($rdf_url).', rss_url='.$this->_quote($rss_url).', atom_url='.$this->_quote($atom_url).', mode='.$mode.', encoding='.$this->_quote($encoding).', refresh='.$refresh.', headline='.$headline.', updated_unix='.$updated_unix.', channel = '.$this->_quote($channel).', xml = '.$this->_quote($xml).', aux_int_1='.$aux_int_1.', aux_int_2='.$aux_int_2.', aux_text_1='.$this->_quote($aux_text_1).', aux_text_2='.$this->_quote($aux_text_2).' WHERE lid='.$lid;

	if ( !$result = $this->_query($sql, 0, 0, $force) ) 
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// refresh
//---------------------------------------------------------
function update_xml_url($lid, $mode, $rdf_url, $rss_url, $atom_url)
{
	if ( !$link = $this->get($lid) )
	{
		return false;
	}

	$link->setVar('mode',     $mode);
	$link->setVar('rdf_url',  $rdf_url);
	$link->setVar('rss_url',  $rss_url);
	$link->setVar('atom_url', $atom_url);

// enable from GET method
	if ( $this->update( $link, true ) )
	{
		return true;
	}
	else
	{
		$this->_set_errors( 'rssc: cannot update link rssurl' );
		$this->_set_errors( $this->getErrors() );
		return false;
	}

}

function update_encoding($lid, $encoding)
{
	if ( !$link = $this->get($lid) )
	{
		return false;
	}

	$link->setVar('encoding', $encoding );

// enable from GET method
	if ( $this->update( $link, true ) )
	{
		return true;
	}
	else
	{
		$this->_set_errors( 'rssc:  cannot update link encoding' );
		$this->_set_errors( $this->getErrors() );
		return false;
	}
}

function update_xml($lid, $channel, $xml_data, $updated='' )
{
	if ( !$link = $this->get($lid) )
	{
		return false;
	}

// refresh channel to link table
	if ( empty($updated) )
	{
		$updated = $time();
	}

// refresh XML cache
	if ( $this->_flag_xml_save )
	{
		$link->setVar('xml', $xml_data );
	}

	$link->setVar('updated_unix', $updated );
	$link->setChannel( $channel );

// enable from GET method
	if ( $this->update( $link, true ) )
	{
		return true;
	}
	else
	{
		$this->_set_errors( 'rssc:  cannot update link xml' );
		$this->_set_errors( $this->getErrors() );
		return false;
	}
}

function &get_channel_by_lid($lid)
{
	if ( !$link = $this->get($lid) )
	{
		return false;
	}

	return $link->getChannel();
}

function set_xml_save($value)
{
	$this->_flag_xml_save = intval($value);
}

//---------------------------------------------------------
// headline
//---------------------------------------------------------
function &get_headline_lids($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$criteria->setSort('headline ASC');
	$criteria->add( new Criteria('headline', 0, '>') );
	$link_objs = $this->getObjects($criteria);

	$lids = array();

	if ( $link_objs )
	{
		foreach ($link_objs as $obj)
		{
			$lids[] = $obj->getVar('lid');
		}
	}

	return $lids;
}

function get_sanitized_headline_links($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$criteria->setSort('headline ASC');
	$criteria->add( new Criteria('headline', 0, '>') );
	$link_objs = $this->getObjects($criteria);

	$links = array();

	if ( $link_objs )
	{
		foreach ($link_objs as $obj)
		{
			$links[] =& $this->_sanitize_link($obj);
		}
	}

	return $links;
}

function &get_sanitized_link_by_lid($lid)
{
	$link_obj = $this->get($lid);

	if ( !is_object($link_obj) )
	{
		return false;
	}

	return $this->_sanitize_link($link_obj);
}

//---------------------------------------------------------
// format
//---------------------------------------------------------
function &add_ltype_items($item_arr)
{
	$data = array();

	foreach ($item_arr as $item)
	{
		$data[] =& $this->add_ltype_item($item);
	}

	return $data;
}

function &add_ltype_item($item)
{
	$data = $item;
	$data['ltype'] = $this->_get_item_ltype( $item );
	return $data;
}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// link object
//---------------------------------------------------------
function _set_lid($lid)
{
	$lid = intval($lid);
	if ($lid < 0)
	{
		$this->_set_errors( 'rssc: lid not above zero' );
		return false;
	}

	$this->_link_lid = $lid;
	return true;
}

function _get_link_obj($lid)
{
	if ( !$this->_set_lid($lid) )
	{
		$this->_set_errors( 'rssc: lid not above zero' );
		return false;
	}

	$link_obj =& $this->get($lid);

	if ( !is_object($link_obj) )
	{
		$this->_set_errors( 'rssc: link object not exist' );
		return false;
	}

	$this->_link_obj  = $link_obj;

	return $link;
}

//---------------------------------------------------------
// link data
//---------------------------------------------------------
function &_sanitize_link(&$link_obj)
{
	$link = $link_obj->getVarAll('s');
	$link['url_xml'] = $link_obj->get_rssurl_by_mode('s');
	$link['icon']    = $this->_get_icon( $link['mode'] );
	$time = $link['updated_unix'];
	$link['updated_l'] = $this->_strings->format_time( $time, 'mysql' );
	$link['updated_s'] = $this->_strings->format_time( $time, 's' );
	return $link;
}

function _get_icon($mode)
{
	switch ($mode)
	{
		case RSSC_C_MODE_RDF:
			return 'rdf.png';
			break;

		case RSSC_C_MODE_RSS:
			return 'rss.png';
			break;

		case RSSC_C_MODE_ATOM:
			return 'atom.png';
			break;
	}

	return false;
}

//---------------------------------------------------------
// format
//---------------------------------------------------------
function _get_item_ltype($item)
{
	if ( isset($item['lid']) )
	{
		$link_obj = $this->get( $item['lid'] );

		if ( is_object($link_obj) )
		{
			return $link_obj->getVar('ltype');
		}
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>