<?php
// $Id: rssc_parser_base.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

//=========================================================
// Rss Center Module
// class rss_atom_parser_base
// for PHP gennerally
// this file contain 2 class
//   rssc_parser_base
//   rssc_parser_element_base
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_parser_base') ) 
{

//=========================================================
// class rssc_parser_base
//=========================================================
class rssc_parser_base extends rssc_error
{
	var $_encoding = 'UTF-8';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_parser_base()
{
	$this->rssc_error();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_parser_base();
	}

	return $instance;
}


//---------------------------------------------------------
// function
//---------------------------------------------------------
function setEncoding($encoding)
{
	$encoding = strtoupper($encoding);

	if (($encoding == 'UTF-8')||($encoding == 'US-ASCII')||($encoding == 'ISO-8859-1'))
	{
		$this->_encoding = $encoding;
	}
}

// --- class end ---
}

//=========================================================
// class parser_element_base
//=========================================================
class rssc_parser_element_base
{

// local variable
	var $_data_arr = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_parser_element_base()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_parser_element_base();
	}

	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function clear_vars()
{
	$this->_data_arr = array();
}

function set_var($key, $value)
{
	$this->_data_arr[$key] = $value;
}

function get_var($key)
{
	if ( isset($this->_data_arr[$key]) )
	{
		return $this->_data_arr[$key];
	}
}

function set_var_array($arr)
{
	if ( !is_array($arr) )  return false;

	foreach ($arr as $key => $value)
	{
		$this->_data_arr[$key] = $value;
	}
}

//--------------------------------------------------------
// get unixtime from RFC822
//--------------------------------------------------------
function get_unixtime_rfc822( $datetime )
{
	$unixtime = strtotime($datetime);

// maybe undefined time zone
	if ($unixtime == -1)
	{

// delete time zone
		$datetime = preg_replace("/ [a-zA-Z]{3,}$/", '', $datetime);
		$unixtime = strtotime( $datetime );

// give up
		if ($unixtime == -1)
		{
			$unixtime = 0;
		}
	}

	return $unixtime;
}

// -------------------------------------------------------------------------
// http://www.arielworks.net/articles/2004/0224c/
// array parse_w3cdtf(string datetime)
// -------------------------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
//  Year:
//      YYYY (eg 1997)
//   Year and month:
//      YYYY-MM (eg 1997-07)
//   Complete date:
//      YYYY-MM-DD (eg 1997-07-16)
//   Complete date plus hours and minutes:
//      YYYY-MM-DDThh:mmTZD (eg 1997-07-16T19:20+01:00)
//   Complete date plus hours, minutes and seconds:
//      YYYY-MM-DDThh:mm:ssTZD (eg 1997-07-16T19:20:30+01:00)
//   Complete date plus hours, minutes, seconds and a decimal fraction of a second
//      YYYY-MM-DDThh:mm:ss.sTZD (eg 1997-07-16T19:20:30.45+01:00)
// -------------------------------------------------------------------------
function get_unixtime_w3cdtf($datetime)
{
	$arr = $this->parse_w3cdtf($datetime);
	return $arr['timestamp'];
}

function parse_w3cdtf($datetime)
{

// 2004-10-24 K.OHWADA
// suppress warning
	$year     = 0;
    $month    = 0;
    $day      = 0;
    $hour     = 0;
    $minute   = 0;
    $second   = 0;
    $fraction = 0;
    $timezone = 0;
	$offset_sign   = 0;
    $offset_hour   = 0;
    $offset_minute = 0;

    // Year
    if(preg_match("/^(\d{4})$/", $datetime, $val)) {
        $year = $val[1];

    // Year and month
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];

    // Complete date
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];

    // Complete date plus hours and minutes
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $timezone = $val[6];

    // Complete date plus hours, minutes and seconds
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $second = $val[6];
        $timezone = $val[7];

    // Complete date plus hours, minutes, seconds and a decimal fraction of a second
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9]).([0-9]+)(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $second = $val[6];
        $fraction = $val[7];
        $timezone = $val[8];

    // Not W3C-DTF
    } else {
        return false;
    }

    // Offset of Timezone for gmmktime()
    if($timezone != "Z") {
        $offset_sign = substr($timezone, 0, 1);
        $offset_hour = substr($timezone, 1, 2);
        $offset_minute = substr($timezone, 4, 2);
    }

    $timestamp = gmmktime($hour - ($offset_sign . $offset_hour), $minute - ($offset_sign . $offset_minute), $second, $month, $day, $year);

    $result = array("year" => $year, "month" => $month, "day" => $day,
                    "hour" => $hour, "minute" => $minute, "second" => $second,
                    "fraction" => $fraction, "timezone" => $timezone, "timestamp" => $timestamp);

    return $result;
}


//---------------------------------------------------------
// ATOM 0.3 -> 1.0
//---------------------------------------------------------
function get_atom_updated($data)
{
	if ( isset($data['updated']) )
	{
		return $data['updated'];
	}
	elseif ( isset($data['modified']) )
	{
		return $data['modified'];
	}

	return false;
}

function get_atom_published($data)
{
	if ( isset($data['published']) )
	{
		return $data['published'];
	}
	elseif ( isset($data['issued']) )
	{
		return $data['issued'];
	}

	return false;
}

function get_atom_author_uri($data)
{
	if ( isset($data['author_uri']) )
	{
		return $data['author_uri'];
	}
	elseif ( isset($data['author_url']) )
	{
		return $data['author_url'];
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>