<?php
// $Id: rssc_remote_file.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

// 2006-01-20 K.OHWADA
// remove remote_image

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_remote_file') ) 
{

//---------------------------------------------------------
// define constant
//---------------------------------------------------------
define('RSSC_REMOTE_E_EMPTY_URL',  100);
define('RSSC_REMOTE_E_NOT_FOPEN',  101);
define('RSSC_REMOTE_E_NOT_FCLOSE', 102);
define('RSSC_REMOTE_E_NOT_FWRITE', 104);
define('RSSC_REMOTE_E_NO_RESULT',  105);

define('RSSC_SNOPPY_E_NOT_FETCH', 110);
define('RSSC_SNOPPY_E_NO_RESULT', 111);

//=========================================================
// class rssc_remote_file
// use class snoopy
//=========================================================
class rssc_remote_file
{
// class instance
	var $_snoopy;

// file pointer
	var $_fp;

// variable
	var $_flag_allow_url_fopen;
	var $_error_code = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_remote_file()
{

// class instance
	$this->_snoopy = new Snoopy();

// allow_url_fopen
	$this->_flag_allow_url_fopen = ini_get('allow_url_fopen');

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_remote_file();
	}

	return $instance;
}


//---------------------------------------------------------
// check_url
//---------------------------------------------------------
function check_url($url)
{
	$this->_error_code = 0;

	if ( empty($url) )
	{
		$this->_error_code = RSSC_REMOTE_E_EMPTY_URL;
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		return $this->_check_url_local( $url );
	}
// not allow_url_fopen
	else
	{
		return $this->_check_url_remote( $url );
	}
}

function _check_url_local($url)
{
	if ( $this->_fopen($url, "r") )
	{
		$this->_fclose();
		return true;
	}
	else
	{
		return false;
	}
}


//=========================================================
// read_file
//=========================================================
function read_file($url)
{
	$this->_error_code = 0;

	if ( empty($url) )
	{
		$this->_error_code = RSSC_REMOTE_E_EMPTY_URL;
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		return $this->_read_file_local( $url );
	}
// not allow_url_fopen
	else
	{
		return $this->_read_file_remote( $url );
	}

}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function getErrorCode()
{
	return $this->_error_code;
}

//=========================================================
// private function
//=========================================================
//---------------------------------------------------------
// open & close file
//---------------------------------------------------------
function _fopen( $filename, $mode )
{
	$this->_fp = false;

	$fp = fopen($filename, $mode);

	if ( !$fp )
	{
		$this->_error_code = RSSC_REMOTE_E_NOT_FOPEN;
		return false;
	}

	$this->_fp = $fp;
	return $fp;
}

function _fclose()
{
	if ( !$this->_fp )  return false;

	if ( fclose($this->_fp) )
	{
		return true;
	}
	else
	{
		$this->_error_code = RSSC_REMOTE_E_NOT_FCLOSE;
		return false;
	}
}

//---------------------------------------------------------
// read file
//---------------------------------------------------------
function _read_file_local( $filename )
{
	$fp = $this->_fopen( $filename, "r" );
	if ( !$fp )
	{
		return false;
	}

	$content = $this->_fread();
	$this->_fclose();

	return $content;
}

function _fread()
{
	if ( !$this->_fp )  return false;

	$content = '';

	do 
	{
		$data = fread($this->_fp, 8192);
		if ( strlen($data) == 0 )  break;
		$content .= $data;
	} while(true);

	if ($content)
	{
		return $content;
	}
	else
	{
		$this->_error_code = RSSC_REMOTE_E_NO_RESULT;
		return false;
	}
}

//---------------------------------------------------------
// write file
//---------------------------------------------------------
function _write_file( $filename, $data )
{
	$fp = $this->_fopen( $filename, "w" );
	if ( !$fp )
	{
		return false;
	}

	$ret = $this->_fwrite($data);
	$this->_fclose();

	return $ret;
}

function _write($data)
{
	if ( fwrite($this->_fp, $data) )
	{
		return true;
	}
	else
	{
		$this->_error_code = RSSC_REMOTE_E_NOT_FWRITE;
		return false;
	}
}

//=========================================================
// use class spoopy
//=========================================================
function _check_url_remote( $url )
{
	return $this->_snoppy_fetch( $url );
}

function _read_file_remote( $url )
{
	return $this->_snoppy_fetch( $url );
}

function _snoppy_fetch( $url )
{
	if ( $this->_snoopy->fetch( $url ) )
	{
		$res = $this->_snoopy->results;

		if ($res)
		{
			return $res;
		}
		else
		{
			$this->_error_code = RSSC_SNOPPY_E_NO_RESULT;
			return false;
		}
	}
	else
	{
		$this->_error_code = RSSC_SNOPPY_E_NOT_FETCH;
		return false;
	}
}

//----- class end -----
}

// === class end ===
}

?>