<?php
// $Id: rssc_rss_parser.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

//=========================================================
// Rss Center Module
// class for RSS Parser 
// for PHP gennerally
// this file contain 1 xml parser & 3 class
//   rssc_rss_xml_xxx
//   rssc_rss_parser
//   rssc_rss_parser_channel
//   rssc_rss_parser_item
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_rss_parser') ) 
{

//---------------------------------------------------------
// RDF Site Summary 1.0 Modules: Content
// http://web.resource.org/rss/1.0/modules/content/

// RSS 2.0 Specification
// http://blogs.law.harvard.edu/tech/rss

// Dublin Core Metadata Element Set
// http://dublincore.org/documents/dces/
//---------------------------------------------------------

//--------------------------------------------------------
// undefined time zone
//
// http://www.xoopstotal.com.br/backend.php
// <lastBuildDate>Tue, 21 Dec 2004 21:21:09 BRT</lastBuildDate> 
//--------------------------------------------------------

//--------------------------------------------------------
// channel contains items
// item is in the outside of channel
//
// http://pear.php.net/feeds/latest.rss
// <channel rdf:about="http://pear.php.net/">
//   <link>http://pear.php.net/</link> 
//   <items>
//     <rdf:Seq>
//       <rdf:li rdf:resource="xxx" /> 
//     </rdf:Seq>
//   </items>
//   <title>PEAR: Latest releases</title> 
// </channel>
// <item rdf:about="xxx">
//   <title>Log 1.8.7</title> 
//   <link>http://pear.php.net/package/Log/download/1.8.7/</link> 
// </item>

//--------------------------------------------------------

//--------------------------------------------------------
// encoding isn't UTF-8
//
// http://mori-umi.net/index.rdf
// ?xml version="1.0" encoding="EUC-JP" ? 
//--------------------------------------------------------

//--------------------------------------------------------
// element encoded
//
// http://shibuya.pm.org/blosxom/index.rss10
// <content:encoded>
// <![CDATA[ 
//   Shibuya Perl Mongers Presents
// ]]> 
// </content:encoded>
//---------------------------------------------------------

//=========================================================
// global function
//=========================================================
//  $rssc_rss_xml_channel
//  $rssc_rss_xml_items
//  $rssc_rss_xml_item_num
//  $rssc_rss_xml_uris;
//  $rssc_rss_xml_parent
//  $rssc_rss_xml_current

//---------------------------------------------------------
// start element handler
//---------------------------------------------------------
function rssc_rss_xml_start_element($parser, $name, $attrs)
{
	global $rssc_rss_xml_parent, $rssc_rss_xml_parent_num, $rssc_rss_xml_uris;
	global $rssc_rss_xml_channel, $rssc_rss_xml_items, $rssc_rss_xml_item_num;

//  echo "<br>\n";
//  echo "parent:  $rssc_rss_xml_parent <br>\n";
//  echo "current: $rssc_rss_xml_current <br>\n";
//  echo "name:    $name <br>\n";
//  print_r($attrs);
//  echo "<br>\n";

	$parent = $rssc_rss_xml_parent[$rssc_rss_xml_parent_num];

	$parent_num_prev = $rssc_rss_xml_parent_num - 1;
	if ($parent_num_prev < 0)  $parent_num_prev = 0;
	$parent_prev = $rssc_rss_xml_parent[$parent_num_prev];

	$name_ns = split(':',$name);
	$name_wk = array_pop($name_ns);
	$uri1 = implode($name_ns,":");

	$name_low = strtolower( $name_wk );

	$flag = 0;
	foreach($rssc_rss_xml_uris as $uri2)
	{
  		if ($uri1 == $uri2)
  		{
    		$flag = 1;
    		break;
  		}
	}

// CHANNEL
	if ( $name_wk == 'CHANNEL' )
	{
		$rssc_rss_xml_parent_num = 0;
		$rssc_rss_xml_parent[0]  = $name_wk;
		return;
	}

// increment parent
	if ( $flag || empty($uri1) )
	{
		$rssc_rss_xml_parent_num ++;
		$rssc_rss_xml_parent[$rssc_rss_xml_parent_num] = $name_wk;
	}

}

//---------------------------------------------------------
// end element handler
//---------------------------------------------------------
function rssc_rss_xml_end_element($parser, $name)
{
	global $rssc_rss_xml_parent, $rssc_rss_xml_parent_num, $rssc_rss_xml_item_num, $rssc_rss_xml_items, $rssc_rss_xml_uris;

	$parent = $rssc_rss_xml_parent[$rssc_rss_xml_parent_num];

	$parent_num_prev = $rssc_rss_xml_parent_num - 1;
	if ($parent_num_prev < 0)  $parent_num_prev = 0;
	$parent_prev = $rssc_rss_xml_parent[$parent_num_prev];

	$name_ns = split(':',$name);
	$name_wk = array_pop($name_ns);
	$uri1 = implode($name_ns,":");

//	echo "<br>\n";
//	echo "parent num : $rssc_rss_xml_parent_num <br>\n";
//	echo "parent prev: $parent_prev <br>\n";
//	echo "parent  :    $parent <br>\n";
//	echo "current :    $name_wk <br>\n";

	$flag = 0;
	foreach($rssc_rss_xml_uris as $uri2)
	{
  		if ($uri1 == $uri2)
  		{
			$flag = 1;
    		break;
  		}
	}

// decrement parent
	if (( $flag || empty($uri1) )&&( $parent == $name_wk ))
	{
		$rssc_rss_xml_parent_num --;
		if ($rssc_rss_xml_parent_num < 0)  $rssc_rss_xml_parent_num = 0;

      	if ($name_wk == 'ITEM')
      	{
      		$rssc_rss_xml_item_num ++;
      	}
	}

}

//---------------------------------------------------------
// character data handler
//---------------------------------------------------------
function rssc_rss_xml_character_data($parser, $data) 
{
	global $rssc_rss_xml_parent, $rssc_rss_xml_parent_num, $rssc_rss_xml_channel, $rssc_rss_xml_image, $rssc_rss_xml_items, $rssc_rss_xml_item_num;

	$parent_0 = '';
	$parent_1 = '';
	$parent_2 = '';
	if ( isset($rssc_rss_xml_parent[0]) )	$parent_0 = $rssc_rss_xml_parent[0];
	if ( isset($rssc_rss_xml_parent[1]) )	$parent_1 = $rssc_rss_xml_parent[1];
	if ( isset($rssc_rss_xml_parent[2]) )	$parent_2 = $rssc_rss_xml_parent[2];

	$current     = $rssc_rss_xml_parent[$rssc_rss_xml_parent_num];
	$current_low = strtolower( $current );
	$data        = trim($data);

//	echo "<br>\n";
//	echo "parent num: $rssc_rss_xml_parent_num <br>\n";
//	echo "parent 0:   $parent_0 <br>\n";
//	echo "parent 1:   $parent_1 <br>\n";
//	echo "parent 2:   $parent_2 <br>\n";
//	echo "current :   $current <br>\n";
//	echo "data:       $data <br>\n";
//	print_r($rssc_rss_xml_items);
//	echo "<hr>\n";

//	if ($parent_0 != 'CHANNEL')  return;

	switch($parent_1)
	{
// ITEM
		case 'ITEM':
			switch($current)
			{
				case 'TITLE':
				case 'LINK':
				case 'DESCRIPTION':
				case 'AUTHOR':
				case 'CATEGORY':
				case 'COMMENTS':
				case 'ENCLOSURE':
				case 'GUID':
				case 'PUBDATE':
				case 'SOURCE':

// dc:xxx
//				case 'TITLE':
				case 'CREATOR':
				case 'SUBJECT':
//				case 'DESCRIPTION':
				case 'PUBLISHER':
				case 'CONTRIBUTOR':
				case 'DATE':
				case 'TYPE':
				case 'FORMAT':
				case 'IDENTIFIER':
//				case 'SOURCE':
				case 'LANGUAGE':
				case 'RELATION':
				case 'COVERAGE':
				case 'RIGHTS':

// content:encoded
    			case 'ENCODED':

// others
				case 'SRC':
				case 'WIDTH':
				case 'HEIGHT':    
					if ( isset( $rssc_rss_xml_items[$rssc_rss_xml_item_num][$current_low] ) )
					{
						$rssc_rss_xml_items[$rssc_rss_xml_item_num][$current_low] .= $data;
					}
					else
					{
						$rssc_rss_xml_items[$rssc_rss_xml_item_num][$current_low] = $data;
					}
					break;
			}
			break;

// IMAGE
		case 'IMAGE':
			switch($current)
			{
    			case 'TITLE':
    			case 'LINK':
    			case 'URL':
    			case 'WIDTH':
    			case 'HEIGHT':
    			    if ( isset( $rssc_rss_xml_image[$current_low] ) )
     				{
     					$rssc_rss_xml_image[$current_low] .= $data;
     				}
     				else
     				{
     					$rssc_rss_xml_image[$current_low] = $data;
      				}
					break;
			}
			break;

// CHANNEL
		default:
			switch($current)
			{

// Required channel elements
				case 'TITLE':
				case 'LINK':
				case 'DESCRIPTION':

// Optional channel elements 
				case 'LANGUAGE':
				case 'COPYRIGHT':
				case 'MANAGINGEDITOR':
				case 'WEBMASTER':
				case 'PUBDATE':
				case 'LASTBUILDDATE':
				case 'CATEGORY':
				case 'GENERATOR':
				case 'DOCS':
				case 'CLOUD':
				case 'TTL':
				case 'RATING':
				case 'TEXTINPUT':
				case 'SKIPHOURS':
				case 'SKIPDAYS':

// dc:xxx
//				case 'TITLE':
				case 'CREATOR':
				case 'SUBJECT':
//				case 'DESCRIPTION':
				case 'PUBLISHER':
				case 'CONTRIBUTOR':
				case 'DATE':
				case 'TYPE':
				case 'FORMAT':
				case 'IDENTIFIER':
				case 'SOURCE':
				case 'LANGUAGE':
				case 'RELATION':
				case 'COVERAGE':
				case 'RIGHTS':

				    if ( isset( $rssc_rss_xml_channel[$current_low] ) )
     				{
     					$rssc_rss_xml_channel[$current_low] .= $data;
     				}
     				else
     				{
     					$rssc_rss_xml_channel[$current_low] = $data;
      				}
					break;
			}
			break;
	}

}

//---------------------------------------------------------
// start namespace handler
//---------------------------------------------------------
function rssc_rss_xml_ns_start($parser, $prefix, $uri)
{
	global $rssc_rss_xml_uris;
//	echo "nss;$prefix;$uri <br>\n";
	array_push($rssc_rss_xml_uris, strtoupper($uri));
}

//---------------------------------------------------------
// end namespace handler
//---------------------------------------------------------
function rssc_rss_xml_ns_end($parser, $prefix)
{
	global $rssc_rss_xml_uris;
	array_pop($rssc_rss_xml_uris);
}

//=========================================================
// class rssc_rss_xml_parser
//=========================================================
class rssc_rss_parser extends  rssc_parser_base
{
	var $parse_error;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_rss_parser()
{
	$this->rssc_parser_base();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_rss_parser();
	}

	return $instance;
}

//---------------------------------------------------------
// get_channel
//---------------------------------------------------------
function get_channel()
{
	global $rssc_rss_xml_channel;

	$rss_channel =& $this->create_channel();
	$rss_channel->set_var_array( $rssc_rss_xml_channel );
	$channel = $rss_channel->get_channel();
	return $channel;
}

//---------------------------------------------------------
// get_image
//---------------------------------------------------------
function get_image()
{
	global $rssc_rss_xml_image;
	return $rssc_rss_xml_image;
}

//---------------------------------------------------------
// get_items
//---------------------------------------------------------
function get_items()
{
	global $rssc_rss_xml_items;

	$i = 0;
	$arr = array();

	foreach ($rssc_rss_xml_items as $item)
	{
		$rss_item =& $this->create_item();
		$rss_item->set_var_array( $item );
		$arr[] = $rss_item->get_item();
	}

	return $arr;
}

//---------------------------------------------------------
// get_parse_error
//---------------------------------------------------------
function get_parse_error()
{
  return $this->parse_error;
}

//---------------------------------------------------------
// parse
//---------------------------------------------------------
function parse($data)
{
	global $rssc_rss_xml_item_num, $rssc_rss_xml_parent_num, $rssc_rss_xml_parent, $rssc_rss_xml_channel, $rssc_rss_xml_image, $rssc_rss_xml_items, $rssc_rss_xml_uris;

// global
	$rssc_rss_xml_channel    = array();
	$rssc_rss_xml_image      = array();
	$rssc_rss_xml_items      = array();
	$rssc_rss_xml_item_num   = 0;
	$rssc_rss_xml_parent     = array();
	$rssc_rss_xml_parent[0]  = '';
	$rssc_rss_xml_parent_num = 0;
	$rssc_rss_xml_uris       = array();

	$this->parse_error = '';

	$xml_parser = xml_parser_create_ns( $this->_encoding );
	xml_set_element_handler($xml_parser, "rssc_rss_xml_start_element", "rssc_rss_xml_end_element");
	xml_set_character_data_handler($xml_parser, "rssc_rss_xml_character_data");
	xml_set_start_namespace_decl_handler($xml_parser, "rssc_rss_xml_ns_start");
	xml_set_end_namespace_decl_handler($xml_parser, "rssc_rss_xml_ns_end");

	if (!xml_parse($xml_parser, $data, sizeof($data)))
	{
		$line  = xml_get_current_line_number($xml_parser);
		$error = xml_error_string(xml_get_error_code($xml_parser));

		if ($line == 1)
		{
			$this->parse_error = 'XML error at line 1, check URL';
		}
		else
		{
			$this->parse_error = sprintf('XML error: %s at line %d', $error, $line );
		}

		xml_parser_free($xml_parser);
		return false;
	}

	xml_parser_free($xml_parser);

	return true;
}

//=========================================================
// output option
//=========================================================
function &create_channel()
{
	return new rssc_rss_parser_channel();
}

function &create_item()
{
	return new rssc_rss_parser_item();
}

// --- class end ---
}


//=========================================================
// class rss channel
//=========================================================
class rssc_rss_parser_channel extends rssc_parser_element_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_rss_parser_channel()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_rss_parser_channel();
	}

	return $instance;
}

//---------------------------------------------------------
// get channel
//---------------------------------------------------------
function get_channel()
{
	$data = $this->_data_arr;

	if ( isset($data['pubdate']) )
	{
		$data['pubdate_unix'] = $this->get_unixtime_rfc822( $data['pubdate'] );
	}

	if ( isset($data['lastbuilddate']) )
	{
		$data['lastbuilddate_unix'] = $this->get_unixtime_rfc822( $data['lastbuilddate'] );
	}

	if ( isset($data['date']) )
	{
		$data['date_unix']= $this->get_unixtime_w3cdtf( $data['date'] );
	}

	return $data;
}

// --- class end ---
}

//=========================================================
// class rss item
//=========================================================
class rssc_rss_parser_item extends rssc_parser_element_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_rss_parser_item()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_rss_parser_item();
	}

	return $instance;
}

//---------------------------------------------------------
// get item
//---------------------------------------------------------
function get_item()
{
	$arr = $this->_data_arr;

	if ( isset($arr['date']) )
	{
		$arr['date_unix'] = $this->get_unixtime_w3cdtf( $arr['date'] );
	}

	if ( isset($arr['pubdate']) )
	{
		$arr['pubdate_unix'] = $this->get_unixtime_rfc822( $arr['pubdate'] );
	}

	return $arr;
}

// --- class end ---
}

// === class end ===
}

?>