<?php
// $Id: rssc_sanitize.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('ssc_sanitize') ) 
{

//=========================================================
// class ssc_sanitize
//=========================================================
class rssc_sanitize
{
// class instance
	var $_strings;

// set param
	var $_flag_title_html   = 0;
	var $_flag_content_html = 0;
	var $_max_summary = 250;
	var $_max_title   =   0;	// unlimited
	var $_max_content =   0;	// unlimited

// result
	var $_result_data = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_sanitize()
{
// class instance
	$this->_strings =& rssc_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_sanitize();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
function &sanitize($data, $format='n')
{
	if ($format == 'n')
	{
		return $data;
	}

	$arr = array();
	$arr['channel'] = array();
	$arr['image']   = array();
	$arr['items']   = array();

	if ( isset($data['channel']) )
	{
		$arr['channel'] = $this->sanitize_channel($data['channel'], $format);
	}

	if ( isset($data['image']) )
	{
		$arr['image'] = $this->sanitize_image($data['image'], $format);
	}

	if ( isset($data['items']) )
	{
		$arr['items'] = $this->sanitize_items($data['items'], $format);
	}

	$this->_result_data = $arr;

	return $arr;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_title_html($value)
{
	$this->_flag_title_html = intval($value);
}

function set_content_html($value)
{
	$this->_flag_content_html = intval($value);
}

function set_max_title($value)
{
	$this->_max_title = intval($value);
}

function set_max_summary($value)
{
	$this->_max_summary = intval($value);
}

function set_max_content($value)
{
	$this->_max_content = intval($value);
}

//---------------------------------------------------------
// get result
//---------------------------------------------------------
function &getResult()
{
	return $this->_result_data;
}

function &getChannel()
{
	if ( isset($this->_result_data['channel']) )
	{
		return $this->_result_data['channel'];
	}

	return false;
}

function &getImage()
{
	if ( isset($this->_result_data['image']) )
	{
		return $this->_result_data['image'];
	}

	return false;
}

function &getItems()
{
	if ( isset($this->_result_data['items']) )
	{
		return $this->_result_data['items'];
	}

	return false;
}

//=========================================================
// private
//=========================================================
function &sanitize_channel($channel, $format='n')
{
	if ($format == 'n')
	{
		return $channel;
	}

	$arr = array();

	foreach ($channel as $key => $value)
	{
		$arr[$key] = $this->_strings->make_format($value, $format);
	}

	return $arr;

}

function &sanitize_image($image, $format='n')
{
	if ($format == 'n')
	{
		return $image;
	}

	$arr = array();

	foreach ($image as $key => $value)
	{
		$arr[$key] = $this->_strings->make_format($value, $format);
	}

	return $arr;

}

function &sanitize_items($items, $format='n')
{
	if ($format == 'n')
	{
		return $items;
	}

	$arr = array();

	foreach ($items as $num => $item)
	{
		$arr[$num] =& $this->sanitize_item($item, $format);
	}

	return $arr;
}

function &sanitize_item($item, $format='n')
{
	if ($format == 'n')
	{
		return $item;
	}

	$arr = array();

	foreach ($item as $key => $value)
	{
		switch ($key)
		{
			case 'link':
				$val_new = $this->sanitize_item_link($value, $format);
				break;

			case 'title':
				$val_new = $this->sanitize_item_title($value, $format);
				break;

			case 'content':
			case 'encoded':
				$val_new = $this->sanitize_item_content($value, $format);
				break;

			case 'summary':
			case 'description':
				$val_new = $this->sanitize_item_summary($value, $format);
				break;

			case 'raws':
				$val_new = '';
				break;

			default:
				$val_new = $this->_strings->make_format($value, $format);
				break;
		}

		$arr[$key] = $val_new;
	}

	return $arr;
}

function sanitize_item_link($text, $format='n')
{
	$text = $this->_strings->strip_control_code($text);
	$text = $this->_strings->strip_crlf($text);
	$text = $this->_strings->conv_js($text);
	$text = $this->_strings->make_format($text, $format);
	return $text;
}

function sanitize_item_title($text, $format='n')
{
// allow HTML tag & under max content
	if ( $this->_flag_title_html )
	{
		if ( ($this->_max_title < 0) || (strlen($text) <= $this->_max_title) )
		{
			return $this->_strings->conv_js($text);
		}
	}

	$text = $this->_strings->strip_tags_for_text($text);
	$text = $this->_strings->shorten_text($text, $this->_max_title);
	$text = $this->_strings->make_format($text, $format);
	return $text;
}

function sanitize_item_content($text, $format='n')
{
// allow HTML tag & under max content
	if ( $this->_flag_content_html )
	{
		if ( ($this->_max_content < 0) || (strlen($text) <= $this->_max_content) )
		{
			return $this->_strings->conv_js($text);
		}
	}

	return $this->_strings->make_summary($text, $this->_max_content, $format);
}

function sanitize_item_summary($text, $format='n')
{
	return $this->_strings->make_summary($text, $this->_max_summary, $format);
}

// --- class end ---
}

// === class end ===
}

?>