<?php
// $Id: rssc_search_handler.php,v 1.1.1.1 2006/01/03 05:06:03 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_search_handler') ) 
{

//=========================================================
// class rssc_search_handler
//=========================================================
class rssc_search_handler extends rssc_view_param
{
// class instance
	var $_link_handler;

	var $_myts;
	var $_format;
	var $_strings;

// inputt param
	var $_min_keyword = 4;
	var $_str_query;
	var $_mode_andor;

// result
	var $_feeds   = array();
	var $_queries = array();
	var $_ignores = array();
	var $_str_keyword;
	var $_str_ignored;
	var $_sel_and;
	var $_sel_or;
	var $_sel_exact;
	var $_urlencode;

// local
	var $_flag_parse_query = false;
	var $_where;
	var $_time_start;

// define by rssc_view_param
//	var $_feed_handler;
//	var $_sanitize;
//	var $_feed_start;
//	var $_feed_limit;
//	var $_feed_order;
//	var $_flag_sanitize;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_search_handler( $dirname )
{
	$this->rssc_view_param();

	$this->_link_handler =& rssc_get_handler( 'link', $dirname );
	$this->_feed_handler =& rssc_get_handler( 'feed', $dirname );

	$this->_myts     =& MyTextSanitizer::getInstance();
	$this->_format   =& rssc_view_format::getInstance();
	$this->_strings  =& rssc_strings::getInstance();

}

//--------------------------------------------------------
// search
//--------------------------------------------------------
function search()
{
	if ( !$this->parseQuery($this->_str_query, $this->_mode_andor, $this->_min_keyword) )
	{
		return -1;
	}

	$count = $this->_feed_handler->get_count_by_where($this->_where);

	if ($count > 0)
	{
		$this->_get_feeds_by_where($this->_where, $this->_feed_order, $this->_feed_limit, $this->_feed_start);
	}

	return $count;
}

//--------------------------------------------------------
// parseQuery
//--------------------------------------------------------
function parseQuery($query, $andor, $min)
{
	$this->_flag_parse_query = true;

	$this->_queries = array();
	$this->_ignores = array();
	$this->_str_keyword = '';
	$this->_str_ignored = '';
	$this->_mode_andor = '';
	$this->_sel_and    = '';
	$this->_sel_or     = '';
	$this->_sel_exact  = '';

	$query = trim($query);

	if ($query == '')
	{
		return false;
	}

	if ( ($andor != "OR") && ($andor != "exact") && ($andor != "AND") ) 
	{
		$andor = "AND";
	}

	if ($andor != 'exact') 
	{
		$query_han = $this->_strings->convert_space_zen_to_han($query);
		$query_temp_arr = preg_split('/[\s,]+/', $query_han);

		foreach ($query_temp_arr as $q) 
		{
			$q = trim($q);

			if (strlen($q) >= $min) 
			{
				$this->_queries[] = $this->_myts->addSlashes($q);
			} 
			else 
			{
				$this->_ignores[] = $this->_myts->addSlashes($q);
			}
		}

		foreach ($this->_queries as $q) 
		{
			$this->_str_keyword .= ' <b>'.htmlspecialchars(stripslashes($q)).'</b>';
		}

		if (!empty($this->_ignores)) 
		{
			foreach ($this->_ignores as $q) 
			{
				$this->_str_ignored .= ' <b>'.htmlspecialchars(stripslashes($q)).'</b>';
			}
		}

		if ($andor == 'OR') $this->_sel_or  = "selected='selected'";
		else                $this->_sel_and = "selected='selected'";
	}
	else 
	{
		$this->_queries = array($myts->addSlashes($query));
		$this->_str_keyword .= ' "<b>'.htmlspecialchars(stripslashes($this->_queries[0])).'</b>"';
		$this->_sel_exact = "selected='selected'";
	}

	$this->_mode_andor = $andor;

	if (count($this->_queries) == 0)
	{
		return false;
	}

	$urlencode = implode(' ', $this->_queries);
	$urlencode = stripslashes($urlencode);
	$urlencode = urlencode($urlencode);
	$this->_urlencode = $urlencode;

	$this->_make_where($this->_queries, $this->_mode_andor);

	return true;
}

//--------------------------------------------------------
// get count & object
//--------------------------------------------------------
function getSearchCount()
{
	if ( !$this->_flag_parse_query )
	{
		$this->parseQuery($this->_str_query, $this->_mode_andor, $this->_min_keyword);
	}

	return $this->_feed_handler->get_count_by_where($this->_where);
}

function &getSearchFeeds($limit=0, $start=0)
{
	if ( !$this->_flag_parse_query )
	{
		$this->parseQuery($this->_str_query, $this->_mode_andor, $this->_min_keyword);
	}

	return $this->_get_feeds_by_where($this->_where, $this->_feed_order, $limit, $start);
}

function getLatest($limit=0, $start=0)
{
	$feeds = $this->_feed_handler->get_latest($this->_feed_order, $limit, $start);

	$feeds =& $this->_format->format_items($feeds);
	$feeds =& $this->_link_handler->add_ltype_items($feeds);

	if ($this->_flag_sanitize)
	{
		$feeds = $this->_sanitize->sanitize_items($feeds, 's');
	}

	return $feeds;
}

function getTotal()
{
	return $this->_feed_handler->get_total();
}


//-------------------------------------------------------------------
// measure time
//-------------------------------------------------------------------
function startMeasureTime()
{
	$this->_time_start = $this->_get_microtime();
}

function getMeasureTime()
{
	$time = $this->_get_microtime() - $this->_time_start;
	return $time;
}

//--------------------------------------------------------
// configration
//--------------------------------------------------------
function setMinKeyword($value)
{
	$this->_min_keyword = intval($value);
}

//--------------------------------------------------------
// set & get param
//--------------------------------------------------------
function setQuery($value)
{
	$this->_str_query = trim($value);
}

function setAndor($value)
{
	$this->_mode_andor = trim($value);
}

function &getFeeds()
{
	return $this->_feeds;
}

function getIgnores()
{
	return $this->_ignores;
}

function getKeyword()
{
	return $this->_str_keyword;
}

function getIgnored()
{
	return $this->_str_ignored;
}

function getAndor()
{
	return $this->_mode_andor;
}

function getAnd()
{
	return $this->_sel_and;
}

function getOr()
{
	return $this->_sel_or;
}

function getExact()
{
	return $this->_sel_exact;
}

function getQueries()
{
	return $this->_queries;
}

function getQueryUrlencode()
{
	return $this->_urlencode;
}

//=========================================================
// Private
//=========================================================
//--------------------------------------------------------
// make_sql
//--------------------------------------------------------
function _make_where($query_array, $andor='AND')
{
	$where = '';

	if ( is_array($query_array) && $count = count($query_array) )
	{
		$where .= "( search LIKE '%$query_array[0]%' ";

		for ($i=1; $i<$count; $i++)
		{
			$where .= "$andor ";
			$where  .= "search LIKE '%$query_array[$i]%' ";
		}

		$where .= ") ";
	}

	$this->_where = $where;
	return $where;
}

//--------------------------------------------------------
// get count & feeds by where
//--------------------------------------------------------
function _get_feeds_by_where($where='', $order='updated_unix DESC', $limit=0, $start=0)
{
	$feeds =& $this->_feed_handler->get_feeds_by_where($where, $order, $limit, $start);
	$feeds =& $this->_format->format_items($feeds);
	$feeds =& $this->_link_handler->add_ltype_items($feeds);

	if ($this->_flag_sanitize)
	{
		$feeds =& $this->_sanitize->sanitize_items($feeds, 's');
	}

	$this->_feeds =& $feeds;
	return $feeds;
}

//-------------------------------------------------------------------
// measure time
//-------------------------------------------------------------------
function _get_microtime()
{ 
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$sec + (float)$usec); 
}

//----- class end -----
}

// === class end ===
}

?>