<?php
// $Id: rssc_strings.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_strings') ) 
{

//=========================================================
// class rssc_strings
//=========================================================
class rssc_strings
{
// class
	var $_myts;
	var $_system;

// local variable
	var $_max_summary = 100;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_strings()
{
// class
	$this->_myts   =& MyTextSanitizer::getInstance();
	$this->_system =& rssc_system::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_strings();
	}

	return $instance;
}

// --------------------------------------------------------
// summary
// --------------------------------------------------------
function make_summary($text, $max, $format='n')
{
	$text = $this->strip_tags_for_text($text);
	$text = $this->shorten_text($text, $max);
	$text = $this->make_format($text, $format);
	return $text;
}

function strip_tags_for_text($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->strip_style_tag($text);
	$text = $this->add_space_after_tag($text);
	$text = strip_tags($text);
	$text = $this->strip_space($text);
	return $text;
}

// --------------------------------------------------------
// onvert_array_key_to_string
// array($key => $value)  ==> $key:$value
// --------------------------------------------------------
function convert_array_key_to_string($arr)
{
	if ( (count($arr) == 0) || !is_array($arr) )
	{
		return '';
	}

	$str = '';

	foreach ($arr as $key => $value)
	{
// replace return code
		$value = preg_replace("/\n/", '\\n', $value);

		$str .= $key.":".$value."\n";
	}

	return $str;
}

function convert_string_to_array_key($str, $format='n')
{
	$array = array();

	$line_arr = $this->convert_string_to_array($str, "\n");

	if ( count($line_arr) == 0 )  return $array;

	foreach ($line_arr as $line)
	{
		list($key, $value) = split(":", $line, 2);

// replace return code
		$value = preg_replace('/\\n/', "\n", $value);

		$array[$key] = $this->make_format($value, $format);
	}

	return $array;
}


//---------------------------------------------------------
// convert array to string
// array($a, $b, $c)  ==> $a & $b & $c
//---------------------------------------------------------
function convert_array_to_string($arr, $pattern='&')
{
	if ( is_array($arr) )
	{
		$str = $pattern;

		foreach ($arr as $value)
		{
			$str .= intval($value).$pattern;
		}
	}
	elseif ( is_int($arr) )
	{
		$str = $pattern.intval($arr).$pattern;
	}
	else
	{
		$str = $arr;
	}

	return $str;
}

function convert_string_to_array($str, $pattern='&')
{
	$str_arr = split($pattern, $str);

	$i = 0;	
	$arr = array();
	foreach ($str_arr as $value)
	{
		$value = trim($value);

		if ($value == '')  continue;

		$arr[$i++] = $value;
	}

	return $arr;
}

// --------------------------------------------------------
// sanitize and convert htmlspecialchars for textarea
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &#039;
// --------------------------------------------------------
function sanitize_html_text($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->conv_js($text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

// --------------------------------------------------------
// sanitize and convert htmlspecialchars for textarea
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &#039;
// --------------------------------------------------------
function sanitize_html_textarea($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->conv_js($text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

//---------------------------------------------------------
// sanitize and convert htmlspecialchars for url
//   <     -> &lt;
//   >     -> &gt;
//   "     -> &quot;
//   '     -> &#039;
//   &     -> &amp;
//   &amp; -> &amp;
//---------------------------------------------------------
function sanitize_html_url($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->conv_js($text);
	$text = preg_replace('/&amp;/i', '&', $text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	return $text;
}

// --------------------------------------------------------
// strip_control_code
// --------------------------------------------------------
function strip_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	$text = preg_replace('/[\x7F]/',     ' ',$text);
	return $text;
}

function strip_crlf($text)
{
	$text = preg_replace("/\r/",' ',$text);
	$text = preg_replace("/\n/",' ',$text);
	return $text;
}

function strip_style_tag($text)
{
	return preg_replace('|<\s*style\s?.*?>(.*)<\s*/\s*style\s*>|is', '', $text);
}

function add_space_after_tag($text)
{
	return str_replace(">",   "> ", $text);
}

//--------------------------------------------------------
// strip_space
//--------------------------------------------------------
function strip_space($text)
{
	$text = $this->convert_space_zen_to_han($text);
	$text = preg_replace("/&nbsp;/i", ' ', $text);
	$text = preg_replace("/[\x20]+/", ' ', $text);
	return $text;
}

//--------------------------------------------------------
// sanitaize text
//--------------------------------------------------------
function conv_js($text)
{
	$text = preg_replace('/javascript:/si', 'java script:', $text);
	$text = preg_replace('/about:/si', 'about :', $text);
	return $text;
}

//--------------------------------------------------------
// sanitize text for HTML
//--------------------------------------------------------
function make_format($text, $format='n')
{
	switch (strtolower($format)) 
	{
		case 's':
		case 'show':
		case 'e':
		case 'edit':
			$text = $this->_myts->htmlSpecialChars($text);
			break;

		case 'p':
		case 'preview':
		case 'f':
		case 'formpreview':
			$text = $this->_myts->stripSlashesGPC($text);
			$text = $this->_myts->htmlSpecialChars($text);
			break;

		case 'n':
		case 'none':
		default:
			break;
	}

	return $text;
}


//--------------------------------------------------------
// format time
//--------------------------------------------------------
function format_time($time, $format='mysql')
{
	return formatTimestamp( $time, $format );
}

//--------------------------------------------------------
// make_url_null
//--------------------------------------------------------
function make_url_null($url, $default='http://')
{
	if ($url)
	{
		return $url;
	}
	else
	{
		return $default;
	}
}

//--------------------------------------------------------
// split_nl
//--------------------------------------------------------
function split_nl($text)
{
	$rext = $this->convert_nl($text);
	return split("\n", $text);
}

//--------------------------------------------------------
// convert_nl
//--------------------------------------------------------
function convert_nl($text)
{
	$text = str_replace( "\r\n", "\n", $text ); 
	$text = str_replace( "\n\r", "\n", $text ); 
	$text = str_replace( "\r",   "\n", $text ); 
	return $text;
}

//--------------------------------------------------------
// set parameter
//--------------------------------------------------------
function set_max_summary($value)
{
	$this->_max_summary = intval($value);
}

//========================================================
// multibyte function
//========================================================
//--------------------------------------------------------
// shorten_text
//--------------------------------------------------------
function shorten_text($text, $max)
{
// nothing, if zero
	if ($max == 0)
	{
		return '';
	}

// unlimited, if minus
	if ($max < 0)
	{
		return $text;
	}

// less than
	if ( strlen($text) <= $max)
	{
		return $text;
	}

	if (function_exists('mb_strcut'))
	{
	// cut strings for multibayte byte length
		$text = mb_strcut( $text, 0, $max )." ...";
	}
	else
	{
		$text = substr( $text, 0, $max )." ...";
	}

	return $text;
}

//--------------------------------------------------------
// convert_space_zen_to_han
//--------------------------------------------------------
function convert_space_zen_to_han($text)
{
	if ( $this->_system->is_japanese() && function_exists('mb_convert_kana') )
	{
		return mb_convert_kana($text, "s");
	}

	return $text;
}

// --- class end ---
}

// === class end ===
}

?>