<?php
// $Id: rssc_view_format.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

//================================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('rssc_view_format') ) 
{

//=========================================================
// class rssc_view_format
//=========================================================
class rssc_view_format
{
// class
	var $_strings;

// constant
	var $_TITLE_SUBSTITUTE = '---';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_format()
{
// class
	$this->_strings =& rssc_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_view_format();
	}

	return $instance;
}

//=========================================================
// Public
//=========================================================
function &format($data_in)
{
	$data = array();

	if ( isset($data_in['channel']) )
	{
		$data['channel'] =& $this->format_channel( $data_in['channel'] );
	}

	if ( isset($data_in['image']) )
	{
		$data['image'] =& $this->format_image( $data_in['image'] );
	}
	elseif ( isset($data_in['channel']) )
	{
		$image = $this->get_image( $data_in['channel'] );

		if ($image)
		{
			$data['image'] =& $this->format_image( $image );
		}
	}

	if ( isset($data_in['items']) )
	{
		$data['items'] =& $this->format_items( $data_in['items'] );
	}

	return $data;
}

function &format_channel($channel)
{
	$data = $channel;
	$data['title']       = $this->_substitute_title( $channel, 'title' );
	$data['author_name'] = $this->_get_channel_author_name( $channel );

// rss
	if ( isset($channel['pubdate_unix']) )
	{
		$unix = $channel['pubdate_unix'];
		$data['pubdate_l'] = $this->_format_time( $unix, 'mysql' );
		$data['pubdate_s'] = $this->_format_time( $unix, 's' );
	}

	if ( isset($channel['lastbuilddate_unix']) )
	{
		$unix = $channel['lastbuilddate_unix'];
		$data['lastbuilddate_l'] = $this->_format_time( $unix, 'mysql' );
		$data['lastbuilddate_s'] = $this->_format_time( $unix, 's' );
	}

// atom
	if ( isset($channel['published_unix']) )
	{
		$unix = $channel['published_unix'];
		$data['published_l'] = $this->_format_time( $unix, 'mysql' );
		$data['published_s'] = $this->_format_time( $unix, 's' );
	}

	if ( isset($channel['updated_unix']) )
	{
		$unix = $channel['updated_unix'];
		$data['updated_l'] = $this->_format_time( $unix, 'mysql' );
		$data['updated_s'] = $this->_format_time( $unix, 's' );
	}

// dc:date
	if ( isset($channel['date_unix']) )
	{
		$unix = $channel['date_unix'];
		$data['date_u'] = $unix;
		$data['date_l'] = $this->_format_time( $unix, 'mysql' );
		$data['date_s'] = $this->_format_time( $unix, 's' );
	}

	return $data;

}

function &format_image($image)
{
	return $image;	// no action
}

function &format_items($item_arr)
{
	$data = array();

	foreach ($item_arr as $item)
	{
		$data[] =& $this->format_item($item);
	}

	return $data;
}

function &format_item($item)
{
	$data = $item;
	$data['site_title'] = $this->_substitute_title( $item, 'site_title' );
	$data['title']      = $this->_substitute_title( $item, 'title' );
	$data['summary']    = $this->_get_item_summary( $item );

// rss
	if ( isset($item['pubdate_unix']) )
	{
		$unix = $item['pubdate_unix'];

// some feed have no date
		if ($unix)
		{
			$data['pubdate_l'] = $this->_format_time( $unix, 'mysql' );
			$data['pubdate_s'] = $this->_format_time( $unix, 's' );
		}
	}

// atom
	if ( isset($item['published_unix']) )
	{
		$unix = $item['published_unix'];

		if ($unix)
		{
			$data['published_l'] = $this->_format_time( $unix, 'mysql' );
			$data['published_s'] = $this->_format_time( $unix, 's' );
		}

	}

	if ( isset($item['updated_unix']) )
	{
		$unix = $item['updated_unix'];

		if ($unix)
		{
			$data['updated_l'] = $this->_format_time( $unix, 'mysql' );
			$data['updated_s'] = $this->_format_time( $unix, 's' );
		}
	}

// dc:date
	if ( isset($item['date_unix']) )
	{
		$unix = $item['date_unix'];

		if ($unix)
		{
			$data['date_l'] = $this->_format_time( $unix, 'mysql' );
			$data['date_s'] = $this->_format_time( $unix, 's' );
		}
	}

	return $data;
}

function get_image($channel)
{
	$data = array();

	if ( isset($channel['image_title']) ) 
	{
		$data['title'] = $channel['image_title'];
	}

	if ( isset($channel['image_url']) ) 
	{
		$data['url'] = $channel['image_url'];
	}

	if ( isset($channel['image_width']) ) 
	{
		$data['width'] = $channel['image_width'];
	}

	if ( isset($channel['image_height']) ) 
	{
		$data['height'] = $channel['image_height'];
	}

	return $data;
}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// substitute_title
// some feed have no title
// subsutute by ---
//---------------------------------------------------------
function _substitute_title($arr, $key)
{
	if ( isset($arr[$key]) && ($arr[$key] != ''))
	{
		return $arr[$key];
	}

	return $this->_TITLE_SUBSTITUTE;
}

//---------------------------------------------------------
// channel
//---------------------------------------------------------
function _get_channel_author_name($channel)
{
	if ( isset($channel['author_name']) )
	{
		return $channel['author_name'];
	}
	elseif ( isset($channel['webmaster']) )
	{
		return $channel['webmaster'];
	}

	return false;
}

//---------------------------------------------------------
// RSS item
//---------------------------------------------------------
function _get_item_summary($item)
{
	if ( isset($item['summary']) )
	{
		return $item['summary'];
	}
	elseif ( isset($item['content']) )
	{
		return $this->_strings->strip_tags_for_text( $item['content'] );
	}

	return false;
}

function _get_item_pubdate_unix($item)
{
	if ( isset($item['pubdate_unix']) )
	{
		return $item['pubdate_unix'];
	}
	elseif ( isset($item['updated_unix']) )
	{
		return $item['updated_unix'];
	}

	return false;
}

//---------------------------------------------------------
// strings class
//---------------------------------------------------------
function _format_time($time, $format='mysql')
{
	return $this->_strings->format_time( $time, $format );
}

// --- class end ---
}

// === class end ===
}

?>