<?php
// $Id: rssc_view_handler.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_handler') ) 
{

//=========================================================
// class rssc_view_handler
//=========================================================
class rssc_view_handler extends rssc_view_param
{
// handler
	var $_link_handler;

// class instance
	var $_format;

// input & result
	var $_result_data = array();

// define by rssc_view_param
//	var $_feed_handler;
//	var $_sanitize;
//	var $_feed_start;
//	var $_feed_limit;
//	var $_feed_order;
//	var $_flag_sanitize;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_handler( $dirname )
{
	$this->rssc_view_param();

// class instance
	$this->_link_handler   =& rssc_get_handler('link',  $dirname);
	$this->_feed_handler   =& rssc_get_handler('feed',  $dirname);
	$this->_format =& rssc_view_format::getInstance();
}

//=========================================================
// public
//=========================================================
function &getHeadlineLids($limit=0, $start=0)
{
	return $this->_link_handler->get_headline_lids($limit, $start);
}

function &getHeadlineLinks($limit=0, $start=0)
{
	return $this->_link_handler->get_sanitized_headline_links($limit, $start);
}

function &getLink($lid)
{
	return $this->_link_handler->get_sanitized_link_by_lid($lid);
}

function &getChannel($lid)
{
	$channel =& $this->_link_handler->get_channel_by_lid($lid);

	if ( !$channel )
	{
		return false;
	}

	$channel =& $this->_format->format_channel($channel);

	if ( $this->_flag_sanitize )
	{
		$channel =& $this->_sanitize->sanitize_channel($channel, 's');
	}

	return $channel;
}

function &getImage($lid)
{
	$channel = $this->_link_handler->get_channel_by_lid($lid);

	if ( !$channel )
	{
		return false;
	}

	$image =& $this->_format->get_image($channel);
	$image =& $this->_format->format_channel($image);

	if ( $this->_flag_sanitize )
	{
		$image = $this->_sanitize->sanitize_image($image, 's');
	}

	return $image;
}

function &getFeedByFid($fid)
{
	$feed =& $this->_feed_handler->get_feed_by_fid($fid);
	$feed =& $this->_format->format_item($feed);
	$feed =& $this->_link_handler->add_ltype_item($feed);

	if ( $this->_flag_sanitize )
	{
		$feed =& $this->_sanitize->sanitize_item($feed, 's');
	}

	return $feed;
}

function &getFeeds($lid)
{
	$feeds =& $this->_feed_handler->get_feeds_by_lid($lid, $this->_feed_order, $this->_feed_limit, $this->_feed_start );

	$feeds =& $this->_format->format_items($feeds);
	$feeds =& $this->_link_handler->add_ltype_items($feeds);

	if ( $this->_flag_sanitize )
	{
		$feeds =& $this->_sanitize->sanitize_items($feeds, 's');
	}

	return $feeds;
}

function &getHeadlineLinksFeeds($link_limit=0, $link_start=0)
{
	$lids  =& $this->_link_handler->get_headline_lids($link_limit, $link_start);
	$links = array();

	foreach ($lids as $lid)
	{
		$link  =& $this->_link_handler->get_sanitized_link_by_lid($lid);
		$feeds =& $this->_feed_handler->get_feeds_by_lid($lid, $this->_feed_order, $this->_feed_limit, $this->_feed_start);
		$feeds =& $this->_format->format_items($feeds);
		$feeds =& $this->_link_handler->add_ltype_items($feeds);
		$feeds =& $this->_sanitize->sanitize_items($feeds, 's');
		$link['feeds'] =& $feeds;
		$links[] =& $link;
	}

	return $links;
}

//---------------------------------------------------------
// view parsed data
//---------------------------------------------------------
function &format($data)
{
	return $this->_format->format($data);
}

function &sanitize($data)
{
	return $this->_sanitize->sanitize($data, 's');
}

// --- class end ---
}

// === class end ===
}

?>