<?php
// $Id: rssc_view_param.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_param') ) 
{

//=========================================================
// class rssc_view_param
//=========================================================
class rssc_view_param
{
// handler
	var $_feed_handler;	// not set in this class

// class instance
	var $_sanitize;

// input parameter
	var $_feed_order = RSSC_C_ORDER_TEXT_UPDATED;
	var $_feed_start =  0;
	var $_feed_limit = 10;
	var $_flag_sanitize = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_param()
{
// class instance
	$this->_sanitize =& rssc_sanitize::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_view_param();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function setFeedOrder($value)
{
	switch ( intval($value) )
	{
		case RSSC_C_ORDER_INT_PUBLISHED:
			$order = RSSC_C_ORDER_TEXT_PUBLISHED;
			break;

		case RSSC_C_ORDER_INT_UPDATED:
		default:
			$order = RSSC_C_ORDER_TEXT_UPDATED;
			break;
	}

	$this->_feed_order = $order;
}

function setFeedStart($value)
{
	$this->_feed_start = intval($value);
}

function setFeedLimit($value)
{
	$this->_feed_limit = intval($value);
}

function setFlagSanitize($value)
{
	$this->_flag_sanitize = intval($value);
}

//---------------------------------------------------------
// feed property
//---------------------------------------------------------
function setFutureDays($value)
{
	$this->_feed_handler->set_future($value);
}

//---------------------------------------------------------
// sanitize property
//---------------------------------------------------------
function setTitleHtml($value)
{
	$this->_sanitize->set_title_html($value);
}

function setContentHtml($value)
{
	$this->_sanitize->set_content_html($value);
}

function setMaxTitle($value)
{
	$this->_sanitize->set_max_title($value);
}

function setMaxSummary($value)
{
	$this->_sanitize->set_max_summary($value);
}

function setMaxContent($value)
{
	$this->_sanitize->set_max_content($value);
}

// --- class end ---
}

// === class end ===
}

?>