<?php
// $Id: rssc_white_handler.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss center Module
// this file contain 2 class
//   rssc_white
//   rssc_white_handler
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_white_handler') ) 
{

//=========================================================
// class white
//=========================================================
class rssc_white extends XoopsObject
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_white()
{
	$this->XoopsObject();
	$this->initVar('wid', XOBJ_DTYPE_INT, null, false);
	$this->initVar('lid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p1',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p2',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p3',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('url',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('memo',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function getVarAll($format='n')
{
	return array(
		'wid' => $this->getVar('wid', $format),
		'lid' => $this->getVar('lid', $format),
		'uid' => $this->getVar('uid', $format),
		'mid' => $this->getVar('mid', $format),
		'p1'  => $this->getVar('p1',  $format),
		'p2'  => $this->getVar('p2',  $format),
		'p3'  => $this->getVar('p3',  $format),
		'title' => $this->getVar('title', $format),
		'url'   => $this->getVar('url',   $format),
		'memo'  => $this->getVar('memo',  $format),
	);
}

// --- class end ---
}

//=========================================================
// class white handler
//=========================================================
class rssc_white_handler extends rssc_db_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_white_handler( $dirname )
{
	$this->rssc_db_base($dirname, 'rssc_white_handler');

	$this->_table      = $this->_db->prefix( $dirname.'_white' );
	$this->_id_name    = 'wid';
	$this->_class_name = 'rssc_white';

	$this->_flag_debug_print_sql   = 0;
	$this->_flag_debug_print_error = 0;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function insert(&$obj)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('white table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('white table: not clean');
		return false;
	}

	if ( !$obj->isNew() )
	{
		$this->_set_errors('white table: not new');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'INSERT INTO '.$this->_table.' (lid, uid, mid, p1, p2, p3, title, url, memo, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->_quote($title).', '.$this->_quote($url).', '.$this->_quote($memo).', '.$aux_int_1.', '.$aux_int_2.', '.$this->_quote($aux_text_1).', '.$this->_quote($aux_text_1).')';

	if ( !$result = $this->_queryF($sql) ) 
	{	return false;	}

	if (empty($wid)) 
	{
		$wid = $this->_db->getInsertId();
	}

	return $wid;
}

function update(&$obj)
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('white table: not match class');
		return false;
	}

	if ( !$obj->cleanVars() )
	{
		$this->_set_errors('white table: not clean');
		return false;
	}

	foreach ($obj->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	if (empty($wid)) 
	{
		$this->_set_errors('white table: not exist wid');
		return false;
	}

	$sql = 'UPDATE '.$this->_table.' SET lid='.$lid.', uid='.$uid.', mid='.$mid.', p1='.$p1.', p2='.$p2.', p3='.$p3.', title='.$this->_quote($title).', url='.$this->_quote($url).', memo='.$this->_quote($memo).', aux_int_1='.$aux_int_1.', aux_int_2='.$aux_int_2.', aux_text_1='.$this->_quote($aux_text_1).', aux_text_2='.$this->_quote($aux_text_2).' WHERE wid='.$wid;

	if ( !$result = $this->_queryF($sql) ) 
	{	return false;	}

	return true;
}

// --- class end ---
}

// === class end ===
}

?>