<?php
// $Id: rssc_xml_parser.php,v 1.1.1.1 2006/01/03 05:06:04 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_xml_parser') ) 
{

//=========================================================
// class rssc_xml_parser
//=========================================================
class rssc_xml_parser extends rssc_error
{
// class instance
	var $_parser_rss_xoops;
	var $_parser_rss_self;
	var $_parser_atom_self;
	var $_convert;

// basic config
	var $_sel_parser_rss  = RSSC_C_PARSER_RSS_SELF;
	var $_sel_parser_atom = RSSC_C_PARSER_ATOM_SELF;
	var $_local_encoding  = _CHARSET;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_xml_parser()
{
	$this->rssc_error();

// class
	$this->_convert =& rssc_convert::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_xml_parser();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================

//---------------------------------------------------------
// parse XML
//---------------------------------------------------------
function parse($xml_data, $xml_mode, $xml_encoding)
{
	$this->_set_log_func_name('parse');

	$parser = $this->_select_parser($xml_mode);

	switch ($parser)
	{
		case RSSC_C_PARSER_ATOM_SELF:
			$this->_parser_atom_self =& rssc_atom_parser::getInstance();
			return $this->_parse_format_atom_self( $xml_data, $xml_encoding );
			break;

		case RSSC_C_PARSER_RSS_XOOPS:
		default:
			$this->_parser_rss_self =& rssc_rss_parser::getInstance();
			return $this->_parse_format_rss_xoops( $xml_data, $xml_encoding );
			break;

		case RSSC_C_PARSER_RSS_SELF:
		default:
			$this->_parser_rss_self =& rssc_rss_parser::getInstance();
			return $this->_parse_format_rss_self( $xml_data, $xml_encoding );
			break;
	}

	return true;	// dummy
}


//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_rss_parser($value)
{
	$this->_sel_parser_rss = $value;
}

function set_atom_parser($value)
{
	$this->_sel_parser_atom = $value;
}

function set_local_encoding($value)
{
	$this->_sel_local_encoding = $value;
}


//=========================================================
// private
//=========================================================

//---------------------------------------------------------
// select parser
//---------------------------------------------------------
function _select_parser($xml_mode=0)
{
	switch ($xml_mode)
	{
		case RSSC_C_MODE_RDF:
			$parser = $this->_sel_parser_rss;
			break;
		
		case RSSC_C_MODE_RSS:
			$parser = $this->_sel_parser_rss;
			break;

		case RSSC_C_MODE_ATOM:
			$parser = $this->_sel_parser_atom;
			break;
	}

	return $parser;
}

//---------------------------------------------------------
// convert to local
//---------------------------------------------------------
function _convert_to_local($parsed_data, $from)
{
	$local_data = array();
	$to = $this->_local_encoding;

	if ( $from == $to )
	{
		return $parsed_data;
	}

	if ( isset($parsed_data['channel']) )
	{
		$local_data['channel'] = $this->_convert->convert_array( $parsed_data['channel'], $to, $from );
	}

	if ( isset($parsed_data['image']) )
	{
		$local_data['image'] = $this->_convert->convert_array( $parsed_data['image'], $to, $from );
	}

	if ( isset($parsed_data['items']) )
	{
		$local_data['items'] = $this->_convert->convert_array_array( $parsed_data['items'], $to, $from );
	}

	if ( isset($parsed_data['mode']) )
	{
		$local_data['mode'] = $parsed_data['mode'];
	}

	return $local_data;
}

//=========================================================
// ATOM parser
//=========================================================
function _parse_format_atom_self($xml_data, $xml_encoding)
{
	$parsed_data = $this->_parse_atom_self($xml_data, $xml_encoding);

	if ( !$parsed_data )
	{
		return false;
	}

	$parsed_data = $this->_convert_to_local( $parsed_data, $xml_encoding );
	return $this->_format_atom_self( $parsed_data );

//	return $this->_format_atom_self( $parsed_data );
}

function _parse_atom_self($xml_data, $encoding)
{
	$this->_set_log_func_name('<b>atom parser</b>');

	$this->_parser_atom_self->setEncoding($encoding);

	if ( !$this->_parser_atom_self->parse($xml_data) )
	{
		$this->_set_errors( 'rssc: atom parser cannot parse' );
		$this->_set_errors( $this->_parser_atom_self->getErrros() );
		return false;
	}

	$channel = $this->_parser_atom_self->get_feed();
	$items   = $this->_parser_atom_self->get_entrys();

	return $this->_build_parsed_data($channel, array(), $items, 'atom');
}

function _format_atom_self($parsed_data)
{
	$arr = array();

	if ( isset($parsed_data['channel']) )
	{
		$arr = $parsed_data['channel'];
	}

	$formated_data = array();
	$formated_data['channel'] = $arr;
	$formated_data['items']   = 
		$this->_format_atom_self_items( $parsed_data['channel'], $parsed_data['items'] );

	return $formated_data;
}

function _format_atom_self_items($channel, $items)
{
	$site_title = $this->_get_channel_title($channel);
	$site_link  = $this->_get_channel_link($channel);

	$arr = array();

	foreach ($items as $item)
	{
		$temp = $this->_format_item($item, $site_title, $site_link);
		$arr[] = $temp;
	}

	return $arr;
}

//=========================================================
// RSS parser
//=========================================================
function _parse_format_rss_self($xml_data, $xml_encoding)
{
	$parsed_data = $this->_parse_rss_self($xml_data, $xml_encoding);

	if ( !$parsed_data )
	{
		return false;
	}

	$parsed_data = $this->_convert_to_local($parsed_data, $xml_encoding);
	return $this->_format_rss_self( $parsed_data );

//	return $this->_format_rss_self( $parsed_data );
}

function _parse_rss_self($xml_data, $encoding)
{
	$this->_set_log_func_name('<b>rss parser</b>');

	$this->_parser_rss_self->setEncoding($encoding);

	if ( !$this->_parser_rss_self->parse($xml_data) )
	{
		$this->_set_errors( 'rssc: rss parser cannot parse' );
		$this->_set_errors( $this->_parser_rss_self->get_parse_error() );
		return false;
	}

	$channel = $this->_parser_rss_self->get_channel();
	$image   = $this->_parser_rss_self->get_image();
	$items   = $this->_parser_rss_self->get_items();

	return $this->_build_parsed_data($channel, $image, $items);
}

function _format_rss_self($parsed_data)
{
	$formated_data = array();
	$arr = array();

	if ( isset($parsed_data['channel']) )
	{
		$arr = $parsed_data['channel'];
	}

	if ( isset($parsed_data['image']) )
	{
		$formated_data['image'] = $parsed_data['image'];

		foreach ($parsed_data['image'] as $key => $value)
		{
			$arr[ 'image_'.$key ] = $value;
		}
	}

	$formated_data['channel'] = $arr;
	$formated_data['items']   = 
		$this->_format_rss_self_items( $parsed_data['channel'], $parsed_data['items'] );

	return $formated_data;
}

function _format_rss_self_items($channel, $items)
{
	$site_title = $this->_get_channel_title($channel);
	$site_link  = $this->_get_channel_link($channel);

	$arr = array();

	foreach ($items as $item)
	{
		$arr[] = $this->_format_rss_item($item, $site_title, $site_link);
	}

	return $arr;
}

//=========================================================
// XOOPS xmlrss2parser
//=========================================================
function _parse_format_rss_xoops($xml_data, $xml_encoding)
{
	$parsed_data = $this->_parse_rss_xoops($xml_data, $xml_encoding);

	if ( !$parsed_data )
	{
		return false;
	}

	$parsed_data = $this->_convert_to_local( $parsed_data, $xml_encoding );
	return $this->_format_rss_xoops( $parsed_data );

//	return $this->_format_rss_xoops( $parsed_data );
}

function _parse_rss_xoops($xml_data, $encoding)
{
	$this->_set_log_func_name('<b>xmlrss2parser</b>');

	$parser_rss_xoops = new XoopsXmlRss2Parser( $xml_data );

	switch ( $encoding ) 
	{
		case 'utf-8':
			$parser_rss_xoops->useUtfEncoding();
			break;

		case 'us-ascii':
			$parser_rss_xoops->useAsciiEncoding();
			break;

		default:
			$parser_rss_xoops->useIsoEncoding();
			break;
	}

	$result = $parser_rss_xoops->parse();

	if (!$result) 
	{
		$this->_set_errors( 'rssc: xoops parser cannot parse' );
		$this->_set_errors( $parser_rss_xoops->getErrors(false) );
		return false;
	}

	$channel =& $parser_rss_xoops->getChannelData();
	$image   =& $parser_rss_xoops->getImageData();
	$items   =& $parser_rss_xoops->getItems();

	return $this->_build_parsed_data($channel, $image, $items);
}

function _format_rss_xoops($parsed_data)
{
	$formated_data = array();
	$arr = array();

	if ( isset($parsed_data['channel']) )
	{
		$arr = $parsed_data['channel'];
	}

	if ( isset($parsed_data['image']) )
	{
		foreach ($parsed_data['image'] as $key => $value)
		{
			$arr[ 'image_'.$key ] = $value;
		}
	}

	$formated_data['channel'] = $arr;
	$formated_data['items']   = 
		$this->_format_rss_xoops_items( $parsed_data['channel'], $parsed_data['items'] );

	return $formated_data;
}

function _format_rss_xoops_items($channel, $items)
{
	$site_title = $this->_get_channel_title($channel);
	$site_link  = $this->_get_channel_link($channel);

	$arr = array();

	foreach ($items as $item)
	{
		$rss_item =& $this->_parser_rss_self->create_item();
		$rss_item->set_var_array( $item );
		$temp = $rss_item->get_item();

		$arr[] = $this->_format_rss_item($temp, $site_title, $site_link);
	}

	return $arr;
}


//---------------------------------------------------------
// utility
//---------------------------------------------------------
function _build_parsed_data($channel, $image, $items, $mode='rss')
{
	$parsed_data = array();
	$parsed_data['channel'] = $channel;
	$parsed_data['image']   = $image;
	$parsed_data['items']   = $items;
	$parsed_data['mode']    = $mode;
	return $parsed_data;
}

//---------------------------------------------------------
// get element
//---------------------------------------------------------
function _format_item($item, $site_title, $site_link)
{
	$arr = $item;
	$arr['site_title'] = $site_title;
	$arr['site_link']  = $site_link;
	$arr['raws'] = $item;
	return $arr;
}

function _format_rss_item($item, $site_title, $site_link)
{
	$arr = $this->_format_item($item, $site_title, $site_link);
	$arr['content']      = $this->_get_rss_content($item);
	$arr['author_name']  = $this->_get_rss_author_name($item);
	$arr['author_email'] = $this->_get_rss_author_email($item);
	$arr['author_uri']   = $this->_get_rss_author_uri($item);

	$unixtime = $this->_get_rss_date_unix($item);
	$arr['published_unix'] = $unixtime;
	$arr['updated_unix']   = $unixtime;

	return $arr;
}

function _get_channel_title($channel)
{
	if ( isset( $channel['title'] ) )
	{
		return $channel['title'];
	}

	return false;
}

function _get_channel_link($channel)
{
	if ( isset( $channel['link'] ) )
	{
		return $channel['link'];
	}

	return false;
}

function _get_rss_author_name($item)
{
	if ( isset($item['creator']) )
	{
		return $item['creator'];
	}

	return false;
}

function _get_rss_author_email($item)
{
	if ( isset($item['author']) )
	{
		return $item['author'];
	}

	return false;
}

function _get_rss_author_uri($item)
{
	return false;
}

function _get_rss_date_unix($item)
{
	if ( isset($item['pubdate_unix']) )
	{
		return $item['pubdate_unix'];
	}
	elseif ( isset($item['date_unix']) )
	{
		return $item['date_unix'];
	}

	return 0;
}

function _get_rss_content($item)
{
	if ( isset($item['content']) )
	{
		return $item['content'];
	}
	elseif ( isset($item['encoded']) )
	{
		return $item['encoded'];
	}
	elseif ( isset($item['description']) )
	{
		return $item['description'];
	}

	return false;
}

//----- class end -----
}

// === class end ===
}

?>