<?php
// $Id: headline.php,v 1.1.1.1 2006/01/03 05:05:59 ohwada Exp $

//================================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//================================================================

include '../../mainfile.php';

$DIRNAME     = $xoopsModule->dirname();
$MODULE_ROOT = XOOPS_ROOT_PATH.'/modules/'.$DIRNAME;
$MODULE_URL  = XOOPS_URL.'/modules/'.$DIRNAME;

include_once $MODULE_ROOT.'/api/refresh.php';
include_once $MODULE_ROOT.'/api/view.php';
include_once $MODULE_ROOT.'/class/rssc_post.php';

$refresh_handler =& rssc_get_handler( 'refresh', $DIRNAME );
$view_handler    =& rssc_get_handler( 'view',    $DIRNAME );
$conf_handler    =& rssc_get_handler( 'config_data', $DIRNAME );
$post    =& rssc_post::getInstance();
$system  =& rssc_system::getInstance();

// --- template start ---
include XOOPS_ROOT_PATH.'/header.php';
$xoopsOption['template_main'] = $DIRNAME.'_headline.html';

$is_admin =  $system->is_module_admin();

$conf =& $conf_handler->get_config_data();

$view_handler->setFeedStart( 0 );
$view_handler->setFeedLimit(  $conf['main_headline_feeds_perpage'] );
$view_handler->setFeedOrder(  $conf['main_headline_order'] );
$view_handler->setFutureDays( $conf['basic_future_days'] );

$view_handler->setFlagSanitize(1);	// sanitize
$view_handler->setTitleHtml(   0 );
$view_handler->setContentHtml( 0 );
$view_handler->setMaxContent(  0 );
$view_handler->setMaxTitle(    $conf['main_headline_max_title'] );
$view_handler->setMaxSummary(  $conf['main_headline_max_summary'] );

$link_limit = $conf['main_headline_links_perpage'];
$lid_get    = $post->get_get_int('lid');

$error = '';

if ( !$refresh_handler->refreshHeadline($link_limit) )
{
	$error = $refresh_handler->getErrors('s');
}

$links =& $view_handler->getHeadlineLinks($link_limit);

if ($lid_get > 0)
{
	$lid = $lid_get;
}
else
{
	$lid = $links[0]['lid'];
}

$channel =& $view_handler->getLink($lid);
$feeds   =& $view_handler->getFeeds($lid);

$xoopsTpl->assign('lang_main',       _RSSC_MAIN);
$xoopsTpl->assign('lang_headline',   _RSSC_HEADLINE);
$xoopsTpl->assign('lang_lastupdate', _RSSC_LASTUPDATE);

$xoopsTpl->assign('module_url',  $MODULE_URL);
$xoopsTpl->assign('is_admin',    $is_admin);
$xoopsTpl->assign('rssc_error',  $error);
$xoopsTpl->assign('channel',     $channel);

foreach ($links as $link) 
{
	$xoopsTpl->append('links', $link);
}

foreach ($feeds as $feed) 
{
	$xoopsTpl->append('feeds', $feed);
}

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>