<?php
// $Id: index.php,v 1.1.1.1 2006/01/03 05:05:59 ohwada Exp $

//================================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//================================================================

include '../../mainfile.php';

$DIRNAME     = $xoopsModule->dirname();
$MODULE_ROOT = XOOPS_ROOT_PATH.'/modules/'.$DIRNAME;
$MODULE_URL  = XOOPS_URL.'/modules/'.$DIRNAME;

include_once $MODULE_ROOT.'/api/search.php';
include_once $MODULE_ROOT.'/class/rssc_post.php';
include_once $MODULE_ROOT.'/class/rssc_pagenavi.php';

$search_handler =& rssc_get_handler( 'search', $DIRNAME );
$conf_handler   =& rssc_get_handler( 'config_data', $DIRNAME );
$post      =& rssc_post::getInstance();
$system    =& rssc_system::getInstance();
$pagenavi  =& rssc_pagenavi::getInstance();

// --- template start ---
include XOOPS_ROOT_PATH.'/header.php';
$xoopsOption['template_main'] = $DIRNAME.'_index.html';

$search_handler->startMeasureTime();

$conf  =& $conf_handler->get_config_data();
$limit =  $conf['main_search_perpage'];
$min   =  $conf['main_search_min'];

$search_handler->setFeedLimit(  $limit );
$search_handler->setMinKeyword( $min );
$search_handler->setFeedOrder(  $conf['main_search_order'] );
$search_handler->setFutureDays( $conf['basic_future_days'] );

$search_handler->setFlagSanitize(1);	// sanitize
$search_handler->setTitleHtml(   0 );
$search_handler->setContentHtml( 0 );
$search_handler->setMaxContent(  0 );
$search_handler->setMaxTitle(    $conf['main_search_max_title'] );
$search_handler->setMaxSummary(  $conf['main_search_max_summary'] );

$pagenavi->setPerpage($limit);
$pagenavi->getGetPage();

$action = $post->get_post_get('action');
$andor  = $post->get_post_get('andor', 'AND');
$query  = $post->get_post_get_trim('query');

$total    = $search_handler->getTotal();
$is_admin = $system->is_module_admin();

$feeds     = array();
$count     = 0;
$flag_show = 0;
$start     =  0;
$and       = '';
$or        = '';
$exact     = '';
$keyword   = '';
$ignored   = '';
$urlencode = '';
$navi      = '';
$reason_not_show = '';

if ( $action == 'results')
{
	if ($query)
	{
		if ( $search_handler->parseQuery($query, $andor, $min) )
		{
			$and       = $search_handler->getAnd();
			$or        = $search_handler->getOr();
			$exact     = $search_handler->getExact();
			$keyword   = $search_handler->getKeyword();
			$ignored   = $search_handler->getIgnored();
			$urlencode = $search_handler->getQueryUrlencode();
			$count     = $search_handler->getSearchCount();

			if ($count > 0) 
			{
				$flag_show = 2;

				$pagenavi->setTotal($count);
				$start =  $pagenavi->calcStart();
				$feeds =& $search_handler->getSearchFeeds($limit, $start);

				$search_url  = $MODULE_URL.'/index.php?action=results';
				$search_url .= '&amp;query='.$urlencode;
				$search_url .= '&amp;andor='.$andor;

				$navi = $pagenavi->build($search_url);
			}
			else
			{
				$flag_show = 3;
				$reason_not_show = _SR_NOMATCH;
			}
		}
		else 
		{
			$flag_show = 3;
			$reason_not_show = sprintf(_SR_KEYTOOSHORT, $min);
		}

	}
	else
	{
		$flag_show = 2;
		$reason_not_show = _SR_PLZENTER;
		$and = "selected='selected'";
	}
}
else
{
	$flag_show = 1;
	$and = "selected='selected'";

	$pagenavi->setTotal($total);
	$start =  $pagenavi->calcStart();
	$feeds =& $search_handler->getLatest($limit, $start);

	$search_url = $MODULE_URL.'/index.php';
	$navi = $pagenavi->build($search_url);

}

// assign template
$query_html = htmlspecialchars($query);

if ($count)
{
	$found = sprintf(_SR_FOUND, $count);
}
else
{
	$found = '';
}

// RDF/RSS/ATOM auto discovery
$dir_rssc = 'modules/'.$DIRNAME;
$xoopsTpl->assign('xoops_rdf',  $dir_rssc.'/rdf.php' );
$xoopsTpl->assign('xoops_rss',  $dir_rssc.'/rss.php' );
$xoopsTpl->assign('xoops_atom', $dir_rssc.'/atom.php' );

$xoopsTpl->assign('lang_main',     _RSSC_MAIN);
$xoopsTpl->assign('lang_headline', _RSSC_HEADLINE);
$xoopsTpl->assign('lang_latest',   _RSSC_LATEST_FEEDS);
$xoopsTpl->assign('lang_search',   _SR_SEARCH);
$xoopsTpl->assign('lang_all',      _SR_ALL);
$xoopsTpl->assign('lang_any',      _SR_ANY);
$xoopsTpl->assign('lang_exact',    _SR_EXACT);
$xoopsTpl->assign('lang_nomatch',  _SR_NOMATCH);
$xoopsTpl->assign('lang_result',   _SR_SEARCHRESULTS);
$xoopsTpl->assign('lang_showall',  _SR_SHOWALLR);
$xoopsTpl->assign('lang_prev',     _SR_PREVIOUS);
$xoopsTpl->assign('lang_next',     _SR_NEXT);
$xoopsTpl->assign('lang_keyword',  _SR_KEYWORDS.':');
$xoopsTpl->assign('lang_total',   sprintf(_RSSC_THEREARE,   $total) );
$xoopsTpl->assign('lang_ignored', sprintf(_SR_IGNOREDWORDS, $min) );

$xoopsTpl->assign('module_url',   $MODULE_URL);
$xoopsTpl->assign('is_admin',     $is_admin);
$xoopsTpl->assign('rssc_and',     $and);
$xoopsTpl->assign('rssc_or',      $or);
$xoopsTpl->assign('rssc_exact',   $exact);
$xoopsTpl->assign('rssc_keyword', $keyword);
$xoopsTpl->assign('rssc_ignored', $ignored);
$xoopsTpl->assign('rssc_query',   $query_html);
$xoopsTpl->assign('rssc_andor',   $andor);
$xoopsTpl->assign('rssc_show',    $flag_show);
$xoopsTpl->assign('rssc_found',   $found);
$xoopsTpl->assign('rssc_navi',    $navi);
$xoopsTpl->assign('rssc_reason',  $reason_not_show);
$xoopsTpl->assign('rssc_urlencode', $urlencode);
$xoopsTpl->assign('feed_limit', $limit);
$xoopsTpl->assign('feed_start', $start);

foreach ($feeds as $feed) 
{
	$xoopsTpl->append('feeds', $feed);
}

$time = sprintf("%6.3f", $search_handler->getMeasureTime() );
$xoopsTpl->assign('rssc_time', $time);

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


?>