<?php
// $Id: rss.php,v 1.1.1.1 2006/01/03 05:05:59 ohwada Exp $

//================================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//================================================================

include "../../mainfile.php";

$DIRNAME     = $xoopsModule->dirname();
$MODULE_ROOT = XOOPS_ROOT_PATH.'/modules/'.$DIRNAME;
$MODULE_URL  = XOOPS_URL.'/modules/'.$DIRNAME;

include_once $MODULE_ROOT."/api/rss.php";
include_once $MODULE_ROOT."/class/rssc_post.php";

$search_handler =& rssc_get_handler( 'search', $DIRNAME );
$conf_handler   =& rssc_get_handler( 'config_data', $DIRNAME );
$post    =& rssc_post::getInstance();
$system  =& rssc_system::getInstance();

$view_goto_url = $MODULE_URL.'/index.php';

$TEMPLATE_RDF  = $MODULE_ROOT.'/templates/xml/rssc_build_rdf.html';
$TEMPLATE_RSS  = $MODULE_ROOT.'/templates/xml/rssc_build_rss.html';
$TEMPLATE_ATOM = $MODULE_ROOT.'/templates/xml/rssc_build_atom.html';

$conf_data =& $conf_handler->get_config_data();
$max_limit = $conf_data['main_search_perpage'];
$min       = $conf_data['main_search_min'];

$search_handler->setMinKeyword( $min );
$search_handler->setFeedOrder(  $conf_data['main_search_order'] );
$search_handler->setFutureDays( $conf_data['basic_future_days'] );
$search_handler->setFlagSanitize(0);	// not sanitize

$mode  = $post->get_get('mode',  'rss');
$andor = $post->get_get('andor', 'AND');
$query = $post->get_get_trim('query');
$start = $post->get_get_int('start');
$limit = $post->get_get_int('limit');

if ($limit <= 0)
{
	$limit = $max_limit;
}

$search_handler->setFeedLimit( $limit );
$search_handler->setFeedStart( $start );
$search_handler->setQuery( $query );
$search_handler->setAndor( $andor );

$feeds = array();

if ($query)
{
	if ( $search_handler->search() > 0 )
	{
		$feeds =& $search_handler->getFeeds();
	}
}
else
{
	$feeds =& $search_handler->getLatest($limit, $start);
}

if ($mode == 'rdf')
{
	$builder =& rssc_build_rdf::getInstance();
	$builder->set_template( $TEMPLATE_RDF );
}
elseif ($mode == 'atom')
{
	$builder =& rssc_build_atom::getInstance();
	$builder->set_template( $TEMPLATE_ATOM );
}
else
{
	$builder =& rssc_build_rss::getInstance();
	$builder->set_template( $TEMPLATE_RSS );
}

$builder->set_items($feeds);

if ( $system->is_module_admin() )
{
	$builder->set_view_goto_url( $view_goto_url );
	$builder->view();
}
else
{
	$builder->build();
}

exit();
// --- main end ---


?>