<?php
// $Id: single.php,v 1.1.1.1 2006/01/03 05:05:59 ohwada Exp $

//================================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//================================================================

include "../../mainfile.php";

$DIRNAME     = $xoopsModule->dirname();
$MODULE_ROOT = XOOPS_ROOT_PATH.'/modules/'.$DIRNAME;
$MODULE_URL  = XOOPS_URL.'/modules/'.$DIRNAME;

include_once $MODULE_ROOT.'/api/view.php';
include_once $MODULE_ROOT.'/class/rssc_post.php';

$view_handler =& rssc_get_handler( 'view', $DIRNAME );
$conf_handler =& rssc_get_handler( 'config_data', $DIRNAME );
$post         =& rssc_post::getInstance();
$system       =& rssc_system::getInstance();

// --- template start ---
include XOOPS_ROOT_PATH.'/header.php';
$xoopsOption['template_main'] = $DIRNAME.'_single.html';

$is_admin = $system->is_module_admin();

$conf =& $conf_handler->get_config_data();

$view_handler->setFlagSanitize(1);	// sanitize
$view_handler->setTitleHtml(   0 );
$view_handler->setContentHtml( 0 );
$view_handler->setMaxContent(  0 );
$view_handler->setMaxTitle(    $conf['main_single_max_title'] );
$view_handler->setMaxSummary(  $conf['main_single_max_summary'] );

$fid   = $post->get_get_int('fid');
$feed  = array();
$link  = array();
$error = '';
$show  = 0;

if ($fid > 0)
{
	$feed =& $view_handler->getFeedByFid($fid);

	if ( is_array($feed) && isset($feed['lid']) )
	{
		$show = 1;
		$link =& $view_handler->getLink( $feed['lid'] );
	}
	else
	{
		$error = _NO_RECORD;
	}
}
else
{
	$error = _NO_RECORD;
}

$xoopsTpl->assign('lang_main',     _RSSC_MAIN);
$xoopsTpl->assign('lang_headline', _RSSC_HEADLINE);
$xoopsTpl->assign('lang_single',   _RSSC_SINGLE);

$xoopsTpl->assign('module_url',  $MODULE_URL);
$xoopsTpl->assign('is_admin',    $is_admin);
$xoopsTpl->assign('rssc_show',   $show);
$xoopsTpl->assign('rssc_error',  $error);
$xoopsTpl->assign('link',  $link);
$xoopsTpl->assign('feed',  $feed);

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>