# $Id: rssc.sql,v 1.1.1.1 2006/01/03 05:06:07 ohwada Exp $

# =========================================================
# RSS Center Module
# 2006-01-01 K.OHWADA
# =========================================================

#
# Table structure for table `rssc_config`
# modify from system `config`
#

CREATE TABLE rssc_config (
  id smallint(5) unsigned NOT NULL auto_increment,
  conf_id smallint(5) unsigned NOT NULL default 0,
  conf_name varchar(255) NOT NULL default '',
  conf_value text NOT NULL,
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY (id),
  KEY conf_id (conf_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `rssc_link`
#

CREATE TABLE rssc_link (
  lid int(11) unsigned NOT NULL auto_increment,
  uid int(11) unsigned default '0',
  mid int(11) unsigned default '0',
  p1  int(11) unsigned default '0',
  p2  int(11) unsigned default '0',
  p3  int(11) unsigned default '0',
  title  varchar(255)    default '',
  url    varchar(255)  NOT NULL default '',
  ltype  tinyint(2) unsigned default '0',
  refresh   mediumint(8) unsigned default '3600',
  headline  mediumint(8) unsigned default '0',
  mode      tinyint(3)   default '0',
  rdf_url   varchar(255) default '',
  rss_url   varchar(255) default '',
  atom_url  varchar(255) default '',
  encoding  varchar(15)  default '',
  updated_unix int(10) default'0',
  channel text    default '',
  xml  mediumtext default '',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY  (lid),
  KEY mid (mid),
  KEY p (p1, p2, p3)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `rssc_feed`
#

CREATE TABLE rssc_feed (
  fid int(11) unsigned NOT NULL auto_increment,
  lid int(11) unsigned NOT NULL default '0',
  uid int(11) unsigned default '0',
  mid int(11) unsigned default '0',
  p1  int(11) unsigned default '0',
  p2  int(11) unsigned default '0',
  p3  int(11) unsigned default '0',
  site_title varchar(255) default '',
  site_link  varchar(255) default '',
  title  varchar(255) NOT NULL default '',
  link   varchar(255) NOT NULL default '',
  entry_id  varchar(255) default '',
  guid      varchar(255) default '',
  updated_unix   int(10) default '0',
  published_unix int(10) default '0',
  category  varchar(255) default '',
  author_name  varchar(255) default '',
  author_uri   varchar(255) default '',
  author_email varchar(255) default '',
  type_cont    varchar(255) default '',
  raws    text default '',
  content text default '',
  search  text default '',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY  (fid),
  KEY lid (lid),
  KEY mid (mid),
  KEY p   (p1, p2, p3),
  KEY link (link),
  KEY updated   (updated_unix),
  KEY published (published_unix)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `rssc_black`
#

CREATE TABLE rssc_black (
  bid int(11) unsigned NOT NULL auto_increment,
  lid int(11) unsigned default '0',
  uid int(11) unsigned default '0',
  mid int(11) unsigned default '0',
  p1  int(11) unsigned default '0',
  p2  int(11) unsigned default '0',
  p3  int(11) unsigned default '0',
  title varchar(255) default '',
  url   varchar(255) NOT NULL default '',
  memo text default '',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY  (bid)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `rssc_white`
#

CREATE TABLE rssc_white (
  wid int(11) unsigned NOT NULL auto_increment,
  lid int(11) unsigned default '0',
  uid int(11) unsigned default '0',
  mid int(11) unsigned default '0',
  p1  int(11) unsigned default '0',
  p2  int(11) unsigned default '0',
  p3  int(11) unsigned default '0',
  title varchar(255) default '',
  url   varchar(255) NOT NULL default '',
  memo text default '',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY  (wid)
) TYPE=MyISAM;
# --------------------------------------------------------

INSERT INTO rssc_link VALUES (1, 1, 0, 0, 0, 0, 'XOOPS.org', 'http://www.xoops.org/', 0, 3600, 1, 2, '', 'http://www.xoops.org/backend.php', '', 'utf-8', 0, '', '', 0, 0, '', '');
